<?php
/**
 * GetViewStatsRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Open Orders API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: openorders
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\OpenOrders\Model;

use \ArrayAccess;
use \Linnworks\OpenOrders\ObjectSerializer;

/**
 * GetViewStatsRequest Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\OpenOrders
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetViewStatsRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GetViewStatsRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'location_id' => 'string',
        'view_id' => 'int',
        'user_id' => 'int',
        'include_user_management' => 'bool',
        'only_visible' => 'bool',
        'rebuild_cache_if_required' => 'bool',
        'recalculate_view_if_required' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'location_id' => 'uuid',
        'view_id' => 'int32',
        'user_id' => 'int32',
        'include_user_management' => null,
        'only_visible' => null,
        'rebuild_cache_if_required' => null,
        'recalculate_view_if_required' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'location_id' => false,
        'view_id' => false,
        'user_id' => false,
        'include_user_management' => false,
        'only_visible' => false,
        'rebuild_cache_if_required' => false,
        'recalculate_view_if_required' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'location_id' => 'LocationId',
        'view_id' => 'ViewId',
        'user_id' => 'UserId',
        'include_user_management' => 'IncludeUserManagement',
        'only_visible' => 'OnlyVisible',
        'rebuild_cache_if_required' => 'RebuildCacheIfRequired',
        'recalculate_view_if_required' => 'RecalculateViewIfRequired'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'location_id' => 'setLocationId',
        'view_id' => 'setViewId',
        'user_id' => 'setUserId',
        'include_user_management' => 'setIncludeUserManagement',
        'only_visible' => 'setOnlyVisible',
        'rebuild_cache_if_required' => 'setRebuildCacheIfRequired',
        'recalculate_view_if_required' => 'setRecalculateViewIfRequired'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'location_id' => 'getLocationId',
        'view_id' => 'getViewId',
        'user_id' => 'getUserId',
        'include_user_management' => 'getIncludeUserManagement',
        'only_visible' => 'getOnlyVisible',
        'rebuild_cache_if_required' => 'getRebuildCacheIfRequired',
        'recalculate_view_if_required' => 'getRecalculateViewIfRequired'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('view_id', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('include_user_management', $data ?? [], null);
        $this->setIfExists('only_visible', $data ?? [], null);
        $this->setIfExists('rebuild_cache_if_required', $data ?? [], null);
        $this->setIfExists('recalculate_view_if_required', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets location_id
     *
     * @return string|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param string|null $location_id location_id
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets view_id
     *
     * @return int|null
     */
    public function getViewId()
    {
        return $this->container['view_id'];
    }

    /**
     * Sets view_id
     *
     * @param int|null $view_id view_id
     *
     * @return self
     */
    public function setViewId($view_id)
    {
        if (is_null($view_id)) {
            throw new \InvalidArgumentException('non-nullable view_id cannot be null');
        }
        $this->container['view_id'] = $view_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return int|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param int|null $user_id user_id
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets include_user_management
     *
     * @return bool|null
     */
    public function getIncludeUserManagement()
    {
        return $this->container['include_user_management'];
    }

    /**
     * Sets include_user_management
     *
     * @param bool|null $include_user_management include_user_management
     *
     * @return self
     */
    public function setIncludeUserManagement($include_user_management)
    {
        if (is_null($include_user_management)) {
            throw new \InvalidArgumentException('non-nullable include_user_management cannot be null');
        }
        $this->container['include_user_management'] = $include_user_management;

        return $this;
    }

    /**
     * Gets only_visible
     *
     * @return bool|null
     */
    public function getOnlyVisible()
    {
        return $this->container['only_visible'];
    }

    /**
     * Sets only_visible
     *
     * @param bool|null $only_visible only_visible
     *
     * @return self
     */
    public function setOnlyVisible($only_visible)
    {
        if (is_null($only_visible)) {
            throw new \InvalidArgumentException('non-nullable only_visible cannot be null');
        }
        $this->container['only_visible'] = $only_visible;

        return $this;
    }

    /**
     * Gets rebuild_cache_if_required
     *
     * @return bool|null
     */
    public function getRebuildCacheIfRequired()
    {
        return $this->container['rebuild_cache_if_required'];
    }

    /**
     * Sets rebuild_cache_if_required
     *
     * @param bool|null $rebuild_cache_if_required If only the currently built stats are required, pass false here. Useful for polling whether a long running cache build has finished  The default is true.
     *
     * @return self
     */
    public function setRebuildCacheIfRequired($rebuild_cache_if_required)
    {
        if (is_null($rebuild_cache_if_required)) {
            throw new \InvalidArgumentException('non-nullable rebuild_cache_if_required cannot be null');
        }
        $this->container['rebuild_cache_if_required'] = $rebuild_cache_if_required;

        return $this;
    }

    /**
     * Gets recalculate_view_if_required
     *
     * @return bool|null
     */
    public function getRecalculateViewIfRequired()
    {
        return $this->container['recalculate_view_if_required'];
    }

    /**
     * Sets recalculate_view_if_required
     *
     * @param bool|null $recalculate_view_if_required recalculate_view_if_required
     *
     * @return self
     */
    public function setRecalculateViewIfRequired($recalculate_view_if_required)
    {
        if (is_null($recalculate_view_if_required)) {
            throw new \InvalidArgumentException('non-nullable recalculate_view_if_required cannot be null');
        }
        $this->container['recalculate_view_if_required'] = $recalculate_view_if_required;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


