# # OrderItem

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**item_id** | **string** | Stock Item ID | [optional]
**item_number** | **string** | Item number as on channel | [optional]
**sku** | **string** | Product SKU | [optional]
**item_source** | **string** | Item source / channel name | [optional]
**title** | **string** | Item title | [optional]
**quantity** | **int** | Quantity | [optional]
**category_name** | **string** | Product category | [optional]
**composite_availablity** | **int** | Composite availability | [optional]
**stock_levels_specified** | **bool** | If stock level specified | [optional]
**on_order** | **int** | Level due in purchase orders | [optional]
**on_purchase_order** | [**\Linnworks\OpenOrders\Model\OrderItemOnOrder**](OrderItemOnOrder.md) |  | [optional]
**in_order_book** | **int** | Quantity currently in open orders | [optional]
**level** | **int** | Current stock level | [optional]
**minimum_level** | **int** | Minimum level | [optional]
**available_stock** | **int** | Currently available stock level (Level-InOrderBook) | [optional]
**price_per_unit** | **float** | Unit price | [optional]
**unit_cost** | **float** | Unit cost | [optional]
**despatch_stock_unit_cost** | **float** | Despatch stock unit cost | [optional]
**discount** | **float** | Percentage (0%, 10%, 20%, etc...) | [optional]
**tax** | **float** | Actual tax value on an item | [optional] [readonly]
**tax_rate** | **float** | Tax rate | [optional]
**cost** | **float** | Total item cost (exc tax) | [optional]
**cost_inc_tax** | **float** | Total item cost (inc tax) | [optional]
**composite_sub_items** | [**\Linnworks\OpenOrders\Model\OrderItem[]**](OrderItem.md) | List of order items | [optional]
**is_service** | **bool** | if item is a service | [optional]
**sales_tax** | **float** | Sales Tax | [optional]
**tax_cost_inclusive** | **bool** | If tax is included in a cost | [optional]
**part_shipped** | **bool** | If order is partly shipped | [optional]
**weight** | **float** | Order weight | [optional]
**barcode_number** | **string** | Product barcode | [optional]
**market** | **int** | Market | [optional]
**channel_sku** | **string** | Channel product SKU | [optional]
**channel_title** | **string** | Channel product title | [optional]
**discount_value** | **float** |  | [optional] [readonly]
**has_image** | **bool** | If item got an image | [optional] [readonly]
**image_id** | **string** | Image ID | [optional]
**additional_info** | [**\Linnworks\OpenOrders\Model\OrderItemOption[]**](OrderItemOption.md) | List of order item options | [optional]
**stock_level_indicator** | **int** | Stock level indicator | [optional]
**shipping_cost** | **float** | If batch number scan required | [optional]
**part_shipped_qty** | **int** | ShippingCost | [optional]
**item_name** | **string** | PartShippedQty | [optional]
**batch_number_scan_required** | **bool** | ItemName | [optional]
**serial_number_scan_required** | **bool** | If serial number scan required | [optional]
**bin_rack** | **string** | Binrack location | [optional]
**bin_racks** | [**\Linnworks\OpenOrders\Model\OrderItemBinRack[]**](OrderItemBinRack.md) | List of BinRacks used for OrderItem | [optional]
**inventory_tracking_type** | **int** | Identifies whether the item has a sell by date or other defined order in which inventory is to be sold | [optional]
**is_batched_stock_item** | **bool** | If item has batches | [optional] [readonly]
**is_warehouse_managed** | **bool** |  | [optional]
**is_unlinked** | **bool** |  | [optional] [readonly]
**stock_item_int_id** | **int** |  | [optional]
**boxes** | [**\Linnworks\OpenOrders\Model\StockItemBoxConfiguration[]**](StockItemBoxConfiguration.md) |  | [optional]
**added_date** | **\DateTime** |  | [optional]
**row_id** | **string** | Record row ID | [optional]
**order_id** | **string** | Order ID (pkOrderID) | [optional]
**stock_item_id** | **string** | Stock Item ID | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
