# Linnworks\OpenOrders\OpenOrdersApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**assignOrderIdentifier()**](OpenOrdersApi.md#assignOrderIdentifier) | **POST** /api/OpenOrders/AssignOrderIdentifier | AssignOrderIdentifier |
| [**assignStockToOrders()**](OpenOrdersApi.md#assignStockToOrders) | **POST** /api/OpenOrders/AssignStockToOrders | AssignStockToOrders |
| [**deleteAssignedStock()**](OpenOrdersApi.md#deleteAssignedStock) | **POST** /api/OpenOrders/DeleteAssignedStock | DeleteAssignedStock |
| [**deleteIdentifier()**](OpenOrdersApi.md#deleteIdentifier) | **POST** /api/OpenOrders/DeleteIdentifier | DeleteIdentifier |
| [**getAvailableChannels()**](OpenOrdersApi.md#getAvailableChannels) | **GET** /api/OpenOrders/GetAvailableChannels | GetAvailableChannels |
| [**getIdentifiers()**](OpenOrdersApi.md#getIdentifiers) | **GET** /api/OpenOrders/GetIdentifiers | GetIdentifiers |
| [**getIdentifiersByOrderIds()**](OpenOrdersApi.md#getIdentifiersByOrderIds) | **POST** /api/OpenOrders/GetIdentifiersByOrderIds | GetIdentifiersByOrderIds |
| [**getOpenOrderIds()**](OpenOrdersApi.md#getOpenOrderIds) | **POST** /api/OpenOrders/GetOpenOrderIds | GetOpenOrderIds |
| [**getOpenOrders()**](OpenOrdersApi.md#getOpenOrders) | **POST** /api/OpenOrders/GetOpenOrders | GetOpenOrders |
| [**getOpenOrdersDetails()**](OpenOrdersApi.md#getOpenOrdersDetails) | **POST** /api/OpenOrders/GetOpenOrdersDetails | GetOpenOrdersDetails |
| [**getOrderItemIndicators()**](OpenOrdersApi.md#getOrderItemIndicators) | **POST** /api/OpenOrders/GetOrderItemIndicators | GetOrderItemIndicators |
| [**getOrdersLowFidelity()**](OpenOrdersApi.md#getOrdersLowFidelity) | **POST** /api/OpenOrders/GetOrdersLowFidelity | GetOrdersLowFidelity |
| [**getViewStats()**](OpenOrdersApi.md#getViewStats) | **POST** /api/OpenOrders/GetViewStats | GetViewStats |
| [**markReadyForCollection()**](OpenOrdersApi.md#markReadyForCollection) | **POST** /api/OpenOrders/MarkReadyForCollection | MarkReadyForCollection |
| [**saveIdentifier()**](OpenOrdersApi.md#saveIdentifier) | **POST** /api/OpenOrders/SaveIdentifier | SaveIdentifier |
| [**searchOrders()**](OpenOrdersApi.md#searchOrders) | **POST** /api/OpenOrders/SearchOrders | SearchOrders |
| [**unassignOrderIdentifier()**](OpenOrdersApi.md#unassignOrderIdentifier) | **POST** /api/OpenOrders/UnassignOrderIdentifier | UnassignOrderIdentifier |


## `assignOrderIdentifier()`

```php
assignOrderIdentifier($request): \Linnworks\OpenOrders\Model\AssignResult
```

AssignOrderIdentifier

Add an identifier to an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest(); // \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest

try {
    $result = $apiInstance->assignOrderIdentifier($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->assignOrderIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest**](../Model/ChangeOrderIdentifierRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\AssignResult**](../Model/AssignResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `assignStockToOrders()`

```php
assignStockToOrders($request): \Linnworks\OpenOrders\Model\AssignStockToOrdersResponseOrderItemBatchExtendedGuid
```

AssignStockToOrders

Assign Stock to Orders <b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\AssignStockToOrdersRequest(); // \Linnworks\OpenOrders\Model\AssignStockToOrdersRequest

try {
    $result = $apiInstance->assignStockToOrders($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->assignStockToOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\AssignStockToOrdersRequest**](../Model/AssignStockToOrdersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\AssignStockToOrdersResponseOrderItemBatchExtendedGuid**](../Model/AssignStockToOrdersResponseOrderItemBatchExtendedGuid.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteAssignedStock()`

```php
deleteAssignedStock($request): \Linnworks\OpenOrders\Model\AssignStockToOrdersResponseInt32Int32
```

DeleteAssignedStock

<b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\ClearStockAssignmentRequest(); // \Linnworks\OpenOrders\Model\ClearStockAssignmentRequest

try {
    $result = $apiInstance->deleteAssignedStock($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->deleteAssignedStock: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\ClearStockAssignmentRequest**](../Model/ClearStockAssignmentRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\AssignStockToOrdersResponseInt32Int32**](../Model/AssignStockToOrdersResponseInt32Int32.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteIdentifier()`

```php
deleteIdentifier($request)
```

DeleteIdentifier

Delete an identifier. This will also remove the identifier from all orders that it's assigned to <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\DeleteIdentifiersRequest(); // \Linnworks\OpenOrders\Model\DeleteIdentifiersRequest

try {
    $apiInstance->deleteIdentifier($request);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->deleteIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\DeleteIdentifiersRequest**](../Model/DeleteIdentifiersRequest.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAvailableChannels()`

```php
getAvailableChannels(): \Linnworks\OpenOrders\Model\GetAvailableChannelsResponse
```

GetAvailableChannels

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getAvailableChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getAvailableChannels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\OpenOrders\Model\GetAvailableChannelsResponse**](../Model/GetAvailableChannelsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getIdentifiers()`

```php
getIdentifiers(): \Linnworks\OpenOrders\Model\Identifier[]
```

GetIdentifiers

Get all identifiers that are available to add to an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getIdentifiers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getIdentifiers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\OpenOrders\Model\Identifier[]**](../Model/Identifier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getIdentifiersByOrderIds()`

```php
getIdentifiersByOrderIds($request): \Linnworks\OpenOrders\Model\OrderIdentifier[]
```

GetIdentifiersByOrderIds

Get all identifiers for a list of orderIds <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOrderIdentifierRequest(); // \Linnworks\OpenOrders\Model\GetOrderIdentifierRequest

try {
    $result = $apiInstance->getIdentifiersByOrderIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getIdentifiersByOrderIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOrderIdentifierRequest**](../Model/GetOrderIdentifierRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\OrderIdentifier[]**](../Model/OrderIdentifier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrderIds()`

```php
getOpenOrderIds($request): \Linnworks\OpenOrders\Model\GenericPagedResultGuid
```

GetOpenOrderIds

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOpenOrdersRequest(); // \Linnworks\OpenOrders\Model\GetOpenOrdersRequest

try {
    $result = $apiInstance->getOpenOrderIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getOpenOrderIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOpenOrdersRequest**](../Model/GetOpenOrdersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\GenericPagedResultGuid**](../Model/GenericPagedResultGuid.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrders()`

```php
getOpenOrders($request): \Linnworks\OpenOrders\Model\PostFilterPagedResponseOpenOrder
```

GetOpenOrders

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOpenOrdersRequest(); // \Linnworks\OpenOrders\Model\GetOpenOrdersRequest

try {
    $result = $apiInstance->getOpenOrders($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getOpenOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOpenOrdersRequest**](../Model/GetOpenOrdersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\PostFilterPagedResponseOpenOrder**](../Model/PostFilterPagedResponseOpenOrder.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOpenOrdersDetails()`

```php
getOpenOrdersDetails($request): \Linnworks\OpenOrders\Model\GetOpenOrdersDetailsResponse
```

GetOpenOrdersDetails

Open order details by order ids. Not limited by the number of orders you can retrieve. This call is designed to return ONLY open orders,   it is much faster than GetOrderDetail call <b>Permissions Required: </b> GlobalPermissions.OrderBook.ViewOrderDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOpenOrdersDetailsRequest(); // \Linnworks\OpenOrders\Model\GetOpenOrdersDetailsRequest

try {
    $result = $apiInstance->getOpenOrdersDetails($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getOpenOrdersDetails: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOpenOrdersDetailsRequest**](../Model/GetOpenOrdersDetailsRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\GetOpenOrdersDetailsResponse**](../Model/GetOpenOrdersDetailsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrderItemIndicators()`

```php
getOrderItemIndicators($request): \Linnworks\OpenOrders\Model\GetOrderItemIndicatorResponse
```

GetOrderItemIndicators

<b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOrderItemIndicatorRequest(); // \Linnworks\OpenOrders\Model\GetOrderItemIndicatorRequest

try {
    $result = $apiInstance->getOrderItemIndicators($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getOrderItemIndicators: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOrderItemIndicatorRequest**](../Model/GetOrderItemIndicatorRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\GetOrderItemIndicatorResponse**](../Model/GetOrderItemIndicatorResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getOrdersLowFidelity()`

```php
getOrdersLowFidelity($request): \Linnworks\OpenOrders\Model\GetOrdersLowFidelityResponse
```

GetOrdersLowFidelity

Returns low fidelity view of open orders. The data is generally useful for very basic view or counters of what is in the open orders. Useful for finding orders quickly as it returns all scannable fields of the order and order items such as order ids, skus, barcodes etc. <b>Permissions Required: </b> GlobalPermissions.OrderBook.DespatchConsoleNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetOrdersLowFidelityRequest(); // \Linnworks\OpenOrders\Model\GetOrdersLowFidelityRequest

try {
    $result = $apiInstance->getOrdersLowFidelity($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getOrdersLowFidelity: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetOrdersLowFidelityRequest**](../Model/GetOrdersLowFidelityRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\GetOrdersLowFidelityResponse**](../Model/GetOrdersLowFidelityResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getViewStats()`

```php
getViewStats($request): \Linnworks\OpenOrders\Model\OrderViewStats[]
```

GetViewStats

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\GetViewStatsRequest(); // \Linnworks\OpenOrders\Model\GetViewStatsRequest

try {
    $result = $apiInstance->getViewStats($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->getViewStats: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\GetViewStatsRequest**](../Model/GetViewStatsRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\OrderViewStats[]**](../Model/OrderViewStats.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `markReadyForCollection()`

```php
markReadyForCollection($request): \Linnworks\OpenOrders\Model\GenericOrderOperationResult
```

MarkReadyForCollection

<b>Permissions Required: </b> GlobalPermissions.OrderBook.OpenOrdersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\MarkReadyForCollectionRequest(); // \Linnworks\OpenOrders\Model\MarkReadyForCollectionRequest

try {
    $result = $apiInstance->markReadyForCollection($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->markReadyForCollection: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\MarkReadyForCollectionRequest**](../Model/MarkReadyForCollectionRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\GenericOrderOperationResult**](../Model/GenericOrderOperationResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `saveIdentifier()`

```php
saveIdentifier($request): \Linnworks\OpenOrders\Model\Identifier
```

SaveIdentifier

Create or update an order identifier <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\SaveIdentifiersRequest(); // \Linnworks\OpenOrders\Model\SaveIdentifiersRequest

try {
    $result = $apiInstance->saveIdentifier($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->saveIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\SaveIdentifiersRequest**](../Model/SaveIdentifiersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\Identifier**](../Model/Identifier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `searchOrders()`

```php
searchOrders($request): \Linnworks\OpenOrders\Model\SearchOrdersResponse
```

SearchOrders

<b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\SearchOrdersRequest(); // \Linnworks\OpenOrders\Model\SearchOrdersRequest

try {
    $result = $apiInstance->searchOrders($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->searchOrders: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\SearchOrdersRequest**](../Model/SearchOrdersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\SearchOrdersResponse**](../Model/SearchOrdersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `unassignOrderIdentifier()`

```php
unassignOrderIdentifier($request): \Linnworks\OpenOrders\Model\AssignResult
```

UnassignOrderIdentifier

Remove an identifier from an order <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest(); // \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest

try {
    $result = $apiInstance->unassignOrderIdentifier($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->unassignOrderIdentifier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest**](../Model/ChangeOrderIdentifierRequest.md)|  | [optional] |

### Return type

[**\Linnworks\OpenOrders\Model\AssignResult**](../Model/AssignResult.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
