# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\OpenOrders\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\OpenOrders\Api\OpenOrdersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest(); // \Linnworks\OpenOrders\Model\ChangeOrderIdentifierRequest

try {
    $result = $apiInstance->assignOrderIdentifier($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OpenOrdersApi->assignOrderIdentifier: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*OpenOrdersApi* | [**assignOrderIdentifier**](docs/Api/OpenOrdersApi.md#assignorderidentifier) | **POST** /api/OpenOrders/AssignOrderIdentifier | AssignOrderIdentifier
*OpenOrdersApi* | [**assignStockToOrders**](docs/Api/OpenOrdersApi.md#assignstocktoorders) | **POST** /api/OpenOrders/AssignStockToOrders | AssignStockToOrders
*OpenOrdersApi* | [**deleteAssignedStock**](docs/Api/OpenOrdersApi.md#deleteassignedstock) | **POST** /api/OpenOrders/DeleteAssignedStock | DeleteAssignedStock
*OpenOrdersApi* | [**deleteIdentifier**](docs/Api/OpenOrdersApi.md#deleteidentifier) | **POST** /api/OpenOrders/DeleteIdentifier | DeleteIdentifier
*OpenOrdersApi* | [**getAvailableChannels**](docs/Api/OpenOrdersApi.md#getavailablechannels) | **GET** /api/OpenOrders/GetAvailableChannels | GetAvailableChannels
*OpenOrdersApi* | [**getIdentifiers**](docs/Api/OpenOrdersApi.md#getidentifiers) | **GET** /api/OpenOrders/GetIdentifiers | GetIdentifiers
*OpenOrdersApi* | [**getIdentifiersByOrderIds**](docs/Api/OpenOrdersApi.md#getidentifiersbyorderids) | **POST** /api/OpenOrders/GetIdentifiersByOrderIds | GetIdentifiersByOrderIds
*OpenOrdersApi* | [**getOpenOrderIds**](docs/Api/OpenOrdersApi.md#getopenorderids) | **POST** /api/OpenOrders/GetOpenOrderIds | GetOpenOrderIds
*OpenOrdersApi* | [**getOpenOrders**](docs/Api/OpenOrdersApi.md#getopenorders) | **POST** /api/OpenOrders/GetOpenOrders | GetOpenOrders
*OpenOrdersApi* | [**getOpenOrdersDetails**](docs/Api/OpenOrdersApi.md#getopenordersdetails) | **POST** /api/OpenOrders/GetOpenOrdersDetails | GetOpenOrdersDetails
*OpenOrdersApi* | [**getOrderItemIndicators**](docs/Api/OpenOrdersApi.md#getorderitemindicators) | **POST** /api/OpenOrders/GetOrderItemIndicators | GetOrderItemIndicators
*OpenOrdersApi* | [**getOrdersLowFidelity**](docs/Api/OpenOrdersApi.md#getorderslowfidelity) | **POST** /api/OpenOrders/GetOrdersLowFidelity | GetOrdersLowFidelity
*OpenOrdersApi* | [**getViewStats**](docs/Api/OpenOrdersApi.md#getviewstats) | **POST** /api/OpenOrders/GetViewStats | GetViewStats
*OpenOrdersApi* | [**markReadyForCollection**](docs/Api/OpenOrdersApi.md#markreadyforcollection) | **POST** /api/OpenOrders/MarkReadyForCollection | MarkReadyForCollection
*OpenOrdersApi* | [**saveIdentifier**](docs/Api/OpenOrdersApi.md#saveidentifier) | **POST** /api/OpenOrders/SaveIdentifier | SaveIdentifier
*OpenOrdersApi* | [**searchOrders**](docs/Api/OpenOrdersApi.md#searchorders) | **POST** /api/OpenOrders/SearchOrders | SearchOrders
*OpenOrdersApi* | [**unassignOrderIdentifier**](docs/Api/OpenOrdersApi.md#unassignorderidentifier) | **POST** /api/OpenOrders/UnassignOrderIdentifier | UnassignOrderIdentifier

## Models

- [AssignResult](docs/Model/AssignResult.md)
- [AssignStockToOrdersRequest](docs/Model/AssignStockToOrdersRequest.md)
- [AssignStockToOrdersResponseInt32Int32](docs/Model/AssignStockToOrdersResponseInt32Int32.md)
- [AssignStockToOrdersResponseOrderItemBatchExtendedGuid](docs/Model/AssignStockToOrdersResponseOrderItemBatchExtendedGuid.md)
- [BatchActionResultInt32Int32](docs/Model/BatchActionResultInt32Int32.md)
- [BatchActionResultOrderItemBatchExtendedGuid](docs/Model/BatchActionResultOrderItemBatchExtendedGuid.md)
- [ChangeOrderIdentifierRequest](docs/Model/ChangeOrderIdentifierRequest.md)
- [ClearStockAssignmentRequest](docs/Model/ClearStockAssignmentRequest.md)
- [CustomerAddress](docs/Model/CustomerAddress.md)
- [DeleteIdentifiersRequest](docs/Model/DeleteIdentifiersRequest.md)
- [ExtendedProperty](docs/Model/ExtendedProperty.md)
- [GenericOrderOperationResult](docs/Model/GenericOrderOperationResult.md)
- [GenericPagedResultGuid](docs/Model/GenericPagedResultGuid.md)
- [GetAvailableChannelsResponse](docs/Model/GetAvailableChannelsResponse.md)
- [GetOpenOrdersDetailsRequest](docs/Model/GetOpenOrdersDetailsRequest.md)
- [GetOpenOrdersDetailsResponse](docs/Model/GetOpenOrdersDetailsResponse.md)
- [GetOpenOrdersRequest](docs/Model/GetOpenOrdersRequest.md)
- [GetOrderIdentifierRequest](docs/Model/GetOrderIdentifierRequest.md)
- [GetOrderItemIndicatorRequest](docs/Model/GetOrderItemIndicatorRequest.md)
- [GetOrderItemIndicatorResponse](docs/Model/GetOrderItemIndicatorResponse.md)
- [GetOrdersLowFidelityRequest](docs/Model/GetOrdersLowFidelityRequest.md)
- [GetOrdersLowFidelityResponse](docs/Model/GetOrdersLowFidelityResponse.md)
- [GetViewStatsRequest](docs/Model/GetViewStatsRequest.md)
- [Identifier](docs/Model/Identifier.md)
- [IndicatorRequest](docs/Model/IndicatorRequest.md)
- [MarkReadyForCollectionRequest](docs/Model/MarkReadyForCollectionRequest.md)
- [OpenOrder](docs/Model/OpenOrder.md)
- [OpenOrderItem](docs/Model/OpenOrderItem.md)
- [OpenOrderLowFidelity](docs/Model/OpenOrderLowFidelity.md)
- [OrderCustomerInfo](docs/Model/OrderCustomerInfo.md)
- [OrderDetails](docs/Model/OrderDetails.md)
- [OrderFulfillmentState](docs/Model/OrderFulfillmentState.md)
- [OrderGeneralInfo](docs/Model/OrderGeneralInfo.md)
- [OrderIdentifier](docs/Model/OrderIdentifier.md)
- [OrderItem](docs/Model/OrderItem.md)
- [OrderItemBase](docs/Model/OrderItemBase.md)
- [OrderItemBatch](docs/Model/OrderItemBatch.md)
- [OrderItemBatchExtended](docs/Model/OrderItemBatchExtended.md)
- [OrderItemBinRack](docs/Model/OrderItemBinRack.md)
- [OrderItemIndicator](docs/Model/OrderItemIndicator.md)
- [OrderItemOnOrder](docs/Model/OrderItemOnOrder.md)
- [OrderItemOption](docs/Model/OrderItemOption.md)
- [OrderNote](docs/Model/OrderNote.md)
- [OrderShippingInfo](docs/Model/OrderShippingInfo.md)
- [OrderTaxInfo](docs/Model/OrderTaxInfo.md)
- [OrderTotalsInfo](docs/Model/OrderTotalsInfo.md)
- [OrderViewIds](docs/Model/OrderViewIds.md)
- [OrderViewStats](docs/Model/OrderViewStats.md)
- [OrderViewUserPreference](docs/Model/OrderViewUserPreference.md)
- [PostFilterPagedResponseOpenOrder](docs/Model/PostFilterPagedResponseOpenOrder.md)
- [ProductIdentifier](docs/Model/ProductIdentifier.md)
- [SaveIdentifiersRequest](docs/Model/SaveIdentifiersRequest.md)
- [ScheduledDelivery](docs/Model/ScheduledDelivery.md)
- [SearchOrdersRequest](docs/Model/SearchOrdersRequest.md)
- [SearchOrdersResponse](docs/Model/SearchOrdersResponse.md)
- [ServiceInformation](docs/Model/ServiceInformation.md)
- [StockItemBatch](docs/Model/StockItemBatch.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [StockItemBoxConfiguration](docs/Model/StockItemBoxConfiguration.md)
- [ViewGroup](docs/Model/ViewGroup.md)
- [ViewUser](docs/Model/ViewUser.md)
- [ViewUserManagement](docs/Model/ViewUserManagement.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `openorders`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
