<?php
/**
 * Supplier
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * Supplier Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Supplier implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Supplier';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_supplier_id' => 'string',
        'supplier_name' => 'string',
        'contact_name' => 'string',
        'address' => 'string',
        'alternative_address' => 'string',
        'city' => 'string',
        'region' => 'string',
        'country' => 'string',
        'post_code' => 'string',
        'telephone_number' => 'string',
        'secondary_tel_number' => 'string',
        'fax_number' => 'string',
        'email' => 'string',
        'web_page' => 'string',
        'currency' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_supplier_id' => 'uuid',
        'supplier_name' => null,
        'contact_name' => null,
        'address' => null,
        'alternative_address' => null,
        'city' => null,
        'region' => null,
        'country' => null,
        'post_code' => null,
        'telephone_number' => null,
        'secondary_tel_number' => null,
        'fax_number' => null,
        'email' => null,
        'web_page' => null,
        'currency' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_supplier_id' => false,
        'supplier_name' => false,
        'contact_name' => false,
        'address' => false,
        'alternative_address' => false,
        'city' => false,
        'region' => false,
        'country' => false,
        'post_code' => false,
        'telephone_number' => false,
        'secondary_tel_number' => false,
        'fax_number' => false,
        'email' => false,
        'web_page' => false,
        'currency' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_supplier_id' => 'pkSupplierID',
        'supplier_name' => 'SupplierName',
        'contact_name' => 'ContactName',
        'address' => 'Address',
        'alternative_address' => 'AlternativeAddress',
        'city' => 'City',
        'region' => 'Region',
        'country' => 'Country',
        'post_code' => 'PostCode',
        'telephone_number' => 'TelephoneNumber',
        'secondary_tel_number' => 'SecondaryTelNumber',
        'fax_number' => 'FaxNumber',
        'email' => 'Email',
        'web_page' => 'WebPage',
        'currency' => 'Currency'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_supplier_id' => 'setPkSupplierId',
        'supplier_name' => 'setSupplierName',
        'contact_name' => 'setContactName',
        'address' => 'setAddress',
        'alternative_address' => 'setAlternativeAddress',
        'city' => 'setCity',
        'region' => 'setRegion',
        'country' => 'setCountry',
        'post_code' => 'setPostCode',
        'telephone_number' => 'setTelephoneNumber',
        'secondary_tel_number' => 'setSecondaryTelNumber',
        'fax_number' => 'setFaxNumber',
        'email' => 'setEmail',
        'web_page' => 'setWebPage',
        'currency' => 'setCurrency'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_supplier_id' => 'getPkSupplierId',
        'supplier_name' => 'getSupplierName',
        'contact_name' => 'getContactName',
        'address' => 'getAddress',
        'alternative_address' => 'getAlternativeAddress',
        'city' => 'getCity',
        'region' => 'getRegion',
        'country' => 'getCountry',
        'post_code' => 'getPostCode',
        'telephone_number' => 'getTelephoneNumber',
        'secondary_tel_number' => 'getSecondaryTelNumber',
        'fax_number' => 'getFaxNumber',
        'email' => 'getEmail',
        'web_page' => 'getWebPage',
        'currency' => 'getCurrency'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_supplier_id', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('contact_name', $data ?? [], null);
        $this->setIfExists('address', $data ?? [], null);
        $this->setIfExists('alternative_address', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('region', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('post_code', $data ?? [], null);
        $this->setIfExists('telephone_number', $data ?? [], null);
        $this->setIfExists('secondary_tel_number', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('web_page', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_supplier_id
     *
     * @return string|null
     */
    public function getPkSupplierId()
    {
        return $this->container['pk_supplier_id'];
    }

    /**
     * Sets pk_supplier_id
     *
     * @param string|null $pk_supplier_id Supplier Id
     *
     * @return self
     */
    public function setPkSupplierId($pk_supplier_id)
    {
        if (is_null($pk_supplier_id)) {
            throw new \InvalidArgumentException('non-nullable pk_supplier_id cannot be null');
        }
        $this->container['pk_supplier_id'] = $pk_supplier_id;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name Supplier Name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            throw new \InvalidArgumentException('non-nullable supplier_name cannot be null');
        }
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets contact_name
     *
     * @return string|null
     */
    public function getContactName()
    {
        return $this->container['contact_name'];
    }

    /**
     * Sets contact_name
     *
     * @param string|null $contact_name Name of main contact
     *
     * @return self
     */
    public function setContactName($contact_name)
    {
        if (is_null($contact_name)) {
            throw new \InvalidArgumentException('non-nullable contact_name cannot be null');
        }
        $this->container['contact_name'] = $contact_name;

        return $this;
    }

    /**
     * Gets address
     *
     * @return string|null
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     *
     * @param string|null $address Supplier's address
     *
     * @return self
     */
    public function setAddress($address)
    {
        if (is_null($address)) {
            throw new \InvalidArgumentException('non-nullable address cannot be null');
        }
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets alternative_address
     *
     * @return string|null
     */
    public function getAlternativeAddress()
    {
        return $this->container['alternative_address'];
    }

    /**
     * Sets alternative_address
     *
     * @param string|null $alternative_address Second line of address
     *
     * @return self
     */
    public function setAlternativeAddress($alternative_address)
    {
        if (is_null($alternative_address)) {
            throw new \InvalidArgumentException('non-nullable alternative_address cannot be null');
        }
        $this->container['alternative_address'] = $alternative_address;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city City
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            throw new \InvalidArgumentException('non-nullable city cannot be null');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets region
     *
     * @return string|null
     */
    public function getRegion()
    {
        return $this->container['region'];
    }

    /**
     * Sets region
     *
     * @param string|null $region Region
     *
     * @return self
     */
    public function setRegion($region)
    {
        if (is_null($region)) {
            throw new \InvalidArgumentException('non-nullable region cannot be null');
        }
        $this->container['region'] = $region;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country Country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets post_code
     *
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->container['post_code'];
    }

    /**
     * Sets post_code
     *
     * @param string|null $post_code Postcode
     *
     * @return self
     */
    public function setPostCode($post_code)
    {
        if (is_null($post_code)) {
            throw new \InvalidArgumentException('non-nullable post_code cannot be null');
        }
        $this->container['post_code'] = $post_code;

        return $this;
    }

    /**
     * Gets telephone_number
     *
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->container['telephone_number'];
    }

    /**
     * Sets telephone_number
     *
     * @param string|null $telephone_number Telephone number
     *
     * @return self
     */
    public function setTelephoneNumber($telephone_number)
    {
        if (is_null($telephone_number)) {
            throw new \InvalidArgumentException('non-nullable telephone_number cannot be null');
        }
        $this->container['telephone_number'] = $telephone_number;

        return $this;
    }

    /**
     * Gets secondary_tel_number
     *
     * @return string|null
     */
    public function getSecondaryTelNumber()
    {
        return $this->container['secondary_tel_number'];
    }

    /**
     * Sets secondary_tel_number
     *
     * @param string|null $secondary_tel_number Secondary telephone number
     *
     * @return self
     */
    public function setSecondaryTelNumber($secondary_tel_number)
    {
        if (is_null($secondary_tel_number)) {
            throw new \InvalidArgumentException('non-nullable secondary_tel_number cannot be null');
        }
        $this->container['secondary_tel_number'] = $secondary_tel_number;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number Fax number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            throw new \InvalidArgumentException('non-nullable fax_number cannot be null');
        }
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email E-mail
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets web_page
     *
     * @return string|null
     */
    public function getWebPage()
    {
        return $this->container['web_page'];
    }

    /**
     * Sets web_page
     *
     * @param string|null $web_page Web page
     *
     * @return self
     */
    public function setWebPage($web_page)
    {
        if (is_null($web_page)) {
            throw new \InvalidArgumentException('non-nullable web_page cannot be null');
        }
        $this->container['web_page'] = $web_page;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Currency used
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


