<?php
/**
 * StockLocation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockLocation Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockLocation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockLocation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'stock_location_id' => 'string',
        'location_name' => 'string',
        'address1' => 'string',
        'address2' => 'string',
        'city' => 'string',
        'county' => 'string',
        'country' => 'string',
        'zip_code' => 'string',
        'is_not_trackable' => 'bool',
        'location_tag' => 'string',
        'is_fulfillment_center' => 'bool',
        'count_in_order_until_acknowledgement' => 'bool',
        'fulfilment_center_deduct_stock_when_processed' => 'bool',
        'is_warehouse_managed' => 'bool',
        'stock_location_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'stock_location_id' => 'uuid',
        'location_name' => null,
        'address1' => null,
        'address2' => null,
        'city' => null,
        'county' => null,
        'country' => null,
        'zip_code' => null,
        'is_not_trackable' => null,
        'location_tag' => null,
        'is_fulfillment_center' => null,
        'count_in_order_until_acknowledgement' => null,
        'fulfilment_center_deduct_stock_when_processed' => null,
        'is_warehouse_managed' => null,
        'stock_location_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'stock_location_id' => false,
        'location_name' => false,
        'address1' => false,
        'address2' => false,
        'city' => false,
        'county' => false,
        'country' => false,
        'zip_code' => false,
        'is_not_trackable' => false,
        'location_tag' => false,
        'is_fulfillment_center' => false,
        'count_in_order_until_acknowledgement' => false,
        'fulfilment_center_deduct_stock_when_processed' => false,
        'is_warehouse_managed' => false,
        'stock_location_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'stock_location_id' => 'StockLocationId',
        'location_name' => 'LocationName',
        'address1' => 'Address1',
        'address2' => 'Address2',
        'city' => 'City',
        'county' => 'County',
        'country' => 'Country',
        'zip_code' => 'ZipCode',
        'is_not_trackable' => 'IsNotTrackable',
        'location_tag' => 'LocationTag',
        'is_fulfillment_center' => 'IsFulfillmentCenter',
        'count_in_order_until_acknowledgement' => 'CountInOrderUntilAcknowledgement',
        'fulfilment_center_deduct_stock_when_processed' => 'FulfilmentCenterDeductStockWhenProcessed',
        'is_warehouse_managed' => 'IsWarehouseManaged',
        'stock_location_int_id' => 'StockLocationIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'stock_location_id' => 'setStockLocationId',
        'location_name' => 'setLocationName',
        'address1' => 'setAddress1',
        'address2' => 'setAddress2',
        'city' => 'setCity',
        'county' => 'setCounty',
        'country' => 'setCountry',
        'zip_code' => 'setZipCode',
        'is_not_trackable' => 'setIsNotTrackable',
        'location_tag' => 'setLocationTag',
        'is_fulfillment_center' => 'setIsFulfillmentCenter',
        'count_in_order_until_acknowledgement' => 'setCountInOrderUntilAcknowledgement',
        'fulfilment_center_deduct_stock_when_processed' => 'setFulfilmentCenterDeductStockWhenProcessed',
        'is_warehouse_managed' => 'setIsWarehouseManaged',
        'stock_location_int_id' => 'setStockLocationIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'stock_location_id' => 'getStockLocationId',
        'location_name' => 'getLocationName',
        'address1' => 'getAddress1',
        'address2' => 'getAddress2',
        'city' => 'getCity',
        'county' => 'getCounty',
        'country' => 'getCountry',
        'zip_code' => 'getZipCode',
        'is_not_trackable' => 'getIsNotTrackable',
        'location_tag' => 'getLocationTag',
        'is_fulfillment_center' => 'getIsFulfillmentCenter',
        'count_in_order_until_acknowledgement' => 'getCountInOrderUntilAcknowledgement',
        'fulfilment_center_deduct_stock_when_processed' => 'getFulfilmentCenterDeductStockWhenProcessed',
        'is_warehouse_managed' => 'getIsWarehouseManaged',
        'stock_location_int_id' => 'getStockLocationIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('stock_location_id', $data ?? [], null);
        $this->setIfExists('location_name', $data ?? [], null);
        $this->setIfExists('address1', $data ?? [], null);
        $this->setIfExists('address2', $data ?? [], null);
        $this->setIfExists('city', $data ?? [], null);
        $this->setIfExists('county', $data ?? [], null);
        $this->setIfExists('country', $data ?? [], null);
        $this->setIfExists('zip_code', $data ?? [], null);
        $this->setIfExists('is_not_trackable', $data ?? [], null);
        $this->setIfExists('location_tag', $data ?? [], null);
        $this->setIfExists('is_fulfillment_center', $data ?? [], null);
        $this->setIfExists('count_in_order_until_acknowledgement', $data ?? [], null);
        $this->setIfExists('fulfilment_center_deduct_stock_when_processed', $data ?? [], null);
        $this->setIfExists('is_warehouse_managed', $data ?? [], null);
        $this->setIfExists('stock_location_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets stock_location_id
     *
     * @return string|null
     */
    public function getStockLocationId()
    {
        return $this->container['stock_location_id'];
    }

    /**
     * Sets stock_location_id
     *
     * @param string|null $stock_location_id stock_location_id
     *
     * @return self
     */
    public function setStockLocationId($stock_location_id)
    {
        if (is_null($stock_location_id)) {
            throw new \InvalidArgumentException('non-nullable stock_location_id cannot be null');
        }
        $this->container['stock_location_id'] = $stock_location_id;

        return $this;
    }

    /**
     * Gets location_name
     *
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->container['location_name'];
    }

    /**
     * Sets location_name
     *
     * @param string|null $location_name location_name
     *
     * @return self
     */
    public function setLocationName($location_name)
    {
        if (is_null($location_name)) {
            throw new \InvalidArgumentException('non-nullable location_name cannot be null');
        }
        $this->container['location_name'] = $location_name;

        return $this;
    }

    /**
     * Gets address1
     *
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->container['address1'];
    }

    /**
     * Sets address1
     *
     * @param string|null $address1 address1
     *
     * @return self
     */
    public function setAddress1($address1)
    {
        if (is_null($address1)) {
            throw new \InvalidArgumentException('non-nullable address1 cannot be null');
        }
        $this->container['address1'] = $address1;

        return $this;
    }

    /**
     * Gets address2
     *
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->container['address2'];
    }

    /**
     * Sets address2
     *
     * @param string|null $address2 address2
     *
     * @return self
     */
    public function setAddress2($address2)
    {
        if (is_null($address2)) {
            throw new \InvalidArgumentException('non-nullable address2 cannot be null');
        }
        $this->container['address2'] = $address2;

        return $this;
    }

    /**
     * Gets city
     *
     * @return string|null
     */
    public function getCity()
    {
        return $this->container['city'];
    }

    /**
     * Sets city
     *
     * @param string|null $city city
     *
     * @return self
     */
    public function setCity($city)
    {
        if (is_null($city)) {
            throw new \InvalidArgumentException('non-nullable city cannot be null');
        }
        $this->container['city'] = $city;

        return $this;
    }

    /**
     * Gets county
     *
     * @return string|null
     */
    public function getCounty()
    {
        return $this->container['county'];
    }

    /**
     * Sets county
     *
     * @param string|null $county county
     *
     * @return self
     */
    public function setCounty($county)
    {
        if (is_null($county)) {
            throw new \InvalidArgumentException('non-nullable county cannot be null');
        }
        $this->container['county'] = $county;

        return $this;
    }

    /**
     * Gets country
     *
     * @return string|null
     */
    public function getCountry()
    {
        return $this->container['country'];
    }

    /**
     * Sets country
     *
     * @param string|null $country country
     *
     * @return self
     */
    public function setCountry($country)
    {
        if (is_null($country)) {
            throw new \InvalidArgumentException('non-nullable country cannot be null');
        }
        $this->container['country'] = $country;

        return $this;
    }

    /**
     * Gets zip_code
     *
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->container['zip_code'];
    }

    /**
     * Sets zip_code
     *
     * @param string|null $zip_code zip_code
     *
     * @return self
     */
    public function setZipCode($zip_code)
    {
        if (is_null($zip_code)) {
            throw new \InvalidArgumentException('non-nullable zip_code cannot be null');
        }
        $this->container['zip_code'] = $zip_code;

        return $this;
    }

    /**
     * Gets is_not_trackable
     *
     * @return bool|null
     */
    public function getIsNotTrackable()
    {
        return $this->container['is_not_trackable'];
    }

    /**
     * Sets is_not_trackable
     *
     * @param bool|null $is_not_trackable is_not_trackable
     *
     * @return self
     */
    public function setIsNotTrackable($is_not_trackable)
    {
        if (is_null($is_not_trackable)) {
            throw new \InvalidArgumentException('non-nullable is_not_trackable cannot be null');
        }
        $this->container['is_not_trackable'] = $is_not_trackable;

        return $this;
    }

    /**
     * Gets location_tag
     *
     * @return string|null
     */
    public function getLocationTag()
    {
        return $this->container['location_tag'];
    }

    /**
     * Sets location_tag
     *
     * @param string|null $location_tag location_tag
     *
     * @return self
     */
    public function setLocationTag($location_tag)
    {
        if (is_null($location_tag)) {
            throw new \InvalidArgumentException('non-nullable location_tag cannot be null');
        }
        $this->container['location_tag'] = $location_tag;

        return $this;
    }

    /**
     * Gets is_fulfillment_center
     *
     * @return bool|null
     */
    public function getIsFulfillmentCenter()
    {
        return $this->container['is_fulfillment_center'];
    }

    /**
     * Sets is_fulfillment_center
     *
     * @param bool|null $is_fulfillment_center is_fulfillment_center
     *
     * @return self
     */
    public function setIsFulfillmentCenter($is_fulfillment_center)
    {
        if (is_null($is_fulfillment_center)) {
            throw new \InvalidArgumentException('non-nullable is_fulfillment_center cannot be null');
        }
        $this->container['is_fulfillment_center'] = $is_fulfillment_center;

        return $this;
    }

    /**
     * Gets count_in_order_until_acknowledgement
     *
     * @return bool|null
     */
    public function getCountInOrderUntilAcknowledgement()
    {
        return $this->container['count_in_order_until_acknowledgement'];
    }

    /**
     * Sets count_in_order_until_acknowledgement
     *
     * @param bool|null $count_in_order_until_acknowledgement count_in_order_until_acknowledgement
     *
     * @return self
     */
    public function setCountInOrderUntilAcknowledgement($count_in_order_until_acknowledgement)
    {
        if (is_null($count_in_order_until_acknowledgement)) {
            throw new \InvalidArgumentException('non-nullable count_in_order_until_acknowledgement cannot be null');
        }
        $this->container['count_in_order_until_acknowledgement'] = $count_in_order_until_acknowledgement;

        return $this;
    }

    /**
     * Gets fulfilment_center_deduct_stock_when_processed
     *
     * @return bool|null
     */
    public function getFulfilmentCenterDeductStockWhenProcessed()
    {
        return $this->container['fulfilment_center_deduct_stock_when_processed'];
    }

    /**
     * Sets fulfilment_center_deduct_stock_when_processed
     *
     * @param bool|null $fulfilment_center_deduct_stock_when_processed fulfilment_center_deduct_stock_when_processed
     *
     * @return self
     */
    public function setFulfilmentCenterDeductStockWhenProcessed($fulfilment_center_deduct_stock_when_processed)
    {
        if (is_null($fulfilment_center_deduct_stock_when_processed)) {
            throw new \InvalidArgumentException('non-nullable fulfilment_center_deduct_stock_when_processed cannot be null');
        }
        $this->container['fulfilment_center_deduct_stock_when_processed'] = $fulfilment_center_deduct_stock_when_processed;

        return $this;
    }

    /**
     * Gets is_warehouse_managed
     *
     * @return bool|null
     */
    public function getIsWarehouseManaged()
    {
        return $this->container['is_warehouse_managed'];
    }

    /**
     * Sets is_warehouse_managed
     *
     * @param bool|null $is_warehouse_managed is_warehouse_managed
     *
     * @return self
     */
    public function setIsWarehouseManaged($is_warehouse_managed)
    {
        if (is_null($is_warehouse_managed)) {
            throw new \InvalidArgumentException('non-nullable is_warehouse_managed cannot be null');
        }
        $this->container['is_warehouse_managed'] = $is_warehouse_managed;

        return $this;
    }

    /**
     * Gets stock_location_int_id
     *
     * @return int|null
     */
    public function getStockLocationIntId()
    {
        return $this->container['stock_location_int_id'];
    }

    /**
     * Sets stock_location_int_id
     *
     * @param int|null $stock_location_int_id stock_location_int_id
     *
     * @return self
     */
    public function setStockLocationIntId($stock_location_int_id)
    {
        if (is_null($stock_location_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_location_int_id cannot be null');
        }
        $this->container['stock_location_int_id'] = $stock_location_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


