<?php
/**
 * StockItemPrice
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemPrice Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemPrice implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemPrice';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'rules' => '\Linnworks\Inventory\Model\StockItemPricingRule[]',
        'pk_row_id' => 'string',
        'source' => 'string',
        'sub_source' => 'string',
        'price' => 'float',
        'tag' => 'string',
        'update_status' => 'string',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'rules' => null,
        'pk_row_id' => 'uuid',
        'source' => null,
        'sub_source' => null,
        'price' => 'double',
        'tag' => null,
        'update_status' => null,
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'rules' => false,
        'pk_row_id' => false,
        'source' => false,
        'sub_source' => false,
        'price' => false,
        'tag' => false,
        'update_status' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rules' => 'Rules',
        'pk_row_id' => 'pkRowId',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'price' => 'Price',
        'tag' => 'Tag',
        'update_status' => 'UpdateStatus',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'rules' => 'setRules',
        'pk_row_id' => 'setPkRowId',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'price' => 'setPrice',
        'tag' => 'setTag',
        'update_status' => 'setUpdateStatus',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'rules' => 'getRules',
        'pk_row_id' => 'getPkRowId',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'price' => 'getPrice',
        'tag' => 'getTag',
        'update_status' => 'getUpdateStatus',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const UPDATE_STATUS_NO_CHANGE = 'NoChange';
    public const UPDATE_STATUS_PENDING = 'Pending';
    public const UPDATE_STATUS_SENT_NOT_CONFIRMED = 'SentNotConfirmed';
    public const UPDATE_STATUS_SUCCESS = 'Success';
    public const UPDATE_STATUS_ERROR = 'Error';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getUpdateStatusAllowableValues()
    {
        return [
            self::UPDATE_STATUS_NO_CHANGE,
            self::UPDATE_STATUS_PENDING,
            self::UPDATE_STATUS_SENT_NOT_CONFIRMED,
            self::UPDATE_STATUS_SUCCESS,
            self::UPDATE_STATUS_ERROR,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('rules', $data ?? [], null);
        $this->setIfExists('pk_row_id', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('tag', $data ?? [], null);
        $this->setIfExists('update_status', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getUpdateStatusAllowableValues();
        if (!is_null($this->container['update_status']) && !in_array($this->container['update_status'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'update_status', must be one of '%s'",
                $this->container['update_status'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets rules
     *
     * @return \Linnworks\Inventory\Model\StockItemPricingRule[]|null
     */
    public function getRules()
    {
        return $this->container['rules'];
    }

    /**
     * Sets rules
     *
     * @param \Linnworks\Inventory\Model\StockItemPricingRule[]|null $rules Pricing rule
     *
     * @return self
     */
    public function setRules($rules)
    {
        if (is_null($rules)) {
            throw new \InvalidArgumentException('non-nullable rules cannot be null');
        }
        $this->container['rules'] = $rules;

        return $this;
    }

    /**
     * Gets pk_row_id
     *
     * @return string|null
     */
    public function getPkRowId()
    {
        return $this->container['pk_row_id'];
    }

    /**
     * Sets pk_row_id
     *
     * @param string|null $pk_row_id Record row ID (generate random)
     *
     * @return self
     */
    public function setPkRowId($pk_row_id)
    {
        if (is_null($pk_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_row_id cannot be null');
        }
        $this->container['pk_row_id'] = $pk_row_id;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source SubSource (e.g. EBAY1)
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets price
     *
     * @return float|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param float|null $price Channel price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets tag
     *
     * @return string|null
     */
    public function getTag()
    {
        return $this->container['tag'];
    }

    /**
     * Sets tag
     *
     * @param string|null $tag Product price tag
     *
     * @return self
     */
    public function setTag($tag)
    {
        if (is_null($tag)) {
            throw new \InvalidArgumentException('non-nullable tag cannot be null');
        }
        $this->container['tag'] = $tag;

        return $this;
    }

    /**
     * Gets update_status
     *
     * @return string|null
     */
    public function getUpdateStatus()
    {
        return $this->container['update_status'];
    }

    /**
     * Sets update_status
     *
     * @param string|null $update_status update_status
     *
     * @return self
     */
    public function setUpdateStatus($update_status)
    {
        if (is_null($update_status)) {
            throw new \InvalidArgumentException('non-nullable update_status cannot be null');
        }
        $allowedValues = $this->getUpdateStatusAllowableValues();
        if (!in_array($update_status, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'update_status', must be one of '%s'",
                    $update_status,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['update_status'] = $update_status;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


