<?php
/**
 * StockItemEbayCompatibility
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemEbayCompatibility Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemEbayCompatibility implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemEbayCompatibility';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fk_stock_item_id' => 'string',
        'fk_compatibility_list_id' => 'string',
        'sku' => 'string',
        'compatibility_notes' => 'string',
        'value' => 'string',
        'include_years' => 'string',
        'exclude_years' => 'string',
        'culture' => 'string',
        'ebay_compitibility_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fk_stock_item_id' => 'uuid',
        'fk_compatibility_list_id' => 'uuid',
        'sku' => null,
        'compatibility_notes' => null,
        'value' => null,
        'include_years' => null,
        'exclude_years' => null,
        'culture' => null,
        'ebay_compitibility_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fk_stock_item_id' => false,
        'fk_compatibility_list_id' => false,
        'sku' => false,
        'compatibility_notes' => false,
        'value' => false,
        'include_years' => false,
        'exclude_years' => false,
        'culture' => false,
        'ebay_compitibility_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fk_stock_item_id' => 'FkStockItemId',
        'fk_compatibility_list_id' => 'FkCompatibilityListId',
        'sku' => 'SKU',
        'compatibility_notes' => 'CompatibilityNotes',
        'value' => 'Value',
        'include_years' => 'IncludeYears',
        'exclude_years' => 'ExcludeYears',
        'culture' => 'Culture',
        'ebay_compitibility_type' => 'EbayCompitibilityType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fk_stock_item_id' => 'setFkStockItemId',
        'fk_compatibility_list_id' => 'setFkCompatibilityListId',
        'sku' => 'setSku',
        'compatibility_notes' => 'setCompatibilityNotes',
        'value' => 'setValue',
        'include_years' => 'setIncludeYears',
        'exclude_years' => 'setExcludeYears',
        'culture' => 'setCulture',
        'ebay_compitibility_type' => 'setEbayCompitibilityType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fk_stock_item_id' => 'getFkStockItemId',
        'fk_compatibility_list_id' => 'getFkCompatibilityListId',
        'sku' => 'getSku',
        'compatibility_notes' => 'getCompatibilityNotes',
        'value' => 'getValue',
        'include_years' => 'getIncludeYears',
        'exclude_years' => 'getExcludeYears',
        'culture' => 'getCulture',
        'ebay_compitibility_type' => 'getEbayCompitibilityType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const EBAY_COMPITIBILITY_TYPE_K_TYPE = 'KType';
    public const EBAY_COMPITIBILITY_TYPE_E_PID = 'ePID';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getEbayCompitibilityTypeAllowableValues()
    {
        return [
            self::EBAY_COMPITIBILITY_TYPE_K_TYPE,
            self::EBAY_COMPITIBILITY_TYPE_E_PID,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fk_stock_item_id', $data ?? [], null);
        $this->setIfExists('fk_compatibility_list_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('compatibility_notes', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
        $this->setIfExists('include_years', $data ?? [], null);
        $this->setIfExists('exclude_years', $data ?? [], null);
        $this->setIfExists('culture', $data ?? [], null);
        $this->setIfExists('ebay_compitibility_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getEbayCompitibilityTypeAllowableValues();
        if (!is_null($this->container['ebay_compitibility_type']) && !in_array($this->container['ebay_compitibility_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'ebay_compitibility_type', must be one of '%s'",
                $this->container['ebay_compitibility_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fk_stock_item_id
     *
     * @return string|null
     */
    public function getFkStockItemId()
    {
        return $this->container['fk_stock_item_id'];
    }

    /**
     * Sets fk_stock_item_id
     *
     * @param string|null $fk_stock_item_id StockItem unique identifier (Optional if SKU is supplied)
     *
     * @return self
     */
    public function setFkStockItemId($fk_stock_item_id)
    {
        if (is_null($fk_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_stock_item_id cannot be null');
        }
        $this->container['fk_stock_item_id'] = $fk_stock_item_id;

        return $this;
    }

    /**
     * Gets fk_compatibility_list_id
     *
     * @return string|null
     */
    public function getFkCompatibilityListId()
    {
        return $this->container['fk_compatibility_list_id'];
    }

    /**
     * Sets fk_compatibility_list_id
     *
     * @param string|null $fk_compatibility_list_id Compatibility list ID (Optional)
     *
     * @return self
     */
    public function setFkCompatibilityListId($fk_compatibility_list_id)
    {
        if (is_null($fk_compatibility_list_id)) {
            throw new \InvalidArgumentException('non-nullable fk_compatibility_list_id cannot be null');
        }
        $this->container['fk_compatibility_list_id'] = $fk_compatibility_list_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Stock item SKU (Will be ignored fkStockItemId is supplied)
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets compatibility_notes
     *
     * @return string|null
     */
    public function getCompatibilityNotes()
    {
        return $this->container['compatibility_notes'];
    }

    /**
     * Sets compatibility_notes
     *
     * @param string|null $compatibility_notes Compatibility notes
     *
     * @return self
     */
    public function setCompatibilityNotes($compatibility_notes)
    {
        if (is_null($compatibility_notes)) {
            throw new \InvalidArgumentException('non-nullable compatibility_notes cannot be null');
        }
        $this->container['compatibility_notes'] = $compatibility_notes;

        return $this;
    }

    /**
     * Gets value
     *
     * @return string|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param string|null $value Value
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets include_years
     *
     * @return string|null
     */
    public function getIncludeYears()
    {
        return $this->container['include_years'];
    }

    /**
     * Sets include_years
     *
     * @param string|null $include_years Years to include
     *
     * @return self
     */
    public function setIncludeYears($include_years)
    {
        if (is_null($include_years)) {
            throw new \InvalidArgumentException('non-nullable include_years cannot be null');
        }
        $this->container['include_years'] = $include_years;

        return $this;
    }

    /**
     * Gets exclude_years
     *
     * @return string|null
     */
    public function getExcludeYears()
    {
        return $this->container['exclude_years'];
    }

    /**
     * Sets exclude_years
     *
     * @param string|null $exclude_years Years to exclude
     *
     * @return self
     */
    public function setExcludeYears($exclude_years)
    {
        if (is_null($exclude_years)) {
            throw new \InvalidArgumentException('non-nullable exclude_years cannot be null');
        }
        $this->container['exclude_years'] = $exclude_years;

        return $this;
    }

    /**
     * Gets culture
     *
     * @return string|null
     */
    public function getCulture()
    {
        return $this->container['culture'];
    }

    /**
     * Sets culture
     *
     * @param string|null $culture Compatibility culture, one of US, UK, DE, AU, CA, FR, IT, ES
     *
     * @return self
     */
    public function setCulture($culture)
    {
        if (is_null($culture)) {
            throw new \InvalidArgumentException('non-nullable culture cannot be null');
        }
        $this->container['culture'] = $culture;

        return $this;
    }

    /**
     * Gets ebay_compitibility_type
     *
     * @return string|null
     */
    public function getEbayCompitibilityType()
    {
        return $this->container['ebay_compitibility_type'];
    }

    /**
     * Sets ebay_compitibility_type
     *
     * @param string|null $ebay_compitibility_type ebay_compitibility_type
     *
     * @return self
     */
    public function setEbayCompitibilityType($ebay_compitibility_type)
    {
        if (is_null($ebay_compitibility_type)) {
            throw new \InvalidArgumentException('non-nullable ebay_compitibility_type cannot be null');
        }
        $allowedValues = $this->getEbayCompitibilityTypeAllowableValues();
        if (!in_array($ebay_compitibility_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'ebay_compitibility_type', must be one of '%s'",
                    $ebay_compitibility_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['ebay_compitibility_type'] = $ebay_compitibility_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


