<?php
/**
 * StockItemComposition
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemComposition Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemComposition implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemComposition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'linked_stock_item_id' => 'string',
        'item_title' => 'string',
        'sku' => 'string',
        'quantity' => 'int',
        'purchase_price' => 'float',
        'inventory_tracking_type' => 'int',
        'dim_height' => 'float',
        'dim_width' => 'float',
        'dim_depth' => 'float',
        'weight' => 'float',
        'package_group_id' => 'string',
        'tax_rate' => 'float',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'linked_stock_item_id' => 'uuid',
        'item_title' => null,
        'sku' => null,
        'quantity' => 'int32',
        'purchase_price' => 'double',
        'inventory_tracking_type' => 'int32',
        'dim_height' => 'double',
        'dim_width' => 'double',
        'dim_depth' => 'double',
        'weight' => 'double',
        'package_group_id' => 'uuid',
        'tax_rate' => 'double',
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'linked_stock_item_id' => false,
        'item_title' => false,
        'sku' => false,
        'quantity' => false,
        'purchase_price' => false,
        'inventory_tracking_type' => false,
        'dim_height' => false,
        'dim_width' => false,
        'dim_depth' => false,
        'weight' => false,
        'package_group_id' => false,
        'tax_rate' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'linked_stock_item_id' => 'LinkedStockItemId',
        'item_title' => 'ItemTitle',
        'sku' => 'SKU',
        'quantity' => 'Quantity',
        'purchase_price' => 'PurchasePrice',
        'inventory_tracking_type' => 'InventoryTrackingType',
        'dim_height' => 'DimHeight',
        'dim_width' => 'DimWidth',
        'dim_depth' => 'DimDepth',
        'weight' => 'Weight',
        'package_group_id' => 'PackageGroupId',
        'tax_rate' => 'TaxRate',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'linked_stock_item_id' => 'setLinkedStockItemId',
        'item_title' => 'setItemTitle',
        'sku' => 'setSku',
        'quantity' => 'setQuantity',
        'purchase_price' => 'setPurchasePrice',
        'inventory_tracking_type' => 'setInventoryTrackingType',
        'dim_height' => 'setDimHeight',
        'dim_width' => 'setDimWidth',
        'dim_depth' => 'setDimDepth',
        'weight' => 'setWeight',
        'package_group_id' => 'setPackageGroupId',
        'tax_rate' => 'setTaxRate',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'linked_stock_item_id' => 'getLinkedStockItemId',
        'item_title' => 'getItemTitle',
        'sku' => 'getSku',
        'quantity' => 'getQuantity',
        'purchase_price' => 'getPurchasePrice',
        'inventory_tracking_type' => 'getInventoryTrackingType',
        'dim_height' => 'getDimHeight',
        'dim_width' => 'getDimWidth',
        'dim_depth' => 'getDimDepth',
        'weight' => 'getWeight',
        'package_group_id' => 'getPackageGroupId',
        'tax_rate' => 'getTaxRate',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('linked_stock_item_id', $data ?? [], null);
        $this->setIfExists('item_title', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('purchase_price', $data ?? [], null);
        $this->setIfExists('inventory_tracking_type', $data ?? [], null);
        $this->setIfExists('dim_height', $data ?? [], null);
        $this->setIfExists('dim_width', $data ?? [], null);
        $this->setIfExists('dim_depth', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('package_group_id', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets linked_stock_item_id
     *
     * @return string|null
     */
    public function getLinkedStockItemId()
    {
        return $this->container['linked_stock_item_id'];
    }

    /**
     * Sets linked_stock_item_id
     *
     * @param string|null $linked_stock_item_id Stock item ID of linked product
     *
     * @return self
     */
    public function setLinkedStockItemId($linked_stock_item_id)
    {
        if (is_null($linked_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable linked_stock_item_id cannot be null');
        }
        $this->container['linked_stock_item_id'] = $linked_stock_item_id;

        return $this;
    }

    /**
     * Gets item_title
     *
     * @return string|null
     */
    public function getItemTitle()
    {
        return $this->container['item_title'];
    }

    /**
     * Sets item_title
     *
     * @param string|null $item_title Product title
     *
     * @return self
     */
    public function setItemTitle($item_title)
    {
        if (is_null($item_title)) {
            throw new \InvalidArgumentException('non-nullable item_title cannot be null');
        }
        $this->container['item_title'] = $item_title;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Product quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets purchase_price
     *
     * @return float|null
     */
    public function getPurchasePrice()
    {
        return $this->container['purchase_price'];
    }

    /**
     * Sets purchase_price
     *
     * @param float|null $purchase_price Item purchase price
     *
     * @return self
     */
    public function setPurchasePrice($purchase_price)
    {
        if (is_null($purchase_price)) {
            throw new \InvalidArgumentException('non-nullable purchase_price cannot be null');
        }
        $this->container['purchase_price'] = $purchase_price;

        return $this;
    }

    /**
     * Gets inventory_tracking_type
     *
     * @return int|null
     */
    public function getInventoryTrackingType()
    {
        return $this->container['inventory_tracking_type'];
    }

    /**
     * Sets inventory_tracking_type
     *
     * @param int|null $inventory_tracking_type Tracking type of an item
     *
     * @return self
     */
    public function setInventoryTrackingType($inventory_tracking_type)
    {
        if (is_null($inventory_tracking_type)) {
            throw new \InvalidArgumentException('non-nullable inventory_tracking_type cannot be null');
        }
        $this->container['inventory_tracking_type'] = $inventory_tracking_type;

        return $this;
    }

    /**
     * Gets dim_height
     *
     * @return float|null
     */
    public function getDimHeight()
    {
        return $this->container['dim_height'];
    }

    /**
     * Sets dim_height
     *
     * @param float|null $dim_height dim_height
     *
     * @return self
     */
    public function setDimHeight($dim_height)
    {
        if (is_null($dim_height)) {
            throw new \InvalidArgumentException('non-nullable dim_height cannot be null');
        }
        $this->container['dim_height'] = $dim_height;

        return $this;
    }

    /**
     * Gets dim_width
     *
     * @return float|null
     */
    public function getDimWidth()
    {
        return $this->container['dim_width'];
    }

    /**
     * Sets dim_width
     *
     * @param float|null $dim_width dim_width
     *
     * @return self
     */
    public function setDimWidth($dim_width)
    {
        if (is_null($dim_width)) {
            throw new \InvalidArgumentException('non-nullable dim_width cannot be null');
        }
        $this->container['dim_width'] = $dim_width;

        return $this;
    }

    /**
     * Gets dim_depth
     *
     * @return float|null
     */
    public function getDimDepth()
    {
        return $this->container['dim_depth'];
    }

    /**
     * Sets dim_depth
     *
     * @param float|null $dim_depth dim_depth
     *
     * @return self
     */
    public function setDimDepth($dim_depth)
    {
        if (is_null($dim_depth)) {
            throw new \InvalidArgumentException('non-nullable dim_depth cannot be null');
        }
        $this->container['dim_depth'] = $dim_depth;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets package_group_id
     *
     * @return string|null
     */
    public function getPackageGroupId()
    {
        return $this->container['package_group_id'];
    }

    /**
     * Sets package_group_id
     *
     * @param string|null $package_group_id package_group_id
     *
     * @return self
     */
    public function setPackageGroupId($package_group_id)
    {
        if (is_null($package_group_id)) {
            throw new \InvalidArgumentException('non-nullable package_group_id cannot be null');
        }
        $this->container['package_group_id'] = $package_group_id;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


