<?php
/**
 * StockItemChannelSKUWithLocation
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemChannelSKUWithLocation Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemChannelSKUWithLocation implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemChannelSKUWithLocation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'fk_row_id' => 'string',
        'location_id' => 'int',
        'location_name' => 'string',
        'ignore_sync' => 'bool',
        'max_listed_quantity' => 'int',
        'end_when_stock' => 'int',
        'stock_percentage' => 'float',
        'last_update' => '\DateTime',
        'update_status' => 'string',
        'submitted_quantity' => 'int',
        'listed_quantity' => 'int',
        'retry_count' => 'int',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'fk_row_id' => 'uuid',
        'location_id' => 'int32',
        'location_name' => null,
        'ignore_sync' => null,
        'max_listed_quantity' => 'int32',
        'end_when_stock' => 'int32',
        'stock_percentage' => 'double',
        'last_update' => 'date-time',
        'update_status' => null,
        'submitted_quantity' => 'int32',
        'listed_quantity' => 'int32',
        'retry_count' => 'int32',
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'fk_row_id' => false,
        'location_id' => false,
        'location_name' => false,
        'ignore_sync' => false,
        'max_listed_quantity' => false,
        'end_when_stock' => false,
        'stock_percentage' => false,
        'last_update' => false,
        'update_status' => false,
        'submitted_quantity' => false,
        'listed_quantity' => false,
        'retry_count' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'fk_row_id' => 'fkRowId',
        'location_id' => 'LocationId',
        'location_name' => 'LocationName',
        'ignore_sync' => 'IgnoreSync',
        'max_listed_quantity' => 'MaxListedQuantity',
        'end_when_stock' => 'EndWhenStock',
        'stock_percentage' => 'StockPercentage',
        'last_update' => 'LastUpdate',
        'update_status' => 'UpdateStatus',
        'submitted_quantity' => 'SubmittedQuantity',
        'listed_quantity' => 'ListedQuantity',
        'retry_count' => 'RetryCount',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'fk_row_id' => 'setFkRowId',
        'location_id' => 'setLocationId',
        'location_name' => 'setLocationName',
        'ignore_sync' => 'setIgnoreSync',
        'max_listed_quantity' => 'setMaxListedQuantity',
        'end_when_stock' => 'setEndWhenStock',
        'stock_percentage' => 'setStockPercentage',
        'last_update' => 'setLastUpdate',
        'update_status' => 'setUpdateStatus',
        'submitted_quantity' => 'setSubmittedQuantity',
        'listed_quantity' => 'setListedQuantity',
        'retry_count' => 'setRetryCount',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'fk_row_id' => 'getFkRowId',
        'location_id' => 'getLocationId',
        'location_name' => 'getLocationName',
        'ignore_sync' => 'getIgnoreSync',
        'max_listed_quantity' => 'getMaxListedQuantity',
        'end_when_stock' => 'getEndWhenStock',
        'stock_percentage' => 'getStockPercentage',
        'last_update' => 'getLastUpdate',
        'update_status' => 'getUpdateStatus',
        'submitted_quantity' => 'getSubmittedQuantity',
        'listed_quantity' => 'getListedQuantity',
        'retry_count' => 'getRetryCount',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('fk_row_id', $data ?? [], null);
        $this->setIfExists('location_id', $data ?? [], null);
        $this->setIfExists('location_name', $data ?? [], null);
        $this->setIfExists('ignore_sync', $data ?? [], null);
        $this->setIfExists('max_listed_quantity', $data ?? [], null);
        $this->setIfExists('end_when_stock', $data ?? [], null);
        $this->setIfExists('stock_percentage', $data ?? [], null);
        $this->setIfExists('last_update', $data ?? [], null);
        $this->setIfExists('update_status', $data ?? [], null);
        $this->setIfExists('submitted_quantity', $data ?? [], null);
        $this->setIfExists('listed_quantity', $data ?? [], null);
        $this->setIfExists('retry_count', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets fk_row_id
     *
     * @return string|null
     */
    public function getFkRowId()
    {
        return $this->container['fk_row_id'];
    }

    /**
     * Sets fk_row_id
     *
     * @param string|null $fk_row_id Record row ID
     *
     * @return self
     */
    public function setFkRowId($fk_row_id)
    {
        if (is_null($fk_row_id)) {
            throw new \InvalidArgumentException('non-nullable fk_row_id cannot be null');
        }
        $this->container['fk_row_id'] = $fk_row_id;

        return $this;
    }

    /**
     * Gets location_id
     *
     * @return int|null
     */
    public function getLocationId()
    {
        return $this->container['location_id'];
    }

    /**
     * Sets location_id
     *
     * @param int|null $location_id Location ID
     *
     * @return self
     */
    public function setLocationId($location_id)
    {
        if (is_null($location_id)) {
            throw new \InvalidArgumentException('non-nullable location_id cannot be null');
        }
        $this->container['location_id'] = $location_id;

        return $this;
    }

    /**
     * Gets location_name
     *
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->container['location_name'];
    }

    /**
     * Sets location_name
     *
     * @param string|null $location_name Location name
     *
     * @return self
     */
    public function setLocationName($location_name)
    {
        if (is_null($location_name)) {
            throw new \InvalidArgumentException('non-nullable location_name cannot be null');
        }
        $this->container['location_name'] = $location_name;

        return $this;
    }

    /**
     * Gets ignore_sync
     *
     * @return bool|null
     */
    public function getIgnoreSync()
    {
        return $this->container['ignore_sync'];
    }

    /**
     * Sets ignore_sync
     *
     * @param bool|null $ignore_sync Ignored on a sync
     *
     * @return self
     */
    public function setIgnoreSync($ignore_sync)
    {
        if (is_null($ignore_sync)) {
            throw new \InvalidArgumentException('non-nullable ignore_sync cannot be null');
        }
        $this->container['ignore_sync'] = $ignore_sync;

        return $this;
    }

    /**
     * Gets max_listed_quantity
     *
     * @return int|null
     */
    public function getMaxListedQuantity()
    {
        return $this->container['max_listed_quantity'];
    }

    /**
     * Sets max_listed_quantity
     *
     * @param int|null $max_listed_quantity Maximum listed quantity
     *
     * @return self
     */
    public function setMaxListedQuantity($max_listed_quantity)
    {
        if (is_null($max_listed_quantity)) {
            throw new \InvalidArgumentException('non-nullable max_listed_quantity cannot be null');
        }
        $this->container['max_listed_quantity'] = $max_listed_quantity;

        return $this;
    }

    /**
     * Gets end_when_stock
     *
     * @return int|null
     */
    public function getEndWhenStock()
    {
        return $this->container['end_when_stock'];
    }

    /**
     * Sets end_when_stock
     *
     * @param int|null $end_when_stock End listing when stock level
     *
     * @return self
     */
    public function setEndWhenStock($end_when_stock)
    {
        if (is_null($end_when_stock)) {
            throw new \InvalidArgumentException('non-nullable end_when_stock cannot be null');
        }
        $this->container['end_when_stock'] = $end_when_stock;

        return $this;
    }

    /**
     * Gets stock_percentage
     *
     * @return float|null
     */
    public function getStockPercentage()
    {
        return $this->container['stock_percentage'];
    }

    /**
     * Sets stock_percentage
     *
     * @param float|null $stock_percentage Stock percantage
     *
     * @return self
     */
    public function setStockPercentage($stock_percentage)
    {
        if (is_null($stock_percentage)) {
            throw new \InvalidArgumentException('non-nullable stock_percentage cannot be null');
        }
        $this->container['stock_percentage'] = $stock_percentage;

        return $this;
    }

    /**
     * Gets last_update
     *
     * @return \DateTime|null
     */
    public function getLastUpdate()
    {
        return $this->container['last_update'];
    }

    /**
     * Sets last_update
     *
     * @param \DateTime|null $last_update Last update date and time
     *
     * @return self
     */
    public function setLastUpdate($last_update)
    {
        if (is_null($last_update)) {
            throw new \InvalidArgumentException('non-nullable last_update cannot be null');
        }
        $this->container['last_update'] = $last_update;

        return $this;
    }

    /**
     * Gets update_status
     *
     * @return string|null
     */
    public function getUpdateStatus()
    {
        return $this->container['update_status'];
    }

    /**
     * Sets update_status
     *
     * @param string|null $update_status Current update status
     *
     * @return self
     */
    public function setUpdateStatus($update_status)
    {
        if (is_null($update_status)) {
            throw new \InvalidArgumentException('non-nullable update_status cannot be null');
        }
        $this->container['update_status'] = $update_status;

        return $this;
    }

    /**
     * Gets submitted_quantity
     *
     * @return int|null
     */
    public function getSubmittedQuantity()
    {
        return $this->container['submitted_quantity'];
    }

    /**
     * Sets submitted_quantity
     *
     * @param int|null $submitted_quantity Quantity submitted to the channel
     *
     * @return self
     */
    public function setSubmittedQuantity($submitted_quantity)
    {
        if (is_null($submitted_quantity)) {
            throw new \InvalidArgumentException('non-nullable submitted_quantity cannot be null');
        }
        $this->container['submitted_quantity'] = $submitted_quantity;

        return $this;
    }

    /**
     * Gets listed_quantity
     *
     * @return int|null
     */
    public function getListedQuantity()
    {
        return $this->container['listed_quantity'];
    }

    /**
     * Sets listed_quantity
     *
     * @param int|null $listed_quantity Currently listed quantity
     *
     * @return self
     */
    public function setListedQuantity($listed_quantity)
    {
        if (is_null($listed_quantity)) {
            throw new \InvalidArgumentException('non-nullable listed_quantity cannot be null');
        }
        $this->container['listed_quantity'] = $listed_quantity;

        return $this;
    }

    /**
     * Gets retry_count
     *
     * @return int|null
     */
    public function getRetryCount()
    {
        return $this->container['retry_count'];
    }

    /**
     * Sets retry_count
     *
     * @param int|null $retry_count How many retries
     *
     * @return self
     */
    public function setRetryCount($retry_count)
    {
        if (is_null($retry_count)) {
            throw new \InvalidArgumentException('non-nullable retry_count cannot be null');
        }
        $this->container['retry_count'] = $retry_count;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


