<?php
/**
 * StockItemChannelSKU
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemChannelSKU Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemChannelSKU implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemChannelSKU';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'channel_sku_row_id' => 'string',
        'sku' => 'string',
        'source' => 'string',
        'sub_source' => 'string',
        'update_status' => 'string',
        'channel_reference_id' => 'string',
        'last_update' => '\DateTime',
        'max_listed_quantity' => 'int',
        'end_when_stock' => 'int',
        'submitted_quantity' => 'int',
        'listed_quantity' => 'int',
        'stock_percentage' => 'float',
        'ignore_sync' => 'bool',
        'ignore_sync_multi_location' => 'bool',
        'is_multi_location' => 'bool',
        'stock_item_id' => 'string',
        'stock_item_int_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'channel_sku_row_id' => 'uuid',
        'sku' => null,
        'source' => null,
        'sub_source' => null,
        'update_status' => null,
        'channel_reference_id' => null,
        'last_update' => 'date-time',
        'max_listed_quantity' => 'int32',
        'end_when_stock' => 'int32',
        'submitted_quantity' => 'int32',
        'listed_quantity' => 'int32',
        'stock_percentage' => 'double',
        'ignore_sync' => null,
        'ignore_sync_multi_location' => null,
        'is_multi_location' => null,
        'stock_item_id' => 'uuid',
        'stock_item_int_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'channel_sku_row_id' => false,
        'sku' => false,
        'source' => false,
        'sub_source' => false,
        'update_status' => false,
        'channel_reference_id' => false,
        'last_update' => false,
        'max_listed_quantity' => false,
        'end_when_stock' => false,
        'submitted_quantity' => false,
        'listed_quantity' => false,
        'stock_percentage' => false,
        'ignore_sync' => false,
        'ignore_sync_multi_location' => false,
        'is_multi_location' => false,
        'stock_item_id' => false,
        'stock_item_int_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'channel_sku_row_id' => 'ChannelSKURowId',
        'sku' => 'SKU',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'update_status' => 'UpdateStatus',
        'channel_reference_id' => 'ChannelReferenceId',
        'last_update' => 'LastUpdate',
        'max_listed_quantity' => 'MaxListedQuantity',
        'end_when_stock' => 'EndWhenStock',
        'submitted_quantity' => 'SubmittedQuantity',
        'listed_quantity' => 'ListedQuantity',
        'stock_percentage' => 'StockPercentage',
        'ignore_sync' => 'IgnoreSync',
        'ignore_sync_multi_location' => 'IgnoreSyncMultiLocation',
        'is_multi_location' => 'IsMultiLocation',
        'stock_item_id' => 'StockItemId',
        'stock_item_int_id' => 'StockItemIntId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'channel_sku_row_id' => 'setChannelSkuRowId',
        'sku' => 'setSku',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'update_status' => 'setUpdateStatus',
        'channel_reference_id' => 'setChannelReferenceId',
        'last_update' => 'setLastUpdate',
        'max_listed_quantity' => 'setMaxListedQuantity',
        'end_when_stock' => 'setEndWhenStock',
        'submitted_quantity' => 'setSubmittedQuantity',
        'listed_quantity' => 'setListedQuantity',
        'stock_percentage' => 'setStockPercentage',
        'ignore_sync' => 'setIgnoreSync',
        'ignore_sync_multi_location' => 'setIgnoreSyncMultiLocation',
        'is_multi_location' => 'setIsMultiLocation',
        'stock_item_id' => 'setStockItemId',
        'stock_item_int_id' => 'setStockItemIntId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'channel_sku_row_id' => 'getChannelSkuRowId',
        'sku' => 'getSku',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'update_status' => 'getUpdateStatus',
        'channel_reference_id' => 'getChannelReferenceId',
        'last_update' => 'getLastUpdate',
        'max_listed_quantity' => 'getMaxListedQuantity',
        'end_when_stock' => 'getEndWhenStock',
        'submitted_quantity' => 'getSubmittedQuantity',
        'listed_quantity' => 'getListedQuantity',
        'stock_percentage' => 'getStockPercentage',
        'ignore_sync' => 'getIgnoreSync',
        'ignore_sync_multi_location' => 'getIgnoreSyncMultiLocation',
        'is_multi_location' => 'getIsMultiLocation',
        'stock_item_id' => 'getStockItemId',
        'stock_item_int_id' => 'getStockItemIntId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('channel_sku_row_id', $data ?? [], null);
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('update_status', $data ?? [], null);
        $this->setIfExists('channel_reference_id', $data ?? [], null);
        $this->setIfExists('last_update', $data ?? [], null);
        $this->setIfExists('max_listed_quantity', $data ?? [], null);
        $this->setIfExists('end_when_stock', $data ?? [], null);
        $this->setIfExists('submitted_quantity', $data ?? [], null);
        $this->setIfExists('listed_quantity', $data ?? [], null);
        $this->setIfExists('stock_percentage', $data ?? [], null);
        $this->setIfExists('ignore_sync', $data ?? [], null);
        $this->setIfExists('ignore_sync_multi_location', $data ?? [], null);
        $this->setIfExists('is_multi_location', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('stock_item_int_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets channel_sku_row_id
     *
     * @return string|null
     */
    public function getChannelSkuRowId()
    {
        return $this->container['channel_sku_row_id'];
    }

    /**
     * Sets channel_sku_row_id
     *
     * @param string|null $channel_sku_row_id RowId of channel SKU
     *
     * @return self
     */
    public function setChannelSkuRowId($channel_sku_row_id)
    {
        if (is_null($channel_sku_row_id)) {
            throw new \InvalidArgumentException('non-nullable channel_sku_row_id cannot be null');
        }
        $this->container['channel_sku_row_id'] = $channel_sku_row_id;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku Product SKU number
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source Region code
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets update_status
     *
     * @return string|null
     */
    public function getUpdateStatus()
    {
        return $this->container['update_status'];
    }

    /**
     * Sets update_status
     *
     * @param string|null $update_status Current update status
     *
     * @return self
     */
    public function setUpdateStatus($update_status)
    {
        if (is_null($update_status)) {
            throw new \InvalidArgumentException('non-nullable update_status cannot be null');
        }
        $this->container['update_status'] = $update_status;

        return $this;
    }

    /**
     * Gets channel_reference_id
     *
     * @return string|null
     */
    public function getChannelReferenceId()
    {
        return $this->container['channel_reference_id'];
    }

    /**
     * Sets channel_reference_id
     *
     * @param string|null $channel_reference_id Channel reference ID
     *
     * @return self
     */
    public function setChannelReferenceId($channel_reference_id)
    {
        if (is_null($channel_reference_id)) {
            throw new \InvalidArgumentException('non-nullable channel_reference_id cannot be null');
        }
        $this->container['channel_reference_id'] = $channel_reference_id;

        return $this;
    }

    /**
     * Gets last_update
     *
     * @return \DateTime|null
     */
    public function getLastUpdate()
    {
        return $this->container['last_update'];
    }

    /**
     * Sets last_update
     *
     * @param \DateTime|null $last_update Last update date and time
     *
     * @return self
     */
    public function setLastUpdate($last_update)
    {
        if (is_null($last_update)) {
            throw new \InvalidArgumentException('non-nullable last_update cannot be null');
        }
        $this->container['last_update'] = $last_update;

        return $this;
    }

    /**
     * Gets max_listed_quantity
     *
     * @return int|null
     */
    public function getMaxListedQuantity()
    {
        return $this->container['max_listed_quantity'];
    }

    /**
     * Sets max_listed_quantity
     *
     * @param int|null $max_listed_quantity Maximum listed quantity
     *
     * @return self
     */
    public function setMaxListedQuantity($max_listed_quantity)
    {
        if (is_null($max_listed_quantity)) {
            throw new \InvalidArgumentException('non-nullable max_listed_quantity cannot be null');
        }
        $this->container['max_listed_quantity'] = $max_listed_quantity;

        return $this;
    }

    /**
     * Gets end_when_stock
     *
     * @return int|null
     */
    public function getEndWhenStock()
    {
        return $this->container['end_when_stock'];
    }

    /**
     * Sets end_when_stock
     *
     * @param int|null $end_when_stock End listing when stock level
     *
     * @return self
     */
    public function setEndWhenStock($end_when_stock)
    {
        if (is_null($end_when_stock)) {
            throw new \InvalidArgumentException('non-nullable end_when_stock cannot be null');
        }
        $this->container['end_when_stock'] = $end_when_stock;

        return $this;
    }

    /**
     * Gets submitted_quantity
     *
     * @return int|null
     */
    public function getSubmittedQuantity()
    {
        return $this->container['submitted_quantity'];
    }

    /**
     * Sets submitted_quantity
     *
     * @param int|null $submitted_quantity Submitted quantity
     *
     * @return self
     */
    public function setSubmittedQuantity($submitted_quantity)
    {
        if (is_null($submitted_quantity)) {
            throw new \InvalidArgumentException('non-nullable submitted_quantity cannot be null');
        }
        $this->container['submitted_quantity'] = $submitted_quantity;

        return $this;
    }

    /**
     * Gets listed_quantity
     *
     * @return int|null
     */
    public function getListedQuantity()
    {
        return $this->container['listed_quantity'];
    }

    /**
     * Sets listed_quantity
     *
     * @param int|null $listed_quantity Listed quantity
     *
     * @return self
     */
    public function setListedQuantity($listed_quantity)
    {
        if (is_null($listed_quantity)) {
            throw new \InvalidArgumentException('non-nullable listed_quantity cannot be null');
        }
        $this->container['listed_quantity'] = $listed_quantity;

        return $this;
    }

    /**
     * Gets stock_percentage
     *
     * @return float|null
     */
    public function getStockPercentage()
    {
        return $this->container['stock_percentage'];
    }

    /**
     * Sets stock_percentage
     *
     * @param float|null $stock_percentage Stock percentage
     *
     * @return self
     */
    public function setStockPercentage($stock_percentage)
    {
        if (is_null($stock_percentage)) {
            throw new \InvalidArgumentException('non-nullable stock_percentage cannot be null');
        }
        $this->container['stock_percentage'] = $stock_percentage;

        return $this;
    }

    /**
     * Gets ignore_sync
     *
     * @return bool|null
     */
    public function getIgnoreSync()
    {
        return $this->container['ignore_sync'];
    }

    /**
     * Sets ignore_sync
     *
     * @param bool|null $ignore_sync Ignore sync
     *
     * @return self
     */
    public function setIgnoreSync($ignore_sync)
    {
        if (is_null($ignore_sync)) {
            throw new \InvalidArgumentException('non-nullable ignore_sync cannot be null');
        }
        $this->container['ignore_sync'] = $ignore_sync;

        return $this;
    }

    /**
     * Gets ignore_sync_multi_location
     *
     * @return bool|null
     */
    public function getIgnoreSyncMultiLocation()
    {
        return $this->container['ignore_sync_multi_location'];
    }

    /**
     * Sets ignore_sync_multi_location
     *
     * @param bool|null $ignore_sync_multi_location Ignore sync for multi location items
     *
     * @return self
     */
    public function setIgnoreSyncMultiLocation($ignore_sync_multi_location)
    {
        if (is_null($ignore_sync_multi_location)) {
            throw new \InvalidArgumentException('non-nullable ignore_sync_multi_location cannot be null');
        }
        $this->container['ignore_sync_multi_location'] = $ignore_sync_multi_location;

        return $this;
    }

    /**
     * Gets is_multi_location
     *
     * @return bool|null
     */
    public function getIsMultiLocation()
    {
        return $this->container['is_multi_location'];
    }

    /**
     * Sets is_multi_location
     *
     * @param bool|null $is_multi_location Multi location
     *
     * @return self
     */
    public function setIsMultiLocation($is_multi_location)
    {
        if (is_null($is_multi_location)) {
            throw new \InvalidArgumentException('non-nullable is_multi_location cannot be null');
        }
        $this->container['is_multi_location'] = $is_multi_location;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stock Item Id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets stock_item_int_id
     *
     * @return int|null
     */
    public function getStockItemIntId()
    {
        return $this->container['stock_item_int_id'];
    }

    /**
     * Sets stock_item_int_id
     *
     * @param int|null $stock_item_int_id Stock Item interger Id
     *
     * @return self
     */
    public function setStockItemIntId($stock_item_int_id)
    {
        if (is_null($stock_item_int_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_int_id cannot be null');
        }
        $this->container['stock_item_int_id'] = $stock_item_int_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


