<?php
/**
 * StockItemBatchInventory
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * StockItemBatchInventory Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class StockItemBatchInventory implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'StockItemBatchInventory';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'batch_inventory_id' => 'int',
        'batch_id' => 'int',
        'stock_location_id' => 'string',
        'bin_rack' => 'string',
        'priority_sequence' => 'int',
        'quantity' => 'int',
        'stock_value' => 'float',
        'start_quantity' => 'int',
        'picked_quantity' => 'int',
        'batch_status' => 'string',
        'is_deleted' => 'bool',
        'warehouse_binrack_standard_type' => 'int',
        'warehouse_binrack_type_name' => 'string',
        'in_transfer' => 'int',
        'bin_rack_id' => 'int',
        'warehouse_binrack_type_id' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'batch_inventory_id' => 'int32',
        'batch_id' => 'int32',
        'stock_location_id' => 'uuid',
        'bin_rack' => null,
        'priority_sequence' => 'int32',
        'quantity' => 'int32',
        'stock_value' => 'double',
        'start_quantity' => 'int32',
        'picked_quantity' => 'int32',
        'batch_status' => null,
        'is_deleted' => null,
        'warehouse_binrack_standard_type' => 'int32',
        'warehouse_binrack_type_name' => null,
        'in_transfer' => 'int32',
        'bin_rack_id' => 'int32',
        'warehouse_binrack_type_id' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'batch_inventory_id' => false,
        'batch_id' => false,
        'stock_location_id' => false,
        'bin_rack' => false,
        'priority_sequence' => false,
        'quantity' => false,
        'stock_value' => false,
        'start_quantity' => false,
        'picked_quantity' => false,
        'batch_status' => false,
        'is_deleted' => false,
        'warehouse_binrack_standard_type' => false,
        'warehouse_binrack_type_name' => false,
        'in_transfer' => false,
        'bin_rack_id' => false,
        'warehouse_binrack_type_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'batch_inventory_id' => 'BatchInventoryId',
        'batch_id' => 'BatchId',
        'stock_location_id' => 'StockLocationId',
        'bin_rack' => 'BinRack',
        'priority_sequence' => 'PrioritySequence',
        'quantity' => 'Quantity',
        'stock_value' => 'StockValue',
        'start_quantity' => 'StartQuantity',
        'picked_quantity' => 'PickedQuantity',
        'batch_status' => 'BatchStatus',
        'is_deleted' => 'IsDeleted',
        'warehouse_binrack_standard_type' => 'WarehouseBinrackStandardType',
        'warehouse_binrack_type_name' => 'WarehouseBinrackTypeName',
        'in_transfer' => 'InTransfer',
        'bin_rack_id' => 'BinRackId',
        'warehouse_binrack_type_id' => 'WarehouseBinrackTypeId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'batch_inventory_id' => 'setBatchInventoryId',
        'batch_id' => 'setBatchId',
        'stock_location_id' => 'setStockLocationId',
        'bin_rack' => 'setBinRack',
        'priority_sequence' => 'setPrioritySequence',
        'quantity' => 'setQuantity',
        'stock_value' => 'setStockValue',
        'start_quantity' => 'setStartQuantity',
        'picked_quantity' => 'setPickedQuantity',
        'batch_status' => 'setBatchStatus',
        'is_deleted' => 'setIsDeleted',
        'warehouse_binrack_standard_type' => 'setWarehouseBinrackStandardType',
        'warehouse_binrack_type_name' => 'setWarehouseBinrackTypeName',
        'in_transfer' => 'setInTransfer',
        'bin_rack_id' => 'setBinRackId',
        'warehouse_binrack_type_id' => 'setWarehouseBinrackTypeId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'batch_inventory_id' => 'getBatchInventoryId',
        'batch_id' => 'getBatchId',
        'stock_location_id' => 'getStockLocationId',
        'bin_rack' => 'getBinRack',
        'priority_sequence' => 'getPrioritySequence',
        'quantity' => 'getQuantity',
        'stock_value' => 'getStockValue',
        'start_quantity' => 'getStartQuantity',
        'picked_quantity' => 'getPickedQuantity',
        'batch_status' => 'getBatchStatus',
        'is_deleted' => 'getIsDeleted',
        'warehouse_binrack_standard_type' => 'getWarehouseBinrackStandardType',
        'warehouse_binrack_type_name' => 'getWarehouseBinrackTypeName',
        'in_transfer' => 'getInTransfer',
        'bin_rack_id' => 'getBinRackId',
        'warehouse_binrack_type_id' => 'getWarehouseBinrackTypeId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('batch_id', $data ?? [], null);
        $this->setIfExists('stock_location_id', $data ?? [], null);
        $this->setIfExists('bin_rack', $data ?? [], null);
        $this->setIfExists('priority_sequence', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('stock_value', $data ?? [], null);
        $this->setIfExists('start_quantity', $data ?? [], null);
        $this->setIfExists('picked_quantity', $data ?? [], null);
        $this->setIfExists('batch_status', $data ?? [], null);
        $this->setIfExists('is_deleted', $data ?? [], null);
        $this->setIfExists('warehouse_binrack_standard_type', $data ?? [], null);
        $this->setIfExists('warehouse_binrack_type_name', $data ?? [], null);
        $this->setIfExists('in_transfer', $data ?? [], null);
        $this->setIfExists('bin_rack_id', $data ?? [], null);
        $this->setIfExists('warehouse_binrack_type_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id Stock item batch record ID
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets batch_id
     *
     * @return int|null
     */
    public function getBatchId()
    {
        return $this->container['batch_id'];
    }

    /**
     * Sets batch_id
     *
     * @param int|null $batch_id Batch ID
     *
     * @return self
     */
    public function setBatchId($batch_id)
    {
        if (is_null($batch_id)) {
            throw new \InvalidArgumentException('non-nullable batch_id cannot be null');
        }
        $this->container['batch_id'] = $batch_id;

        return $this;
    }

    /**
     * Gets stock_location_id
     *
     * @return string|null
     */
    public function getStockLocationId()
    {
        return $this->container['stock_location_id'];
    }

    /**
     * Sets stock_location_id
     *
     * @param string|null $stock_location_id Location ID
     *
     * @return self
     */
    public function setStockLocationId($stock_location_id)
    {
        if (is_null($stock_location_id)) {
            throw new \InvalidArgumentException('non-nullable stock_location_id cannot be null');
        }
        $this->container['stock_location_id'] = $stock_location_id;

        return $this;
    }

    /**
     * Gets bin_rack
     *
     * @return string|null
     */
    public function getBinRack()
    {
        return $this->container['bin_rack'];
    }

    /**
     * Sets bin_rack
     *
     * @param string|null $bin_rack BinRack
     *
     * @return self
     */
    public function setBinRack($bin_rack)
    {
        if (is_null($bin_rack)) {
            throw new \InvalidArgumentException('non-nullable bin_rack cannot be null');
        }
        $this->container['bin_rack'] = $bin_rack;

        return $this;
    }

    /**
     * Gets priority_sequence
     *
     * @return int|null
     */
    public function getPrioritySequence()
    {
        return $this->container['priority_sequence'];
    }

    /**
     * Sets priority_sequence
     *
     * @param int|null $priority_sequence Pick order
     *
     * @return self
     */
    public function setPrioritySequence($priority_sequence)
    {
        if (is_null($priority_sequence)) {
            throw new \InvalidArgumentException('non-nullable priority_sequence cannot be null');
        }
        $this->container['priority_sequence'] = $priority_sequence;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets stock_value
     *
     * @return float|null
     */
    public function getStockValue()
    {
        return $this->container['stock_value'];
    }

    /**
     * Sets stock_value
     *
     * @param float|null $stock_value Current stock value
     *
     * @return self
     */
    public function setStockValue($stock_value)
    {
        if (is_null($stock_value)) {
            throw new \InvalidArgumentException('non-nullable stock_value cannot be null');
        }
        $this->container['stock_value'] = $stock_value;

        return $this;
    }

    /**
     * Gets start_quantity
     *
     * @return int|null
     */
    public function getStartQuantity()
    {
        return $this->container['start_quantity'];
    }

    /**
     * Sets start_quantity
     *
     * @param int|null $start_quantity Quantity originally booked in
     *
     * @return self
     */
    public function setStartQuantity($start_quantity)
    {
        if (is_null($start_quantity)) {
            throw new \InvalidArgumentException('non-nullable start_quantity cannot be null');
        }
        $this->container['start_quantity'] = $start_quantity;

        return $this;
    }

    /**
     * Gets picked_quantity
     *
     * @return int|null
     */
    public function getPickedQuantity()
    {
        return $this->container['picked_quantity'];
    }

    /**
     * Sets picked_quantity
     *
     * @param int|null $picked_quantity Indicate how many units are now allocated in open orders
     *
     * @return self
     */
    public function setPickedQuantity($picked_quantity)
    {
        if (is_null($picked_quantity)) {
            throw new \InvalidArgumentException('non-nullable picked_quantity cannot be null');
        }
        $this->container['picked_quantity'] = $picked_quantity;

        return $this;
    }

    /**
     * Gets batch_status
     *
     * @return string|null
     */
    public function getBatchStatus()
    {
        return $this->container['batch_status'];
    }

    /**
     * Sets batch_status
     *
     * @param string|null $batch_status Batch Status
     *
     * @return self
     */
    public function setBatchStatus($batch_status)
    {
        if (is_null($batch_status)) {
            throw new \InvalidArgumentException('non-nullable batch_status cannot be null');
        }
        $this->container['batch_status'] = $batch_status;

        return $this;
    }

    /**
     * Gets is_deleted
     *
     * @return bool|null
     */
    public function getIsDeleted()
    {
        return $this->container['is_deleted'];
    }

    /**
     * Sets is_deleted
     *
     * @param bool|null $is_deleted Is BatchInventory deleted
     *
     * @return self
     */
    public function setIsDeleted($is_deleted)
    {
        if (is_null($is_deleted)) {
            throw new \InvalidArgumentException('non-nullable is_deleted cannot be null');
        }
        $this->container['is_deleted'] = $is_deleted;

        return $this;
    }

    /**
     * Gets warehouse_binrack_standard_type
     *
     * @return int|null
     */
    public function getWarehouseBinrackStandardType()
    {
        return $this->container['warehouse_binrack_standard_type'];
    }

    /**
     * Sets warehouse_binrack_standard_type
     *
     * @param int|null $warehouse_binrack_standard_type Warehouse binrack standard type
     *
     * @return self
     */
    public function setWarehouseBinrackStandardType($warehouse_binrack_standard_type)
    {
        if (is_null($warehouse_binrack_standard_type)) {
            throw new \InvalidArgumentException('non-nullable warehouse_binrack_standard_type cannot be null');
        }
        $this->container['warehouse_binrack_standard_type'] = $warehouse_binrack_standard_type;

        return $this;
    }

    /**
     * Gets warehouse_binrack_type_name
     *
     * @return string|null
     */
    public function getWarehouseBinrackTypeName()
    {
        return $this->container['warehouse_binrack_type_name'];
    }

    /**
     * Sets warehouse_binrack_type_name
     *
     * @param string|null $warehouse_binrack_type_name Warehouse binrack type friendly name
     *
     * @return self
     */
    public function setWarehouseBinrackTypeName($warehouse_binrack_type_name)
    {
        if (is_null($warehouse_binrack_type_name)) {
            throw new \InvalidArgumentException('non-nullable warehouse_binrack_type_name cannot be null');
        }
        $this->container['warehouse_binrack_type_name'] = $warehouse_binrack_type_name;

        return $this;
    }

    /**
     * Gets in_transfer
     *
     * @return int|null
     */
    public function getInTransfer()
    {
        return $this->container['in_transfer'];
    }

    /**
     * Sets in_transfer
     *
     * @param int|null $in_transfer Number of items in Transfer phase.
     *
     * @return self
     */
    public function setInTransfer($in_transfer)
    {
        if (is_null($in_transfer)) {
            throw new \InvalidArgumentException('non-nullable in_transfer cannot be null');
        }
        $this->container['in_transfer'] = $in_transfer;

        return $this;
    }

    /**
     * Gets bin_rack_id
     *
     * @return int|null
     */
    public function getBinRackId()
    {
        return $this->container['bin_rack_id'];
    }

    /**
     * Sets bin_rack_id
     *
     * @param int|null $bin_rack_id Binrack Id (Use for WMS)
     *
     * @return self
     */
    public function setBinRackId($bin_rack_id)
    {
        if (is_null($bin_rack_id)) {
            throw new \InvalidArgumentException('non-nullable bin_rack_id cannot be null');
        }
        $this->container['bin_rack_id'] = $bin_rack_id;

        return $this;
    }

    /**
     * Gets warehouse_binrack_type_id
     *
     * @return int|null
     */
    public function getWarehouseBinrackTypeId()
    {
        return $this->container['warehouse_binrack_type_id'];
    }

    /**
     * Sets warehouse_binrack_type_id
     *
     * @param int|null $warehouse_binrack_type_id Warehouse binrack type unique id.
     *
     * @return self
     */
    public function setWarehouseBinrackTypeId($warehouse_binrack_type_id)
    {
        if (is_null($warehouse_binrack_type_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_binrack_type_id cannot be null');
        }
        $this->container['warehouse_binrack_type_id'] = $warehouse_binrack_type_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


