<?php
/**
 * ScrapItemExtended
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * ScrapItemExtended Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ScrapItemExtended implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ScrapItemExtended';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_scrap_id' => 'string',
        'batch_inventory_id' => 'int',
        'fk_stock_item_id' => 'string',
        'quantity' => 'int',
        'scrap_category' => 'string',
        'scrap_reason' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_scrap_id' => 'uuid',
        'batch_inventory_id' => 'int32',
        'fk_stock_item_id' => 'uuid',
        'quantity' => 'int32',
        'scrap_category' => null,
        'scrap_reason' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_scrap_id' => false,
        'batch_inventory_id' => false,
        'fk_stock_item_id' => false,
        'quantity' => false,
        'scrap_category' => false,
        'scrap_reason' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_scrap_id' => 'pkScrapId',
        'batch_inventory_id' => 'BatchInventoryId',
        'fk_stock_item_id' => 'fkStockItemId',
        'quantity' => 'Quantity',
        'scrap_category' => 'ScrapCategory',
        'scrap_reason' => 'ScrapReason'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_scrap_id' => 'setPkScrapId',
        'batch_inventory_id' => 'setBatchInventoryId',
        'fk_stock_item_id' => 'setFkStockItemId',
        'quantity' => 'setQuantity',
        'scrap_category' => 'setScrapCategory',
        'scrap_reason' => 'setScrapReason'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_scrap_id' => 'getPkScrapId',
        'batch_inventory_id' => 'getBatchInventoryId',
        'fk_stock_item_id' => 'getFkStockItemId',
        'quantity' => 'getQuantity',
        'scrap_category' => 'getScrapCategory',
        'scrap_reason' => 'getScrapReason'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_scrap_id', $data ?? [], null);
        $this->setIfExists('batch_inventory_id', $data ?? [], null);
        $this->setIfExists('fk_stock_item_id', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('scrap_category', $data ?? [], null);
        $this->setIfExists('scrap_reason', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_scrap_id
     *
     * @return string|null
     */
    public function getPkScrapId()
    {
        return $this->container['pk_scrap_id'];
    }

    /**
     * Sets pk_scrap_id
     *
     * @param string|null $pk_scrap_id Nullable
     *
     * @return self
     */
    public function setPkScrapId($pk_scrap_id)
    {
        if (is_null($pk_scrap_id)) {
            throw new \InvalidArgumentException('non-nullable pk_scrap_id cannot be null');
        }
        $this->container['pk_scrap_id'] = $pk_scrap_id;

        return $this;
    }

    /**
     * Gets batch_inventory_id
     *
     * @return int|null
     */
    public function getBatchInventoryId()
    {
        return $this->container['batch_inventory_id'];
    }

    /**
     * Sets batch_inventory_id
     *
     * @param int|null $batch_inventory_id Inventory batch id
     *
     * @return self
     */
    public function setBatchInventoryId($batch_inventory_id)
    {
        if (is_null($batch_inventory_id)) {
            throw new \InvalidArgumentException('non-nullable batch_inventory_id cannot be null');
        }
        $this->container['batch_inventory_id'] = $batch_inventory_id;

        return $this;
    }

    /**
     * Gets fk_stock_item_id
     *
     * @return string|null
     */
    public function getFkStockItemId()
    {
        return $this->container['fk_stock_item_id'];
    }

    /**
     * Sets fk_stock_item_id
     *
     * @param string|null $fk_stock_item_id Stock item id to scrap
     *
     * @return self
     */
    public function setFkStockItemId($fk_stock_item_id)
    {
        if (is_null($fk_stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable fk_stock_item_id cannot be null');
        }
        $this->container['fk_stock_item_id'] = $fk_stock_item_id;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity Quantity to scrap
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets scrap_category
     *
     * @return string|null
     */
    public function getScrapCategory()
    {
        return $this->container['scrap_category'];
    }

    /**
     * Sets scrap_category
     *
     * @param string|null $scrap_category Scrap category
     *
     * @return self
     */
    public function setScrapCategory($scrap_category)
    {
        if (is_null($scrap_category)) {
            throw new \InvalidArgumentException('non-nullable scrap_category cannot be null');
        }
        $this->container['scrap_category'] = $scrap_category;

        return $this;
    }

    /**
     * Gets scrap_reason
     *
     * @return string|null
     */
    public function getScrapReason()
    {
        return $this->container['scrap_reason'];
    }

    /**
     * Sets scrap_reason
     *
     * @param string|null $scrap_reason Scrap reason (max 600 characters)
     *
     * @return self
     */
    public function setScrapReason($scrap_reason)
    {
        if (is_null($scrap_reason)) {
            throw new \InvalidArgumentException('non-nullable scrap_reason cannot be null');
        }
        $this->container['scrap_reason'] = $scrap_reason;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


