<?php
/**
 * ParameterInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * ParameterInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ParameterInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ParameterInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'parameter_type' => 'string',
        'name' => 'string',
        'has_default_value' => 'bool',
        'default_value' => 'object',
        'raw_default_value' => 'object',
        'position' => 'int',
        'attributes' => 'string',
        'member' => '\Linnworks\Inventory\Model\MemberInfo',
        'is_in' => 'bool',
        'is_out' => 'bool',
        'is_lcid' => 'bool',
        'is_retval' => 'bool',
        'is_optional' => 'bool',
        'metadata_token' => 'int',
        'custom_attributes' => '\Linnworks\Inventory\Model\CustomAttributeData[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'parameter_type' => null,
        'name' => null,
        'has_default_value' => null,
        'default_value' => null,
        'raw_default_value' => null,
        'position' => 'int32',
        'attributes' => null,
        'member' => null,
        'is_in' => null,
        'is_out' => null,
        'is_lcid' => null,
        'is_retval' => null,
        'is_optional' => null,
        'metadata_token' => 'int32',
        'custom_attributes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'parameter_type' => false,
        'name' => false,
        'has_default_value' => false,
        'default_value' => false,
        'raw_default_value' => false,
        'position' => false,
        'attributes' => false,
        'member' => false,
        'is_in' => false,
        'is_out' => false,
        'is_lcid' => false,
        'is_retval' => false,
        'is_optional' => false,
        'metadata_token' => false,
        'custom_attributes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'parameter_type' => 'ParameterType',
        'name' => 'Name',
        'has_default_value' => 'HasDefaultValue',
        'default_value' => 'DefaultValue',
        'raw_default_value' => 'RawDefaultValue',
        'position' => 'Position',
        'attributes' => 'Attributes',
        'member' => 'Member',
        'is_in' => 'IsIn',
        'is_out' => 'IsOut',
        'is_lcid' => 'IsLcid',
        'is_retval' => 'IsRetval',
        'is_optional' => 'IsOptional',
        'metadata_token' => 'MetadataToken',
        'custom_attributes' => 'CustomAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'parameter_type' => 'setParameterType',
        'name' => 'setName',
        'has_default_value' => 'setHasDefaultValue',
        'default_value' => 'setDefaultValue',
        'raw_default_value' => 'setRawDefaultValue',
        'position' => 'setPosition',
        'attributes' => 'setAttributes',
        'member' => 'setMember',
        'is_in' => 'setIsIn',
        'is_out' => 'setIsOut',
        'is_lcid' => 'setIsLcid',
        'is_retval' => 'setIsRetval',
        'is_optional' => 'setIsOptional',
        'metadata_token' => 'setMetadataToken',
        'custom_attributes' => 'setCustomAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'parameter_type' => 'getParameterType',
        'name' => 'getName',
        'has_default_value' => 'getHasDefaultValue',
        'default_value' => 'getDefaultValue',
        'raw_default_value' => 'getRawDefaultValue',
        'position' => 'getPosition',
        'attributes' => 'getAttributes',
        'member' => 'getMember',
        'is_in' => 'getIsIn',
        'is_out' => 'getIsOut',
        'is_lcid' => 'getIsLcid',
        'is_retval' => 'getIsRetval',
        'is_optional' => 'getIsOptional',
        'metadata_token' => 'getMetadataToken',
        'custom_attributes' => 'getCustomAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ATTRIBUTES_NONE = 'None';
    public const ATTRIBUTES_IN = 'In';
    public const ATTRIBUTES_OUT = 'Out';
    public const ATTRIBUTES_LCID = 'Lcid';
    public const ATTRIBUTES_RETVAL = 'Retval';
    public const ATTRIBUTES_OPTIONAL = 'Optional';
    public const ATTRIBUTES_RESERVED_MASK = 'ReservedMask';
    public const ATTRIBUTES_HAS_DEFAULT = 'HasDefault';
    public const ATTRIBUTES_HAS_FIELD_MARSHAL = 'HasFieldMarshal';
    public const ATTRIBUTES_RESERVED3 = 'Reserved3';
    public const ATTRIBUTES_RESERVED4 = 'Reserved4';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAttributesAllowableValues()
    {
        return [
            self::ATTRIBUTES_NONE,
            self::ATTRIBUTES_IN,
            self::ATTRIBUTES_OUT,
            self::ATTRIBUTES_LCID,
            self::ATTRIBUTES_RETVAL,
            self::ATTRIBUTES_OPTIONAL,
            self::ATTRIBUTES_RESERVED_MASK,
            self::ATTRIBUTES_HAS_DEFAULT,
            self::ATTRIBUTES_HAS_FIELD_MARSHAL,
            self::ATTRIBUTES_RESERVED3,
            self::ATTRIBUTES_RESERVED4,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('parameter_type', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('has_default_value', $data ?? [], null);
        $this->setIfExists('default_value', $data ?? [], null);
        $this->setIfExists('raw_default_value', $data ?? [], null);
        $this->setIfExists('position', $data ?? [], null);
        $this->setIfExists('attributes', $data ?? [], null);
        $this->setIfExists('member', $data ?? [], null);
        $this->setIfExists('is_in', $data ?? [], null);
        $this->setIfExists('is_out', $data ?? [], null);
        $this->setIfExists('is_lcid', $data ?? [], null);
        $this->setIfExists('is_retval', $data ?? [], null);
        $this->setIfExists('is_optional', $data ?? [], null);
        $this->setIfExists('metadata_token', $data ?? [], null);
        $this->setIfExists('custom_attributes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getAttributesAllowableValues();
        if (!is_null($this->container['attributes']) && !in_array($this->container['attributes'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'attributes', must be one of '%s'",
                $this->container['attributes'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets parameter_type
     *
     * @return string|null
     */
    public function getParameterType()
    {
        return $this->container['parameter_type'];
    }

    /**
     * Sets parameter_type
     *
     * @param string|null $parameter_type parameter_type
     *
     * @return self
     */
    public function setParameterType($parameter_type)
    {
        if (is_null($parameter_type)) {
            throw new \InvalidArgumentException('non-nullable parameter_type cannot be null');
        }
        $this->container['parameter_type'] = $parameter_type;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets has_default_value
     *
     * @return bool|null
     */
    public function getHasDefaultValue()
    {
        return $this->container['has_default_value'];
    }

    /**
     * Sets has_default_value
     *
     * @param bool|null $has_default_value has_default_value
     *
     * @return self
     */
    public function setHasDefaultValue($has_default_value)
    {
        if (is_null($has_default_value)) {
            throw new \InvalidArgumentException('non-nullable has_default_value cannot be null');
        }
        $this->container['has_default_value'] = $has_default_value;

        return $this;
    }

    /**
     * Gets default_value
     *
     * @return object|null
     */
    public function getDefaultValue()
    {
        return $this->container['default_value'];
    }

    /**
     * Sets default_value
     *
     * @param object|null $default_value default_value
     *
     * @return self
     */
    public function setDefaultValue($default_value)
    {
        if (is_null($default_value)) {
            throw new \InvalidArgumentException('non-nullable default_value cannot be null');
        }
        $this->container['default_value'] = $default_value;

        return $this;
    }

    /**
     * Gets raw_default_value
     *
     * @return object|null
     */
    public function getRawDefaultValue()
    {
        return $this->container['raw_default_value'];
    }

    /**
     * Sets raw_default_value
     *
     * @param object|null $raw_default_value raw_default_value
     *
     * @return self
     */
    public function setRawDefaultValue($raw_default_value)
    {
        if (is_null($raw_default_value)) {
            throw new \InvalidArgumentException('non-nullable raw_default_value cannot be null');
        }
        $this->container['raw_default_value'] = $raw_default_value;

        return $this;
    }

    /**
     * Gets position
     *
     * @return int|null
     */
    public function getPosition()
    {
        return $this->container['position'];
    }

    /**
     * Sets position
     *
     * @param int|null $position position
     *
     * @return self
     */
    public function setPosition($position)
    {
        if (is_null($position)) {
            throw new \InvalidArgumentException('non-nullable position cannot be null');
        }
        $this->container['position'] = $position;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return string|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param string|null $attributes attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        if (is_null($attributes)) {
            throw new \InvalidArgumentException('non-nullable attributes cannot be null');
        }
        $allowedValues = $this->getAttributesAllowableValues();
        if (!in_array($attributes, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'attributes', must be one of '%s'",
                    $attributes,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets member
     *
     * @return \Linnworks\Inventory\Model\MemberInfo|null
     */
    public function getMember()
    {
        return $this->container['member'];
    }

    /**
     * Sets member
     *
     * @param \Linnworks\Inventory\Model\MemberInfo|null $member member
     *
     * @return self
     */
    public function setMember($member)
    {
        if (is_null($member)) {
            throw new \InvalidArgumentException('non-nullable member cannot be null');
        }
        $this->container['member'] = $member;

        return $this;
    }

    /**
     * Gets is_in
     *
     * @return bool|null
     */
    public function getIsIn()
    {
        return $this->container['is_in'];
    }

    /**
     * Sets is_in
     *
     * @param bool|null $is_in is_in
     *
     * @return self
     */
    public function setIsIn($is_in)
    {
        if (is_null($is_in)) {
            throw new \InvalidArgumentException('non-nullable is_in cannot be null');
        }
        $this->container['is_in'] = $is_in;

        return $this;
    }

    /**
     * Gets is_out
     *
     * @return bool|null
     */
    public function getIsOut()
    {
        return $this->container['is_out'];
    }

    /**
     * Sets is_out
     *
     * @param bool|null $is_out is_out
     *
     * @return self
     */
    public function setIsOut($is_out)
    {
        if (is_null($is_out)) {
            throw new \InvalidArgumentException('non-nullable is_out cannot be null');
        }
        $this->container['is_out'] = $is_out;

        return $this;
    }

    /**
     * Gets is_lcid
     *
     * @return bool|null
     */
    public function getIsLcid()
    {
        return $this->container['is_lcid'];
    }

    /**
     * Sets is_lcid
     *
     * @param bool|null $is_lcid is_lcid
     *
     * @return self
     */
    public function setIsLcid($is_lcid)
    {
        if (is_null($is_lcid)) {
            throw new \InvalidArgumentException('non-nullable is_lcid cannot be null');
        }
        $this->container['is_lcid'] = $is_lcid;

        return $this;
    }

    /**
     * Gets is_retval
     *
     * @return bool|null
     */
    public function getIsRetval()
    {
        return $this->container['is_retval'];
    }

    /**
     * Sets is_retval
     *
     * @param bool|null $is_retval is_retval
     *
     * @return self
     */
    public function setIsRetval($is_retval)
    {
        if (is_null($is_retval)) {
            throw new \InvalidArgumentException('non-nullable is_retval cannot be null');
        }
        $this->container['is_retval'] = $is_retval;

        return $this;
    }

    /**
     * Gets is_optional
     *
     * @return bool|null
     */
    public function getIsOptional()
    {
        return $this->container['is_optional'];
    }

    /**
     * Sets is_optional
     *
     * @param bool|null $is_optional is_optional
     *
     * @return self
     */
    public function setIsOptional($is_optional)
    {
        if (is_null($is_optional)) {
            throw new \InvalidArgumentException('non-nullable is_optional cannot be null');
        }
        $this->container['is_optional'] = $is_optional;

        return $this;
    }

    /**
     * Gets metadata_token
     *
     * @return int|null
     */
    public function getMetadataToken()
    {
        return $this->container['metadata_token'];
    }

    /**
     * Sets metadata_token
     *
     * @param int|null $metadata_token metadata_token
     *
     * @return self
     */
    public function setMetadataToken($metadata_token)
    {
        if (is_null($metadata_token)) {
            throw new \InvalidArgumentException('non-nullable metadata_token cannot be null');
        }
        $this->container['metadata_token'] = $metadata_token;

        return $this;
    }

    /**
     * Gets custom_attributes
     *
     * @return \Linnworks\Inventory\Model\CustomAttributeData[]|null
     */
    public function getCustomAttributes()
    {
        return $this->container['custom_attributes'];
    }

    /**
     * Sets custom_attributes
     *
     * @param \Linnworks\Inventory\Model\CustomAttributeData[]|null $custom_attributes custom_attributes
     *
     * @return self
     */
    public function setCustomAttributes($custom_attributes)
    {
        if (is_null($custom_attributes)) {
            throw new \InvalidArgumentException('non-nullable custom_attributes cannot be null');
        }
        $this->container['custom_attributes'] = $custom_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


