<?php
/**
 * MethodInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * MethodInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MethodInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MethodInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'member_type' => 'string',
        'return_type' => 'string',
        'return_parameter' => '\Linnworks\Inventory\Model\ParameterInfo',
        'return_type_custom_attributes' => 'object',
        'method_implementation_flags' => 'string',
        'method_handle' => 'object',
        'attributes' => 'string',
        'calling_convention' => 'string',
        'is_generic_method_definition' => 'bool',
        'contains_generic_parameters' => 'bool',
        'is_generic_method' => 'bool',
        'is_security_critical' => 'bool',
        'is_security_safe_critical' => 'bool',
        'is_security_transparent' => 'bool',
        'is_public' => 'bool',
        'is_private' => 'bool',
        'is_family' => 'bool',
        'is_assembly' => 'bool',
        'is_family_and_assembly' => 'bool',
        'is_family_or_assembly' => 'bool',
        'is_static' => 'bool',
        'is_final' => 'bool',
        'is_virtual' => 'bool',
        'is_hide_by_sig' => 'bool',
        'is_abstract' => 'bool',
        'is_special_name' => 'bool',
        'is_constructor' => 'bool',
        'name' => 'string',
        'declaring_type' => 'string',
        'reflected_type' => 'string',
        'custom_attributes' => '\Linnworks\Inventory\Model\CustomAttributeData[]',
        'metadata_token' => 'int',
        'module' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'member_type' => null,
        'return_type' => null,
        'return_parameter' => null,
        'return_type_custom_attributes' => null,
        'method_implementation_flags' => null,
        'method_handle' => null,
        'attributes' => null,
        'calling_convention' => null,
        'is_generic_method_definition' => null,
        'contains_generic_parameters' => null,
        'is_generic_method' => null,
        'is_security_critical' => null,
        'is_security_safe_critical' => null,
        'is_security_transparent' => null,
        'is_public' => null,
        'is_private' => null,
        'is_family' => null,
        'is_assembly' => null,
        'is_family_and_assembly' => null,
        'is_family_or_assembly' => null,
        'is_static' => null,
        'is_final' => null,
        'is_virtual' => null,
        'is_hide_by_sig' => null,
        'is_abstract' => null,
        'is_special_name' => null,
        'is_constructor' => null,
        'name' => null,
        'declaring_type' => null,
        'reflected_type' => null,
        'custom_attributes' => null,
        'metadata_token' => 'int32',
        'module' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'member_type' => false,
        'return_type' => false,
        'return_parameter' => false,
        'return_type_custom_attributes' => false,
        'method_implementation_flags' => false,
        'method_handle' => false,
        'attributes' => false,
        'calling_convention' => false,
        'is_generic_method_definition' => false,
        'contains_generic_parameters' => false,
        'is_generic_method' => false,
        'is_security_critical' => false,
        'is_security_safe_critical' => false,
        'is_security_transparent' => false,
        'is_public' => false,
        'is_private' => false,
        'is_family' => false,
        'is_assembly' => false,
        'is_family_and_assembly' => false,
        'is_family_or_assembly' => false,
        'is_static' => false,
        'is_final' => false,
        'is_virtual' => false,
        'is_hide_by_sig' => false,
        'is_abstract' => false,
        'is_special_name' => false,
        'is_constructor' => false,
        'name' => false,
        'declaring_type' => false,
        'reflected_type' => false,
        'custom_attributes' => false,
        'metadata_token' => false,
        'module' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'member_type' => 'MemberType',
        'return_type' => 'ReturnType',
        'return_parameter' => 'ReturnParameter',
        'return_type_custom_attributes' => 'ReturnTypeCustomAttributes',
        'method_implementation_flags' => 'MethodImplementationFlags',
        'method_handle' => 'MethodHandle',
        'attributes' => 'Attributes',
        'calling_convention' => 'CallingConvention',
        'is_generic_method_definition' => 'IsGenericMethodDefinition',
        'contains_generic_parameters' => 'ContainsGenericParameters',
        'is_generic_method' => 'IsGenericMethod',
        'is_security_critical' => 'IsSecurityCritical',
        'is_security_safe_critical' => 'IsSecuritySafeCritical',
        'is_security_transparent' => 'IsSecurityTransparent',
        'is_public' => 'IsPublic',
        'is_private' => 'IsPrivate',
        'is_family' => 'IsFamily',
        'is_assembly' => 'IsAssembly',
        'is_family_and_assembly' => 'IsFamilyAndAssembly',
        'is_family_or_assembly' => 'IsFamilyOrAssembly',
        'is_static' => 'IsStatic',
        'is_final' => 'IsFinal',
        'is_virtual' => 'IsVirtual',
        'is_hide_by_sig' => 'IsHideBySig',
        'is_abstract' => 'IsAbstract',
        'is_special_name' => 'IsSpecialName',
        'is_constructor' => 'IsConstructor',
        'name' => 'Name',
        'declaring_type' => 'DeclaringType',
        'reflected_type' => 'ReflectedType',
        'custom_attributes' => 'CustomAttributes',
        'metadata_token' => 'MetadataToken',
        'module' => 'Module'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'member_type' => 'setMemberType',
        'return_type' => 'setReturnType',
        'return_parameter' => 'setReturnParameter',
        'return_type_custom_attributes' => 'setReturnTypeCustomAttributes',
        'method_implementation_flags' => 'setMethodImplementationFlags',
        'method_handle' => 'setMethodHandle',
        'attributes' => 'setAttributes',
        'calling_convention' => 'setCallingConvention',
        'is_generic_method_definition' => 'setIsGenericMethodDefinition',
        'contains_generic_parameters' => 'setContainsGenericParameters',
        'is_generic_method' => 'setIsGenericMethod',
        'is_security_critical' => 'setIsSecurityCritical',
        'is_security_safe_critical' => 'setIsSecuritySafeCritical',
        'is_security_transparent' => 'setIsSecurityTransparent',
        'is_public' => 'setIsPublic',
        'is_private' => 'setIsPrivate',
        'is_family' => 'setIsFamily',
        'is_assembly' => 'setIsAssembly',
        'is_family_and_assembly' => 'setIsFamilyAndAssembly',
        'is_family_or_assembly' => 'setIsFamilyOrAssembly',
        'is_static' => 'setIsStatic',
        'is_final' => 'setIsFinal',
        'is_virtual' => 'setIsVirtual',
        'is_hide_by_sig' => 'setIsHideBySig',
        'is_abstract' => 'setIsAbstract',
        'is_special_name' => 'setIsSpecialName',
        'is_constructor' => 'setIsConstructor',
        'name' => 'setName',
        'declaring_type' => 'setDeclaringType',
        'reflected_type' => 'setReflectedType',
        'custom_attributes' => 'setCustomAttributes',
        'metadata_token' => 'setMetadataToken',
        'module' => 'setModule'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'member_type' => 'getMemberType',
        'return_type' => 'getReturnType',
        'return_parameter' => 'getReturnParameter',
        'return_type_custom_attributes' => 'getReturnTypeCustomAttributes',
        'method_implementation_flags' => 'getMethodImplementationFlags',
        'method_handle' => 'getMethodHandle',
        'attributes' => 'getAttributes',
        'calling_convention' => 'getCallingConvention',
        'is_generic_method_definition' => 'getIsGenericMethodDefinition',
        'contains_generic_parameters' => 'getContainsGenericParameters',
        'is_generic_method' => 'getIsGenericMethod',
        'is_security_critical' => 'getIsSecurityCritical',
        'is_security_safe_critical' => 'getIsSecuritySafeCritical',
        'is_security_transparent' => 'getIsSecurityTransparent',
        'is_public' => 'getIsPublic',
        'is_private' => 'getIsPrivate',
        'is_family' => 'getIsFamily',
        'is_assembly' => 'getIsAssembly',
        'is_family_and_assembly' => 'getIsFamilyAndAssembly',
        'is_family_or_assembly' => 'getIsFamilyOrAssembly',
        'is_static' => 'getIsStatic',
        'is_final' => 'getIsFinal',
        'is_virtual' => 'getIsVirtual',
        'is_hide_by_sig' => 'getIsHideBySig',
        'is_abstract' => 'getIsAbstract',
        'is_special_name' => 'getIsSpecialName',
        'is_constructor' => 'getIsConstructor',
        'name' => 'getName',
        'declaring_type' => 'getDeclaringType',
        'reflected_type' => 'getReflectedType',
        'custom_attributes' => 'getCustomAttributes',
        'metadata_token' => 'getMetadataToken',
        'module' => 'getModule'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const MEMBER_TYPE_CONSTRUCTOR = 'Constructor';
    public const MEMBER_TYPE_EVENT = 'Event';
    public const MEMBER_TYPE_FIELD = 'Field';
    public const MEMBER_TYPE_METHOD = 'Method';
    public const MEMBER_TYPE_PROPERTY = 'Property';
    public const MEMBER_TYPE_TYPE_INFO = 'TypeInfo';
    public const MEMBER_TYPE_CUSTOM = 'Custom';
    public const MEMBER_TYPE_NESTED_TYPE = 'NestedType';
    public const MEMBER_TYPE_ALL = 'All';
    public const METHOD_IMPLEMENTATION_FLAGS_CODE_TYPE_MASK = 'CodeTypeMask';
    public const METHOD_IMPLEMENTATION_FLAGS_IL = 'IL';
    public const METHOD_IMPLEMENTATION_FLAGS_NATIVE = 'Native';
    public const METHOD_IMPLEMENTATION_FLAGS_OPTIL = 'OPTIL';
    public const METHOD_IMPLEMENTATION_FLAGS_RUNTIME = 'Runtime';
    public const METHOD_IMPLEMENTATION_FLAGS_MANAGED_MASK = 'ManagedMask';
    public const METHOD_IMPLEMENTATION_FLAGS_UNMANAGED = 'Unmanaged';
    public const METHOD_IMPLEMENTATION_FLAGS_MANAGED = 'Managed';
    public const METHOD_IMPLEMENTATION_FLAGS_FORWARD_REF = 'ForwardRef';
    public const METHOD_IMPLEMENTATION_FLAGS_PRESERVE_SIG = 'PreserveSig';
    public const METHOD_IMPLEMENTATION_FLAGS_INTERNAL_CALL = 'InternalCall';
    public const METHOD_IMPLEMENTATION_FLAGS_SYNCHRONIZED = 'Synchronized';
    public const METHOD_IMPLEMENTATION_FLAGS_NO_INLINING = 'NoInlining';
    public const METHOD_IMPLEMENTATION_FLAGS_AGGRESSIVE_INLINING = 'AggressiveInlining';
    public const METHOD_IMPLEMENTATION_FLAGS_NO_OPTIMIZATION = 'NoOptimization';
    public const METHOD_IMPLEMENTATION_FLAGS_SECURITY_MITIGATIONS = 'SecurityMitigations';
    public const METHOD_IMPLEMENTATION_FLAGS_MAX_METHOD_IMPL_VAL = 'MaxMethodImplVal';
    public const ATTRIBUTES_MEMBER_ACCESS_MASK = 'MemberAccessMask';
    public const ATTRIBUTES_PRIVATE_SCOPE = 'PrivateScope';
    public const ATTRIBUTES__PRIVATE = 'Private';
    public const ATTRIBUTES_FAM_AND_ASSEM = 'FamANDAssem';
    public const ATTRIBUTES_ASSEMBLY = 'Assembly';
    public const ATTRIBUTES_FAMILY = 'Family';
    public const ATTRIBUTES_FAM_OR_ASSEM = 'FamORAssem';
    public const ATTRIBUTES__PUBLIC = 'Public';
    public const ATTRIBUTES__STATIC = 'Static';
    public const ATTRIBUTES__FINAL = 'Final';
    public const ATTRIBUTES_VIRTUAL = 'Virtual';
    public const ATTRIBUTES_HIDE_BY_SIG = 'HideBySig';
    public const ATTRIBUTES_CHECK_ACCESS_ON_OVERRIDE = 'CheckAccessOnOverride';
    public const ATTRIBUTES_VTABLE_LAYOUT_MASK = 'VtableLayoutMask';
    public const ATTRIBUTES_REUSE_SLOT = 'ReuseSlot';
    public const ATTRIBUTES_NEW_SLOT = 'NewSlot';
    public const ATTRIBUTES__ABSTRACT = 'Abstract';
    public const ATTRIBUTES_SPECIAL_NAME = 'SpecialName';
    public const ATTRIBUTES_PINVOKE_IMPL = 'PinvokeImpl';
    public const ATTRIBUTES_UNMANAGED_EXPORT = 'UnmanagedExport';
    public const ATTRIBUTES_RT_SPECIAL_NAME = 'RTSpecialName';
    public const ATTRIBUTES_RESERVED_MASK = 'ReservedMask';
    public const ATTRIBUTES_HAS_SECURITY = 'HasSecurity';
    public const ATTRIBUTES_REQUIRE_SEC_OBJECT = 'RequireSecObject';
    public const CALLING_CONVENTION_STANDARD = 'Standard';
    public const CALLING_CONVENTION_VAR_ARGS = 'VarArgs';
    public const CALLING_CONVENTION_ANY = 'Any';
    public const CALLING_CONVENTION_HAS_THIS = 'HasThis';
    public const CALLING_CONVENTION_EXPLICIT_THIS = 'ExplicitThis';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMemberTypeAllowableValues()
    {
        return [
            self::MEMBER_TYPE_CONSTRUCTOR,
            self::MEMBER_TYPE_EVENT,
            self::MEMBER_TYPE_FIELD,
            self::MEMBER_TYPE_METHOD,
            self::MEMBER_TYPE_PROPERTY,
            self::MEMBER_TYPE_TYPE_INFO,
            self::MEMBER_TYPE_CUSTOM,
            self::MEMBER_TYPE_NESTED_TYPE,
            self::MEMBER_TYPE_ALL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMethodImplementationFlagsAllowableValues()
    {
        return [
            self::METHOD_IMPLEMENTATION_FLAGS_CODE_TYPE_MASK,
            self::METHOD_IMPLEMENTATION_FLAGS_IL,
            self::METHOD_IMPLEMENTATION_FLAGS_NATIVE,
            self::METHOD_IMPLEMENTATION_FLAGS_OPTIL,
            self::METHOD_IMPLEMENTATION_FLAGS_RUNTIME,
            self::METHOD_IMPLEMENTATION_FLAGS_MANAGED_MASK,
            self::METHOD_IMPLEMENTATION_FLAGS_UNMANAGED,
            self::METHOD_IMPLEMENTATION_FLAGS_MANAGED,
            self::METHOD_IMPLEMENTATION_FLAGS_FORWARD_REF,
            self::METHOD_IMPLEMENTATION_FLAGS_PRESERVE_SIG,
            self::METHOD_IMPLEMENTATION_FLAGS_INTERNAL_CALL,
            self::METHOD_IMPLEMENTATION_FLAGS_SYNCHRONIZED,
            self::METHOD_IMPLEMENTATION_FLAGS_NO_INLINING,
            self::METHOD_IMPLEMENTATION_FLAGS_AGGRESSIVE_INLINING,
            self::METHOD_IMPLEMENTATION_FLAGS_NO_OPTIMIZATION,
            self::METHOD_IMPLEMENTATION_FLAGS_SECURITY_MITIGATIONS,
            self::METHOD_IMPLEMENTATION_FLAGS_MAX_METHOD_IMPL_VAL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getAttributesAllowableValues()
    {
        return [
            self::ATTRIBUTES_MEMBER_ACCESS_MASK,
            self::ATTRIBUTES_PRIVATE_SCOPE,
            self::ATTRIBUTES__PRIVATE,
            self::ATTRIBUTES_FAM_AND_ASSEM,
            self::ATTRIBUTES_ASSEMBLY,
            self::ATTRIBUTES_FAMILY,
            self::ATTRIBUTES_FAM_OR_ASSEM,
            self::ATTRIBUTES__PUBLIC,
            self::ATTRIBUTES__STATIC,
            self::ATTRIBUTES__FINAL,
            self::ATTRIBUTES_VIRTUAL,
            self::ATTRIBUTES_HIDE_BY_SIG,
            self::ATTRIBUTES_CHECK_ACCESS_ON_OVERRIDE,
            self::ATTRIBUTES_VTABLE_LAYOUT_MASK,
            self::ATTRIBUTES_REUSE_SLOT,
            self::ATTRIBUTES_NEW_SLOT,
            self::ATTRIBUTES__ABSTRACT,
            self::ATTRIBUTES_SPECIAL_NAME,
            self::ATTRIBUTES_PINVOKE_IMPL,
            self::ATTRIBUTES_UNMANAGED_EXPORT,
            self::ATTRIBUTES_RT_SPECIAL_NAME,
            self::ATTRIBUTES_RESERVED_MASK,
            self::ATTRIBUTES_HAS_SECURITY,
            self::ATTRIBUTES_REQUIRE_SEC_OBJECT,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getCallingConventionAllowableValues()
    {
        return [
            self::CALLING_CONVENTION_STANDARD,
            self::CALLING_CONVENTION_VAR_ARGS,
            self::CALLING_CONVENTION_ANY,
            self::CALLING_CONVENTION_HAS_THIS,
            self::CALLING_CONVENTION_EXPLICIT_THIS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('member_type', $data ?? [], null);
        $this->setIfExists('return_type', $data ?? [], null);
        $this->setIfExists('return_parameter', $data ?? [], null);
        $this->setIfExists('return_type_custom_attributes', $data ?? [], null);
        $this->setIfExists('method_implementation_flags', $data ?? [], null);
        $this->setIfExists('method_handle', $data ?? [], null);
        $this->setIfExists('attributes', $data ?? [], null);
        $this->setIfExists('calling_convention', $data ?? [], null);
        $this->setIfExists('is_generic_method_definition', $data ?? [], null);
        $this->setIfExists('contains_generic_parameters', $data ?? [], null);
        $this->setIfExists('is_generic_method', $data ?? [], null);
        $this->setIfExists('is_security_critical', $data ?? [], null);
        $this->setIfExists('is_security_safe_critical', $data ?? [], null);
        $this->setIfExists('is_security_transparent', $data ?? [], null);
        $this->setIfExists('is_public', $data ?? [], null);
        $this->setIfExists('is_private', $data ?? [], null);
        $this->setIfExists('is_family', $data ?? [], null);
        $this->setIfExists('is_assembly', $data ?? [], null);
        $this->setIfExists('is_family_and_assembly', $data ?? [], null);
        $this->setIfExists('is_family_or_assembly', $data ?? [], null);
        $this->setIfExists('is_static', $data ?? [], null);
        $this->setIfExists('is_final', $data ?? [], null);
        $this->setIfExists('is_virtual', $data ?? [], null);
        $this->setIfExists('is_hide_by_sig', $data ?? [], null);
        $this->setIfExists('is_abstract', $data ?? [], null);
        $this->setIfExists('is_special_name', $data ?? [], null);
        $this->setIfExists('is_constructor', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('declaring_type', $data ?? [], null);
        $this->setIfExists('reflected_type', $data ?? [], null);
        $this->setIfExists('custom_attributes', $data ?? [], null);
        $this->setIfExists('metadata_token', $data ?? [], null);
        $this->setIfExists('module', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getMemberTypeAllowableValues();
        if (!is_null($this->container['member_type']) && !in_array($this->container['member_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'member_type', must be one of '%s'",
                $this->container['member_type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getMethodImplementationFlagsAllowableValues();
        if (!is_null($this->container['method_implementation_flags']) && !in_array($this->container['method_implementation_flags'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'method_implementation_flags', must be one of '%s'",
                $this->container['method_implementation_flags'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getAttributesAllowableValues();
        if (!is_null($this->container['attributes']) && !in_array($this->container['attributes'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'attributes', must be one of '%s'",
                $this->container['attributes'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getCallingConventionAllowableValues();
        if (!is_null($this->container['calling_convention']) && !in_array($this->container['calling_convention'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'calling_convention', must be one of '%s'",
                $this->container['calling_convention'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets member_type
     *
     * @return string|null
     */
    public function getMemberType()
    {
        return $this->container['member_type'];
    }

    /**
     * Sets member_type
     *
     * @param string|null $member_type member_type
     *
     * @return self
     */
    public function setMemberType($member_type)
    {
        if (is_null($member_type)) {
            throw new \InvalidArgumentException('non-nullable member_type cannot be null');
        }
        $allowedValues = $this->getMemberTypeAllowableValues();
        if (!in_array($member_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'member_type', must be one of '%s'",
                    $member_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['member_type'] = $member_type;

        return $this;
    }

    /**
     * Gets return_type
     *
     * @return string|null
     */
    public function getReturnType()
    {
        return $this->container['return_type'];
    }

    /**
     * Sets return_type
     *
     * @param string|null $return_type return_type
     *
     * @return self
     */
    public function setReturnType($return_type)
    {
        if (is_null($return_type)) {
            throw new \InvalidArgumentException('non-nullable return_type cannot be null');
        }
        $this->container['return_type'] = $return_type;

        return $this;
    }

    /**
     * Gets return_parameter
     *
     * @return \Linnworks\Inventory\Model\ParameterInfo|null
     */
    public function getReturnParameter()
    {
        return $this->container['return_parameter'];
    }

    /**
     * Sets return_parameter
     *
     * @param \Linnworks\Inventory\Model\ParameterInfo|null $return_parameter return_parameter
     *
     * @return self
     */
    public function setReturnParameter($return_parameter)
    {
        if (is_null($return_parameter)) {
            throw new \InvalidArgumentException('non-nullable return_parameter cannot be null');
        }
        $this->container['return_parameter'] = $return_parameter;

        return $this;
    }

    /**
     * Gets return_type_custom_attributes
     *
     * @return object|null
     */
    public function getReturnTypeCustomAttributes()
    {
        return $this->container['return_type_custom_attributes'];
    }

    /**
     * Sets return_type_custom_attributes
     *
     * @param object|null $return_type_custom_attributes return_type_custom_attributes
     *
     * @return self
     */
    public function setReturnTypeCustomAttributes($return_type_custom_attributes)
    {
        if (is_null($return_type_custom_attributes)) {
            throw new \InvalidArgumentException('non-nullable return_type_custom_attributes cannot be null');
        }
        $this->container['return_type_custom_attributes'] = $return_type_custom_attributes;

        return $this;
    }

    /**
     * Gets method_implementation_flags
     *
     * @return string|null
     */
    public function getMethodImplementationFlags()
    {
        return $this->container['method_implementation_flags'];
    }

    /**
     * Sets method_implementation_flags
     *
     * @param string|null $method_implementation_flags method_implementation_flags
     *
     * @return self
     */
    public function setMethodImplementationFlags($method_implementation_flags)
    {
        if (is_null($method_implementation_flags)) {
            throw new \InvalidArgumentException('non-nullable method_implementation_flags cannot be null');
        }
        $allowedValues = $this->getMethodImplementationFlagsAllowableValues();
        if (!in_array($method_implementation_flags, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'method_implementation_flags', must be one of '%s'",
                    $method_implementation_flags,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['method_implementation_flags'] = $method_implementation_flags;

        return $this;
    }

    /**
     * Gets method_handle
     *
     * @return object|null
     */
    public function getMethodHandle()
    {
        return $this->container['method_handle'];
    }

    /**
     * Sets method_handle
     *
     * @param object|null $method_handle method_handle
     *
     * @return self
     */
    public function setMethodHandle($method_handle)
    {
        if (is_null($method_handle)) {
            throw new \InvalidArgumentException('non-nullable method_handle cannot be null');
        }
        $this->container['method_handle'] = $method_handle;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return string|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param string|null $attributes attributes
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        if (is_null($attributes)) {
            throw new \InvalidArgumentException('non-nullable attributes cannot be null');
        }
        $allowedValues = $this->getAttributesAllowableValues();
        if (!in_array($attributes, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'attributes', must be one of '%s'",
                    $attributes,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets calling_convention
     *
     * @return string|null
     */
    public function getCallingConvention()
    {
        return $this->container['calling_convention'];
    }

    /**
     * Sets calling_convention
     *
     * @param string|null $calling_convention calling_convention
     *
     * @return self
     */
    public function setCallingConvention($calling_convention)
    {
        if (is_null($calling_convention)) {
            throw new \InvalidArgumentException('non-nullable calling_convention cannot be null');
        }
        $allowedValues = $this->getCallingConventionAllowableValues();
        if (!in_array($calling_convention, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'calling_convention', must be one of '%s'",
                    $calling_convention,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['calling_convention'] = $calling_convention;

        return $this;
    }

    /**
     * Gets is_generic_method_definition
     *
     * @return bool|null
     */
    public function getIsGenericMethodDefinition()
    {
        return $this->container['is_generic_method_definition'];
    }

    /**
     * Sets is_generic_method_definition
     *
     * @param bool|null $is_generic_method_definition is_generic_method_definition
     *
     * @return self
     */
    public function setIsGenericMethodDefinition($is_generic_method_definition)
    {
        if (is_null($is_generic_method_definition)) {
            throw new \InvalidArgumentException('non-nullable is_generic_method_definition cannot be null');
        }
        $this->container['is_generic_method_definition'] = $is_generic_method_definition;

        return $this;
    }

    /**
     * Gets contains_generic_parameters
     *
     * @return bool|null
     */
    public function getContainsGenericParameters()
    {
        return $this->container['contains_generic_parameters'];
    }

    /**
     * Sets contains_generic_parameters
     *
     * @param bool|null $contains_generic_parameters contains_generic_parameters
     *
     * @return self
     */
    public function setContainsGenericParameters($contains_generic_parameters)
    {
        if (is_null($contains_generic_parameters)) {
            throw new \InvalidArgumentException('non-nullable contains_generic_parameters cannot be null');
        }
        $this->container['contains_generic_parameters'] = $contains_generic_parameters;

        return $this;
    }

    /**
     * Gets is_generic_method
     *
     * @return bool|null
     */
    public function getIsGenericMethod()
    {
        return $this->container['is_generic_method'];
    }

    /**
     * Sets is_generic_method
     *
     * @param bool|null $is_generic_method is_generic_method
     *
     * @return self
     */
    public function setIsGenericMethod($is_generic_method)
    {
        if (is_null($is_generic_method)) {
            throw new \InvalidArgumentException('non-nullable is_generic_method cannot be null');
        }
        $this->container['is_generic_method'] = $is_generic_method;

        return $this;
    }

    /**
     * Gets is_security_critical
     *
     * @return bool|null
     */
    public function getIsSecurityCritical()
    {
        return $this->container['is_security_critical'];
    }

    /**
     * Sets is_security_critical
     *
     * @param bool|null $is_security_critical is_security_critical
     *
     * @return self
     */
    public function setIsSecurityCritical($is_security_critical)
    {
        if (is_null($is_security_critical)) {
            throw new \InvalidArgumentException('non-nullable is_security_critical cannot be null');
        }
        $this->container['is_security_critical'] = $is_security_critical;

        return $this;
    }

    /**
     * Gets is_security_safe_critical
     *
     * @return bool|null
     */
    public function getIsSecuritySafeCritical()
    {
        return $this->container['is_security_safe_critical'];
    }

    /**
     * Sets is_security_safe_critical
     *
     * @param bool|null $is_security_safe_critical is_security_safe_critical
     *
     * @return self
     */
    public function setIsSecuritySafeCritical($is_security_safe_critical)
    {
        if (is_null($is_security_safe_critical)) {
            throw new \InvalidArgumentException('non-nullable is_security_safe_critical cannot be null');
        }
        $this->container['is_security_safe_critical'] = $is_security_safe_critical;

        return $this;
    }

    /**
     * Gets is_security_transparent
     *
     * @return bool|null
     */
    public function getIsSecurityTransparent()
    {
        return $this->container['is_security_transparent'];
    }

    /**
     * Sets is_security_transparent
     *
     * @param bool|null $is_security_transparent is_security_transparent
     *
     * @return self
     */
    public function setIsSecurityTransparent($is_security_transparent)
    {
        if (is_null($is_security_transparent)) {
            throw new \InvalidArgumentException('non-nullable is_security_transparent cannot be null');
        }
        $this->container['is_security_transparent'] = $is_security_transparent;

        return $this;
    }

    /**
     * Gets is_public
     *
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->container['is_public'];
    }

    /**
     * Sets is_public
     *
     * @param bool|null $is_public is_public
     *
     * @return self
     */
    public function setIsPublic($is_public)
    {
        if (is_null($is_public)) {
            throw new \InvalidArgumentException('non-nullable is_public cannot be null');
        }
        $this->container['is_public'] = $is_public;

        return $this;
    }

    /**
     * Gets is_private
     *
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->container['is_private'];
    }

    /**
     * Sets is_private
     *
     * @param bool|null $is_private is_private
     *
     * @return self
     */
    public function setIsPrivate($is_private)
    {
        if (is_null($is_private)) {
            throw new \InvalidArgumentException('non-nullable is_private cannot be null');
        }
        $this->container['is_private'] = $is_private;

        return $this;
    }

    /**
     * Gets is_family
     *
     * @return bool|null
     */
    public function getIsFamily()
    {
        return $this->container['is_family'];
    }

    /**
     * Sets is_family
     *
     * @param bool|null $is_family is_family
     *
     * @return self
     */
    public function setIsFamily($is_family)
    {
        if (is_null($is_family)) {
            throw new \InvalidArgumentException('non-nullable is_family cannot be null');
        }
        $this->container['is_family'] = $is_family;

        return $this;
    }

    /**
     * Gets is_assembly
     *
     * @return bool|null
     */
    public function getIsAssembly()
    {
        return $this->container['is_assembly'];
    }

    /**
     * Sets is_assembly
     *
     * @param bool|null $is_assembly is_assembly
     *
     * @return self
     */
    public function setIsAssembly($is_assembly)
    {
        if (is_null($is_assembly)) {
            throw new \InvalidArgumentException('non-nullable is_assembly cannot be null');
        }
        $this->container['is_assembly'] = $is_assembly;

        return $this;
    }

    /**
     * Gets is_family_and_assembly
     *
     * @return bool|null
     */
    public function getIsFamilyAndAssembly()
    {
        return $this->container['is_family_and_assembly'];
    }

    /**
     * Sets is_family_and_assembly
     *
     * @param bool|null $is_family_and_assembly is_family_and_assembly
     *
     * @return self
     */
    public function setIsFamilyAndAssembly($is_family_and_assembly)
    {
        if (is_null($is_family_and_assembly)) {
            throw new \InvalidArgumentException('non-nullable is_family_and_assembly cannot be null');
        }
        $this->container['is_family_and_assembly'] = $is_family_and_assembly;

        return $this;
    }

    /**
     * Gets is_family_or_assembly
     *
     * @return bool|null
     */
    public function getIsFamilyOrAssembly()
    {
        return $this->container['is_family_or_assembly'];
    }

    /**
     * Sets is_family_or_assembly
     *
     * @param bool|null $is_family_or_assembly is_family_or_assembly
     *
     * @return self
     */
    public function setIsFamilyOrAssembly($is_family_or_assembly)
    {
        if (is_null($is_family_or_assembly)) {
            throw new \InvalidArgumentException('non-nullable is_family_or_assembly cannot be null');
        }
        $this->container['is_family_or_assembly'] = $is_family_or_assembly;

        return $this;
    }

    /**
     * Gets is_static
     *
     * @return bool|null
     */
    public function getIsStatic()
    {
        return $this->container['is_static'];
    }

    /**
     * Sets is_static
     *
     * @param bool|null $is_static is_static
     *
     * @return self
     */
    public function setIsStatic($is_static)
    {
        if (is_null($is_static)) {
            throw new \InvalidArgumentException('non-nullable is_static cannot be null');
        }
        $this->container['is_static'] = $is_static;

        return $this;
    }

    /**
     * Gets is_final
     *
     * @return bool|null
     */
    public function getIsFinal()
    {
        return $this->container['is_final'];
    }

    /**
     * Sets is_final
     *
     * @param bool|null $is_final is_final
     *
     * @return self
     */
    public function setIsFinal($is_final)
    {
        if (is_null($is_final)) {
            throw new \InvalidArgumentException('non-nullable is_final cannot be null');
        }
        $this->container['is_final'] = $is_final;

        return $this;
    }

    /**
     * Gets is_virtual
     *
     * @return bool|null
     */
    public function getIsVirtual()
    {
        return $this->container['is_virtual'];
    }

    /**
     * Sets is_virtual
     *
     * @param bool|null $is_virtual is_virtual
     *
     * @return self
     */
    public function setIsVirtual($is_virtual)
    {
        if (is_null($is_virtual)) {
            throw new \InvalidArgumentException('non-nullable is_virtual cannot be null');
        }
        $this->container['is_virtual'] = $is_virtual;

        return $this;
    }

    /**
     * Gets is_hide_by_sig
     *
     * @return bool|null
     */
    public function getIsHideBySig()
    {
        return $this->container['is_hide_by_sig'];
    }

    /**
     * Sets is_hide_by_sig
     *
     * @param bool|null $is_hide_by_sig is_hide_by_sig
     *
     * @return self
     */
    public function setIsHideBySig($is_hide_by_sig)
    {
        if (is_null($is_hide_by_sig)) {
            throw new \InvalidArgumentException('non-nullable is_hide_by_sig cannot be null');
        }
        $this->container['is_hide_by_sig'] = $is_hide_by_sig;

        return $this;
    }

    /**
     * Gets is_abstract
     *
     * @return bool|null
     */
    public function getIsAbstract()
    {
        return $this->container['is_abstract'];
    }

    /**
     * Sets is_abstract
     *
     * @param bool|null $is_abstract is_abstract
     *
     * @return self
     */
    public function setIsAbstract($is_abstract)
    {
        if (is_null($is_abstract)) {
            throw new \InvalidArgumentException('non-nullable is_abstract cannot be null');
        }
        $this->container['is_abstract'] = $is_abstract;

        return $this;
    }

    /**
     * Gets is_special_name
     *
     * @return bool|null
     */
    public function getIsSpecialName()
    {
        return $this->container['is_special_name'];
    }

    /**
     * Sets is_special_name
     *
     * @param bool|null $is_special_name is_special_name
     *
     * @return self
     */
    public function setIsSpecialName($is_special_name)
    {
        if (is_null($is_special_name)) {
            throw new \InvalidArgumentException('non-nullable is_special_name cannot be null');
        }
        $this->container['is_special_name'] = $is_special_name;

        return $this;
    }

    /**
     * Gets is_constructor
     *
     * @return bool|null
     */
    public function getIsConstructor()
    {
        return $this->container['is_constructor'];
    }

    /**
     * Sets is_constructor
     *
     * @param bool|null $is_constructor is_constructor
     *
     * @return self
     */
    public function setIsConstructor($is_constructor)
    {
        if (is_null($is_constructor)) {
            throw new \InvalidArgumentException('non-nullable is_constructor cannot be null');
        }
        $this->container['is_constructor'] = $is_constructor;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets declaring_type
     *
     * @return string|null
     */
    public function getDeclaringType()
    {
        return $this->container['declaring_type'];
    }

    /**
     * Sets declaring_type
     *
     * @param string|null $declaring_type declaring_type
     *
     * @return self
     */
    public function setDeclaringType($declaring_type)
    {
        if (is_null($declaring_type)) {
            throw new \InvalidArgumentException('non-nullable declaring_type cannot be null');
        }
        $this->container['declaring_type'] = $declaring_type;

        return $this;
    }

    /**
     * Gets reflected_type
     *
     * @return string|null
     */
    public function getReflectedType()
    {
        return $this->container['reflected_type'];
    }

    /**
     * Sets reflected_type
     *
     * @param string|null $reflected_type reflected_type
     *
     * @return self
     */
    public function setReflectedType($reflected_type)
    {
        if (is_null($reflected_type)) {
            throw new \InvalidArgumentException('non-nullable reflected_type cannot be null');
        }
        $this->container['reflected_type'] = $reflected_type;

        return $this;
    }

    /**
     * Gets custom_attributes
     *
     * @return \Linnworks\Inventory\Model\CustomAttributeData[]|null
     */
    public function getCustomAttributes()
    {
        return $this->container['custom_attributes'];
    }

    /**
     * Sets custom_attributes
     *
     * @param \Linnworks\Inventory\Model\CustomAttributeData[]|null $custom_attributes custom_attributes
     *
     * @return self
     */
    public function setCustomAttributes($custom_attributes)
    {
        if (is_null($custom_attributes)) {
            throw new \InvalidArgumentException('non-nullable custom_attributes cannot be null');
        }
        $this->container['custom_attributes'] = $custom_attributes;

        return $this;
    }

    /**
     * Gets metadata_token
     *
     * @return int|null
     */
    public function getMetadataToken()
    {
        return $this->container['metadata_token'];
    }

    /**
     * Sets metadata_token
     *
     * @param int|null $metadata_token metadata_token
     *
     * @return self
     */
    public function setMetadataToken($metadata_token)
    {
        if (is_null($metadata_token)) {
            throw new \InvalidArgumentException('non-nullable metadata_token cannot be null');
        }
        $this->container['metadata_token'] = $metadata_token;

        return $this;
    }

    /**
     * Gets module
     *
     * @return object|null
     */
    public function getModule()
    {
        return $this->container['module'];
    }

    /**
     * Sets module
     *
     * @param object|null $module module
     *
     * @return self
     */
    public function setModule($module)
    {
        if (is_null($module)) {
            throw new \InvalidArgumentException('non-nullable module cannot be null');
        }
        $this->container['module'] = $module;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


