<?php
/**
 * MemberInfo
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * MemberInfo Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class MemberInfo implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'MemberInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'member_type' => 'string',
        'name' => 'string',
        'declaring_type' => 'string',
        'reflected_type' => 'string',
        'custom_attributes' => '\Linnworks\Inventory\Model\CustomAttributeData[]',
        'metadata_token' => 'int',
        'module' => 'object'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'member_type' => null,
        'name' => null,
        'declaring_type' => null,
        'reflected_type' => null,
        'custom_attributes' => null,
        'metadata_token' => 'int32',
        'module' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'member_type' => false,
        'name' => false,
        'declaring_type' => false,
        'reflected_type' => false,
        'custom_attributes' => false,
        'metadata_token' => false,
        'module' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'member_type' => 'MemberType',
        'name' => 'Name',
        'declaring_type' => 'DeclaringType',
        'reflected_type' => 'ReflectedType',
        'custom_attributes' => 'CustomAttributes',
        'metadata_token' => 'MetadataToken',
        'module' => 'Module'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'member_type' => 'setMemberType',
        'name' => 'setName',
        'declaring_type' => 'setDeclaringType',
        'reflected_type' => 'setReflectedType',
        'custom_attributes' => 'setCustomAttributes',
        'metadata_token' => 'setMetadataToken',
        'module' => 'setModule'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'member_type' => 'getMemberType',
        'name' => 'getName',
        'declaring_type' => 'getDeclaringType',
        'reflected_type' => 'getReflectedType',
        'custom_attributes' => 'getCustomAttributes',
        'metadata_token' => 'getMetadataToken',
        'module' => 'getModule'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const MEMBER_TYPE_CONSTRUCTOR = 'Constructor';
    public const MEMBER_TYPE_EVENT = 'Event';
    public const MEMBER_TYPE_FIELD = 'Field';
    public const MEMBER_TYPE_METHOD = 'Method';
    public const MEMBER_TYPE_PROPERTY = 'Property';
    public const MEMBER_TYPE_TYPE_INFO = 'TypeInfo';
    public const MEMBER_TYPE_CUSTOM = 'Custom';
    public const MEMBER_TYPE_NESTED_TYPE = 'NestedType';
    public const MEMBER_TYPE_ALL = 'All';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getMemberTypeAllowableValues()
    {
        return [
            self::MEMBER_TYPE_CONSTRUCTOR,
            self::MEMBER_TYPE_EVENT,
            self::MEMBER_TYPE_FIELD,
            self::MEMBER_TYPE_METHOD,
            self::MEMBER_TYPE_PROPERTY,
            self::MEMBER_TYPE_TYPE_INFO,
            self::MEMBER_TYPE_CUSTOM,
            self::MEMBER_TYPE_NESTED_TYPE,
            self::MEMBER_TYPE_ALL,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('member_type', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('declaring_type', $data ?? [], null);
        $this->setIfExists('reflected_type', $data ?? [], null);
        $this->setIfExists('custom_attributes', $data ?? [], null);
        $this->setIfExists('metadata_token', $data ?? [], null);
        $this->setIfExists('module', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getMemberTypeAllowableValues();
        if (!is_null($this->container['member_type']) && !in_array($this->container['member_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'member_type', must be one of '%s'",
                $this->container['member_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets member_type
     *
     * @return string|null
     */
    public function getMemberType()
    {
        return $this->container['member_type'];
    }

    /**
     * Sets member_type
     *
     * @param string|null $member_type member_type
     *
     * @return self
     */
    public function setMemberType($member_type)
    {
        if (is_null($member_type)) {
            throw new \InvalidArgumentException('non-nullable member_type cannot be null');
        }
        $allowedValues = $this->getMemberTypeAllowableValues();
        if (!in_array($member_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'member_type', must be one of '%s'",
                    $member_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['member_type'] = $member_type;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets declaring_type
     *
     * @return string|null
     */
    public function getDeclaringType()
    {
        return $this->container['declaring_type'];
    }

    /**
     * Sets declaring_type
     *
     * @param string|null $declaring_type declaring_type
     *
     * @return self
     */
    public function setDeclaringType($declaring_type)
    {
        if (is_null($declaring_type)) {
            throw new \InvalidArgumentException('non-nullable declaring_type cannot be null');
        }
        $this->container['declaring_type'] = $declaring_type;

        return $this;
    }

    /**
     * Gets reflected_type
     *
     * @return string|null
     */
    public function getReflectedType()
    {
        return $this->container['reflected_type'];
    }

    /**
     * Sets reflected_type
     *
     * @param string|null $reflected_type reflected_type
     *
     * @return self
     */
    public function setReflectedType($reflected_type)
    {
        if (is_null($reflected_type)) {
            throw new \InvalidArgumentException('non-nullable reflected_type cannot be null');
        }
        $this->container['reflected_type'] = $reflected_type;

        return $this;
    }

    /**
     * Gets custom_attributes
     *
     * @return \Linnworks\Inventory\Model\CustomAttributeData[]|null
     */
    public function getCustomAttributes()
    {
        return $this->container['custom_attributes'];
    }

    /**
     * Sets custom_attributes
     *
     * @param \Linnworks\Inventory\Model\CustomAttributeData[]|null $custom_attributes custom_attributes
     *
     * @return self
     */
    public function setCustomAttributes($custom_attributes)
    {
        if (is_null($custom_attributes)) {
            throw new \InvalidArgumentException('non-nullable custom_attributes cannot be null');
        }
        $this->container['custom_attributes'] = $custom_attributes;

        return $this;
    }

    /**
     * Gets metadata_token
     *
     * @return int|null
     */
    public function getMetadataToken()
    {
        return $this->container['metadata_token'];
    }

    /**
     * Sets metadata_token
     *
     * @param int|null $metadata_token metadata_token
     *
     * @return self
     */
    public function setMetadataToken($metadata_token)
    {
        if (is_null($metadata_token)) {
            throw new \InvalidArgumentException('non-nullable metadata_token cannot be null');
        }
        $this->container['metadata_token'] = $metadata_token;

        return $this;
    }

    /**
     * Gets module
     *
     * @return object|null
     */
    public function getModule()
    {
        return $this->container['module'];
    }

    /**
     * Sets module
     *
     * @param object|null $module module
     *
     * @return self
     */
    public function setModule($module)
    {
        if (is_null($module)) {
            throw new \InvalidArgumentException('non-nullable module cannot be null');
        }
        $this->container['module'] = $module;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


