<?php
/**
 * InventoryView
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * InventoryView Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InventoryView implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InventoryView';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'mode' => 'string',
        'source' => 'string',
        'sub_source' => 'string',
        'country_code' => 'string',
        'country_name' => 'string',
        'listing' => 'string',
        'show_only_changed' => 'bool',
        'include_products' => 'string',
        'filters' => '\Linnworks\Inventory\Model\Filter[]',
        'columns' => '\Linnworks\Inventory\Model\Column[]',
        'channels' => '\Linnworks\Inventory\Model\InventoryChannel[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'name' => null,
        'mode' => null,
        'source' => null,
        'sub_source' => null,
        'country_code' => null,
        'country_name' => null,
        'listing' => null,
        'show_only_changed' => null,
        'include_products' => null,
        'filters' => null,
        'columns' => null,
        'channels' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'name' => false,
        'mode' => false,
        'source' => false,
        'sub_source' => false,
        'country_code' => false,
        'country_name' => false,
        'listing' => false,
        'show_only_changed' => false,
        'include_products' => false,
        'filters' => false,
        'columns' => false,
        'channels' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'Id',
        'name' => 'Name',
        'mode' => 'Mode',
        'source' => 'Source',
        'sub_source' => 'SubSource',
        'country_code' => 'CountryCode',
        'country_name' => 'CountryName',
        'listing' => 'Listing',
        'show_only_changed' => 'ShowOnlyChanged',
        'include_products' => 'IncludeProducts',
        'filters' => 'Filters',
        'columns' => 'Columns',
        'channels' => 'Channels'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'mode' => 'setMode',
        'source' => 'setSource',
        'sub_source' => 'setSubSource',
        'country_code' => 'setCountryCode',
        'country_name' => 'setCountryName',
        'listing' => 'setListing',
        'show_only_changed' => 'setShowOnlyChanged',
        'include_products' => 'setIncludeProducts',
        'filters' => 'setFilters',
        'columns' => 'setColumns',
        'channels' => 'setChannels'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'mode' => 'getMode',
        'source' => 'getSource',
        'sub_source' => 'getSubSource',
        'country_code' => 'getCountryCode',
        'country_name' => 'getCountryName',
        'listing' => 'getListing',
        'show_only_changed' => 'getShowOnlyChanged',
        'include_products' => 'getIncludeProducts',
        'filters' => 'getFilters',
        'columns' => 'getColumns',
        'channels' => 'getChannels'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const MODE_ALL = 'All';
    public const MODE_LISTED = 'Listed';
    public const MODE_NOT_LISTED = 'NotListed';
    public const MODE_ERRORS = 'Errors';
    public const LISTING_ALL = 'All';
    public const LISTING_VARIATIONS = 'Variations';
    public const LISTING_NON_VARIATIONS = 'NonVariations';
    public const LISTING_SINGLE_ITEMS = 'SingleItems';
    public const INCLUDE_PRODUCTS_ALL = 'All';
    public const INCLUDE_PRODUCTS_ARCHIVED = 'Archived';
    public const INCLUDE_PRODUCTS_NOT_ARCHIVED = 'NotArchived';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getModeAllowableValues()
    {
        return [
            self::MODE_ALL,
            self::MODE_LISTED,
            self::MODE_NOT_LISTED,
            self::MODE_ERRORS,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getListingAllowableValues()
    {
        return [
            self::LISTING_ALL,
            self::LISTING_VARIATIONS,
            self::LISTING_NON_VARIATIONS,
            self::LISTING_SINGLE_ITEMS,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIncludeProductsAllowableValues()
    {
        return [
            self::INCLUDE_PRODUCTS_ALL,
            self::INCLUDE_PRODUCTS_ARCHIVED,
            self::INCLUDE_PRODUCTS_NOT_ARCHIVED,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('mode', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('country_code', $data ?? [], null);
        $this->setIfExists('country_name', $data ?? [], null);
        $this->setIfExists('listing', $data ?? [], null);
        $this->setIfExists('show_only_changed', $data ?? [], null);
        $this->setIfExists('include_products', $data ?? [], null);
        $this->setIfExists('filters', $data ?? [], null);
        $this->setIfExists('columns', $data ?? [], null);
        $this->setIfExists('channels', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getModeAllowableValues();
        if (!is_null($this->container['mode']) && !in_array($this->container['mode'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'mode', must be one of '%s'",
                $this->container['mode'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getListingAllowableValues();
        if (!is_null($this->container['listing']) && !in_array($this->container['listing'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'listing', must be one of '%s'",
                $this->container['listing'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getIncludeProductsAllowableValues();
        if (!is_null($this->container['include_products']) && !in_array($this->container['include_products'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'include_products', must be one of '%s'",
                $this->container['include_products'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id View ID
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name View name
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets mode
     *
     * @return string|null
     */
    public function getMode()
    {
        return $this->container['mode'];
    }

    /**
     * Sets mode
     *
     * @param string|null $mode Show listed or not listed
     *
     * @return self
     */
    public function setMode($mode)
    {
        if (is_null($mode)) {
            throw new \InvalidArgumentException('non-nullable mode cannot be null');
        }
        $allowedValues = $this->getModeAllowableValues();
        if (!in_array($mode, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'mode', must be one of '%s'",
                    $mode,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['mode'] = $mode;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source ChannelName/Source (e.g. EBAY)
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source SubSource (e.g. EBAY1)
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets country_code
     *
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->container['country_code'];
    }

    /**
     * Sets country_code
     *
     * @param string|null $country_code Country code
     *
     * @return self
     */
    public function setCountryCode($country_code)
    {
        if (is_null($country_code)) {
            throw new \InvalidArgumentException('non-nullable country_code cannot be null');
        }
        $this->container['country_code'] = $country_code;

        return $this;
    }

    /**
     * Gets country_name
     *
     * @return string|null
     */
    public function getCountryName()
    {
        return $this->container['country_name'];
    }

    /**
     * Sets country_name
     *
     * @param string|null $country_name Country code
     *
     * @return self
     */
    public function setCountryName($country_name)
    {
        if (is_null($country_name)) {
            throw new \InvalidArgumentException('non-nullable country_name cannot be null');
        }
        $this->container['country_name'] = $country_name;

        return $this;
    }

    /**
     * Gets listing
     *
     * @return string|null
     */
    public function getListing()
    {
        return $this->container['listing'];
    }

    /**
     * Sets listing
     *
     * @param string|null $listing What listing types to show
     *
     * @return self
     */
    public function setListing($listing)
    {
        if (is_null($listing)) {
            throw new \InvalidArgumentException('non-nullable listing cannot be null');
        }
        $allowedValues = $this->getListingAllowableValues();
        if (!in_array($listing, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'listing', must be one of '%s'",
                    $listing,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['listing'] = $listing;

        return $this;
    }

    /**
     * Gets show_only_changed
     *
     * @return bool|null
     */
    public function getShowOnlyChanged()
    {
        return $this->container['show_only_changed'];
    }

    /**
     * Sets show_only_changed
     *
     * @param bool|null $show_only_changed Show only changed items
     *
     * @return self
     */
    public function setShowOnlyChanged($show_only_changed)
    {
        if (is_null($show_only_changed)) {
            throw new \InvalidArgumentException('non-nullable show_only_changed cannot be null');
        }
        $this->container['show_only_changed'] = $show_only_changed;

        return $this;
    }

    /**
     * Gets include_products
     *
     * @return string|null
     */
    public function getIncludeProducts()
    {
        return $this->container['include_products'];
    }

    /**
     * Sets include_products
     *
     * @param string|null $include_products Include archived products
     *
     * @return self
     */
    public function setIncludeProducts($include_products)
    {
        if (is_null($include_products)) {
            throw new \InvalidArgumentException('non-nullable include_products cannot be null');
        }
        $allowedValues = $this->getIncludeProductsAllowableValues();
        if (!in_array($include_products, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'include_products', must be one of '%s'",
                    $include_products,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['include_products'] = $include_products;

        return $this;
    }

    /**
     * Gets filters
     *
     * @return \Linnworks\Inventory\Model\Filter[]|null
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     *
     * @param \Linnworks\Inventory\Model\Filter[]|null $filters View filters
     *
     * @return self
     */
    public function setFilters($filters)
    {
        if (is_null($filters)) {
            throw new \InvalidArgumentException('non-nullable filters cannot be null');
        }
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets columns
     *
     * @return \Linnworks\Inventory\Model\Column[]|null
     */
    public function getColumns()
    {
        return $this->container['columns'];
    }

    /**
     * Sets columns
     *
     * @param \Linnworks\Inventory\Model\Column[]|null $columns View columns
     *
     * @return self
     */
    public function setColumns($columns)
    {
        if (is_null($columns)) {
            throw new \InvalidArgumentException('non-nullable columns cannot be null');
        }
        $this->container['columns'] = $columns;

        return $this;
    }

    /**
     * Gets channels
     *
     * @return \Linnworks\Inventory\Model\InventoryChannel[]|null
     */
    public function getChannels()
    {
        return $this->container['channels'];
    }

    /**
     * Sets channels
     *
     * @param \Linnworks\Inventory\Model\InventoryChannel[]|null $channels View channels
     *
     * @return self
     */
    public function setChannels($channels)
    {
        if (is_null($channels)) {
            throw new \InvalidArgumentException('non-nullable channels cannot be null');
        }
        $this->container['channels'] = $channels;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


