<?php
/**
 * HeaderConfig
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * HeaderConfig Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class HeaderConfig implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'HeaderConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'source_version' => '\Linnworks\Inventory\Model\ConfigItemString',
        'enabled' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'channel_tag' => '\Linnworks\Inventory\Model\ConfigItemString',
        'channel_location_binding' => '\Linnworks\Inventory\Model\ConfigChannelLocationBinding',
        'is_multi_location' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'auto_populated_locations' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'can_modify_locations_on_channel' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'bopis_supported' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'process_pos_orders' => '\Linnworks\Inventory\Model\ConfigPropertyBoolean',
        'despatch_notes' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'cancellation_notes' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'auto_respond_cancellation_requests' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'cancellation_response_type' => '\Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString',
        'refund_notes' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'download_refunds' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'return_notes' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'download_returns' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'order_save_location' => '\Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionGuid',
        'order_sync_date' => '\Linnworks\Inventory\Model\ConfigItemDateTime',
        'order_cancellation_check_date' => '\Linnworks\Inventory\Model\ConfigItemDateTime',
        'config_discount' => '\Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString',
        'order_download_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'order_download_global_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'order_despatch_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'order_despatch_global_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'order_cancellation_check_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'order_cancellation_check_global_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'rma_download_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'rma_download_global_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'hides_header_attributes' => '\Linnworks\Inventory\Model\ConfigPropertyBoolean',
        'inventory_sync' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'stock_location_binding' => '\Linnworks\Inventory\Model\ConfigStockLocationBinding',
        'max_listed' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'stock_percentage' => '\Linnworks\Inventory\Model\ConfigItemDouble',
        'end_when' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'inv_sync_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'extract_inventory' => '\Linnworks\Inventory\Model\ConfigPropertyBoolean',
        'extract_inventory_variation_mapping_property_name' => '\Linnworks\Inventory\Model\ConfigPropertyString',
        'price_change' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'price_change_error_count' => '\Linnworks\Inventory\Model\ConfigItemInt32',
        'is_inventory_sync_trigger_enabled' => '\Linnworks\Inventory\Model\ConfigPropertyBoolean',
        'is_listing_scan_running' => '\Linnworks\Inventory\Model\ConfigItemBoolean',
        'listing_scan_start_update_date' => '\Linnworks\Inventory\Model\ConfigItemDateTime',
        'last_listing_update_date' => '\Linnworks\Inventory\Model\ConfigItemDateTime',
        'estimated_inventory_scan_complete' => '\Linnworks\Inventory\Model\ConfigItemDateTime',
        'is_header_only' => 'bool',
        'is_hidden' => 'bool',
        'display_name' => 'string',
        'dynamic_properties' => '\Linnworks\Inventory\Model\ConfigItemExternal[]',
        'config_discount_typed' => 'string',
        'postal_service_mapping' => '\Linnworks\Inventory\Model\ConfigPostalServiceMapping',
        'payment_method_mapping' => '\Linnworks\Inventory\Model\ConfigPaymentMethodMapping',
        'pk_channel_id' => 'int',
        'source' => 'string',
        'source_type' => 'string',
        'fulfillment_service_enabled' => 'bool',
        'fulfillment_location' => 'string',
        'concurrency_key' => 'string',
        'rules' => '\Linnworks\Inventory\Model\ConfigRule[]',
        'buttons' => '\Linnworks\Inventory\Model\ConfigButton[]',
        'sub_source' => 'string',
        'header_audit_values' => '\Linnworks\Inventory\Model\ChannelSettingAudit[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'source_version' => null,
        'enabled' => null,
        'channel_tag' => null,
        'channel_location_binding' => null,
        'is_multi_location' => null,
        'auto_populated_locations' => null,
        'can_modify_locations_on_channel' => null,
        'bopis_supported' => null,
        'process_pos_orders' => null,
        'despatch_notes' => null,
        'cancellation_notes' => null,
        'auto_respond_cancellation_requests' => null,
        'cancellation_response_type' => null,
        'refund_notes' => null,
        'download_refunds' => null,
        'return_notes' => null,
        'download_returns' => null,
        'order_save_location' => null,
        'order_sync_date' => null,
        'order_cancellation_check_date' => null,
        'config_discount' => null,
        'order_download_error_count' => null,
        'order_download_global_error_count' => null,
        'order_despatch_error_count' => null,
        'order_despatch_global_error_count' => null,
        'order_cancellation_check_error_count' => null,
        'order_cancellation_check_global_error_count' => null,
        'rma_download_error_count' => null,
        'rma_download_global_error_count' => null,
        'hides_header_attributes' => null,
        'inventory_sync' => null,
        'stock_location_binding' => null,
        'max_listed' => null,
        'stock_percentage' => null,
        'end_when' => null,
        'inv_sync_error_count' => null,
        'extract_inventory' => null,
        'extract_inventory_variation_mapping_property_name' => null,
        'price_change' => null,
        'price_change_error_count' => null,
        'is_inventory_sync_trigger_enabled' => null,
        'is_listing_scan_running' => null,
        'listing_scan_start_update_date' => null,
        'last_listing_update_date' => null,
        'estimated_inventory_scan_complete' => null,
        'is_header_only' => null,
        'is_hidden' => null,
        'display_name' => null,
        'dynamic_properties' => null,
        'config_discount_typed' => null,
        'postal_service_mapping' => null,
        'payment_method_mapping' => null,
        'pk_channel_id' => 'int32',
        'source' => null,
        'source_type' => null,
        'fulfillment_service_enabled' => null,
        'fulfillment_location' => 'uuid',
        'concurrency_key' => null,
        'rules' => null,
        'buttons' => null,
        'sub_source' => null,
        'header_audit_values' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'source_version' => false,
        'enabled' => false,
        'channel_tag' => false,
        'channel_location_binding' => false,
        'is_multi_location' => false,
        'auto_populated_locations' => false,
        'can_modify_locations_on_channel' => false,
        'bopis_supported' => false,
        'process_pos_orders' => false,
        'despatch_notes' => false,
        'cancellation_notes' => false,
        'auto_respond_cancellation_requests' => false,
        'cancellation_response_type' => false,
        'refund_notes' => false,
        'download_refunds' => false,
        'return_notes' => false,
        'download_returns' => false,
        'order_save_location' => false,
        'order_sync_date' => false,
        'order_cancellation_check_date' => false,
        'config_discount' => false,
        'order_download_error_count' => false,
        'order_download_global_error_count' => false,
        'order_despatch_error_count' => false,
        'order_despatch_global_error_count' => false,
        'order_cancellation_check_error_count' => false,
        'order_cancellation_check_global_error_count' => false,
        'rma_download_error_count' => false,
        'rma_download_global_error_count' => false,
        'hides_header_attributes' => false,
        'inventory_sync' => false,
        'stock_location_binding' => false,
        'max_listed' => false,
        'stock_percentage' => false,
        'end_when' => false,
        'inv_sync_error_count' => false,
        'extract_inventory' => false,
        'extract_inventory_variation_mapping_property_name' => false,
        'price_change' => false,
        'price_change_error_count' => false,
        'is_inventory_sync_trigger_enabled' => false,
        'is_listing_scan_running' => false,
        'listing_scan_start_update_date' => false,
        'last_listing_update_date' => false,
        'estimated_inventory_scan_complete' => false,
        'is_header_only' => false,
        'is_hidden' => false,
        'display_name' => false,
        'dynamic_properties' => false,
        'config_discount_typed' => false,
        'postal_service_mapping' => false,
        'payment_method_mapping' => false,
        'pk_channel_id' => false,
        'source' => false,
        'source_type' => false,
        'fulfillment_service_enabled' => false,
        'fulfillment_location' => false,
        'concurrency_key' => false,
        'rules' => false,
        'buttons' => false,
        'sub_source' => false,
        'header_audit_values' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'source_version' => 'SourceVersion',
        'enabled' => 'Enabled',
        'channel_tag' => 'ChannelTag',
        'channel_location_binding' => 'ChannelLocationBinding',
        'is_multi_location' => 'IsMultiLocation',
        'auto_populated_locations' => 'AutoPopulatedLocations',
        'can_modify_locations_on_channel' => 'CanModifyLocationsOnChannel',
        'bopis_supported' => 'BopisSupported',
        'process_pos_orders' => 'ProcessPosOrders',
        'despatch_notes' => 'DespatchNotes',
        'cancellation_notes' => 'CancellationNotes',
        'auto_respond_cancellation_requests' => 'AutoRespondCancellationRequests',
        'cancellation_response_type' => 'CancellationResponseType',
        'refund_notes' => 'RefundNotes',
        'download_refunds' => 'DownloadRefunds',
        'return_notes' => 'ReturnNotes',
        'download_returns' => 'DownloadReturns',
        'order_save_location' => 'OrderSaveLocation',
        'order_sync_date' => 'OrderSyncDate',
        'order_cancellation_check_date' => 'OrderCancellationCheckDate',
        'config_discount' => 'ConfigDiscount',
        'order_download_error_count' => 'OrderDownloadErrorCount',
        'order_download_global_error_count' => 'OrderDownloadGlobalErrorCount',
        'order_despatch_error_count' => 'OrderDespatchErrorCount',
        'order_despatch_global_error_count' => 'OrderDespatchGlobalErrorCount',
        'order_cancellation_check_error_count' => 'OrderCancellationCheckErrorCount',
        'order_cancellation_check_global_error_count' => 'OrderCancellationCheckGlobalErrorCount',
        'rma_download_error_count' => 'RmaDownloadErrorCount',
        'rma_download_global_error_count' => 'RmaDownloadGlobalErrorCount',
        'hides_header_attributes' => 'HidesHeaderAttributes',
        'inventory_sync' => 'InventorySync',
        'stock_location_binding' => 'StockLocationBinding',
        'max_listed' => 'MaxListed',
        'stock_percentage' => 'StockPercentage',
        'end_when' => 'EndWhen',
        'inv_sync_error_count' => 'InvSyncErrorCount',
        'extract_inventory' => 'ExtractInventory',
        'extract_inventory_variation_mapping_property_name' => 'ExtractInventoryVariationMappingPropertyName',
        'price_change' => 'PriceChange',
        'price_change_error_count' => 'PriceChangeErrorCount',
        'is_inventory_sync_trigger_enabled' => 'IsInventorySyncTriggerEnabled',
        'is_listing_scan_running' => 'IsListingScanRunning',
        'listing_scan_start_update_date' => 'ListingScanStartUpdateDate',
        'last_listing_update_date' => 'LastListingUpdateDate',
        'estimated_inventory_scan_complete' => 'EstimatedInventoryScanComplete',
        'is_header_only' => 'IsHeaderOnly',
        'is_hidden' => 'IsHidden',
        'display_name' => 'DisplayName',
        'dynamic_properties' => 'DynamicProperties',
        'config_discount_typed' => 'ConfigDiscountTyped',
        'postal_service_mapping' => 'PostalServiceMapping',
        'payment_method_mapping' => 'PaymentMethodMapping',
        'pk_channel_id' => 'PkChannelId',
        'source' => 'Source',
        'source_type' => 'SourceType',
        'fulfillment_service_enabled' => 'FulfillmentServiceEnabled',
        'fulfillment_location' => 'FulfillmentLocation',
        'concurrency_key' => 'ConcurrencyKey',
        'rules' => 'Rules',
        'buttons' => 'Buttons',
        'sub_source' => 'SubSource',
        'header_audit_values' => 'HeaderAuditValues'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'source_version' => 'setSourceVersion',
        'enabled' => 'setEnabled',
        'channel_tag' => 'setChannelTag',
        'channel_location_binding' => 'setChannelLocationBinding',
        'is_multi_location' => 'setIsMultiLocation',
        'auto_populated_locations' => 'setAutoPopulatedLocations',
        'can_modify_locations_on_channel' => 'setCanModifyLocationsOnChannel',
        'bopis_supported' => 'setBopisSupported',
        'process_pos_orders' => 'setProcessPosOrders',
        'despatch_notes' => 'setDespatchNotes',
        'cancellation_notes' => 'setCancellationNotes',
        'auto_respond_cancellation_requests' => 'setAutoRespondCancellationRequests',
        'cancellation_response_type' => 'setCancellationResponseType',
        'refund_notes' => 'setRefundNotes',
        'download_refunds' => 'setDownloadRefunds',
        'return_notes' => 'setReturnNotes',
        'download_returns' => 'setDownloadReturns',
        'order_save_location' => 'setOrderSaveLocation',
        'order_sync_date' => 'setOrderSyncDate',
        'order_cancellation_check_date' => 'setOrderCancellationCheckDate',
        'config_discount' => 'setConfigDiscount',
        'order_download_error_count' => 'setOrderDownloadErrorCount',
        'order_download_global_error_count' => 'setOrderDownloadGlobalErrorCount',
        'order_despatch_error_count' => 'setOrderDespatchErrorCount',
        'order_despatch_global_error_count' => 'setOrderDespatchGlobalErrorCount',
        'order_cancellation_check_error_count' => 'setOrderCancellationCheckErrorCount',
        'order_cancellation_check_global_error_count' => 'setOrderCancellationCheckGlobalErrorCount',
        'rma_download_error_count' => 'setRmaDownloadErrorCount',
        'rma_download_global_error_count' => 'setRmaDownloadGlobalErrorCount',
        'hides_header_attributes' => 'setHidesHeaderAttributes',
        'inventory_sync' => 'setInventorySync',
        'stock_location_binding' => 'setStockLocationBinding',
        'max_listed' => 'setMaxListed',
        'stock_percentage' => 'setStockPercentage',
        'end_when' => 'setEndWhen',
        'inv_sync_error_count' => 'setInvSyncErrorCount',
        'extract_inventory' => 'setExtractInventory',
        'extract_inventory_variation_mapping_property_name' => 'setExtractInventoryVariationMappingPropertyName',
        'price_change' => 'setPriceChange',
        'price_change_error_count' => 'setPriceChangeErrorCount',
        'is_inventory_sync_trigger_enabled' => 'setIsInventorySyncTriggerEnabled',
        'is_listing_scan_running' => 'setIsListingScanRunning',
        'listing_scan_start_update_date' => 'setListingScanStartUpdateDate',
        'last_listing_update_date' => 'setLastListingUpdateDate',
        'estimated_inventory_scan_complete' => 'setEstimatedInventoryScanComplete',
        'is_header_only' => 'setIsHeaderOnly',
        'is_hidden' => 'setIsHidden',
        'display_name' => 'setDisplayName',
        'dynamic_properties' => 'setDynamicProperties',
        'config_discount_typed' => 'setConfigDiscountTyped',
        'postal_service_mapping' => 'setPostalServiceMapping',
        'payment_method_mapping' => 'setPaymentMethodMapping',
        'pk_channel_id' => 'setPkChannelId',
        'source' => 'setSource',
        'source_type' => 'setSourceType',
        'fulfillment_service_enabled' => 'setFulfillmentServiceEnabled',
        'fulfillment_location' => 'setFulfillmentLocation',
        'concurrency_key' => 'setConcurrencyKey',
        'rules' => 'setRules',
        'buttons' => 'setButtons',
        'sub_source' => 'setSubSource',
        'header_audit_values' => 'setHeaderAuditValues'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'source_version' => 'getSourceVersion',
        'enabled' => 'getEnabled',
        'channel_tag' => 'getChannelTag',
        'channel_location_binding' => 'getChannelLocationBinding',
        'is_multi_location' => 'getIsMultiLocation',
        'auto_populated_locations' => 'getAutoPopulatedLocations',
        'can_modify_locations_on_channel' => 'getCanModifyLocationsOnChannel',
        'bopis_supported' => 'getBopisSupported',
        'process_pos_orders' => 'getProcessPosOrders',
        'despatch_notes' => 'getDespatchNotes',
        'cancellation_notes' => 'getCancellationNotes',
        'auto_respond_cancellation_requests' => 'getAutoRespondCancellationRequests',
        'cancellation_response_type' => 'getCancellationResponseType',
        'refund_notes' => 'getRefundNotes',
        'download_refunds' => 'getDownloadRefunds',
        'return_notes' => 'getReturnNotes',
        'download_returns' => 'getDownloadReturns',
        'order_save_location' => 'getOrderSaveLocation',
        'order_sync_date' => 'getOrderSyncDate',
        'order_cancellation_check_date' => 'getOrderCancellationCheckDate',
        'config_discount' => 'getConfigDiscount',
        'order_download_error_count' => 'getOrderDownloadErrorCount',
        'order_download_global_error_count' => 'getOrderDownloadGlobalErrorCount',
        'order_despatch_error_count' => 'getOrderDespatchErrorCount',
        'order_despatch_global_error_count' => 'getOrderDespatchGlobalErrorCount',
        'order_cancellation_check_error_count' => 'getOrderCancellationCheckErrorCount',
        'order_cancellation_check_global_error_count' => 'getOrderCancellationCheckGlobalErrorCount',
        'rma_download_error_count' => 'getRmaDownloadErrorCount',
        'rma_download_global_error_count' => 'getRmaDownloadGlobalErrorCount',
        'hides_header_attributes' => 'getHidesHeaderAttributes',
        'inventory_sync' => 'getInventorySync',
        'stock_location_binding' => 'getStockLocationBinding',
        'max_listed' => 'getMaxListed',
        'stock_percentage' => 'getStockPercentage',
        'end_when' => 'getEndWhen',
        'inv_sync_error_count' => 'getInvSyncErrorCount',
        'extract_inventory' => 'getExtractInventory',
        'extract_inventory_variation_mapping_property_name' => 'getExtractInventoryVariationMappingPropertyName',
        'price_change' => 'getPriceChange',
        'price_change_error_count' => 'getPriceChangeErrorCount',
        'is_inventory_sync_trigger_enabled' => 'getIsInventorySyncTriggerEnabled',
        'is_listing_scan_running' => 'getIsListingScanRunning',
        'listing_scan_start_update_date' => 'getListingScanStartUpdateDate',
        'last_listing_update_date' => 'getLastListingUpdateDate',
        'estimated_inventory_scan_complete' => 'getEstimatedInventoryScanComplete',
        'is_header_only' => 'getIsHeaderOnly',
        'is_hidden' => 'getIsHidden',
        'display_name' => 'getDisplayName',
        'dynamic_properties' => 'getDynamicProperties',
        'config_discount_typed' => 'getConfigDiscountTyped',
        'postal_service_mapping' => 'getPostalServiceMapping',
        'payment_method_mapping' => 'getPaymentMethodMapping',
        'pk_channel_id' => 'getPkChannelId',
        'source' => 'getSource',
        'source_type' => 'getSourceType',
        'fulfillment_service_enabled' => 'getFulfillmentServiceEnabled',
        'fulfillment_location' => 'getFulfillmentLocation',
        'concurrency_key' => 'getConcurrencyKey',
        'rules' => 'getRules',
        'buttons' => 'getButtons',
        'sub_source' => 'getSubSource',
        'header_audit_values' => 'getHeaderAuditValues'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const CONFIG_DISCOUNT_TYPED_ALL_EVENLY = 'AllEvenly';
    public const CONFIG_DISCOUNT_TYPED_ITEMS_THEN_POSTAGE = 'ItemsThenPostage';
    public const CONFIG_DISCOUNT_TYPED_POSTAGE_THEN_ITEMS = 'PostageThenItems';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getConfigDiscountTypedAllowableValues()
    {
        return [
            self::CONFIG_DISCOUNT_TYPED_ALL_EVENLY,
            self::CONFIG_DISCOUNT_TYPED_ITEMS_THEN_POSTAGE,
            self::CONFIG_DISCOUNT_TYPED_POSTAGE_THEN_ITEMS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('source_version', $data ?? [], null);
        $this->setIfExists('enabled', $data ?? [], null);
        $this->setIfExists('channel_tag', $data ?? [], null);
        $this->setIfExists('channel_location_binding', $data ?? [], null);
        $this->setIfExists('is_multi_location', $data ?? [], null);
        $this->setIfExists('auto_populated_locations', $data ?? [], null);
        $this->setIfExists('can_modify_locations_on_channel', $data ?? [], null);
        $this->setIfExists('bopis_supported', $data ?? [], null);
        $this->setIfExists('process_pos_orders', $data ?? [], null);
        $this->setIfExists('despatch_notes', $data ?? [], null);
        $this->setIfExists('cancellation_notes', $data ?? [], null);
        $this->setIfExists('auto_respond_cancellation_requests', $data ?? [], null);
        $this->setIfExists('cancellation_response_type', $data ?? [], null);
        $this->setIfExists('refund_notes', $data ?? [], null);
        $this->setIfExists('download_refunds', $data ?? [], null);
        $this->setIfExists('return_notes', $data ?? [], null);
        $this->setIfExists('download_returns', $data ?? [], null);
        $this->setIfExists('order_save_location', $data ?? [], null);
        $this->setIfExists('order_sync_date', $data ?? [], null);
        $this->setIfExists('order_cancellation_check_date', $data ?? [], null);
        $this->setIfExists('config_discount', $data ?? [], null);
        $this->setIfExists('order_download_error_count', $data ?? [], null);
        $this->setIfExists('order_download_global_error_count', $data ?? [], null);
        $this->setIfExists('order_despatch_error_count', $data ?? [], null);
        $this->setIfExists('order_despatch_global_error_count', $data ?? [], null);
        $this->setIfExists('order_cancellation_check_error_count', $data ?? [], null);
        $this->setIfExists('order_cancellation_check_global_error_count', $data ?? [], null);
        $this->setIfExists('rma_download_error_count', $data ?? [], null);
        $this->setIfExists('rma_download_global_error_count', $data ?? [], null);
        $this->setIfExists('hides_header_attributes', $data ?? [], null);
        $this->setIfExists('inventory_sync', $data ?? [], null);
        $this->setIfExists('stock_location_binding', $data ?? [], null);
        $this->setIfExists('max_listed', $data ?? [], null);
        $this->setIfExists('stock_percentage', $data ?? [], null);
        $this->setIfExists('end_when', $data ?? [], null);
        $this->setIfExists('inv_sync_error_count', $data ?? [], null);
        $this->setIfExists('extract_inventory', $data ?? [], null);
        $this->setIfExists('extract_inventory_variation_mapping_property_name', $data ?? [], null);
        $this->setIfExists('price_change', $data ?? [], null);
        $this->setIfExists('price_change_error_count', $data ?? [], null);
        $this->setIfExists('is_inventory_sync_trigger_enabled', $data ?? [], null);
        $this->setIfExists('is_listing_scan_running', $data ?? [], null);
        $this->setIfExists('listing_scan_start_update_date', $data ?? [], null);
        $this->setIfExists('last_listing_update_date', $data ?? [], null);
        $this->setIfExists('estimated_inventory_scan_complete', $data ?? [], null);
        $this->setIfExists('is_header_only', $data ?? [], null);
        $this->setIfExists('is_hidden', $data ?? [], null);
        $this->setIfExists('display_name', $data ?? [], null);
        $this->setIfExists('dynamic_properties', $data ?? [], null);
        $this->setIfExists('config_discount_typed', $data ?? [], null);
        $this->setIfExists('postal_service_mapping', $data ?? [], null);
        $this->setIfExists('payment_method_mapping', $data ?? [], null);
        $this->setIfExists('pk_channel_id', $data ?? [], null);
        $this->setIfExists('source', $data ?? [], null);
        $this->setIfExists('source_type', $data ?? [], null);
        $this->setIfExists('fulfillment_service_enabled', $data ?? [], null);
        $this->setIfExists('fulfillment_location', $data ?? [], null);
        $this->setIfExists('concurrency_key', $data ?? [], null);
        $this->setIfExists('rules', $data ?? [], null);
        $this->setIfExists('buttons', $data ?? [], null);
        $this->setIfExists('sub_source', $data ?? [], null);
        $this->setIfExists('header_audit_values', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getConfigDiscountTypedAllowableValues();
        if (!is_null($this->container['config_discount_typed']) && !in_array($this->container['config_discount_typed'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'config_discount_typed', must be one of '%s'",
                $this->container['config_discount_typed'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets source_version
     *
     * @return \Linnworks\Inventory\Model\ConfigItemString|null
     */
    public function getSourceVersion()
    {
        return $this->container['source_version'];
    }

    /**
     * Sets source_version
     *
     * @param \Linnworks\Inventory\Model\ConfigItemString|null $source_version source_version
     *
     * @return self
     */
    public function setSourceVersion($source_version)
    {
        if (is_null($source_version)) {
            throw new \InvalidArgumentException('non-nullable source_version cannot be null');
        }
        $this->container['source_version'] = $source_version;

        return $this;
    }

    /**
     * Gets enabled
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $enabled enabled
     *
     * @return self
     */
    public function setEnabled($enabled)
    {
        if (is_null($enabled)) {
            throw new \InvalidArgumentException('non-nullable enabled cannot be null');
        }
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets channel_tag
     *
     * @return \Linnworks\Inventory\Model\ConfigItemString|null
     */
    public function getChannelTag()
    {
        return $this->container['channel_tag'];
    }

    /**
     * Sets channel_tag
     *
     * @param \Linnworks\Inventory\Model\ConfigItemString|null $channel_tag channel_tag
     *
     * @return self
     */
    public function setChannelTag($channel_tag)
    {
        if (is_null($channel_tag)) {
            throw new \InvalidArgumentException('non-nullable channel_tag cannot be null');
        }
        $this->container['channel_tag'] = $channel_tag;

        return $this;
    }

    /**
     * Gets channel_location_binding
     *
     * @return \Linnworks\Inventory\Model\ConfigChannelLocationBinding|null
     */
    public function getChannelLocationBinding()
    {
        return $this->container['channel_location_binding'];
    }

    /**
     * Sets channel_location_binding
     *
     * @param \Linnworks\Inventory\Model\ConfigChannelLocationBinding|null $channel_location_binding channel_location_binding
     *
     * @return self
     */
    public function setChannelLocationBinding($channel_location_binding)
    {
        if (is_null($channel_location_binding)) {
            throw new \InvalidArgumentException('non-nullable channel_location_binding cannot be null');
        }
        $this->container['channel_location_binding'] = $channel_location_binding;

        return $this;
    }

    /**
     * Gets is_multi_location
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getIsMultiLocation()
    {
        return $this->container['is_multi_location'];
    }

    /**
     * Sets is_multi_location
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $is_multi_location is_multi_location
     *
     * @return self
     */
    public function setIsMultiLocation($is_multi_location)
    {
        if (is_null($is_multi_location)) {
            throw new \InvalidArgumentException('non-nullable is_multi_location cannot be null');
        }
        $this->container['is_multi_location'] = $is_multi_location;

        return $this;
    }

    /**
     * Gets auto_populated_locations
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getAutoPopulatedLocations()
    {
        return $this->container['auto_populated_locations'];
    }

    /**
     * Sets auto_populated_locations
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $auto_populated_locations auto_populated_locations
     *
     * @return self
     */
    public function setAutoPopulatedLocations($auto_populated_locations)
    {
        if (is_null($auto_populated_locations)) {
            throw new \InvalidArgumentException('non-nullable auto_populated_locations cannot be null');
        }
        $this->container['auto_populated_locations'] = $auto_populated_locations;

        return $this;
    }

    /**
     * Gets can_modify_locations_on_channel
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getCanModifyLocationsOnChannel()
    {
        return $this->container['can_modify_locations_on_channel'];
    }

    /**
     * Sets can_modify_locations_on_channel
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $can_modify_locations_on_channel can_modify_locations_on_channel
     *
     * @return self
     */
    public function setCanModifyLocationsOnChannel($can_modify_locations_on_channel)
    {
        if (is_null($can_modify_locations_on_channel)) {
            throw new \InvalidArgumentException('non-nullable can_modify_locations_on_channel cannot be null');
        }
        $this->container['can_modify_locations_on_channel'] = $can_modify_locations_on_channel;

        return $this;
    }

    /**
     * Gets bopis_supported
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getBopisSupported()
    {
        return $this->container['bopis_supported'];
    }

    /**
     * Sets bopis_supported
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $bopis_supported bopis_supported
     *
     * @return self
     */
    public function setBopisSupported($bopis_supported)
    {
        if (is_null($bopis_supported)) {
            throw new \InvalidArgumentException('non-nullable bopis_supported cannot be null');
        }
        $this->container['bopis_supported'] = $bopis_supported;

        return $this;
    }

    /**
     * Gets process_pos_orders
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertyBoolean|null
     */
    public function getProcessPosOrders()
    {
        return $this->container['process_pos_orders'];
    }

    /**
     * Sets process_pos_orders
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertyBoolean|null $process_pos_orders process_pos_orders
     *
     * @return self
     */
    public function setProcessPosOrders($process_pos_orders)
    {
        if (is_null($process_pos_orders)) {
            throw new \InvalidArgumentException('non-nullable process_pos_orders cannot be null');
        }
        $this->container['process_pos_orders'] = $process_pos_orders;

        return $this;
    }

    /**
     * Gets despatch_notes
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getDespatchNotes()
    {
        return $this->container['despatch_notes'];
    }

    /**
     * Sets despatch_notes
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $despatch_notes despatch_notes
     *
     * @return self
     */
    public function setDespatchNotes($despatch_notes)
    {
        if (is_null($despatch_notes)) {
            throw new \InvalidArgumentException('non-nullable despatch_notes cannot be null');
        }
        $this->container['despatch_notes'] = $despatch_notes;

        return $this;
    }

    /**
     * Gets cancellation_notes
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getCancellationNotes()
    {
        return $this->container['cancellation_notes'];
    }

    /**
     * Sets cancellation_notes
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $cancellation_notes cancellation_notes
     *
     * @return self
     */
    public function setCancellationNotes($cancellation_notes)
    {
        if (is_null($cancellation_notes)) {
            throw new \InvalidArgumentException('non-nullable cancellation_notes cannot be null');
        }
        $this->container['cancellation_notes'] = $cancellation_notes;

        return $this;
    }

    /**
     * Gets auto_respond_cancellation_requests
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getAutoRespondCancellationRequests()
    {
        return $this->container['auto_respond_cancellation_requests'];
    }

    /**
     * Sets auto_respond_cancellation_requests
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $auto_respond_cancellation_requests auto_respond_cancellation_requests
     *
     * @return self
     */
    public function setAutoRespondCancellationRequests($auto_respond_cancellation_requests)
    {
        if (is_null($auto_respond_cancellation_requests)) {
            throw new \InvalidArgumentException('non-nullable auto_respond_cancellation_requests cannot be null');
        }
        $this->container['auto_respond_cancellation_requests'] = $auto_respond_cancellation_requests;

        return $this;
    }

    /**
     * Gets cancellation_response_type
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString|null
     */
    public function getCancellationResponseType()
    {
        return $this->container['cancellation_response_type'];
    }

    /**
     * Sets cancellation_response_type
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString|null $cancellation_response_type cancellation_response_type
     *
     * @return self
     */
    public function setCancellationResponseType($cancellation_response_type)
    {
        if (is_null($cancellation_response_type)) {
            throw new \InvalidArgumentException('non-nullable cancellation_response_type cannot be null');
        }
        $this->container['cancellation_response_type'] = $cancellation_response_type;

        return $this;
    }

    /**
     * Gets refund_notes
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getRefundNotes()
    {
        return $this->container['refund_notes'];
    }

    /**
     * Sets refund_notes
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $refund_notes refund_notes
     *
     * @return self
     */
    public function setRefundNotes($refund_notes)
    {
        if (is_null($refund_notes)) {
            throw new \InvalidArgumentException('non-nullable refund_notes cannot be null');
        }
        $this->container['refund_notes'] = $refund_notes;

        return $this;
    }

    /**
     * Gets download_refunds
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getDownloadRefunds()
    {
        return $this->container['download_refunds'];
    }

    /**
     * Sets download_refunds
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $download_refunds download_refunds
     *
     * @return self
     */
    public function setDownloadRefunds($download_refunds)
    {
        if (is_null($download_refunds)) {
            throw new \InvalidArgumentException('non-nullable download_refunds cannot be null');
        }
        $this->container['download_refunds'] = $download_refunds;

        return $this;
    }

    /**
     * Gets return_notes
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getReturnNotes()
    {
        return $this->container['return_notes'];
    }

    /**
     * Sets return_notes
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $return_notes return_notes
     *
     * @return self
     */
    public function setReturnNotes($return_notes)
    {
        if (is_null($return_notes)) {
            throw new \InvalidArgumentException('non-nullable return_notes cannot be null');
        }
        $this->container['return_notes'] = $return_notes;

        return $this;
    }

    /**
     * Gets download_returns
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getDownloadReturns()
    {
        return $this->container['download_returns'];
    }

    /**
     * Sets download_returns
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $download_returns download_returns
     *
     * @return self
     */
    public function setDownloadReturns($download_returns)
    {
        if (is_null($download_returns)) {
            throw new \InvalidArgumentException('non-nullable download_returns cannot be null');
        }
        $this->container['download_returns'] = $download_returns;

        return $this;
    }

    /**
     * Gets order_save_location
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionGuid|null
     */
    public function getOrderSaveLocation()
    {
        return $this->container['order_save_location'];
    }

    /**
     * Sets order_save_location
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionGuid|null $order_save_location order_save_location
     *
     * @return self
     */
    public function setOrderSaveLocation($order_save_location)
    {
        if (is_null($order_save_location)) {
            throw new \InvalidArgumentException('non-nullable order_save_location cannot be null');
        }
        $this->container['order_save_location'] = $order_save_location;

        return $this;
    }

    /**
     * Gets order_sync_date
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDateTime|null
     */
    public function getOrderSyncDate()
    {
        return $this->container['order_sync_date'];
    }

    /**
     * Sets order_sync_date
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDateTime|null $order_sync_date order_sync_date
     *
     * @return self
     */
    public function setOrderSyncDate($order_sync_date)
    {
        if (is_null($order_sync_date)) {
            throw new \InvalidArgumentException('non-nullable order_sync_date cannot be null');
        }
        $this->container['order_sync_date'] = $order_sync_date;

        return $this;
    }

    /**
     * Gets order_cancellation_check_date
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDateTime|null
     */
    public function getOrderCancellationCheckDate()
    {
        return $this->container['order_cancellation_check_date'];
    }

    /**
     * Sets order_cancellation_check_date
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDateTime|null $order_cancellation_check_date order_cancellation_check_date
     *
     * @return self
     */
    public function setOrderCancellationCheckDate($order_cancellation_check_date)
    {
        if (is_null($order_cancellation_check_date)) {
            throw new \InvalidArgumentException('non-nullable order_cancellation_check_date cannot be null');
        }
        $this->container['order_cancellation_check_date'] = $order_cancellation_check_date;

        return $this;
    }

    /**
     * Gets config_discount
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString|null
     */
    public function getConfigDiscount()
    {
        return $this->container['config_discount'];
    }

    /**
     * Sets config_discount
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertySelectionListSelectStringValueOptionString|null $config_discount config_discount
     *
     * @return self
     */
    public function setConfigDiscount($config_discount)
    {
        if (is_null($config_discount)) {
            throw new \InvalidArgumentException('non-nullable config_discount cannot be null');
        }
        $this->container['config_discount'] = $config_discount;

        return $this;
    }

    /**
     * Gets order_download_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderDownloadErrorCount()
    {
        return $this->container['order_download_error_count'];
    }

    /**
     * Sets order_download_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_download_error_count order_download_error_count
     *
     * @return self
     */
    public function setOrderDownloadErrorCount($order_download_error_count)
    {
        if (is_null($order_download_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_download_error_count cannot be null');
        }
        $this->container['order_download_error_count'] = $order_download_error_count;

        return $this;
    }

    /**
     * Gets order_download_global_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderDownloadGlobalErrorCount()
    {
        return $this->container['order_download_global_error_count'];
    }

    /**
     * Sets order_download_global_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_download_global_error_count order_download_global_error_count
     *
     * @return self
     */
    public function setOrderDownloadGlobalErrorCount($order_download_global_error_count)
    {
        if (is_null($order_download_global_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_download_global_error_count cannot be null');
        }
        $this->container['order_download_global_error_count'] = $order_download_global_error_count;

        return $this;
    }

    /**
     * Gets order_despatch_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderDespatchErrorCount()
    {
        return $this->container['order_despatch_error_count'];
    }

    /**
     * Sets order_despatch_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_despatch_error_count order_despatch_error_count
     *
     * @return self
     */
    public function setOrderDespatchErrorCount($order_despatch_error_count)
    {
        if (is_null($order_despatch_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_despatch_error_count cannot be null');
        }
        $this->container['order_despatch_error_count'] = $order_despatch_error_count;

        return $this;
    }

    /**
     * Gets order_despatch_global_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderDespatchGlobalErrorCount()
    {
        return $this->container['order_despatch_global_error_count'];
    }

    /**
     * Sets order_despatch_global_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_despatch_global_error_count order_despatch_global_error_count
     *
     * @return self
     */
    public function setOrderDespatchGlobalErrorCount($order_despatch_global_error_count)
    {
        if (is_null($order_despatch_global_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_despatch_global_error_count cannot be null');
        }
        $this->container['order_despatch_global_error_count'] = $order_despatch_global_error_count;

        return $this;
    }

    /**
     * Gets order_cancellation_check_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderCancellationCheckErrorCount()
    {
        return $this->container['order_cancellation_check_error_count'];
    }

    /**
     * Sets order_cancellation_check_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_cancellation_check_error_count order_cancellation_check_error_count
     *
     * @return self
     */
    public function setOrderCancellationCheckErrorCount($order_cancellation_check_error_count)
    {
        if (is_null($order_cancellation_check_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_cancellation_check_error_count cannot be null');
        }
        $this->container['order_cancellation_check_error_count'] = $order_cancellation_check_error_count;

        return $this;
    }

    /**
     * Gets order_cancellation_check_global_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getOrderCancellationCheckGlobalErrorCount()
    {
        return $this->container['order_cancellation_check_global_error_count'];
    }

    /**
     * Sets order_cancellation_check_global_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $order_cancellation_check_global_error_count order_cancellation_check_global_error_count
     *
     * @return self
     */
    public function setOrderCancellationCheckGlobalErrorCount($order_cancellation_check_global_error_count)
    {
        if (is_null($order_cancellation_check_global_error_count)) {
            throw new \InvalidArgumentException('non-nullable order_cancellation_check_global_error_count cannot be null');
        }
        $this->container['order_cancellation_check_global_error_count'] = $order_cancellation_check_global_error_count;

        return $this;
    }

    /**
     * Gets rma_download_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getRmaDownloadErrorCount()
    {
        return $this->container['rma_download_error_count'];
    }

    /**
     * Sets rma_download_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $rma_download_error_count rma_download_error_count
     *
     * @return self
     */
    public function setRmaDownloadErrorCount($rma_download_error_count)
    {
        if (is_null($rma_download_error_count)) {
            throw new \InvalidArgumentException('non-nullable rma_download_error_count cannot be null');
        }
        $this->container['rma_download_error_count'] = $rma_download_error_count;

        return $this;
    }

    /**
     * Gets rma_download_global_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getRmaDownloadGlobalErrorCount()
    {
        return $this->container['rma_download_global_error_count'];
    }

    /**
     * Sets rma_download_global_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $rma_download_global_error_count rma_download_global_error_count
     *
     * @return self
     */
    public function setRmaDownloadGlobalErrorCount($rma_download_global_error_count)
    {
        if (is_null($rma_download_global_error_count)) {
            throw new \InvalidArgumentException('non-nullable rma_download_global_error_count cannot be null');
        }
        $this->container['rma_download_global_error_count'] = $rma_download_global_error_count;

        return $this;
    }

    /**
     * Gets hides_header_attributes
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertyBoolean|null
     */
    public function getHidesHeaderAttributes()
    {
        return $this->container['hides_header_attributes'];
    }

    /**
     * Sets hides_header_attributes
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertyBoolean|null $hides_header_attributes hides_header_attributes
     *
     * @return self
     */
    public function setHidesHeaderAttributes($hides_header_attributes)
    {
        if (is_null($hides_header_attributes)) {
            throw new \InvalidArgumentException('non-nullable hides_header_attributes cannot be null');
        }
        $this->container['hides_header_attributes'] = $hides_header_attributes;

        return $this;
    }

    /**
     * Gets inventory_sync
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getInventorySync()
    {
        return $this->container['inventory_sync'];
    }

    /**
     * Sets inventory_sync
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $inventory_sync inventory_sync
     *
     * @return self
     */
    public function setInventorySync($inventory_sync)
    {
        if (is_null($inventory_sync)) {
            throw new \InvalidArgumentException('non-nullable inventory_sync cannot be null');
        }
        $this->container['inventory_sync'] = $inventory_sync;

        return $this;
    }

    /**
     * Gets stock_location_binding
     *
     * @return \Linnworks\Inventory\Model\ConfigStockLocationBinding|null
     */
    public function getStockLocationBinding()
    {
        return $this->container['stock_location_binding'];
    }

    /**
     * Sets stock_location_binding
     *
     * @param \Linnworks\Inventory\Model\ConfigStockLocationBinding|null $stock_location_binding stock_location_binding
     *
     * @return self
     */
    public function setStockLocationBinding($stock_location_binding)
    {
        if (is_null($stock_location_binding)) {
            throw new \InvalidArgumentException('non-nullable stock_location_binding cannot be null');
        }
        $this->container['stock_location_binding'] = $stock_location_binding;

        return $this;
    }

    /**
     * Gets max_listed
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getMaxListed()
    {
        return $this->container['max_listed'];
    }

    /**
     * Sets max_listed
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $max_listed max_listed
     *
     * @return self
     */
    public function setMaxListed($max_listed)
    {
        if (is_null($max_listed)) {
            throw new \InvalidArgumentException('non-nullable max_listed cannot be null');
        }
        $this->container['max_listed'] = $max_listed;

        return $this;
    }

    /**
     * Gets stock_percentage
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDouble|null
     */
    public function getStockPercentage()
    {
        return $this->container['stock_percentage'];
    }

    /**
     * Sets stock_percentage
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDouble|null $stock_percentage stock_percentage
     *
     * @return self
     */
    public function setStockPercentage($stock_percentage)
    {
        if (is_null($stock_percentage)) {
            throw new \InvalidArgumentException('non-nullable stock_percentage cannot be null');
        }
        $this->container['stock_percentage'] = $stock_percentage;

        return $this;
    }

    /**
     * Gets end_when
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getEndWhen()
    {
        return $this->container['end_when'];
    }

    /**
     * Sets end_when
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $end_when end_when
     *
     * @return self
     */
    public function setEndWhen($end_when)
    {
        if (is_null($end_when)) {
            throw new \InvalidArgumentException('non-nullable end_when cannot be null');
        }
        $this->container['end_when'] = $end_when;

        return $this;
    }

    /**
     * Gets inv_sync_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getInvSyncErrorCount()
    {
        return $this->container['inv_sync_error_count'];
    }

    /**
     * Sets inv_sync_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $inv_sync_error_count inv_sync_error_count
     *
     * @return self
     */
    public function setInvSyncErrorCount($inv_sync_error_count)
    {
        if (is_null($inv_sync_error_count)) {
            throw new \InvalidArgumentException('non-nullable inv_sync_error_count cannot be null');
        }
        $this->container['inv_sync_error_count'] = $inv_sync_error_count;

        return $this;
    }

    /**
     * Gets extract_inventory
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertyBoolean|null
     */
    public function getExtractInventory()
    {
        return $this->container['extract_inventory'];
    }

    /**
     * Sets extract_inventory
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertyBoolean|null $extract_inventory extract_inventory
     *
     * @return self
     */
    public function setExtractInventory($extract_inventory)
    {
        if (is_null($extract_inventory)) {
            throw new \InvalidArgumentException('non-nullable extract_inventory cannot be null');
        }
        $this->container['extract_inventory'] = $extract_inventory;

        return $this;
    }

    /**
     * Gets extract_inventory_variation_mapping_property_name
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertyString|null
     */
    public function getExtractInventoryVariationMappingPropertyName()
    {
        return $this->container['extract_inventory_variation_mapping_property_name'];
    }

    /**
     * Sets extract_inventory_variation_mapping_property_name
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertyString|null $extract_inventory_variation_mapping_property_name extract_inventory_variation_mapping_property_name
     *
     * @return self
     */
    public function setExtractInventoryVariationMappingPropertyName($extract_inventory_variation_mapping_property_name)
    {
        if (is_null($extract_inventory_variation_mapping_property_name)) {
            throw new \InvalidArgumentException('non-nullable extract_inventory_variation_mapping_property_name cannot be null');
        }
        $this->container['extract_inventory_variation_mapping_property_name'] = $extract_inventory_variation_mapping_property_name;

        return $this;
    }

    /**
     * Gets price_change
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getPriceChange()
    {
        return $this->container['price_change'];
    }

    /**
     * Sets price_change
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $price_change price_change
     *
     * @return self
     */
    public function setPriceChange($price_change)
    {
        if (is_null($price_change)) {
            throw new \InvalidArgumentException('non-nullable price_change cannot be null');
        }
        $this->container['price_change'] = $price_change;

        return $this;
    }

    /**
     * Gets price_change_error_count
     *
     * @return \Linnworks\Inventory\Model\ConfigItemInt32|null
     */
    public function getPriceChangeErrorCount()
    {
        return $this->container['price_change_error_count'];
    }

    /**
     * Sets price_change_error_count
     *
     * @param \Linnworks\Inventory\Model\ConfigItemInt32|null $price_change_error_count price_change_error_count
     *
     * @return self
     */
    public function setPriceChangeErrorCount($price_change_error_count)
    {
        if (is_null($price_change_error_count)) {
            throw new \InvalidArgumentException('non-nullable price_change_error_count cannot be null');
        }
        $this->container['price_change_error_count'] = $price_change_error_count;

        return $this;
    }

    /**
     * Gets is_inventory_sync_trigger_enabled
     *
     * @return \Linnworks\Inventory\Model\ConfigPropertyBoolean|null
     */
    public function getIsInventorySyncTriggerEnabled()
    {
        return $this->container['is_inventory_sync_trigger_enabled'];
    }

    /**
     * Sets is_inventory_sync_trigger_enabled
     *
     * @param \Linnworks\Inventory\Model\ConfigPropertyBoolean|null $is_inventory_sync_trigger_enabled is_inventory_sync_trigger_enabled
     *
     * @return self
     */
    public function setIsInventorySyncTriggerEnabled($is_inventory_sync_trigger_enabled)
    {
        if (is_null($is_inventory_sync_trigger_enabled)) {
            throw new \InvalidArgumentException('non-nullable is_inventory_sync_trigger_enabled cannot be null');
        }
        $this->container['is_inventory_sync_trigger_enabled'] = $is_inventory_sync_trigger_enabled;

        return $this;
    }

    /**
     * Gets is_listing_scan_running
     *
     * @return \Linnworks\Inventory\Model\ConfigItemBoolean|null
     */
    public function getIsListingScanRunning()
    {
        return $this->container['is_listing_scan_running'];
    }

    /**
     * Sets is_listing_scan_running
     *
     * @param \Linnworks\Inventory\Model\ConfigItemBoolean|null $is_listing_scan_running is_listing_scan_running
     *
     * @return self
     */
    public function setIsListingScanRunning($is_listing_scan_running)
    {
        if (is_null($is_listing_scan_running)) {
            throw new \InvalidArgumentException('non-nullable is_listing_scan_running cannot be null');
        }
        $this->container['is_listing_scan_running'] = $is_listing_scan_running;

        return $this;
    }

    /**
     * Gets listing_scan_start_update_date
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDateTime|null
     */
    public function getListingScanStartUpdateDate()
    {
        return $this->container['listing_scan_start_update_date'];
    }

    /**
     * Sets listing_scan_start_update_date
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDateTime|null $listing_scan_start_update_date listing_scan_start_update_date
     *
     * @return self
     */
    public function setListingScanStartUpdateDate($listing_scan_start_update_date)
    {
        if (is_null($listing_scan_start_update_date)) {
            throw new \InvalidArgumentException('non-nullable listing_scan_start_update_date cannot be null');
        }
        $this->container['listing_scan_start_update_date'] = $listing_scan_start_update_date;

        return $this;
    }

    /**
     * Gets last_listing_update_date
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDateTime|null
     */
    public function getLastListingUpdateDate()
    {
        return $this->container['last_listing_update_date'];
    }

    /**
     * Sets last_listing_update_date
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDateTime|null $last_listing_update_date last_listing_update_date
     *
     * @return self
     */
    public function setLastListingUpdateDate($last_listing_update_date)
    {
        if (is_null($last_listing_update_date)) {
            throw new \InvalidArgumentException('non-nullable last_listing_update_date cannot be null');
        }
        $this->container['last_listing_update_date'] = $last_listing_update_date;

        return $this;
    }

    /**
     * Gets estimated_inventory_scan_complete
     *
     * @return \Linnworks\Inventory\Model\ConfigItemDateTime|null
     */
    public function getEstimatedInventoryScanComplete()
    {
        return $this->container['estimated_inventory_scan_complete'];
    }

    /**
     * Sets estimated_inventory_scan_complete
     *
     * @param \Linnworks\Inventory\Model\ConfigItemDateTime|null $estimated_inventory_scan_complete estimated_inventory_scan_complete
     *
     * @return self
     */
    public function setEstimatedInventoryScanComplete($estimated_inventory_scan_complete)
    {
        if (is_null($estimated_inventory_scan_complete)) {
            throw new \InvalidArgumentException('non-nullable estimated_inventory_scan_complete cannot be null');
        }
        $this->container['estimated_inventory_scan_complete'] = $estimated_inventory_scan_complete;

        return $this;
    }

    /**
     * Gets is_header_only
     *
     * @return bool|null
     */
    public function getIsHeaderOnly()
    {
        return $this->container['is_header_only'];
    }

    /**
     * Sets is_header_only
     *
     * @param bool|null $is_header_only is_header_only
     *
     * @return self
     */
    public function setIsHeaderOnly($is_header_only)
    {
        if (is_null($is_header_only)) {
            throw new \InvalidArgumentException('non-nullable is_header_only cannot be null');
        }
        $this->container['is_header_only'] = $is_header_only;

        return $this;
    }

    /**
     * Gets is_hidden
     *
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->container['is_hidden'];
    }

    /**
     * Sets is_hidden
     *
     * @param bool|null $is_hidden is_hidden
     *
     * @return self
     */
    public function setIsHidden($is_hidden)
    {
        if (is_null($is_hidden)) {
            throw new \InvalidArgumentException('non-nullable is_hidden cannot be null');
        }
        $this->container['is_hidden'] = $is_hidden;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name display_name
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        if (is_null($display_name)) {
            throw new \InvalidArgumentException('non-nullable display_name cannot be null');
        }
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets dynamic_properties
     *
     * @return \Linnworks\Inventory\Model\ConfigItemExternal[]|null
     */
    public function getDynamicProperties()
    {
        return $this->container['dynamic_properties'];
    }

    /**
     * Sets dynamic_properties
     *
     * @param \Linnworks\Inventory\Model\ConfigItemExternal[]|null $dynamic_properties dynamic_properties
     *
     * @return self
     */
    public function setDynamicProperties($dynamic_properties)
    {
        if (is_null($dynamic_properties)) {
            throw new \InvalidArgumentException('non-nullable dynamic_properties cannot be null');
        }
        $this->container['dynamic_properties'] = $dynamic_properties;

        return $this;
    }

    /**
     * Gets config_discount_typed
     *
     * @return string|null
     */
    public function getConfigDiscountTyped()
    {
        return $this->container['config_discount_typed'];
    }

    /**
     * Sets config_discount_typed
     *
     * @param string|null $config_discount_typed config_discount_typed
     *
     * @return self
     */
    public function setConfigDiscountTyped($config_discount_typed)
    {
        if (is_null($config_discount_typed)) {
            throw new \InvalidArgumentException('non-nullable config_discount_typed cannot be null');
        }
        $allowedValues = $this->getConfigDiscountTypedAllowableValues();
        if (!in_array($config_discount_typed, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'config_discount_typed', must be one of '%s'",
                    $config_discount_typed,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['config_discount_typed'] = $config_discount_typed;

        return $this;
    }

    /**
     * Gets postal_service_mapping
     *
     * @return \Linnworks\Inventory\Model\ConfigPostalServiceMapping|null
     */
    public function getPostalServiceMapping()
    {
        return $this->container['postal_service_mapping'];
    }

    /**
     * Sets postal_service_mapping
     *
     * @param \Linnworks\Inventory\Model\ConfigPostalServiceMapping|null $postal_service_mapping postal_service_mapping
     *
     * @return self
     */
    public function setPostalServiceMapping($postal_service_mapping)
    {
        if (is_null($postal_service_mapping)) {
            throw new \InvalidArgumentException('non-nullable postal_service_mapping cannot be null');
        }
        $this->container['postal_service_mapping'] = $postal_service_mapping;

        return $this;
    }

    /**
     * Gets payment_method_mapping
     *
     * @return \Linnworks\Inventory\Model\ConfigPaymentMethodMapping|null
     */
    public function getPaymentMethodMapping()
    {
        return $this->container['payment_method_mapping'];
    }

    /**
     * Sets payment_method_mapping
     *
     * @param \Linnworks\Inventory\Model\ConfigPaymentMethodMapping|null $payment_method_mapping payment_method_mapping
     *
     * @return self
     */
    public function setPaymentMethodMapping($payment_method_mapping)
    {
        if (is_null($payment_method_mapping)) {
            throw new \InvalidArgumentException('non-nullable payment_method_mapping cannot be null');
        }
        $this->container['payment_method_mapping'] = $payment_method_mapping;

        return $this;
    }

    /**
     * Gets pk_channel_id
     *
     * @return int|null
     */
    public function getPkChannelId()
    {
        return $this->container['pk_channel_id'];
    }

    /**
     * Sets pk_channel_id
     *
     * @param int|null $pk_channel_id pk_channel_id
     *
     * @return self
     */
    public function setPkChannelId($pk_channel_id)
    {
        if (is_null($pk_channel_id)) {
            throw new \InvalidArgumentException('non-nullable pk_channel_id cannot be null');
        }
        $this->container['pk_channel_id'] = $pk_channel_id;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source source
     *
     * @return self
     */
    public function setSource($source)
    {
        if (is_null($source)) {
            throw new \InvalidArgumentException('non-nullable source cannot be null');
        }
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets source_type
     *
     * @return string|null
     */
    public function getSourceType()
    {
        return $this->container['source_type'];
    }

    /**
     * Sets source_type
     *
     * @param string|null $source_type source_type
     *
     * @return self
     */
    public function setSourceType($source_type)
    {
        if (is_null($source_type)) {
            throw new \InvalidArgumentException('non-nullable source_type cannot be null');
        }
        $this->container['source_type'] = $source_type;

        return $this;
    }

    /**
     * Gets fulfillment_service_enabled
     *
     * @return bool|null
     */
    public function getFulfillmentServiceEnabled()
    {
        return $this->container['fulfillment_service_enabled'];
    }

    /**
     * Sets fulfillment_service_enabled
     *
     * @param bool|null $fulfillment_service_enabled fulfillment_service_enabled
     *
     * @return self
     */
    public function setFulfillmentServiceEnabled($fulfillment_service_enabled)
    {
        if (is_null($fulfillment_service_enabled)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_service_enabled cannot be null');
        }
        $this->container['fulfillment_service_enabled'] = $fulfillment_service_enabled;

        return $this;
    }

    /**
     * Gets fulfillment_location
     *
     * @return string|null
     */
    public function getFulfillmentLocation()
    {
        return $this->container['fulfillment_location'];
    }

    /**
     * Sets fulfillment_location
     *
     * @param string|null $fulfillment_location fulfillment_location
     *
     * @return self
     */
    public function setFulfillmentLocation($fulfillment_location)
    {
        if (is_null($fulfillment_location)) {
            throw new \InvalidArgumentException('non-nullable fulfillment_location cannot be null');
        }
        $this->container['fulfillment_location'] = $fulfillment_location;

        return $this;
    }

    /**
     * Gets concurrency_key
     *
     * @return string|null
     */
    public function getConcurrencyKey()
    {
        return $this->container['concurrency_key'];
    }

    /**
     * Sets concurrency_key
     *
     * @param string|null $concurrency_key concurrency_key
     *
     * @return self
     */
    public function setConcurrencyKey($concurrency_key)
    {
        if (is_null($concurrency_key)) {
            throw new \InvalidArgumentException('non-nullable concurrency_key cannot be null');
        }
        $this->container['concurrency_key'] = $concurrency_key;

        return $this;
    }

    /**
     * Gets rules
     *
     * @return \Linnworks\Inventory\Model\ConfigRule[]|null
     */
    public function getRules()
    {
        return $this->container['rules'];
    }

    /**
     * Sets rules
     *
     * @param \Linnworks\Inventory\Model\ConfigRule[]|null $rules rules
     *
     * @return self
     */
    public function setRules($rules)
    {
        if (is_null($rules)) {
            throw new \InvalidArgumentException('non-nullable rules cannot be null');
        }
        $this->container['rules'] = $rules;

        return $this;
    }

    /**
     * Gets buttons
     *
     * @return \Linnworks\Inventory\Model\ConfigButton[]|null
     */
    public function getButtons()
    {
        return $this->container['buttons'];
    }

    /**
     * Sets buttons
     *
     * @param \Linnworks\Inventory\Model\ConfigButton[]|null $buttons buttons
     *
     * @return self
     */
    public function setButtons($buttons)
    {
        if (is_null($buttons)) {
            throw new \InvalidArgumentException('non-nullable buttons cannot be null');
        }
        $this->container['buttons'] = $buttons;

        return $this;
    }

    /**
     * Gets sub_source
     *
     * @return string|null
     */
    public function getSubSource()
    {
        return $this->container['sub_source'];
    }

    /**
     * Sets sub_source
     *
     * @param string|null $sub_source sub_source
     *
     * @return self
     */
    public function setSubSource($sub_source)
    {
        if (is_null($sub_source)) {
            throw new \InvalidArgumentException('non-nullable sub_source cannot be null');
        }
        $this->container['sub_source'] = $sub_source;

        return $this;
    }

    /**
     * Gets header_audit_values
     *
     * @return \Linnworks\Inventory\Model\ChannelSettingAudit[]|null
     */
    public function getHeaderAuditValues()
    {
        return $this->container['header_audit_values'];
    }

    /**
     * Sets header_audit_values
     *
     * @param \Linnworks\Inventory\Model\ChannelSettingAudit[]|null $header_audit_values header_audit_values
     *
     * @return self
     */
    public function setHeaderAuditValues($header_audit_values)
    {
        if (is_null($header_audit_values)) {
            throw new \InvalidArgumentException('non-nullable header_audit_values cannot be null');
        }
        $this->container['header_audit_values'] = $header_audit_values;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


