<?php
/**
 * GetImagesInBulkResponseImage
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * GetImagesInBulkResponseImage Class Doc Comment
 *
 * @category Class
 * @description Image response item.
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class GetImagesInBulkResponseImage implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'GetImagesInBulkResponseImage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'sku' => 'string',
        'is_main' => 'bool',
        'pk_row_id' => 'string',
        'checksum_value' => 'string',
        'raw_checksum' => 'string',
        'sort_order' => 'int',
        'stock_item_id' => 'string',
        'full_source' => 'string',
        'full_source_thumbnail' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'sku' => null,
        'is_main' => null,
        'pk_row_id' => 'uuid',
        'checksum_value' => null,
        'raw_checksum' => null,
        'sort_order' => 'int32',
        'stock_item_id' => 'uuid',
        'full_source' => null,
        'full_source_thumbnail' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'sku' => false,
        'is_main' => false,
        'pk_row_id' => false,
        'checksum_value' => false,
        'raw_checksum' => false,
        'sort_order' => false,
        'stock_item_id' => false,
        'full_source' => false,
        'full_source_thumbnail' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'sku' => 'SKU',
        'is_main' => 'IsMain',
        'pk_row_id' => 'pkRowId',
        'checksum_value' => 'ChecksumValue',
        'raw_checksum' => 'RawChecksum',
        'sort_order' => 'SortOrder',
        'stock_item_id' => 'StockItemId',
        'full_source' => 'FullSource',
        'full_source_thumbnail' => 'FullSourceThumbnail'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'sku' => 'setSku',
        'is_main' => 'setIsMain',
        'pk_row_id' => 'setPkRowId',
        'checksum_value' => 'setChecksumValue',
        'raw_checksum' => 'setRawChecksum',
        'sort_order' => 'setSortOrder',
        'stock_item_id' => 'setStockItemId',
        'full_source' => 'setFullSource',
        'full_source_thumbnail' => 'setFullSourceThumbnail'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'sku' => 'getSku',
        'is_main' => 'getIsMain',
        'pk_row_id' => 'getPkRowId',
        'checksum_value' => 'getChecksumValue',
        'raw_checksum' => 'getRawChecksum',
        'sort_order' => 'getSortOrder',
        'stock_item_id' => 'getStockItemId',
        'full_source' => 'getFullSource',
        'full_source_thumbnail' => 'getFullSourceThumbnail'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('sku', $data ?? [], null);
        $this->setIfExists('is_main', $data ?? [], null);
        $this->setIfExists('pk_row_id', $data ?? [], null);
        $this->setIfExists('checksum_value', $data ?? [], null);
        $this->setIfExists('raw_checksum', $data ?? [], null);
        $this->setIfExists('sort_order', $data ?? [], null);
        $this->setIfExists('stock_item_id', $data ?? [], null);
        $this->setIfExists('full_source', $data ?? [], null);
        $this->setIfExists('full_source_thumbnail', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku SKU
     *
     * @return self
     */
    public function setSku($sku)
    {
        if (is_null($sku)) {
            throw new \InvalidArgumentException('non-nullable sku cannot be null');
        }
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets is_main
     *
     * @return bool|null
     */
    public function getIsMain()
    {
        return $this->container['is_main'];
    }

    /**
     * Sets is_main
     *
     * @param bool|null $is_main Is main image
     *
     * @return self
     */
    public function setIsMain($is_main)
    {
        if (is_null($is_main)) {
            throw new \InvalidArgumentException('non-nullable is_main cannot be null');
        }
        $this->container['is_main'] = $is_main;

        return $this;
    }

    /**
     * Gets pk_row_id
     *
     * @return string|null
     */
    public function getPkRowId()
    {
        return $this->container['pk_row_id'];
    }

    /**
     * Sets pk_row_id
     *
     * @param string|null $pk_row_id Image row id
     *
     * @return self
     */
    public function setPkRowId($pk_row_id)
    {
        if (is_null($pk_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_row_id cannot be null');
        }
        $this->container['pk_row_id'] = $pk_row_id;

        return $this;
    }

    /**
     * Gets checksum_value
     *
     * @return string|null
     */
    public function getChecksumValue()
    {
        return $this->container['checksum_value'];
    }

    /**
     * Sets checksum_value
     *
     * @param string|null $checksum_value Checksum
     *
     * @return self
     */
    public function setChecksumValue($checksum_value)
    {
        if (is_null($checksum_value)) {
            throw new \InvalidArgumentException('non-nullable checksum_value cannot be null');
        }
        $this->container['checksum_value'] = $checksum_value;

        return $this;
    }

    /**
     * Gets raw_checksum
     *
     * @return string|null
     */
    public function getRawChecksum()
    {
        return $this->container['raw_checksum'];
    }

    /**
     * Sets raw_checksum
     *
     * @param string|null $raw_checksum Raw file checksum (original and unaltered)
     *
     * @return self
     */
    public function setRawChecksum($raw_checksum)
    {
        if (is_null($raw_checksum)) {
            throw new \InvalidArgumentException('non-nullable raw_checksum cannot be null');
        }
        $this->container['raw_checksum'] = $raw_checksum;

        return $this;
    }

    /**
     * Gets sort_order
     *
     * @return int|null
     */
    public function getSortOrder()
    {
        return $this->container['sort_order'];
    }

    /**
     * Sets sort_order
     *
     * @param int|null $sort_order Sort order
     *
     * @return self
     */
    public function setSortOrder($sort_order)
    {
        if (is_null($sort_order)) {
            throw new \InvalidArgumentException('non-nullable sort_order cannot be null');
        }
        $this->container['sort_order'] = $sort_order;

        return $this;
    }

    /**
     * Gets stock_item_id
     *
     * @return string|null
     */
    public function getStockItemId()
    {
        return $this->container['stock_item_id'];
    }

    /**
     * Sets stock_item_id
     *
     * @param string|null $stock_item_id Stockitem id
     *
     * @return self
     */
    public function setStockItemId($stock_item_id)
    {
        if (is_null($stock_item_id)) {
            throw new \InvalidArgumentException('non-nullable stock_item_id cannot be null');
        }
        $this->container['stock_item_id'] = $stock_item_id;

        return $this;
    }

    /**
     * Gets full_source
     *
     * @return string|null
     */
    public function getFullSource()
    {
        return $this->container['full_source'];
    }

    /**
     * Sets full_source
     *
     * @param string|null $full_source Full image path
     *
     * @return self
     */
    public function setFullSource($full_source)
    {
        if (is_null($full_source)) {
            throw new \InvalidArgumentException('non-nullable full_source cannot be null');
        }
        $this->container['full_source'] = $full_source;

        return $this;
    }

    /**
     * Gets full_source_thumbnail
     *
     * @return string|null
     */
    public function getFullSourceThumbnail()
    {
        return $this->container['full_source_thumbnail'];
    }

    /**
     * Sets full_source_thumbnail
     *
     * @param string|null $full_source_thumbnail Thumbnail image path
     *
     * @return self
     */
    public function setFullSourceThumbnail($full_source_thumbnail)
    {
        if (is_null($full_source_thumbnail)) {
            throw new \InvalidArgumentException('non-nullable full_source_thumbnail cannot be null');
        }
        $this->container['full_source_thumbnail'] = $full_source_thumbnail;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


