<?php
/**
 * Filter
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * Filter Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Filter implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Filter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'filter_name' => 'string',
        'display_name' => 'string',
        'filter_name_exact' => 'string[]',
        'field' => 'string',
        'condition' => 'string',
        'condition_display_name' => 'string',
        'value' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'filter_name' => null,
        'display_name' => null,
        'filter_name_exact' => null,
        'field' => null,
        'condition' => null,
        'condition_display_name' => null,
        'value' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'filter_name' => false,
        'display_name' => false,
        'filter_name_exact' => false,
        'field' => false,
        'condition' => false,
        'condition_display_name' => false,
        'value' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'filter_name' => 'FilterName',
        'display_name' => 'DisplayName',
        'filter_name_exact' => 'FilterNameExact',
        'field' => 'Field',
        'condition' => 'Condition',
        'condition_display_name' => 'ConditionDisplayName',
        'value' => 'Value'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'filter_name' => 'setFilterName',
        'display_name' => 'setDisplayName',
        'filter_name_exact' => 'setFilterNameExact',
        'field' => 'setField',
        'condition' => 'setCondition',
        'condition_display_name' => 'setConditionDisplayName',
        'value' => 'setValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'filter_name' => 'getFilterName',
        'display_name' => 'getDisplayName',
        'filter_name_exact' => 'getFilterNameExact',
        'field' => 'getField',
        'condition' => 'getCondition',
        'condition_display_name' => 'getConditionDisplayName',
        'value' => 'getValue'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const FILTER_NAME_GENERAL = 'General';
    public const FILTER_NAME_SKU = 'SKU';
    public const FILTER_NAME_TITLE = 'Title';
    public const FILTER_NAME_RETAIL_PRICE = 'RetailPrice';
    public const FILTER_NAME_PURCHASE_PRICE = 'PurchasePrice';
    public const FILTER_NAME_TRACKED = 'Tracked';
    public const FILTER_NAME_BARCODE = 'Barcode';
    public const FILTER_NAME_VARIATION_GROUP_NAME = 'VariationGroupName';
    public const FILTER_NAME_AVAILABLE = 'Available';
    public const FILTER_NAME_MINIMUM_LEVEL = 'MinimumLevel';
    public const FILTER_NAME_IN_ORDER = 'InOrder';
    public const FILTER_NAME_STOCK_LEVEL = 'StockLevel';
    public const FILTER_NAME_STOCK_VALUE = 'StockValue';
    public const FILTER_NAME_DUE = 'Due';
    public const FILTER_NAME_BIN_RACK = 'BinRack';
    public const FILTER_NAME_CATEGORY = 'Category';
    public const FILTER_NAME_CHANNEL_SKU = 'ChannelSKU';
    public const FILTER_NAME_SUPPLIER_CODE = 'SupplierCode';
    public const FILTER_NAME_E_BAY_ID = 'eBayId';
    public const FILTER_NAME_AMAZON_ASIN = 'AmazonASIN';
    public const FILTER_NAME_IMAGE = 'Image';
    public const FILTER_NAME_EXTENDED_PROPERTY = 'ExtendedProperty';
    public const FILTER_NAME_EXTENDED_PROPERTY_NAME = 'ExtendedPropertyName';
    public const FILTER_NAME_CHANNEL = 'Channel';
    public const FILTER_NAME_CREATED_DATE = 'CreatedDate';
    public const FILTER_NAME_MODIFIED_DATE = 'ModifiedDate';
    public const FILTER_NAME_SERIAL_NUMBER_SCAN_REQUIRED = 'SerialNumberScanRequired';
    public const FILTER_NAME_BATCH_NUMBER_SCAN_REQUIRED = 'BatchNumberScanRequired';
    public const FILTER_NAME_BATCH_TYPE = 'BatchType';
    public const FILTER_NAME_BATCH_NUMBER = 'BatchNumber';
    public const FILTER_NAME_WEIGHT = 'Weight';
    public const FILTER_NAME_DIM_HEIGHT = 'DimHeight';
    public const FILTER_NAME_DIM_WIDTH = 'DimWidth';
    public const FILTER_NAME_DIM_DEPTH = 'DimDepth';
    public const FILTER_NAME_JIT = 'JIT';
    public const FILTER_NAME_REORDER_AMOUNT = 'ReorderAmount';
    public const FILTER_NAME_REORDER_DATE = 'ReorderDate';
    public const FILTER_NAME_AVERAGE_CONSUMPTION = 'AverageConsumption';
    public const FILTER_NAME_DEFAULT_SUPPLIER = 'DefaultSupplier';
    public const FILTER_NAME_GENERAL_WITH_SEPARATING_WORDS = 'GeneralWithSeparatingWords';
    public const FIELD_INT = 'Int';
    public const FIELD_DOUBLE = 'Double';
    public const FIELD_STRING = 'String';
    public const FIELD_BOOLEAN = 'Boolean';
    public const FIELD_SELECT = 'Select';
    public const FIELD_DATE = 'Date';
    public const FIELD_CHANNEL = 'Channel';
    public const FIELD_OTHER = 'Other';
    public const FIELD_DATETIME2 = 'Datetime2';
    public const FIELD_CALCULATED = 'Calculated';
    public const CONDITION_EQUALS = 'Equals';
    public const CONDITION_CONTAINS = 'Contains';
    public const CONDITION_LESS = 'Less';
    public const CONDITION_GREATER = 'Greater';
    public const CONDITION_NOT_EQUALS = 'NotEquals';
    public const CONDITION_NOT_CONTAINS = 'NotContains';
    public const CONDITION_EXISTS = 'Exists';
    public const CONDITION_LISTED = 'Listed';
    public const CONDITION_NOT_LISTED = 'NotListed';
    public const CONDITION_HAS_ERROR = 'HasError';
    public const CONDITION_ONLY_ERRORS = 'OnlyErrors';
    public const CONDITION_NO_ERRORS = 'NoErrors';
    public const CONDITION_HAS_WARNING = 'HasWarning';
    public const CONDITION_LAST_DAYS = 'LastDays';
    public const CONDITION_OLDER_THAN = 'OlderThan';
    public const CONDITION_NEXT = 'Next';
    public const CONDITION_IS = 'Is';
    public const CONDITION_IN_THE_FEED = 'InTheFeed';
    public const CONDITION_NOT_IN_THE_FEED = 'NotInTheFeed';
    public const CONDITION_CREATING = 'Creating';
    public const CONDITION_UPDATING = 'Updating';
    public const CONDITION_DELETING = 'Deleting';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFilterNameAllowableValues()
    {
        return [
            self::FILTER_NAME_GENERAL,
            self::FILTER_NAME_SKU,
            self::FILTER_NAME_TITLE,
            self::FILTER_NAME_RETAIL_PRICE,
            self::FILTER_NAME_PURCHASE_PRICE,
            self::FILTER_NAME_TRACKED,
            self::FILTER_NAME_BARCODE,
            self::FILTER_NAME_VARIATION_GROUP_NAME,
            self::FILTER_NAME_AVAILABLE,
            self::FILTER_NAME_MINIMUM_LEVEL,
            self::FILTER_NAME_IN_ORDER,
            self::FILTER_NAME_STOCK_LEVEL,
            self::FILTER_NAME_STOCK_VALUE,
            self::FILTER_NAME_DUE,
            self::FILTER_NAME_BIN_RACK,
            self::FILTER_NAME_CATEGORY,
            self::FILTER_NAME_CHANNEL_SKU,
            self::FILTER_NAME_SUPPLIER_CODE,
            self::FILTER_NAME_E_BAY_ID,
            self::FILTER_NAME_AMAZON_ASIN,
            self::FILTER_NAME_IMAGE,
            self::FILTER_NAME_EXTENDED_PROPERTY,
            self::FILTER_NAME_EXTENDED_PROPERTY_NAME,
            self::FILTER_NAME_CHANNEL,
            self::FILTER_NAME_CREATED_DATE,
            self::FILTER_NAME_MODIFIED_DATE,
            self::FILTER_NAME_SERIAL_NUMBER_SCAN_REQUIRED,
            self::FILTER_NAME_BATCH_NUMBER_SCAN_REQUIRED,
            self::FILTER_NAME_BATCH_TYPE,
            self::FILTER_NAME_BATCH_NUMBER,
            self::FILTER_NAME_WEIGHT,
            self::FILTER_NAME_DIM_HEIGHT,
            self::FILTER_NAME_DIM_WIDTH,
            self::FILTER_NAME_DIM_DEPTH,
            self::FILTER_NAME_JIT,
            self::FILTER_NAME_REORDER_AMOUNT,
            self::FILTER_NAME_REORDER_DATE,
            self::FILTER_NAME_AVERAGE_CONSUMPTION,
            self::FILTER_NAME_DEFAULT_SUPPLIER,
            self::FILTER_NAME_GENERAL_WITH_SEPARATING_WORDS,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldAllowableValues()
    {
        return [
            self::FIELD_INT,
            self::FIELD_DOUBLE,
            self::FIELD_STRING,
            self::FIELD_BOOLEAN,
            self::FIELD_SELECT,
            self::FIELD_DATE,
            self::FIELD_CHANNEL,
            self::FIELD_OTHER,
            self::FIELD_DATETIME2,
            self::FIELD_CALCULATED,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getConditionAllowableValues()
    {
        return [
            self::CONDITION_EQUALS,
            self::CONDITION_CONTAINS,
            self::CONDITION_LESS,
            self::CONDITION_GREATER,
            self::CONDITION_NOT_EQUALS,
            self::CONDITION_NOT_CONTAINS,
            self::CONDITION_EXISTS,
            self::CONDITION_LISTED,
            self::CONDITION_NOT_LISTED,
            self::CONDITION_HAS_ERROR,
            self::CONDITION_ONLY_ERRORS,
            self::CONDITION_NO_ERRORS,
            self::CONDITION_HAS_WARNING,
            self::CONDITION_LAST_DAYS,
            self::CONDITION_OLDER_THAN,
            self::CONDITION_NEXT,
            self::CONDITION_IS,
            self::CONDITION_IN_THE_FEED,
            self::CONDITION_NOT_IN_THE_FEED,
            self::CONDITION_CREATING,
            self::CONDITION_UPDATING,
            self::CONDITION_DELETING,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('filter_name', $data ?? [], null);
        $this->setIfExists('display_name', $data ?? [], null);
        $this->setIfExists('filter_name_exact', $data ?? [], null);
        $this->setIfExists('field', $data ?? [], null);
        $this->setIfExists('condition', $data ?? [], null);
        $this->setIfExists('condition_display_name', $data ?? [], null);
        $this->setIfExists('value', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getFilterNameAllowableValues();
        if (!is_null($this->container['filter_name']) && !in_array($this->container['filter_name'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'filter_name', must be one of '%s'",
                $this->container['filter_name'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFieldAllowableValues();
        if (!is_null($this->container['field']) && !in_array($this->container['field'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field', must be one of '%s'",
                $this->container['field'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getConditionAllowableValues();
        if (!is_null($this->container['condition']) && !in_array($this->container['condition'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'condition', must be one of '%s'",
                $this->container['condition'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets filter_name
     *
     * @return string|null
     */
    public function getFilterName()
    {
        return $this->container['filter_name'];
    }

    /**
     * Sets filter_name
     *
     * @param string|null $filter_name Type of the filter
     *
     * @return self
     */
    public function setFilterName($filter_name)
    {
        if (is_null($filter_name)) {
            throw new \InvalidArgumentException('non-nullable filter_name cannot be null');
        }
        $allowedValues = $this->getFilterNameAllowableValues();
        if (!in_array($filter_name, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'filter_name', must be one of '%s'",
                    $filter_name,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['filter_name'] = $filter_name;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name Display name
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        if (is_null($display_name)) {
            throw new \InvalidArgumentException('non-nullable display_name cannot be null');
        }
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets filter_name_exact
     *
     * @return string[]|null
     */
    public function getFilterNameExact()
    {
        return $this->container['filter_name_exact'];
    }

    /**
     * Sets filter_name_exact
     *
     * @param string[]|null $filter_name_exact Filter name
     *
     * @return self
     */
    public function setFilterNameExact($filter_name_exact)
    {
        if (is_null($filter_name_exact)) {
            throw new \InvalidArgumentException('non-nullable filter_name_exact cannot be null');
        }
        $this->container['filter_name_exact'] = $filter_name_exact;

        return $this;
    }

    /**
     * Gets field
     *
     * @return string|null
     */
    public function getField()
    {
        return $this->container['field'];
    }

    /**
     * Sets field
     *
     * @param string|null $field Type of filter field
     *
     * @return self
     */
    public function setField($field)
    {
        if (is_null($field)) {
            throw new \InvalidArgumentException('non-nullable field cannot be null');
        }
        $allowedValues = $this->getFieldAllowableValues();
        if (!in_array($field, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field', must be one of '%s'",
                    $field,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field'] = $field;

        return $this;
    }

    /**
     * Gets condition
     *
     * @return string|null
     */
    public function getCondition()
    {
        return $this->container['condition'];
    }

    /**
     * Sets condition
     *
     * @param string|null $condition Condition type
     *
     * @return self
     */
    public function setCondition($condition)
    {
        if (is_null($condition)) {
            throw new \InvalidArgumentException('non-nullable condition cannot be null');
        }
        $allowedValues = $this->getConditionAllowableValues();
        if (!in_array($condition, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'condition', must be one of '%s'",
                    $condition,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['condition'] = $condition;

        return $this;
    }

    /**
     * Gets condition_display_name
     *
     * @return string|null
     */
    public function getConditionDisplayName()
    {
        return $this->container['condition_display_name'];
    }

    /**
     * Sets condition_display_name
     *
     * @param string|null $condition_display_name Condition display name
     *
     * @return self
     */
    public function setConditionDisplayName($condition_display_name)
    {
        if (is_null($condition_display_name)) {
            throw new \InvalidArgumentException('non-nullable condition_display_name cannot be null');
        }
        $this->container['condition_display_name'] = $condition_display_name;

        return $this;
    }

    /**
     * Gets value
     *
     * @return string|null
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param string|null $value Filter value
     *
     * @return self
     */
    public function setValue($value)
    {
        if (is_null($value)) {
            throw new \InvalidArgumentException('non-nullable value cannot be null');
        }
        $this->container['value'] = $value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


