<?php
/**
 * CountryRegion
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * CountryRegion Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CountryRegion implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'CountryRegion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'pk_region_row_id' => 'int',
        'region_code' => 'string',
        'region_name' => 'string',
        'tax_rate' => 'float',
        'fk_country_id' => 'string',
        'replace_with' => 'string',
        'is_home_region' => 'bool',
        'tags_count' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'pk_region_row_id' => 'int32',
        'region_code' => null,
        'region_name' => null,
        'tax_rate' => 'double',
        'fk_country_id' => 'uuid',
        'replace_with' => null,
        'is_home_region' => null,
        'tags_count' => 'int32'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'pk_region_row_id' => false,
        'region_code' => false,
        'region_name' => false,
        'tax_rate' => false,
        'fk_country_id' => false,
        'replace_with' => false,
        'is_home_region' => false,
        'tags_count' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'pk_region_row_id' => 'pkRegionRowId',
        'region_code' => 'RegionCode',
        'region_name' => 'RegionName',
        'tax_rate' => 'TaxRate',
        'fk_country_id' => 'fkCountryId',
        'replace_with' => 'ReplaceWith',
        'is_home_region' => 'IsHomeRegion',
        'tags_count' => 'TagsCount'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'pk_region_row_id' => 'setPkRegionRowId',
        'region_code' => 'setRegionCode',
        'region_name' => 'setRegionName',
        'tax_rate' => 'setTaxRate',
        'fk_country_id' => 'setFkCountryId',
        'replace_with' => 'setReplaceWith',
        'is_home_region' => 'setIsHomeRegion',
        'tags_count' => 'setTagsCount'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'pk_region_row_id' => 'getPkRegionRowId',
        'region_code' => 'getRegionCode',
        'region_name' => 'getRegionName',
        'tax_rate' => 'getTaxRate',
        'fk_country_id' => 'getFkCountryId',
        'replace_with' => 'getReplaceWith',
        'is_home_region' => 'getIsHomeRegion',
        'tags_count' => 'getTagsCount'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const REPLACE_WITH_NONE = 'None';
    public const REPLACE_WITH_NAME = 'Name';
    public const REPLACE_WITH_CODE = 'Code';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getReplaceWithAllowableValues()
    {
        return [
            self::REPLACE_WITH_NONE,
            self::REPLACE_WITH_NAME,
            self::REPLACE_WITH_CODE,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('pk_region_row_id', $data ?? [], null);
        $this->setIfExists('region_code', $data ?? [], null);
        $this->setIfExists('region_name', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('fk_country_id', $data ?? [], null);
        $this->setIfExists('replace_with', $data ?? [], null);
        $this->setIfExists('is_home_region', $data ?? [], null);
        $this->setIfExists('tags_count', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getReplaceWithAllowableValues();
        if (!is_null($this->container['replace_with']) && !in_array($this->container['replace_with'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'replace_with', must be one of '%s'",
                $this->container['replace_with'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets pk_region_row_id
     *
     * @return int|null
     */
    public function getPkRegionRowId()
    {
        return $this->container['pk_region_row_id'];
    }

    /**
     * Sets pk_region_row_id
     *
     * @param int|null $pk_region_row_id Region row ID
     *
     * @return self
     */
    public function setPkRegionRowId($pk_region_row_id)
    {
        if (is_null($pk_region_row_id)) {
            throw new \InvalidArgumentException('non-nullable pk_region_row_id cannot be null');
        }
        $this->container['pk_region_row_id'] = $pk_region_row_id;

        return $this;
    }

    /**
     * Gets region_code
     *
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->container['region_code'];
    }

    /**
     * Sets region_code
     *
     * @param string|null $region_code Region code
     *
     * @return self
     */
    public function setRegionCode($region_code)
    {
        if (is_null($region_code)) {
            throw new \InvalidArgumentException('non-nullable region_code cannot be null');
        }
        $this->container['region_code'] = $region_code;

        return $this;
    }

    /**
     * Gets region_name
     *
     * @return string|null
     */
    public function getRegionName()
    {
        return $this->container['region_name'];
    }

    /**
     * Sets region_name
     *
     * @param string|null $region_name Region name
     *
     * @return self
     */
    public function setRegionName($region_name)
    {
        if (is_null($region_name)) {
            throw new \InvalidArgumentException('non-nullable region_name cannot be null');
        }
        $this->container['region_name'] = $region_name;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Tax rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets fk_country_id
     *
     * @return string|null
     */
    public function getFkCountryId()
    {
        return $this->container['fk_country_id'];
    }

    /**
     * Sets fk_country_id
     *
     * @param string|null $fk_country_id Country ID
     *
     * @return self
     */
    public function setFkCountryId($fk_country_id)
    {
        if (is_null($fk_country_id)) {
            throw new \InvalidArgumentException('non-nullable fk_country_id cannot be null');
        }
        $this->container['fk_country_id'] = $fk_country_id;

        return $this;
    }

    /**
     * Gets replace_with
     *
     * @return string|null
     */
    public function getReplaceWith()
    {
        return $this->container['replace_with'];
    }

    /**
     * Sets replace_with
     *
     * @param string|null $replace_with replace_with
     *
     * @return self
     */
    public function setReplaceWith($replace_with)
    {
        if (is_null($replace_with)) {
            throw new \InvalidArgumentException('non-nullable replace_with cannot be null');
        }
        $allowedValues = $this->getReplaceWithAllowableValues();
        if (!in_array($replace_with, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'replace_with', must be one of '%s'",
                    $replace_with,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['replace_with'] = $replace_with;

        return $this;
    }

    /**
     * Gets is_home_region
     *
     * @return bool|null
     */
    public function getIsHomeRegion()
    {
        return $this->container['is_home_region'];
    }

    /**
     * Sets is_home_region
     *
     * @param bool|null $is_home_region If this region is home region
     *
     * @return self
     */
    public function setIsHomeRegion($is_home_region)
    {
        if (is_null($is_home_region)) {
            throw new \InvalidArgumentException('non-nullable is_home_region cannot be null');
        }
        $this->container['is_home_region'] = $is_home_region;

        return $this;
    }

    /**
     * Gets tags_count
     *
     * @return int|null
     */
    public function getTagsCount()
    {
        return $this->container['tags_count'];
    }

    /**
     * Sets tags_count
     *
     * @param int|null $tags_count Quantity of tags
     *
     * @return self
     */
    public function setTagsCount($tags_count)
    {
        if (is_null($tags_count)) {
            throw new \InvalidArgumentException('non-nullable tags_count cannot be null');
        }
        $this->container['tags_count'] = $tags_count;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


