<?php
/**
 * Column
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * Column Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Column implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Column';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'column_name' => 'string',
        'display_name' => 'string',
        'export_name' => 'string',
        'group' => 'string',
        'field' => 'string',
        'sort_direction' => 'string',
        'width' => 'float',
        'is_editable' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'column_name' => null,
        'display_name' => null,
        'export_name' => null,
        'group' => null,
        'field' => null,
        'sort_direction' => null,
        'width' => 'double',
        'is_editable' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'column_name' => false,
        'display_name' => false,
        'export_name' => false,
        'group' => false,
        'field' => false,
        'sort_direction' => false,
        'width' => false,
        'is_editable' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'column_name' => 'ColumnName',
        'display_name' => 'DisplayName',
        'export_name' => 'ExportName',
        'group' => 'Group',
        'field' => 'Field',
        'sort_direction' => 'SortDirection',
        'width' => 'Width',
        'is_editable' => 'IsEditable'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'column_name' => 'setColumnName',
        'display_name' => 'setDisplayName',
        'export_name' => 'setExportName',
        'group' => 'setGroup',
        'field' => 'setField',
        'sort_direction' => 'setSortDirection',
        'width' => 'setWidth',
        'is_editable' => 'setIsEditable'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'column_name' => 'getColumnName',
        'display_name' => 'getDisplayName',
        'export_name' => 'getExportName',
        'group' => 'getGroup',
        'field' => 'getField',
        'sort_direction' => 'getSortDirection',
        'width' => 'getWidth',
        'is_editable' => 'getIsEditable'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const COLUMN_NAME_SKU = 'SKU';
    public const COLUMN_NAME_TITLE = 'Title';
    public const COLUMN_NAME_VARIATION_GROUP_NAME = 'VariationGroupName';
    public const COLUMN_NAME_RETAIL_PRICE = 'RetailPrice';
    public const COLUMN_NAME_PURCHASE_PRICE = 'PurchasePrice';
    public const COLUMN_NAME_TRACKED = 'Tracked';
    public const COLUMN_NAME_BARCODE = 'Barcode';
    public const COLUMN_NAME_AVAILABLE = 'Available';
    public const COLUMN_NAME_MINIMUM_LEVEL = 'MinimumLevel';
    public const COLUMN_NAME_IN_ORDER = 'InOrder';
    public const COLUMN_NAME_STOCK_LEVEL = 'StockLevel';
    public const COLUMN_NAME_STOCK_VALUE = 'StockValue';
    public const COLUMN_NAME_DUE = 'Due';
    public const COLUMN_NAME_BIN_RACK = 'BinRack';
    public const COLUMN_NAME_CATEGORY = 'Category';
    public const COLUMN_NAME_IMAGE = 'Image';
    public const COLUMN_NAME_WEIGHT = 'Weight';
    public const COLUMN_NAME_DIM_HEIGHT = 'DimHeight';
    public const COLUMN_NAME_DIM_WIDTH = 'DimWidth';
    public const COLUMN_NAME_DIM_DEPTH = 'DimDepth';
    public const COLUMN_NAME_CREATED_DATE = 'CreatedDate';
    public const COLUMN_NAME_MODIFIED_DATE = 'ModifiedDate';
    public const COLUMN_NAME_SERIAL_NUMBER_SCAN_REQUIRED = 'SerialNumberScanRequired';
    public const COLUMN_NAME_BATCH_NUMBER_SCAN_REQUIRED = 'BatchNumberScanRequired';
    public const COLUMN_NAME_BATCH_TYPE = 'BatchType';
    public const COLUMN_NAME_JIT = 'JIT';
    public const COLUMN_NAME_REORDER_AMOUNT = 'ReorderAmount';
    public const COLUMN_NAME_REORDER_DATE = 'ReorderDate';
    public const COLUMN_NAME_AVERAGE_CONSUMPTION = 'AverageConsumption';
    public const COLUMN_NAME_DEFAULT_SUPPLIER = 'DefaultSupplier';
    public const GROUP_GENERAL = 'General';
    public const GROUP_STOCK = 'Stock';
    public const GROUP_LOCATION = 'Location';
    public const FIELD_INT = 'Int';
    public const FIELD_DOUBLE = 'Double';
    public const FIELD_STRING = 'String';
    public const FIELD_BOOLEAN = 'Boolean';
    public const FIELD_SELECT = 'Select';
    public const FIELD_DATE = 'Date';
    public const FIELD_DATETIME2 = 'Datetime2';
    public const SORT_DIRECTION_NONE = 'None';
    public const SORT_DIRECTION_DESCENDING = 'Descending';
    public const SORT_DIRECTION_ASCENDING = 'Ascending';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getColumnNameAllowableValues()
    {
        return [
            self::COLUMN_NAME_SKU,
            self::COLUMN_NAME_TITLE,
            self::COLUMN_NAME_VARIATION_GROUP_NAME,
            self::COLUMN_NAME_RETAIL_PRICE,
            self::COLUMN_NAME_PURCHASE_PRICE,
            self::COLUMN_NAME_TRACKED,
            self::COLUMN_NAME_BARCODE,
            self::COLUMN_NAME_AVAILABLE,
            self::COLUMN_NAME_MINIMUM_LEVEL,
            self::COLUMN_NAME_IN_ORDER,
            self::COLUMN_NAME_STOCK_LEVEL,
            self::COLUMN_NAME_STOCK_VALUE,
            self::COLUMN_NAME_DUE,
            self::COLUMN_NAME_BIN_RACK,
            self::COLUMN_NAME_CATEGORY,
            self::COLUMN_NAME_IMAGE,
            self::COLUMN_NAME_WEIGHT,
            self::COLUMN_NAME_DIM_HEIGHT,
            self::COLUMN_NAME_DIM_WIDTH,
            self::COLUMN_NAME_DIM_DEPTH,
            self::COLUMN_NAME_CREATED_DATE,
            self::COLUMN_NAME_MODIFIED_DATE,
            self::COLUMN_NAME_SERIAL_NUMBER_SCAN_REQUIRED,
            self::COLUMN_NAME_BATCH_NUMBER_SCAN_REQUIRED,
            self::COLUMN_NAME_BATCH_TYPE,
            self::COLUMN_NAME_JIT,
            self::COLUMN_NAME_REORDER_AMOUNT,
            self::COLUMN_NAME_REORDER_DATE,
            self::COLUMN_NAME_AVERAGE_CONSUMPTION,
            self::COLUMN_NAME_DEFAULT_SUPPLIER,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getGroupAllowableValues()
    {
        return [
            self::GROUP_GENERAL,
            self::GROUP_STOCK,
            self::GROUP_LOCATION,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getFieldAllowableValues()
    {
        return [
            self::FIELD_INT,
            self::FIELD_DOUBLE,
            self::FIELD_STRING,
            self::FIELD_BOOLEAN,
            self::FIELD_SELECT,
            self::FIELD_DATE,
            self::FIELD_DATETIME2,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSortDirectionAllowableValues()
    {
        return [
            self::SORT_DIRECTION_NONE,
            self::SORT_DIRECTION_DESCENDING,
            self::SORT_DIRECTION_ASCENDING,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('column_name', $data ?? [], null);
        $this->setIfExists('display_name', $data ?? [], null);
        $this->setIfExists('export_name', $data ?? [], null);
        $this->setIfExists('group', $data ?? [], null);
        $this->setIfExists('field', $data ?? [], null);
        $this->setIfExists('sort_direction', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('is_editable', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getColumnNameAllowableValues();
        if (!is_null($this->container['column_name']) && !in_array($this->container['column_name'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'column_name', must be one of '%s'",
                $this->container['column_name'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getGroupAllowableValues();
        if (!is_null($this->container['group']) && !in_array($this->container['group'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'group', must be one of '%s'",
                $this->container['group'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getFieldAllowableValues();
        if (!is_null($this->container['field']) && !in_array($this->container['field'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'field', must be one of '%s'",
                $this->container['field'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getSortDirectionAllowableValues();
        if (!is_null($this->container['sort_direction']) && !in_array($this->container['sort_direction'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'sort_direction', must be one of '%s'",
                $this->container['sort_direction'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets column_name
     *
     * @return string|null
     */
    public function getColumnName()
    {
        return $this->container['column_name'];
    }

    /**
     * Sets column_name
     *
     * @param string|null $column_name column_name
     *
     * @return self
     */
    public function setColumnName($column_name)
    {
        if (is_null($column_name)) {
            throw new \InvalidArgumentException('non-nullable column_name cannot be null');
        }
        $allowedValues = $this->getColumnNameAllowableValues();
        if (!in_array($column_name, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'column_name', must be one of '%s'",
                    $column_name,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['column_name'] = $column_name;

        return $this;
    }

    /**
     * Gets display_name
     *
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->container['display_name'];
    }

    /**
     * Sets display_name
     *
     * @param string|null $display_name display_name
     *
     * @return self
     */
    public function setDisplayName($display_name)
    {
        if (is_null($display_name)) {
            throw new \InvalidArgumentException('non-nullable display_name cannot be null');
        }
        $this->container['display_name'] = $display_name;

        return $this;
    }

    /**
     * Gets export_name
     *
     * @return string|null
     */
    public function getExportName()
    {
        return $this->container['export_name'];
    }

    /**
     * Sets export_name
     *
     * @param string|null $export_name export_name
     *
     * @return self
     */
    public function setExportName($export_name)
    {
        if (is_null($export_name)) {
            throw new \InvalidArgumentException('non-nullable export_name cannot be null');
        }
        $this->container['export_name'] = $export_name;

        return $this;
    }

    /**
     * Gets group
     *
     * @return string|null
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     *
     * @param string|null $group group
     *
     * @return self
     */
    public function setGroup($group)
    {
        if (is_null($group)) {
            throw new \InvalidArgumentException('non-nullable group cannot be null');
        }
        $allowedValues = $this->getGroupAllowableValues();
        if (!in_array($group, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'group', must be one of '%s'",
                    $group,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets field
     *
     * @return string|null
     */
    public function getField()
    {
        return $this->container['field'];
    }

    /**
     * Sets field
     *
     * @param string|null $field field
     *
     * @return self
     */
    public function setField($field)
    {
        if (is_null($field)) {
            throw new \InvalidArgumentException('non-nullable field cannot be null');
        }
        $allowedValues = $this->getFieldAllowableValues();
        if (!in_array($field, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'field', must be one of '%s'",
                    $field,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['field'] = $field;

        return $this;
    }

    /**
     * Gets sort_direction
     *
     * @return string|null
     */
    public function getSortDirection()
    {
        return $this->container['sort_direction'];
    }

    /**
     * Sets sort_direction
     *
     * @param string|null $sort_direction sort_direction
     *
     * @return self
     */
    public function setSortDirection($sort_direction)
    {
        if (is_null($sort_direction)) {
            throw new \InvalidArgumentException('non-nullable sort_direction cannot be null');
        }
        $allowedValues = $this->getSortDirectionAllowableValues();
        if (!in_array($sort_direction, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'sort_direction', must be one of '%s'",
                    $sort_direction,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['sort_direction'] = $sort_direction;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            throw new \InvalidArgumentException('non-nullable width cannot be null');
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets is_editable
     *
     * @return bool|null
     */
    public function getIsEditable()
    {
        return $this->container['is_editable'];
    }

    /**
     * Sets is_editable
     *
     * @param bool|null $is_editable is_editable
     *
     * @return self
     */
    public function setIsEditable($is_editable)
    {
        if (is_null($is_editable)) {
            throw new \InvalidArgumentException('non-nullable is_editable cannot be null');
        }
        $this->container['is_editable'] = $is_editable;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


