<?php
/**
 * AdjustmentOptions
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Model;

use \ArrayAccess;
use \Linnworks\Inventory\ObjectSerializer;

/**
 * AdjustmentOptions Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AdjustmentOptions implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AdjustmentOptions';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'title' => 'bool',
        'price' => 'bool',
        'description' => 'bool',
        'add_extended_properties' => 'bool',
        'revise_extended_properties' => 'bool',
        'update_images' => 'bool',
        'variation_attributes' => 'bool',
        'reload_all_images' => 'bool',
        'remove_old_attributes' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'title' => null,
        'price' => null,
        'description' => null,
        'add_extended_properties' => null,
        'revise_extended_properties' => null,
        'update_images' => null,
        'variation_attributes' => null,
        'reload_all_images' => null,
        'remove_old_attributes' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'title' => false,
        'price' => false,
        'description' => false,
        'add_extended_properties' => false,
        'revise_extended_properties' => false,
        'update_images' => false,
        'variation_attributes' => false,
        'reload_all_images' => false,
        'remove_old_attributes' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'title' => 'Title',
        'price' => 'Price',
        'description' => 'Description',
        'add_extended_properties' => 'AddExtendedProperties',
        'revise_extended_properties' => 'ReviseExtendedProperties',
        'update_images' => 'UpdateImages',
        'variation_attributes' => 'VariationAttributes',
        'reload_all_images' => 'ReloadAllImages',
        'remove_old_attributes' => 'RemoveOldAttributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'title' => 'setTitle',
        'price' => 'setPrice',
        'description' => 'setDescription',
        'add_extended_properties' => 'setAddExtendedProperties',
        'revise_extended_properties' => 'setReviseExtendedProperties',
        'update_images' => 'setUpdateImages',
        'variation_attributes' => 'setVariationAttributes',
        'reload_all_images' => 'setReloadAllImages',
        'remove_old_attributes' => 'setRemoveOldAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'title' => 'getTitle',
        'price' => 'getPrice',
        'description' => 'getDescription',
        'add_extended_properties' => 'getAddExtendedProperties',
        'revise_extended_properties' => 'getReviseExtendedProperties',
        'update_images' => 'getUpdateImages',
        'variation_attributes' => 'getVariationAttributes',
        'reload_all_images' => 'getReloadAllImages',
        'remove_old_attributes' => 'getRemoveOldAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('title', $data ?? [], null);
        $this->setIfExists('price', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('add_extended_properties', $data ?? [], null);
        $this->setIfExists('revise_extended_properties', $data ?? [], null);
        $this->setIfExists('update_images', $data ?? [], null);
        $this->setIfExists('variation_attributes', $data ?? [], null);
        $this->setIfExists('reload_all_images', $data ?? [], null);
        $this->setIfExists('remove_old_attributes', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets title
     *
     * @return bool|null
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     *
     * @param bool|null $title Product title
     *
     * @return self
     */
    public function setTitle($title)
    {
        if (is_null($title)) {
            throw new \InvalidArgumentException('non-nullable title cannot be null');
        }
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets price
     *
     * @return bool|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param bool|null $price Product price
     *
     * @return self
     */
    public function setPrice($price)
    {
        if (is_null($price)) {
            throw new \InvalidArgumentException('non-nullable price cannot be null');
        }
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets description
     *
     * @return bool|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param bool|null $description Product description
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets add_extended_properties
     *
     * @return bool|null
     */
    public function getAddExtendedProperties()
    {
        return $this->container['add_extended_properties'];
    }

    /**
     * Sets add_extended_properties
     *
     * @param bool|null $add_extended_properties If product extended properties needs to be added
     *
     * @return self
     */
    public function setAddExtendedProperties($add_extended_properties)
    {
        if (is_null($add_extended_properties)) {
            throw new \InvalidArgumentException('non-nullable add_extended_properties cannot be null');
        }
        $this->container['add_extended_properties'] = $add_extended_properties;

        return $this;
    }

    /**
     * Gets revise_extended_properties
     *
     * @return bool|null
     */
    public function getReviseExtendedProperties()
    {
        return $this->container['revise_extended_properties'];
    }

    /**
     * Sets revise_extended_properties
     *
     * @param bool|null $revise_extended_properties Revise product extended properties
     *
     * @return self
     */
    public function setReviseExtendedProperties($revise_extended_properties)
    {
        if (is_null($revise_extended_properties)) {
            throw new \InvalidArgumentException('non-nullable revise_extended_properties cannot be null');
        }
        $this->container['revise_extended_properties'] = $revise_extended_properties;

        return $this;
    }

    /**
     * Gets update_images
     *
     * @return bool|null
     */
    public function getUpdateImages()
    {
        return $this->container['update_images'];
    }

    /**
     * Sets update_images
     *
     * @param bool|null $update_images Update product images
     *
     * @return self
     */
    public function setUpdateImages($update_images)
    {
        if (is_null($update_images)) {
            throw new \InvalidArgumentException('non-nullable update_images cannot be null');
        }
        $this->container['update_images'] = $update_images;

        return $this;
    }

    /**
     * Gets variation_attributes
     *
     * @return bool|null
     */
    public function getVariationAttributes()
    {
        return $this->container['variation_attributes'];
    }

    /**
     * Sets variation_attributes
     *
     * @param bool|null $variation_attributes Product variation attributes
     *
     * @return self
     */
    public function setVariationAttributes($variation_attributes)
    {
        if (is_null($variation_attributes)) {
            throw new \InvalidArgumentException('non-nullable variation_attributes cannot be null');
        }
        $this->container['variation_attributes'] = $variation_attributes;

        return $this;
    }

    /**
     * Gets reload_all_images
     *
     * @return bool|null
     */
    public function getReloadAllImages()
    {
        return $this->container['reload_all_images'];
    }

    /**
     * Sets reload_all_images
     *
     * @param bool|null $reload_all_images Reload all images for the template
     *
     * @return self
     */
    public function setReloadAllImages($reload_all_images)
    {
        if (is_null($reload_all_images)) {
            throw new \InvalidArgumentException('non-nullable reload_all_images cannot be null');
        }
        $this->container['reload_all_images'] = $reload_all_images;

        return $this;
    }

    /**
     * Gets remove_old_attributes
     *
     * @return bool|null
     */
    public function getRemoveOldAttributes()
    {
        return $this->container['remove_old_attributes'];
    }

    /**
     * Sets remove_old_attributes
     *
     * @param bool|null $remove_old_attributes Removes old attributes
     *
     * @return self
     */
    public function setRemoveOldAttributes($remove_old_attributes)
    {
        if (is_null($remove_old_attributes)) {
            throw new \InvalidArgumentException('non-nullable remove_old_attributes cannot be null');
        }
        $this->container['remove_old_attributes'] = $remove_old_attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


