<?php
/**
 * InventoryApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Inventory API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: inventory
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Inventory\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\Inventory\ApiException;
use Linnworks\Inventory\Configuration;
use Linnworks\Inventory\HeaderSelector;
use Linnworks\Inventory\ObjectSerializer;

/**
 * InventoryApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Inventory
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class InventoryApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'addImageToInventoryItem' => [
            'application/json',
        ],
        'addInventoryItem' => [
            'application/json',
        ],
        'addInventoryItemBulk' => [
            'application/json',
        ],
        'addItemLocations' => [
            'application/json',
        ],
        'addProductIdentifiers' => [
            'application/json',
        ],
        'addScrapCategories' => [
            'application/json',
        ],
        'addScrapItem' => [
            'application/json',
        ],
        'addSupplier' => [
            'application/json',
        ],
        'adjustTemplatesInstant' => [
            'application/json',
        ],
        'archiveInventoryItems' => [
            'application/json',
        ],
        'batchGetInventoryItemChannelSKUs' => [
            'application/json',
        ],
        'bulkScrapBatchedItems' => [
            'application/json',
        ],
        'createBatches' => [
            'application/json',
        ],
        'createCategory' => [
            'application/json',
        ],
        'createCountries' => [
            'application/json',
        ],
        'createCountryRegions' => [
            'application/json',
        ],
        'createInventoryItemChannelSKUs' => [
            'application/json',
        ],
        'createInventoryItemCompositions' => [
            'application/json',
        ],
        'createInventoryItemDescriptions' => [
            'application/json',
        ],
        'createInventoryItemExtendedProperties' => [
            'application/json',
        ],
        'createInventoryItemPrices' => [
            'application/json',
        ],
        'createInventoryItemPricingRules' => [
            'application/json',
        ],
        'createInventoryItemTitles' => [
            'application/json',
        ],
        'createStockSupplierStat' => [
            'application/json',
        ],
        'createUserSpecificView' => [
            'application/json',
        ],
        'deleteBatchInventoryInBulk' => [
            'application/json',
        ],
        'deleteBatchesByStockItemId' => [
            'application/json',
        ],
        'deleteCategoryById' => [
            'application/json',
        ],
        'deleteCountries' => [
            'application/json',
        ],
        'deleteEbayCompatibilityList' => [
            'application/json',
        ],
        'deleteImagesFromInventoryItem' => [
            'application/json',
        ],
        'deleteInventoryItemBulk' => [
            'application/json',
        ],
        'deleteInventoryItemChannelSKUs' => [
            'application/json',
        ],
        'deleteInventoryItemCompositions' => [
            'application/json',
        ],
        'deleteInventoryItemDescriptions' => [
            'application/json',
        ],
        'deleteInventoryItemExtendedProperties' => [
            'application/json',
        ],
        'deleteInventoryItemImageBulk' => [
            'application/json',
        ],
        'deleteInventoryItemPrices' => [
            'application/json',
        ],
        'deleteInventoryItemPricingRules' => [
            'application/json',
        ],
        'deleteInventoryItemTitles' => [
            'application/json',
        ],
        'deleteInventoryItems' => [
            'application/json',
        ],
        'deleteItemLocations' => [
            'application/json',
        ],
        'deleteProductIdentifiers' => [
            'application/json',
        ],
        'deleteScrapCategories' => [
            'application/json',
        ],
        'deleteStockSupplierStat' => [
            'application/json',
        ],
        'deleteSuppliers' => [
            'application/json',
        ],
        'deleteUserSpecificView' => [
            'application/json',
        ],
        'duplicateInventoryItem' => [
            'application/json',
        ],
        'getAllExtendedPropertyNames' => [
            'application/json',
        ],
        'getBatchAudit' => [
            'application/json',
        ],
        'getBatchInventoryById' => [
            'application/json',
        ],
        'getBatchesByStockItemId' => [
            'application/json',
        ],
        'getCategories' => [
            'application/json',
        ],
        'getChannels' => [
            'application/json',
        ],
        'getChannelsBySource' => [
            'application/json',
        ],
        'getCountries' => [
            'application/json',
        ],
        'getCountryCodes' => [
            'application/json',
        ],
        'getEbayCompatibilityList' => [
            'application/json',
        ],
        'getExtendedPropertyNames' => [
            'application/json',
        ],
        'getExtendedPropertyTypes' => [
            'application/json',
        ],
        'getImagesInBulk' => [
            'application/json',
        ],
        'getInventoryBatchTypes' => [
            'application/json',
        ],
        'getInventoryItem' => [
            'application/json',
        ],
        'getInventoryItemAuditTrail' => [
            'application/json',
        ],
        'getInventoryItemAuditTrailPaged' => [
            'application/json',
        ],
        'getInventoryItemBatchInformation' => [
            'application/json',
        ],
        'getInventoryItemBatchInformationByIds' => [
            'application/json',
        ],
        'getInventoryItemById' => [
            'application/json',
        ],
        'getInventoryItemChannelSKUs' => [
            'application/json',
        ],
        'getInventoryItemChannelSKUsWithLocation' => [
            'application/json',
        ],
        'getInventoryItemCompositions' => [
            'application/json',
        ],
        'getInventoryItemDescriptions' => [
            'application/json',
        ],
        'getInventoryItemExtendedProperties' => [
            'application/json',
        ],
        'getInventoryItemImages' => [
            'application/json',
        ],
        'getInventoryItemLocations' => [
            'application/json',
        ],
        'getInventoryItemPriceChannelSuffixes' => [
            'application/json',
        ],
        'getInventoryItemPriceRulesById' => [
            'application/json',
        ],
        'getInventoryItemPriceRulesBySource' => [
            'application/json',
        ],
        'getInventoryItemPriceTags' => [
            'application/json',
        ],
        'getInventoryItemPrices' => [
            'application/json',
        ],
        'getInventoryItemTitles' => [
            'application/json',
        ],
        'getInventoryItemsCompositionByIds' => [
            'application/json',
        ],
        'getInventoryItemsCount' => [
            'application/json',
        ],
        'getNewItemNumber' => [
            'application/json',
        ],
        'getPackageGroups' => [
            'application/json',
        ],
        'getPostalServices' => [
            'application/json',
        ],
        'getPreDefinedViews' => [
            'application/json',
        ],
        'getProductIdentifierExtendedTypes' => [
            'application/json',
        ],
        'getProductIdentifierTypes' => [
            'application/json',
        ],
        'getProductIdentifiersBulkByStockItemId' => [
            'application/json',
        ],
        'getProductIdentifiersByStockItemId' => [
            'application/json',
        ],
        'getScannableProductIdentifiersByOrderIds' => [
            'application/json',
        ],
        'getScrapCategories' => [
            'application/json',
        ],
        'getScrapHistory' => [
            'application/json',
        ],
        'getStockItemBatchesByLocation' => [
            'application/json',
        ],
        'getStockItemIdsBySKU' => [
            'application/json',
        ],
        'getStockItemLabels' => [
            'application/json',
        ],
        'getStockLocations' => [
            'application/json',
        ],
        'getStockSupplierStat' => [
            'application/json',
        ],
        'getStockSupplierStatsBulk' => [
            'application/json',
        ],
        'getSupplierDetails' => [
            'application/json',
        ],
        'getSuppliers' => [
            'application/json',
        ],
        'getUserSpecificViews' => [
            'application/json',
        ],
        'hasStockItemBatches' => [
            'application/json',
        ],
        'hasStockItemStockLevel' => [
            'application/json',
        ],
        'insertUpdateEbayCompatibilityList' => [
            'application/json',
        ],
        'isInventoryItemChannelSKULinked' => [
            'application/json',
        ],
        'isOwnedStockLocation' => [
            'application/json',
        ],
        'itemsHaveScannableIdentifiers' => [
            'application/json',
        ],
        'scrapBatchedItem' => [
            'application/json',
        ],
        'setInventoryItemImageAsMain' => [
            'application/json',
        ],
        'unarchiveInventoryItems' => [
            'application/json',
        ],
        'unlinkChannelListing' => [
            'application/json',
        ],
        'updateBatchDates' => [
            'application/json',
        ],
        'updateBatchDetails' => [
            'application/json',
        ],
        'updateBatchesWithInventory' => [
            'application/json',
        ],
        'updateCategory' => [
            'application/json',
        ],
        'updateCompositeParentStockLevel' => [
            'application/json',
        ],
        'updateCountries' => [
            'application/json',
        ],
        'updateCountryRegions' => [
            'application/json',
        ],
        'updateImages' => [
            'application/json',
        ],
        'updateInventoryItem' => [
            'application/json',
        ],
        'updateInventoryItemChannelSKUs' => [
            'application/json',
        ],
        'updateInventoryItemChannelSKUsWithLocation' => [
            'application/json',
        ],
        'updateInventoryItemCompositions' => [
            'application/json',
        ],
        'updateInventoryItemDescriptions' => [
            'application/json',
        ],
        'updateInventoryItemExtendedProperties' => [
            'application/json',
        ],
        'updateInventoryItemField' => [
            'application/json',
        ],
        'updateInventoryItemLevels' => [
            'application/json',
        ],
        'updateInventoryItemLocationField' => [
            'application/json',
        ],
        'updateInventoryItemPrices' => [
            'application/json',
        ],
        'updateInventoryItemPricingRules' => [
            'application/json',
        ],
        'updateInventoryItemStockField' => [
            'application/json',
        ],
        'updateInventoryItemTitles' => [
            'application/json',
        ],
        'updateItemLocations' => [
            'application/json',
        ],
        'updateProductIdentifiers' => [
            'application/json',
        ],
        'updateScrapCategories' => [
            'application/json',
        ],
        'updateStockSupplierStat' => [
            'application/json',
        ],
        'updateSupplier' => [
            'application/json',
        ],
        'updateUserSpecificView' => [
            'application/json',
        ],
        'uploadImagesToInventoryItem' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation addImageToInventoryItem
     *
     * AddImageToInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest $inventory_add_image_to_inventory_item_request inventory_add_image_to_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addImageToInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\AddImageToInventoryItemResponse
     */
    public function addImageToInventoryItem($inventory_add_image_to_inventory_item_request, string $contentType = self::contentTypes['addImageToInventoryItem'][0])
    {
        list($response) = $this->addImageToInventoryItemWithHttpInfo($inventory_add_image_to_inventory_item_request, $contentType);
        return $response;
    }

    /**
     * Operation addImageToInventoryItemWithHttpInfo
     *
     * AddImageToInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest $inventory_add_image_to_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addImageToInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\AddImageToInventoryItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addImageToInventoryItemWithHttpInfo($inventory_add_image_to_inventory_item_request, string $contentType = self::contentTypes['addImageToInventoryItem'][0])
    {
        $request = $this->addImageToInventoryItemRequest($inventory_add_image_to_inventory_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\AddImageToInventoryItemResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\AddImageToInventoryItemResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\AddImageToInventoryItemResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\AddImageToInventoryItemResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\AddImageToInventoryItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addImageToInventoryItemAsync
     *
     * AddImageToInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest $inventory_add_image_to_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addImageToInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addImageToInventoryItemAsync($inventory_add_image_to_inventory_item_request, string $contentType = self::contentTypes['addImageToInventoryItem'][0])
    {
        return $this->addImageToInventoryItemAsyncWithHttpInfo($inventory_add_image_to_inventory_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addImageToInventoryItemAsyncWithHttpInfo
     *
     * AddImageToInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest $inventory_add_image_to_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addImageToInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addImageToInventoryItemAsyncWithHttpInfo($inventory_add_image_to_inventory_item_request, string $contentType = self::contentTypes['addImageToInventoryItem'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\AddImageToInventoryItemResponse';
        $request = $this->addImageToInventoryItemRequest($inventory_add_image_to_inventory_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addImageToInventoryItem'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest $inventory_add_image_to_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addImageToInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addImageToInventoryItemRequest($inventory_add_image_to_inventory_item_request, string $contentType = self::contentTypes['addImageToInventoryItem'][0])
    {

        // verify the required parameter 'inventory_add_image_to_inventory_item_request' is set
        if ($inventory_add_image_to_inventory_item_request === null || (is_array($inventory_add_image_to_inventory_item_request) && count($inventory_add_image_to_inventory_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_image_to_inventory_item_request when calling addImageToInventoryItem'
            );
        }


        $resourcePath = '/api/Inventory/AddImageToInventoryItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_image_to_inventory_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_image_to_inventory_item_request));
            } else {
                $httpBody = $inventory_add_image_to_inventory_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addInventoryItem
     *
     * AddInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest $inventory_add_inventory_item_request inventory_add_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addInventoryItem($inventory_add_inventory_item_request, string $contentType = self::contentTypes['addInventoryItem'][0])
    {
        $this->addInventoryItemWithHttpInfo($inventory_add_inventory_item_request, $contentType);
    }

    /**
     * Operation addInventoryItemWithHttpInfo
     *
     * AddInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest $inventory_add_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addInventoryItemWithHttpInfo($inventory_add_inventory_item_request, string $contentType = self::contentTypes['addInventoryItem'][0])
    {
        $request = $this->addInventoryItemRequest($inventory_add_inventory_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation addInventoryItemAsync
     *
     * AddInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest $inventory_add_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addInventoryItemAsync($inventory_add_inventory_item_request, string $contentType = self::contentTypes['addInventoryItem'][0])
    {
        return $this->addInventoryItemAsyncWithHttpInfo($inventory_add_inventory_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addInventoryItemAsyncWithHttpInfo
     *
     * AddInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest $inventory_add_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addInventoryItemAsyncWithHttpInfo($inventory_add_inventory_item_request, string $contentType = self::contentTypes['addInventoryItem'][0])
    {
        $returnType = '';
        $request = $this->addInventoryItemRequest($inventory_add_inventory_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addInventoryItem'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest $inventory_add_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addInventoryItemRequest($inventory_add_inventory_item_request, string $contentType = self::contentTypes['addInventoryItem'][0])
    {

        // verify the required parameter 'inventory_add_inventory_item_request' is set
        if ($inventory_add_inventory_item_request === null || (is_array($inventory_add_inventory_item_request) && count($inventory_add_inventory_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_inventory_item_request when calling addInventoryItem'
            );
        }


        $resourcePath = '/api/Inventory/AddInventoryItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_inventory_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_inventory_item_request));
            } else {
                $httpBody = $inventory_add_inventory_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addInventoryItemBulk
     *
     * AddInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest $inventory_add_inventory_item_bulk_request inventory_add_inventory_item_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\BatchedAPIResponseGuid
     */
    public function addInventoryItemBulk($inventory_add_inventory_item_bulk_request, string $contentType = self::contentTypes['addInventoryItemBulk'][0])
    {
        list($response) = $this->addInventoryItemBulkWithHttpInfo($inventory_add_inventory_item_bulk_request, $contentType);
        return $response;
    }

    /**
     * Operation addInventoryItemBulkWithHttpInfo
     *
     * AddInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest $inventory_add_inventory_item_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\BatchedAPIResponseGuid, HTTP status code, HTTP response headers (array of strings)
     */
    public function addInventoryItemBulkWithHttpInfo($inventory_add_inventory_item_bulk_request, string $contentType = self::contentTypes['addInventoryItemBulk'][0])
    {
        $request = $this->addInventoryItemBulkRequest($inventory_add_inventory_item_bulk_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\BatchedAPIResponseGuid' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\BatchedAPIResponseGuid' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\BatchedAPIResponseGuid', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseGuid';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\BatchedAPIResponseGuid',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addInventoryItemBulkAsync
     *
     * AddInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest $inventory_add_inventory_item_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addInventoryItemBulkAsync($inventory_add_inventory_item_bulk_request, string $contentType = self::contentTypes['addInventoryItemBulk'][0])
    {
        return $this->addInventoryItemBulkAsyncWithHttpInfo($inventory_add_inventory_item_bulk_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addInventoryItemBulkAsyncWithHttpInfo
     *
     * AddInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest $inventory_add_inventory_item_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addInventoryItemBulkAsyncWithHttpInfo($inventory_add_inventory_item_bulk_request, string $contentType = self::contentTypes['addInventoryItemBulk'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseGuid';
        $request = $this->addInventoryItemBulkRequest($inventory_add_inventory_item_bulk_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addInventoryItemBulk'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest $inventory_add_inventory_item_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addInventoryItemBulkRequest($inventory_add_inventory_item_bulk_request, string $contentType = self::contentTypes['addInventoryItemBulk'][0])
    {

        // verify the required parameter 'inventory_add_inventory_item_bulk_request' is set
        if ($inventory_add_inventory_item_bulk_request === null || (is_array($inventory_add_inventory_item_bulk_request) && count($inventory_add_inventory_item_bulk_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_inventory_item_bulk_request when calling addInventoryItemBulk'
            );
        }


        $resourcePath = '/api/Inventory/AddInventoryItemBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_inventory_item_bulk_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_inventory_item_bulk_request));
            } else {
                $httpBody = $inventory_add_inventory_item_bulk_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addItemLocations
     *
     * AddItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest $inventory_add_item_locations_request inventory_add_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function addItemLocations($inventory_add_item_locations_request, string $contentType = self::contentTypes['addItemLocations'][0])
    {
        $this->addItemLocationsWithHttpInfo($inventory_add_item_locations_request, $contentType);
    }

    /**
     * Operation addItemLocationsWithHttpInfo
     *
     * AddItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest $inventory_add_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function addItemLocationsWithHttpInfo($inventory_add_item_locations_request, string $contentType = self::contentTypes['addItemLocations'][0])
    {
        $request = $this->addItemLocationsRequest($inventory_add_item_locations_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation addItemLocationsAsync
     *
     * AddItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest $inventory_add_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addItemLocationsAsync($inventory_add_item_locations_request, string $contentType = self::contentTypes['addItemLocations'][0])
    {
        return $this->addItemLocationsAsyncWithHttpInfo($inventory_add_item_locations_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addItemLocationsAsyncWithHttpInfo
     *
     * AddItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest $inventory_add_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addItemLocationsAsyncWithHttpInfo($inventory_add_item_locations_request, string $contentType = self::contentTypes['addItemLocations'][0])
    {
        $returnType = '';
        $request = $this->addItemLocationsRequest($inventory_add_item_locations_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addItemLocations'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest $inventory_add_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addItemLocationsRequest($inventory_add_item_locations_request, string $contentType = self::contentTypes['addItemLocations'][0])
    {

        // verify the required parameter 'inventory_add_item_locations_request' is set
        if ($inventory_add_item_locations_request === null || (is_array($inventory_add_item_locations_request) && count($inventory_add_item_locations_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_item_locations_request when calling addItemLocations'
            );
        }


        $resourcePath = '/api/Inventory/AddItemLocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_item_locations_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_item_locations_request));
            } else {
                $httpBody = $inventory_add_item_locations_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addProductIdentifiers
     *
     * AddProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest $inventory_add_product_identifiers_request inventory_add_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier
     */
    public function addProductIdentifiers($inventory_add_product_identifiers_request, string $contentType = self::contentTypes['addProductIdentifiers'][0])
    {
        list($response) = $this->addProductIdentifiersWithHttpInfo($inventory_add_product_identifiers_request, $contentType);
        return $response;
    }

    /**
     * Operation addProductIdentifiersWithHttpInfo
     *
     * AddProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest $inventory_add_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier, HTTP status code, HTTP response headers (array of strings)
     */
    public function addProductIdentifiersWithHttpInfo($inventory_add_product_identifiers_request, string $contentType = self::contentTypes['addProductIdentifiers'][0])
    {
        $request = $this->addProductIdentifiersRequest($inventory_add_product_identifiers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addProductIdentifiersAsync
     *
     * AddProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest $inventory_add_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addProductIdentifiersAsync($inventory_add_product_identifiers_request, string $contentType = self::contentTypes['addProductIdentifiers'][0])
    {
        return $this->addProductIdentifiersAsyncWithHttpInfo($inventory_add_product_identifiers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addProductIdentifiersAsyncWithHttpInfo
     *
     * AddProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest $inventory_add_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addProductIdentifiersAsyncWithHttpInfo($inventory_add_product_identifiers_request, string $contentType = self::contentTypes['addProductIdentifiers'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier';
        $request = $this->addProductIdentifiersRequest($inventory_add_product_identifiers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addProductIdentifiers'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest $inventory_add_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addProductIdentifiersRequest($inventory_add_product_identifiers_request, string $contentType = self::contentTypes['addProductIdentifiers'][0])
    {

        // verify the required parameter 'inventory_add_product_identifiers_request' is set
        if ($inventory_add_product_identifiers_request === null || (is_array($inventory_add_product_identifiers_request) && count($inventory_add_product_identifiers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_product_identifiers_request when calling addProductIdentifiers'
            );
        }


        $resourcePath = '/api/Inventory/AddProductIdentifiers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_product_identifiers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_product_identifiers_request));
            } else {
                $httpBody = $inventory_add_product_identifiers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addScrapCategories
     *
     * AddScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest $inventory_add_scrap_categories_request inventory_add_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\AddScrapCategoriesResponse
     */
    public function addScrapCategories($inventory_add_scrap_categories_request, string $contentType = self::contentTypes['addScrapCategories'][0])
    {
        list($response) = $this->addScrapCategoriesWithHttpInfo($inventory_add_scrap_categories_request, $contentType);
        return $response;
    }

    /**
     * Operation addScrapCategoriesWithHttpInfo
     *
     * AddScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest $inventory_add_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\AddScrapCategoriesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addScrapCategoriesWithHttpInfo($inventory_add_scrap_categories_request, string $contentType = self::contentTypes['addScrapCategories'][0])
    {
        $request = $this->addScrapCategoriesRequest($inventory_add_scrap_categories_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\AddScrapCategoriesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\AddScrapCategoriesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\AddScrapCategoriesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\AddScrapCategoriesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\AddScrapCategoriesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addScrapCategoriesAsync
     *
     * AddScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest $inventory_add_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addScrapCategoriesAsync($inventory_add_scrap_categories_request, string $contentType = self::contentTypes['addScrapCategories'][0])
    {
        return $this->addScrapCategoriesAsyncWithHttpInfo($inventory_add_scrap_categories_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addScrapCategoriesAsyncWithHttpInfo
     *
     * AddScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest $inventory_add_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addScrapCategoriesAsyncWithHttpInfo($inventory_add_scrap_categories_request, string $contentType = self::contentTypes['addScrapCategories'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\AddScrapCategoriesResponse';
        $request = $this->addScrapCategoriesRequest($inventory_add_scrap_categories_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addScrapCategories'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest $inventory_add_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addScrapCategoriesRequest($inventory_add_scrap_categories_request, string $contentType = self::contentTypes['addScrapCategories'][0])
    {

        // verify the required parameter 'inventory_add_scrap_categories_request' is set
        if ($inventory_add_scrap_categories_request === null || (is_array($inventory_add_scrap_categories_request) && count($inventory_add_scrap_categories_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_scrap_categories_request when calling addScrapCategories'
            );
        }


        $resourcePath = '/api/Inventory/AddScrapCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_scrap_categories_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_scrap_categories_request));
            } else {
                $httpBody = $inventory_add_scrap_categories_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addScrapItem
     *
     * AddScrapItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapItemRequest $inventory_add_scrap_item_request inventory_add_scrap_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\AddScrapItemResponse
     */
    public function addScrapItem($inventory_add_scrap_item_request, string $contentType = self::contentTypes['addScrapItem'][0])
    {
        list($response) = $this->addScrapItemWithHttpInfo($inventory_add_scrap_item_request, $contentType);
        return $response;
    }

    /**
     * Operation addScrapItemWithHttpInfo
     *
     * AddScrapItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapItemRequest $inventory_add_scrap_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\AddScrapItemResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function addScrapItemWithHttpInfo($inventory_add_scrap_item_request, string $contentType = self::contentTypes['addScrapItem'][0])
    {
        $request = $this->addScrapItemRequest($inventory_add_scrap_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\AddScrapItemResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\AddScrapItemResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\AddScrapItemResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\AddScrapItemResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\AddScrapItemResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addScrapItemAsync
     *
     * AddScrapItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapItemRequest $inventory_add_scrap_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addScrapItemAsync($inventory_add_scrap_item_request, string $contentType = self::contentTypes['addScrapItem'][0])
    {
        return $this->addScrapItemAsyncWithHttpInfo($inventory_add_scrap_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addScrapItemAsyncWithHttpInfo
     *
     * AddScrapItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapItemRequest $inventory_add_scrap_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addScrapItemAsyncWithHttpInfo($inventory_add_scrap_item_request, string $contentType = self::contentTypes['addScrapItem'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\AddScrapItemResponse';
        $request = $this->addScrapItemRequest($inventory_add_scrap_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addScrapItem'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddScrapItemRequest $inventory_add_scrap_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addScrapItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addScrapItemRequest($inventory_add_scrap_item_request, string $contentType = self::contentTypes['addScrapItem'][0])
    {

        // verify the required parameter 'inventory_add_scrap_item_request' is set
        if ($inventory_add_scrap_item_request === null || (is_array($inventory_add_scrap_item_request) && count($inventory_add_scrap_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_scrap_item_request when calling addScrapItem'
            );
        }


        $resourcePath = '/api/Inventory/AddScrapItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_scrap_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_scrap_item_request));
            } else {
                $httpBody = $inventory_add_scrap_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation addSupplier
     *
     * AddSupplier
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddSupplierRequest $inventory_add_supplier_request inventory_add_supplier_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addSupplier'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\Supplier
     */
    public function addSupplier($inventory_add_supplier_request, string $contentType = self::contentTypes['addSupplier'][0])
    {
        list($response) = $this->addSupplierWithHttpInfo($inventory_add_supplier_request, $contentType);
        return $response;
    }

    /**
     * Operation addSupplierWithHttpInfo
     *
     * AddSupplier
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddSupplierRequest $inventory_add_supplier_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addSupplier'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\Supplier, HTTP status code, HTTP response headers (array of strings)
     */
    public function addSupplierWithHttpInfo($inventory_add_supplier_request, string $contentType = self::contentTypes['addSupplier'][0])
    {
        $request = $this->addSupplierRequest($inventory_add_supplier_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\Supplier' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\Supplier' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\Supplier', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\Supplier';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\Supplier',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation addSupplierAsync
     *
     * AddSupplier
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddSupplierRequest $inventory_add_supplier_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addSupplierAsync($inventory_add_supplier_request, string $contentType = self::contentTypes['addSupplier'][0])
    {
        return $this->addSupplierAsyncWithHttpInfo($inventory_add_supplier_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation addSupplierAsyncWithHttpInfo
     *
     * AddSupplier
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddSupplierRequest $inventory_add_supplier_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function addSupplierAsyncWithHttpInfo($inventory_add_supplier_request, string $contentType = self::contentTypes['addSupplier'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\Supplier';
        $request = $this->addSupplierRequest($inventory_add_supplier_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'addSupplier'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAddSupplierRequest $inventory_add_supplier_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['addSupplier'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function addSupplierRequest($inventory_add_supplier_request, string $contentType = self::contentTypes['addSupplier'][0])
    {

        // verify the required parameter 'inventory_add_supplier_request' is set
        if ($inventory_add_supplier_request === null || (is_array($inventory_add_supplier_request) && count($inventory_add_supplier_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_add_supplier_request when calling addSupplier'
            );
        }


        $resourcePath = '/api/Inventory/AddSupplier';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_add_supplier_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_add_supplier_request));
            } else {
                $httpBody = $inventory_add_supplier_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation adjustTemplatesInstant
     *
     * AdjustTemplatesInstant
     *
     * @param  \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest $inventory_adjust_templates_instant_request inventory_adjust_templates_instant_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['adjustTemplatesInstant'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function adjustTemplatesInstant($inventory_adjust_templates_instant_request, string $contentType = self::contentTypes['adjustTemplatesInstant'][0])
    {
        $this->adjustTemplatesInstantWithHttpInfo($inventory_adjust_templates_instant_request, $contentType);
    }

    /**
     * Operation adjustTemplatesInstantWithHttpInfo
     *
     * AdjustTemplatesInstant
     *
     * @param  \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest $inventory_adjust_templates_instant_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['adjustTemplatesInstant'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function adjustTemplatesInstantWithHttpInfo($inventory_adjust_templates_instant_request, string $contentType = self::contentTypes['adjustTemplatesInstant'][0])
    {
        $request = $this->adjustTemplatesInstantRequest($inventory_adjust_templates_instant_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation adjustTemplatesInstantAsync
     *
     * AdjustTemplatesInstant
     *
     * @param  \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest $inventory_adjust_templates_instant_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['adjustTemplatesInstant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function adjustTemplatesInstantAsync($inventory_adjust_templates_instant_request, string $contentType = self::contentTypes['adjustTemplatesInstant'][0])
    {
        return $this->adjustTemplatesInstantAsyncWithHttpInfo($inventory_adjust_templates_instant_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation adjustTemplatesInstantAsyncWithHttpInfo
     *
     * AdjustTemplatesInstant
     *
     * @param  \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest $inventory_adjust_templates_instant_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['adjustTemplatesInstant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function adjustTemplatesInstantAsyncWithHttpInfo($inventory_adjust_templates_instant_request, string $contentType = self::contentTypes['adjustTemplatesInstant'][0])
    {
        $returnType = '';
        $request = $this->adjustTemplatesInstantRequest($inventory_adjust_templates_instant_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'adjustTemplatesInstant'
     *
     * @param  \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest $inventory_adjust_templates_instant_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['adjustTemplatesInstant'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function adjustTemplatesInstantRequest($inventory_adjust_templates_instant_request, string $contentType = self::contentTypes['adjustTemplatesInstant'][0])
    {

        // verify the required parameter 'inventory_adjust_templates_instant_request' is set
        if ($inventory_adjust_templates_instant_request === null || (is_array($inventory_adjust_templates_instant_request) && count($inventory_adjust_templates_instant_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_adjust_templates_instant_request when calling adjustTemplatesInstant'
            );
        }


        $resourcePath = '/api/Inventory/AdjustTemplatesInstant';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_adjust_templates_instant_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_adjust_templates_instant_request));
            } else {
                $httpBody = $inventory_adjust_templates_instant_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveInventoryItems
     *
     * ArchiveInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest $inventory_archive_inventory_items_request inventory_archive_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveInventoryItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveInventoryItems($inventory_archive_inventory_items_request, string $contentType = self::contentTypes['archiveInventoryItems'][0])
    {
        $this->archiveInventoryItemsWithHttpInfo($inventory_archive_inventory_items_request, $contentType);
    }

    /**
     * Operation archiveInventoryItemsWithHttpInfo
     *
     * ArchiveInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest $inventory_archive_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveInventoryItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveInventoryItemsWithHttpInfo($inventory_archive_inventory_items_request, string $contentType = self::contentTypes['archiveInventoryItems'][0])
    {
        $request = $this->archiveInventoryItemsRequest($inventory_archive_inventory_items_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation archiveInventoryItemsAsync
     *
     * ArchiveInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest $inventory_archive_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveInventoryItemsAsync($inventory_archive_inventory_items_request, string $contentType = self::contentTypes['archiveInventoryItems'][0])
    {
        return $this->archiveInventoryItemsAsyncWithHttpInfo($inventory_archive_inventory_items_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveInventoryItemsAsyncWithHttpInfo
     *
     * ArchiveInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest $inventory_archive_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveInventoryItemsAsyncWithHttpInfo($inventory_archive_inventory_items_request, string $contentType = self::contentTypes['archiveInventoryItems'][0])
    {
        $returnType = '';
        $request = $this->archiveInventoryItemsRequest($inventory_archive_inventory_items_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveInventoryItems'
     *
     * @param  \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest $inventory_archive_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveInventoryItemsRequest($inventory_archive_inventory_items_request, string $contentType = self::contentTypes['archiveInventoryItems'][0])
    {

        // verify the required parameter 'inventory_archive_inventory_items_request' is set
        if ($inventory_archive_inventory_items_request === null || (is_array($inventory_archive_inventory_items_request) && count($inventory_archive_inventory_items_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_archive_inventory_items_request when calling archiveInventoryItems'
            );
        }


        $resourcePath = '/api/Inventory/ArchiveInventoryItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_archive_inventory_items_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_archive_inventory_items_request));
            } else {
                $httpBody = $inventory_archive_inventory_items_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation batchGetInventoryItemChannelSKUs
     *
     * BatchGetInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest $inventory_batch_get_inventory_item_channel_skus_request inventory_batch_get_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchGetInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemChannelSkuResponse[]
     */
    public function batchGetInventoryItemChannelSKUs($inventory_batch_get_inventory_item_channel_skus_request, string $contentType = self::contentTypes['batchGetInventoryItemChannelSKUs'][0])
    {
        list($response) = $this->batchGetInventoryItemChannelSKUsWithHttpInfo($inventory_batch_get_inventory_item_channel_skus_request, $contentType);
        return $response;
    }

    /**
     * Operation batchGetInventoryItemChannelSKUsWithHttpInfo
     *
     * BatchGetInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest $inventory_batch_get_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchGetInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemChannelSkuResponse[], HTTP status code, HTTP response headers (array of strings)
     */
    public function batchGetInventoryItemChannelSKUsWithHttpInfo($inventory_batch_get_inventory_item_channel_skus_request, string $contentType = self::contentTypes['batchGetInventoryItemChannelSKUs'][0])
    {
        $request = $this->batchGetInventoryItemChannelSKUsRequest($inventory_batch_get_inventory_item_channel_skus_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation batchGetInventoryItemChannelSKUsAsync
     *
     * BatchGetInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest $inventory_batch_get_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchGetInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchGetInventoryItemChannelSKUsAsync($inventory_batch_get_inventory_item_channel_skus_request, string $contentType = self::contentTypes['batchGetInventoryItemChannelSKUs'][0])
    {
        return $this->batchGetInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_batch_get_inventory_item_channel_skus_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation batchGetInventoryItemChannelSKUsAsyncWithHttpInfo
     *
     * BatchGetInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest $inventory_batch_get_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchGetInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchGetInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_batch_get_inventory_item_channel_skus_request, string $contentType = self::contentTypes['batchGetInventoryItemChannelSKUs'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]';
        $request = $this->batchGetInventoryItemChannelSKUsRequest($inventory_batch_get_inventory_item_channel_skus_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'batchGetInventoryItemChannelSKUs'
     *
     * @param  \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest $inventory_batch_get_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['batchGetInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function batchGetInventoryItemChannelSKUsRequest($inventory_batch_get_inventory_item_channel_skus_request, string $contentType = self::contentTypes['batchGetInventoryItemChannelSKUs'][0])
    {

        // verify the required parameter 'inventory_batch_get_inventory_item_channel_skus_request' is set
        if ($inventory_batch_get_inventory_item_channel_skus_request === null || (is_array($inventory_batch_get_inventory_item_channel_skus_request) && count($inventory_batch_get_inventory_item_channel_skus_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_batch_get_inventory_item_channel_skus_request when calling batchGetInventoryItemChannelSKUs'
            );
        }


        $resourcePath = '/api/Inventory/BatchGetInventoryItemChannelSKUs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_batch_get_inventory_item_channel_skus_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_batch_get_inventory_item_channel_skus_request));
            } else {
                $httpBody = $inventory_batch_get_inventory_item_channel_skus_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation bulkScrapBatchedItems
     *
     * BulkScrapBatchedItems
     *
     * @param  \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bulkScrapBatchedItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function bulkScrapBatchedItems($request = null, string $contentType = self::contentTypes['bulkScrapBatchedItems'][0])
    {
        $this->bulkScrapBatchedItemsWithHttpInfo($request, $contentType);
    }

    /**
     * Operation bulkScrapBatchedItemsWithHttpInfo
     *
     * BulkScrapBatchedItems
     *
     * @param  \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bulkScrapBatchedItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function bulkScrapBatchedItemsWithHttpInfo($request = null, string $contentType = self::contentTypes['bulkScrapBatchedItems'][0])
    {
        $request = $this->bulkScrapBatchedItemsRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation bulkScrapBatchedItemsAsync
     *
     * BulkScrapBatchedItems
     *
     * @param  \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bulkScrapBatchedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bulkScrapBatchedItemsAsync($request = null, string $contentType = self::contentTypes['bulkScrapBatchedItems'][0])
    {
        return $this->bulkScrapBatchedItemsAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation bulkScrapBatchedItemsAsyncWithHttpInfo
     *
     * BulkScrapBatchedItems
     *
     * @param  \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bulkScrapBatchedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function bulkScrapBatchedItemsAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['bulkScrapBatchedItems'][0])
    {
        $returnType = '';
        $request = $this->bulkScrapBatchedItemsRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'bulkScrapBatchedItems'
     *
     * @param  \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['bulkScrapBatchedItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function bulkScrapBatchedItemsRequest($request = null, string $contentType = self::contentTypes['bulkScrapBatchedItems'][0])
    {



        $resourcePath = '/api/Inventory/BulkScrapBatchedItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBatches
     *
     * CreateBatches
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateBatchesRequest $inventory_create_batches_request inventory_create_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createBatches($inventory_create_batches_request, string $contentType = self::contentTypes['createBatches'][0])
    {
        $this->createBatchesWithHttpInfo($inventory_create_batches_request, $contentType);
    }

    /**
     * Operation createBatchesWithHttpInfo
     *
     * CreateBatches
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateBatchesRequest $inventory_create_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatches'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBatchesWithHttpInfo($inventory_create_batches_request, string $contentType = self::contentTypes['createBatches'][0])
    {
        $request = $this->createBatchesRequest($inventory_create_batches_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createBatchesAsync
     *
     * CreateBatches
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateBatchesRequest $inventory_create_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchesAsync($inventory_create_batches_request, string $contentType = self::contentTypes['createBatches'][0])
    {
        return $this->createBatchesAsyncWithHttpInfo($inventory_create_batches_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBatchesAsyncWithHttpInfo
     *
     * CreateBatches
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateBatchesRequest $inventory_create_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBatchesAsyncWithHttpInfo($inventory_create_batches_request, string $contentType = self::contentTypes['createBatches'][0])
    {
        $returnType = '';
        $request = $this->createBatchesRequest($inventory_create_batches_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBatches'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateBatchesRequest $inventory_create_batches_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBatches'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBatchesRequest($inventory_create_batches_request, string $contentType = self::contentTypes['createBatches'][0])
    {

        // verify the required parameter 'inventory_create_batches_request' is set
        if ($inventory_create_batches_request === null || (is_array($inventory_create_batches_request) && count($inventory_create_batches_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_batches_request when calling createBatches'
            );
        }


        $resourcePath = '/api/Inventory/CreateBatches';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_batches_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_batches_request));
            } else {
                $httpBody = $inventory_create_batches_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCategory
     *
     * CreateCategory
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCategoryRequest $inventory_create_category_request inventory_create_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\LinnworksCategory
     */
    public function createCategory($inventory_create_category_request, string $contentType = self::contentTypes['createCategory'][0])
    {
        list($response) = $this->createCategoryWithHttpInfo($inventory_create_category_request, $contentType);
        return $response;
    }

    /**
     * Operation createCategoryWithHttpInfo
     *
     * CreateCategory
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCategoryRequest $inventory_create_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\LinnworksCategory, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCategoryWithHttpInfo($inventory_create_category_request, string $contentType = self::contentTypes['createCategory'][0])
    {
        $request = $this->createCategoryRequest($inventory_create_category_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\LinnworksCategory' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\LinnworksCategory' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\LinnworksCategory', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\LinnworksCategory';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\LinnworksCategory',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCategoryAsync
     *
     * CreateCategory
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCategoryRequest $inventory_create_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCategoryAsync($inventory_create_category_request, string $contentType = self::contentTypes['createCategory'][0])
    {
        return $this->createCategoryAsyncWithHttpInfo($inventory_create_category_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCategoryAsyncWithHttpInfo
     *
     * CreateCategory
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCategoryRequest $inventory_create_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCategoryAsyncWithHttpInfo($inventory_create_category_request, string $contentType = self::contentTypes['createCategory'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\LinnworksCategory';
        $request = $this->createCategoryRequest($inventory_create_category_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCategory'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCategoryRequest $inventory_create_category_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCategory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCategoryRequest($inventory_create_category_request, string $contentType = self::contentTypes['createCategory'][0])
    {

        // verify the required parameter 'inventory_create_category_request' is set
        if ($inventory_create_category_request === null || (is_array($inventory_create_category_request) && count($inventory_create_category_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_category_request when calling createCategory'
            );
        }


        $resourcePath = '/api/Inventory/CreateCategory';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_category_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_category_request));
            } else {
                $httpBody = $inventory_create_category_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCountries
     *
     * CreateCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountriesRequest $inventory_create_countries_request inventory_create_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createCountries($inventory_create_countries_request, string $contentType = self::contentTypes['createCountries'][0])
    {
        $this->createCountriesWithHttpInfo($inventory_create_countries_request, $contentType);
    }

    /**
     * Operation createCountriesWithHttpInfo
     *
     * CreateCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountriesRequest $inventory_create_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCountriesWithHttpInfo($inventory_create_countries_request, string $contentType = self::contentTypes['createCountries'][0])
    {
        $request = $this->createCountriesRequest($inventory_create_countries_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createCountriesAsync
     *
     * CreateCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountriesRequest $inventory_create_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCountriesAsync($inventory_create_countries_request, string $contentType = self::contentTypes['createCountries'][0])
    {
        return $this->createCountriesAsyncWithHttpInfo($inventory_create_countries_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCountriesAsyncWithHttpInfo
     *
     * CreateCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountriesRequest $inventory_create_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCountriesAsyncWithHttpInfo($inventory_create_countries_request, string $contentType = self::contentTypes['createCountries'][0])
    {
        $returnType = '';
        $request = $this->createCountriesRequest($inventory_create_countries_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCountries'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountriesRequest $inventory_create_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCountriesRequest($inventory_create_countries_request, string $contentType = self::contentTypes['createCountries'][0])
    {

        // verify the required parameter 'inventory_create_countries_request' is set
        if ($inventory_create_countries_request === null || (is_array($inventory_create_countries_request) && count($inventory_create_countries_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_countries_request when calling createCountries'
            );
        }


        $resourcePath = '/api/Inventory/CreateCountries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_countries_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_countries_request));
            } else {
                $httpBody = $inventory_create_countries_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createCountryRegions
     *
     * CreateCountryRegions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest $inventory_create_country_regions_request inventory_create_country_regions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountryRegions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\CreateCountryRegionsResponse
     */
    public function createCountryRegions($inventory_create_country_regions_request, string $contentType = self::contentTypes['createCountryRegions'][0])
    {
        list($response) = $this->createCountryRegionsWithHttpInfo($inventory_create_country_regions_request, $contentType);
        return $response;
    }

    /**
     * Operation createCountryRegionsWithHttpInfo
     *
     * CreateCountryRegions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest $inventory_create_country_regions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountryRegions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\CreateCountryRegionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCountryRegionsWithHttpInfo($inventory_create_country_regions_request, string $contentType = self::contentTypes['createCountryRegions'][0])
    {
        $request = $this->createCountryRegionsRequest($inventory_create_country_regions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\CreateCountryRegionsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\CreateCountryRegionsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\CreateCountryRegionsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\CreateCountryRegionsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\CreateCountryRegionsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createCountryRegionsAsync
     *
     * CreateCountryRegions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest $inventory_create_country_regions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountryRegions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCountryRegionsAsync($inventory_create_country_regions_request, string $contentType = self::contentTypes['createCountryRegions'][0])
    {
        return $this->createCountryRegionsAsyncWithHttpInfo($inventory_create_country_regions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createCountryRegionsAsyncWithHttpInfo
     *
     * CreateCountryRegions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest $inventory_create_country_regions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountryRegions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createCountryRegionsAsyncWithHttpInfo($inventory_create_country_regions_request, string $contentType = self::contentTypes['createCountryRegions'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\CreateCountryRegionsResponse';
        $request = $this->createCountryRegionsRequest($inventory_create_country_regions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createCountryRegions'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest $inventory_create_country_regions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createCountryRegions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createCountryRegionsRequest($inventory_create_country_regions_request, string $contentType = self::contentTypes['createCountryRegions'][0])
    {

        // verify the required parameter 'inventory_create_country_regions_request' is set
        if ($inventory_create_country_regions_request === null || (is_array($inventory_create_country_regions_request) && count($inventory_create_country_regions_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_country_regions_request when calling createCountryRegions'
            );
        }


        $resourcePath = '/api/Inventory/CreateCountryRegions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_country_regions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_country_regions_request));
            } else {
                $httpBody = $inventory_create_country_regions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemChannelSKUs
     *
     * CreateInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest $inventory_create_inventory_item_channel_skus_request inventory_create_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemChannelSKUs($inventory_create_inventory_item_channel_skus_request, string $contentType = self::contentTypes['createInventoryItemChannelSKUs'][0])
    {
        $this->createInventoryItemChannelSKUsWithHttpInfo($inventory_create_inventory_item_channel_skus_request, $contentType);
    }

    /**
     * Operation createInventoryItemChannelSKUsWithHttpInfo
     *
     * CreateInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest $inventory_create_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemChannelSKUsWithHttpInfo($inventory_create_inventory_item_channel_skus_request, string $contentType = self::contentTypes['createInventoryItemChannelSKUs'][0])
    {
        $request = $this->createInventoryItemChannelSKUsRequest($inventory_create_inventory_item_channel_skus_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemChannelSKUsAsync
     *
     * CreateInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest $inventory_create_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemChannelSKUsAsync($inventory_create_inventory_item_channel_skus_request, string $contentType = self::contentTypes['createInventoryItemChannelSKUs'][0])
    {
        return $this->createInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_create_inventory_item_channel_skus_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemChannelSKUsAsyncWithHttpInfo
     *
     * CreateInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest $inventory_create_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_create_inventory_item_channel_skus_request, string $contentType = self::contentTypes['createInventoryItemChannelSKUs'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemChannelSKUsRequest($inventory_create_inventory_item_channel_skus_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemChannelSKUs'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest $inventory_create_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemChannelSKUsRequest($inventory_create_inventory_item_channel_skus_request, string $contentType = self::contentTypes['createInventoryItemChannelSKUs'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_channel_skus_request' is set
        if ($inventory_create_inventory_item_channel_skus_request === null || (is_array($inventory_create_inventory_item_channel_skus_request) && count($inventory_create_inventory_item_channel_skus_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_channel_skus_request when calling createInventoryItemChannelSKUs'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemChannelSKUs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_channel_skus_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_channel_skus_request));
            } else {
                $httpBody = $inventory_create_inventory_item_channel_skus_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemCompositions
     *
     * CreateInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest $inventory_create_inventory_item_compositions_request inventory_create_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemCompositions($inventory_create_inventory_item_compositions_request, string $contentType = self::contentTypes['createInventoryItemCompositions'][0])
    {
        $this->createInventoryItemCompositionsWithHttpInfo($inventory_create_inventory_item_compositions_request, $contentType);
    }

    /**
     * Operation createInventoryItemCompositionsWithHttpInfo
     *
     * CreateInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest $inventory_create_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemCompositionsWithHttpInfo($inventory_create_inventory_item_compositions_request, string $contentType = self::contentTypes['createInventoryItemCompositions'][0])
    {
        $request = $this->createInventoryItemCompositionsRequest($inventory_create_inventory_item_compositions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemCompositionsAsync
     *
     * CreateInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest $inventory_create_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemCompositionsAsync($inventory_create_inventory_item_compositions_request, string $contentType = self::contentTypes['createInventoryItemCompositions'][0])
    {
        return $this->createInventoryItemCompositionsAsyncWithHttpInfo($inventory_create_inventory_item_compositions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemCompositionsAsyncWithHttpInfo
     *
     * CreateInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest $inventory_create_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemCompositionsAsyncWithHttpInfo($inventory_create_inventory_item_compositions_request, string $contentType = self::contentTypes['createInventoryItemCompositions'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemCompositionsRequest($inventory_create_inventory_item_compositions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemCompositions'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest $inventory_create_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemCompositionsRequest($inventory_create_inventory_item_compositions_request, string $contentType = self::contentTypes['createInventoryItemCompositions'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_compositions_request' is set
        if ($inventory_create_inventory_item_compositions_request === null || (is_array($inventory_create_inventory_item_compositions_request) && count($inventory_create_inventory_item_compositions_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_compositions_request when calling createInventoryItemCompositions'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemCompositions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_compositions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_compositions_request));
            } else {
                $httpBody = $inventory_create_inventory_item_compositions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemDescriptions
     *
     * CreateInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest $inventory_create_inventory_item_descriptions_request inventory_create_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemDescriptions($inventory_create_inventory_item_descriptions_request, string $contentType = self::contentTypes['createInventoryItemDescriptions'][0])
    {
        $this->createInventoryItemDescriptionsWithHttpInfo($inventory_create_inventory_item_descriptions_request, $contentType);
    }

    /**
     * Operation createInventoryItemDescriptionsWithHttpInfo
     *
     * CreateInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest $inventory_create_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemDescriptionsWithHttpInfo($inventory_create_inventory_item_descriptions_request, string $contentType = self::contentTypes['createInventoryItemDescriptions'][0])
    {
        $request = $this->createInventoryItemDescriptionsRequest($inventory_create_inventory_item_descriptions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemDescriptionsAsync
     *
     * CreateInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest $inventory_create_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemDescriptionsAsync($inventory_create_inventory_item_descriptions_request, string $contentType = self::contentTypes['createInventoryItemDescriptions'][0])
    {
        return $this->createInventoryItemDescriptionsAsyncWithHttpInfo($inventory_create_inventory_item_descriptions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemDescriptionsAsyncWithHttpInfo
     *
     * CreateInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest $inventory_create_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemDescriptionsAsyncWithHttpInfo($inventory_create_inventory_item_descriptions_request, string $contentType = self::contentTypes['createInventoryItemDescriptions'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemDescriptionsRequest($inventory_create_inventory_item_descriptions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemDescriptions'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest $inventory_create_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemDescriptionsRequest($inventory_create_inventory_item_descriptions_request, string $contentType = self::contentTypes['createInventoryItemDescriptions'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_descriptions_request' is set
        if ($inventory_create_inventory_item_descriptions_request === null || (is_array($inventory_create_inventory_item_descriptions_request) && count($inventory_create_inventory_item_descriptions_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_descriptions_request when calling createInventoryItemDescriptions'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemDescriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_descriptions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_descriptions_request));
            } else {
                $httpBody = $inventory_create_inventory_item_descriptions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemExtendedProperties
     *
     * CreateInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest $inventory_create_inventory_item_extended_properties_request inventory_create_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemExtendedProperties($inventory_create_inventory_item_extended_properties_request, string $contentType = self::contentTypes['createInventoryItemExtendedProperties'][0])
    {
        $this->createInventoryItemExtendedPropertiesWithHttpInfo($inventory_create_inventory_item_extended_properties_request, $contentType);
    }

    /**
     * Operation createInventoryItemExtendedPropertiesWithHttpInfo
     *
     * CreateInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest $inventory_create_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemExtendedPropertiesWithHttpInfo($inventory_create_inventory_item_extended_properties_request, string $contentType = self::contentTypes['createInventoryItemExtendedProperties'][0])
    {
        $request = $this->createInventoryItemExtendedPropertiesRequest($inventory_create_inventory_item_extended_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemExtendedPropertiesAsync
     *
     * CreateInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest $inventory_create_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemExtendedPropertiesAsync($inventory_create_inventory_item_extended_properties_request, string $contentType = self::contentTypes['createInventoryItemExtendedProperties'][0])
    {
        return $this->createInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_create_inventory_item_extended_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemExtendedPropertiesAsyncWithHttpInfo
     *
     * CreateInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest $inventory_create_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_create_inventory_item_extended_properties_request, string $contentType = self::contentTypes['createInventoryItemExtendedProperties'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemExtendedPropertiesRequest($inventory_create_inventory_item_extended_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemExtendedProperties'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest $inventory_create_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemExtendedPropertiesRequest($inventory_create_inventory_item_extended_properties_request, string $contentType = self::contentTypes['createInventoryItemExtendedProperties'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_extended_properties_request' is set
        if ($inventory_create_inventory_item_extended_properties_request === null || (is_array($inventory_create_inventory_item_extended_properties_request) && count($inventory_create_inventory_item_extended_properties_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_extended_properties_request when calling createInventoryItemExtendedProperties'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_extended_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_extended_properties_request));
            } else {
                $httpBody = $inventory_create_inventory_item_extended_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemPrices
     *
     * CreateInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest $inventory_create_inventory_item_prices_request inventory_create_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemPrices($inventory_create_inventory_item_prices_request, string $contentType = self::contentTypes['createInventoryItemPrices'][0])
    {
        $this->createInventoryItemPricesWithHttpInfo($inventory_create_inventory_item_prices_request, $contentType);
    }

    /**
     * Operation createInventoryItemPricesWithHttpInfo
     *
     * CreateInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest $inventory_create_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemPricesWithHttpInfo($inventory_create_inventory_item_prices_request, string $contentType = self::contentTypes['createInventoryItemPrices'][0])
    {
        $request = $this->createInventoryItemPricesRequest($inventory_create_inventory_item_prices_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemPricesAsync
     *
     * CreateInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest $inventory_create_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemPricesAsync($inventory_create_inventory_item_prices_request, string $contentType = self::contentTypes['createInventoryItemPrices'][0])
    {
        return $this->createInventoryItemPricesAsyncWithHttpInfo($inventory_create_inventory_item_prices_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemPricesAsyncWithHttpInfo
     *
     * CreateInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest $inventory_create_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemPricesAsyncWithHttpInfo($inventory_create_inventory_item_prices_request, string $contentType = self::contentTypes['createInventoryItemPrices'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemPricesRequest($inventory_create_inventory_item_prices_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemPrices'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest $inventory_create_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemPricesRequest($inventory_create_inventory_item_prices_request, string $contentType = self::contentTypes['createInventoryItemPrices'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_prices_request' is set
        if ($inventory_create_inventory_item_prices_request === null || (is_array($inventory_create_inventory_item_prices_request) && count($inventory_create_inventory_item_prices_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_prices_request when calling createInventoryItemPrices'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemPrices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_prices_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_prices_request));
            } else {
                $httpBody = $inventory_create_inventory_item_prices_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemPricingRules
     *
     * CreateInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest $inventory_create_inventory_item_pricing_rules_request inventory_create_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemPricingRules($inventory_create_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['createInventoryItemPricingRules'][0])
    {
        $this->createInventoryItemPricingRulesWithHttpInfo($inventory_create_inventory_item_pricing_rules_request, $contentType);
    }

    /**
     * Operation createInventoryItemPricingRulesWithHttpInfo
     *
     * CreateInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest $inventory_create_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemPricingRulesWithHttpInfo($inventory_create_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['createInventoryItemPricingRules'][0])
    {
        $request = $this->createInventoryItemPricingRulesRequest($inventory_create_inventory_item_pricing_rules_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemPricingRulesAsync
     *
     * CreateInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest $inventory_create_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemPricingRulesAsync($inventory_create_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['createInventoryItemPricingRules'][0])
    {
        return $this->createInventoryItemPricingRulesAsyncWithHttpInfo($inventory_create_inventory_item_pricing_rules_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemPricingRulesAsyncWithHttpInfo
     *
     * CreateInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest $inventory_create_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemPricingRulesAsyncWithHttpInfo($inventory_create_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['createInventoryItemPricingRules'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemPricingRulesRequest($inventory_create_inventory_item_pricing_rules_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemPricingRules'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest $inventory_create_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemPricingRulesRequest($inventory_create_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['createInventoryItemPricingRules'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_pricing_rules_request' is set
        if ($inventory_create_inventory_item_pricing_rules_request === null || (is_array($inventory_create_inventory_item_pricing_rules_request) && count($inventory_create_inventory_item_pricing_rules_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_pricing_rules_request when calling createInventoryItemPricingRules'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemPricingRules';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_pricing_rules_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_pricing_rules_request));
            } else {
                $httpBody = $inventory_create_inventory_item_pricing_rules_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInventoryItemTitles
     *
     * CreateInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest $inventory_create_inventory_item_titles_request inventory_create_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createInventoryItemTitles($inventory_create_inventory_item_titles_request, string $contentType = self::contentTypes['createInventoryItemTitles'][0])
    {
        $this->createInventoryItemTitlesWithHttpInfo($inventory_create_inventory_item_titles_request, $contentType);
    }

    /**
     * Operation createInventoryItemTitlesWithHttpInfo
     *
     * CreateInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest $inventory_create_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInventoryItemTitlesWithHttpInfo($inventory_create_inventory_item_titles_request, string $contentType = self::contentTypes['createInventoryItemTitles'][0])
    {
        $request = $this->createInventoryItemTitlesRequest($inventory_create_inventory_item_titles_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createInventoryItemTitlesAsync
     *
     * CreateInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest $inventory_create_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemTitlesAsync($inventory_create_inventory_item_titles_request, string $contentType = self::contentTypes['createInventoryItemTitles'][0])
    {
        return $this->createInventoryItemTitlesAsyncWithHttpInfo($inventory_create_inventory_item_titles_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInventoryItemTitlesAsyncWithHttpInfo
     *
     * CreateInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest $inventory_create_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInventoryItemTitlesAsyncWithHttpInfo($inventory_create_inventory_item_titles_request, string $contentType = self::contentTypes['createInventoryItemTitles'][0])
    {
        $returnType = '';
        $request = $this->createInventoryItemTitlesRequest($inventory_create_inventory_item_titles_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInventoryItemTitles'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest $inventory_create_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInventoryItemTitlesRequest($inventory_create_inventory_item_titles_request, string $contentType = self::contentTypes['createInventoryItemTitles'][0])
    {

        // verify the required parameter 'inventory_create_inventory_item_titles_request' is set
        if ($inventory_create_inventory_item_titles_request === null || (is_array($inventory_create_inventory_item_titles_request) && count($inventory_create_inventory_item_titles_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_inventory_item_titles_request when calling createInventoryItemTitles'
            );
        }


        $resourcePath = '/api/Inventory/CreateInventoryItemTitles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_inventory_item_titles_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_inventory_item_titles_request));
            } else {
                $httpBody = $inventory_create_inventory_item_titles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createStockSupplierStat
     *
     * CreateStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest $inventory_create_stock_supplier_stat_request inventory_create_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createStockSupplierStat($inventory_create_stock_supplier_stat_request, string $contentType = self::contentTypes['createStockSupplierStat'][0])
    {
        $this->createStockSupplierStatWithHttpInfo($inventory_create_stock_supplier_stat_request, $contentType);
    }

    /**
     * Operation createStockSupplierStatWithHttpInfo
     *
     * CreateStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest $inventory_create_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createStockSupplierStatWithHttpInfo($inventory_create_stock_supplier_stat_request, string $contentType = self::contentTypes['createStockSupplierStat'][0])
    {
        $request = $this->createStockSupplierStatRequest($inventory_create_stock_supplier_stat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createStockSupplierStatAsync
     *
     * CreateStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest $inventory_create_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createStockSupplierStatAsync($inventory_create_stock_supplier_stat_request, string $contentType = self::contentTypes['createStockSupplierStat'][0])
    {
        return $this->createStockSupplierStatAsyncWithHttpInfo($inventory_create_stock_supplier_stat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createStockSupplierStatAsyncWithHttpInfo
     *
     * CreateStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest $inventory_create_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createStockSupplierStatAsyncWithHttpInfo($inventory_create_stock_supplier_stat_request, string $contentType = self::contentTypes['createStockSupplierStat'][0])
    {
        $returnType = '';
        $request = $this->createStockSupplierStatRequest($inventory_create_stock_supplier_stat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createStockSupplierStat'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest $inventory_create_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createStockSupplierStatRequest($inventory_create_stock_supplier_stat_request, string $contentType = self::contentTypes['createStockSupplierStat'][0])
    {

        // verify the required parameter 'inventory_create_stock_supplier_stat_request' is set
        if ($inventory_create_stock_supplier_stat_request === null || (is_array($inventory_create_stock_supplier_stat_request) && count($inventory_create_stock_supplier_stat_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_stock_supplier_stat_request when calling createStockSupplierStat'
            );
        }


        $resourcePath = '/api/Inventory/CreateStockSupplierStat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_stock_supplier_stat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_stock_supplier_stat_request));
            } else {
                $httpBody = $inventory_create_stock_supplier_stat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createUserSpecificView
     *
     * CreateUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest $inventory_create_user_specific_view_request inventory_create_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserSpecificView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createUserSpecificView($inventory_create_user_specific_view_request, string $contentType = self::contentTypes['createUserSpecificView'][0])
    {
        $this->createUserSpecificViewWithHttpInfo($inventory_create_user_specific_view_request, $contentType);
    }

    /**
     * Operation createUserSpecificViewWithHttpInfo
     *
     * CreateUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest $inventory_create_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserSpecificView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserSpecificViewWithHttpInfo($inventory_create_user_specific_view_request, string $contentType = self::contentTypes['createUserSpecificView'][0])
    {
        $request = $this->createUserSpecificViewRequest($inventory_create_user_specific_view_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createUserSpecificViewAsync
     *
     * CreateUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest $inventory_create_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserSpecificViewAsync($inventory_create_user_specific_view_request, string $contentType = self::contentTypes['createUserSpecificView'][0])
    {
        return $this->createUserSpecificViewAsyncWithHttpInfo($inventory_create_user_specific_view_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createUserSpecificViewAsyncWithHttpInfo
     *
     * CreateUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest $inventory_create_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserSpecificViewAsyncWithHttpInfo($inventory_create_user_specific_view_request, string $contentType = self::contentTypes['createUserSpecificView'][0])
    {
        $returnType = '';
        $request = $this->createUserSpecificViewRequest($inventory_create_user_specific_view_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createUserSpecificView'
     *
     * @param  \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest $inventory_create_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createUserSpecificViewRequest($inventory_create_user_specific_view_request, string $contentType = self::contentTypes['createUserSpecificView'][0])
    {

        // verify the required parameter 'inventory_create_user_specific_view_request' is set
        if ($inventory_create_user_specific_view_request === null || (is_array($inventory_create_user_specific_view_request) && count($inventory_create_user_specific_view_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_create_user_specific_view_request when calling createUserSpecificView'
            );
        }


        $resourcePath = '/api/Inventory/CreateUserSpecificView';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_create_user_specific_view_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_create_user_specific_view_request));
            } else {
                $httpBody = $inventory_create_user_specific_view_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBatchInventoryInBulk
     *
     * DeleteBatchInventoryInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest $inventory_delete_batch_inventory_in_bulk_request inventory_delete_batch_inventory_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchInventoryInBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBatchInventoryInBulk($inventory_delete_batch_inventory_in_bulk_request, string $contentType = self::contentTypes['deleteBatchInventoryInBulk'][0])
    {
        $this->deleteBatchInventoryInBulkWithHttpInfo($inventory_delete_batch_inventory_in_bulk_request, $contentType);
    }

    /**
     * Operation deleteBatchInventoryInBulkWithHttpInfo
     *
     * DeleteBatchInventoryInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest $inventory_delete_batch_inventory_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchInventoryInBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBatchInventoryInBulkWithHttpInfo($inventory_delete_batch_inventory_in_bulk_request, string $contentType = self::contentTypes['deleteBatchInventoryInBulk'][0])
    {
        $request = $this->deleteBatchInventoryInBulkRequest($inventory_delete_batch_inventory_in_bulk_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBatchInventoryInBulkAsync
     *
     * DeleteBatchInventoryInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest $inventory_delete_batch_inventory_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchInventoryInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBatchInventoryInBulkAsync($inventory_delete_batch_inventory_in_bulk_request, string $contentType = self::contentTypes['deleteBatchInventoryInBulk'][0])
    {
        return $this->deleteBatchInventoryInBulkAsyncWithHttpInfo($inventory_delete_batch_inventory_in_bulk_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBatchInventoryInBulkAsyncWithHttpInfo
     *
     * DeleteBatchInventoryInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest $inventory_delete_batch_inventory_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchInventoryInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBatchInventoryInBulkAsyncWithHttpInfo($inventory_delete_batch_inventory_in_bulk_request, string $contentType = self::contentTypes['deleteBatchInventoryInBulk'][0])
    {
        $returnType = '';
        $request = $this->deleteBatchInventoryInBulkRequest($inventory_delete_batch_inventory_in_bulk_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBatchInventoryInBulk'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest $inventory_delete_batch_inventory_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchInventoryInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBatchInventoryInBulkRequest($inventory_delete_batch_inventory_in_bulk_request, string $contentType = self::contentTypes['deleteBatchInventoryInBulk'][0])
    {

        // verify the required parameter 'inventory_delete_batch_inventory_in_bulk_request' is set
        if ($inventory_delete_batch_inventory_in_bulk_request === null || (is_array($inventory_delete_batch_inventory_in_bulk_request) && count($inventory_delete_batch_inventory_in_bulk_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_batch_inventory_in_bulk_request when calling deleteBatchInventoryInBulk'
            );
        }


        $resourcePath = '/api/Inventory/DeleteBatchInventoryInBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_batch_inventory_in_bulk_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_batch_inventory_in_bulk_request));
            } else {
                $httpBody = $inventory_delete_batch_inventory_in_bulk_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBatchesByStockItemId
     *
     * DeleteBatchesByStockItemId
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest $inventory_delete_batches_by_stock_item_id_request inventory_delete_batches_by_stock_item_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteBatchesByStockItemId($inventory_delete_batches_by_stock_item_id_request, string $contentType = self::contentTypes['deleteBatchesByStockItemId'][0])
    {
        $this->deleteBatchesByStockItemIdWithHttpInfo($inventory_delete_batches_by_stock_item_id_request, $contentType);
    }

    /**
     * Operation deleteBatchesByStockItemIdWithHttpInfo
     *
     * DeleteBatchesByStockItemId
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest $inventory_delete_batches_by_stock_item_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBatchesByStockItemIdWithHttpInfo($inventory_delete_batches_by_stock_item_id_request, string $contentType = self::contentTypes['deleteBatchesByStockItemId'][0])
    {
        $request = $this->deleteBatchesByStockItemIdRequest($inventory_delete_batches_by_stock_item_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBatchesByStockItemIdAsync
     *
     * DeleteBatchesByStockItemId
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest $inventory_delete_batches_by_stock_item_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBatchesByStockItemIdAsync($inventory_delete_batches_by_stock_item_id_request, string $contentType = self::contentTypes['deleteBatchesByStockItemId'][0])
    {
        return $this->deleteBatchesByStockItemIdAsyncWithHttpInfo($inventory_delete_batches_by_stock_item_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBatchesByStockItemIdAsyncWithHttpInfo
     *
     * DeleteBatchesByStockItemId
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest $inventory_delete_batches_by_stock_item_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBatchesByStockItemIdAsyncWithHttpInfo($inventory_delete_batches_by_stock_item_id_request, string $contentType = self::contentTypes['deleteBatchesByStockItemId'][0])
    {
        $returnType = '';
        $request = $this->deleteBatchesByStockItemIdRequest($inventory_delete_batches_by_stock_item_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBatchesByStockItemId'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest $inventory_delete_batches_by_stock_item_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBatchesByStockItemIdRequest($inventory_delete_batches_by_stock_item_id_request, string $contentType = self::contentTypes['deleteBatchesByStockItemId'][0])
    {

        // verify the required parameter 'inventory_delete_batches_by_stock_item_id_request' is set
        if ($inventory_delete_batches_by_stock_item_id_request === null || (is_array($inventory_delete_batches_by_stock_item_id_request) && count($inventory_delete_batches_by_stock_item_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_batches_by_stock_item_id_request when calling deleteBatchesByStockItemId'
            );
        }


        $resourcePath = '/api/Inventory/DeleteBatchesByStockItemId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_batches_by_stock_item_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_batches_by_stock_item_id_request));
            } else {
                $httpBody = $inventory_delete_batches_by_stock_item_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCategoryById
     *
     * DeleteCategoryById
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest $inventory_delete_category_by_id_request inventory_delete_category_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCategoryById($inventory_delete_category_by_id_request, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $this->deleteCategoryByIdWithHttpInfo($inventory_delete_category_by_id_request, $contentType);
    }

    /**
     * Operation deleteCategoryByIdWithHttpInfo
     *
     * DeleteCategoryById
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest $inventory_delete_category_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCategoryByIdWithHttpInfo($inventory_delete_category_by_id_request, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $request = $this->deleteCategoryByIdRequest($inventory_delete_category_by_id_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCategoryByIdAsync
     *
     * DeleteCategoryById
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest $inventory_delete_category_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoryByIdAsync($inventory_delete_category_by_id_request, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        return $this->deleteCategoryByIdAsyncWithHttpInfo($inventory_delete_category_by_id_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCategoryByIdAsyncWithHttpInfo
     *
     * DeleteCategoryById
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest $inventory_delete_category_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCategoryByIdAsyncWithHttpInfo($inventory_delete_category_by_id_request, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {
        $returnType = '';
        $request = $this->deleteCategoryByIdRequest($inventory_delete_category_by_id_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCategoryById'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest $inventory_delete_category_by_id_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCategoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCategoryByIdRequest($inventory_delete_category_by_id_request, string $contentType = self::contentTypes['deleteCategoryById'][0])
    {

        // verify the required parameter 'inventory_delete_category_by_id_request' is set
        if ($inventory_delete_category_by_id_request === null || (is_array($inventory_delete_category_by_id_request) && count($inventory_delete_category_by_id_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_category_by_id_request when calling deleteCategoryById'
            );
        }


        $resourcePath = '/api/Inventory/DeleteCategoryById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_category_by_id_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_category_by_id_request));
            } else {
                $httpBody = $inventory_delete_category_by_id_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteCountries
     *
     * DeleteCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest $inventory_delete_countries_request inventory_delete_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteCountries($inventory_delete_countries_request, string $contentType = self::contentTypes['deleteCountries'][0])
    {
        $this->deleteCountriesWithHttpInfo($inventory_delete_countries_request, $contentType);
    }

    /**
     * Operation deleteCountriesWithHttpInfo
     *
     * DeleteCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest $inventory_delete_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCountriesWithHttpInfo($inventory_delete_countries_request, string $contentType = self::contentTypes['deleteCountries'][0])
    {
        $request = $this->deleteCountriesRequest($inventory_delete_countries_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCountriesAsync
     *
     * DeleteCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest $inventory_delete_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCountriesAsync($inventory_delete_countries_request, string $contentType = self::contentTypes['deleteCountries'][0])
    {
        return $this->deleteCountriesAsyncWithHttpInfo($inventory_delete_countries_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCountriesAsyncWithHttpInfo
     *
     * DeleteCountries
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest $inventory_delete_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCountriesAsyncWithHttpInfo($inventory_delete_countries_request, string $contentType = self::contentTypes['deleteCountries'][0])
    {
        $returnType = '';
        $request = $this->deleteCountriesRequest($inventory_delete_countries_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCountries'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest $inventory_delete_countries_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCountriesRequest($inventory_delete_countries_request, string $contentType = self::contentTypes['deleteCountries'][0])
    {

        // verify the required parameter 'inventory_delete_countries_request' is set
        if ($inventory_delete_countries_request === null || (is_array($inventory_delete_countries_request) && count($inventory_delete_countries_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_countries_request when calling deleteCountries'
            );
        }


        $resourcePath = '/api/Inventory/DeleteCountries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_countries_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_countries_request));
            } else {
                $httpBody = $inventory_delete_countries_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEbayCompatibilityList
     *
     * DeleteEbayCompatibilityList
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest $inventory_delete_ebay_compatibility_list_request inventory_delete_ebay_compatibility_list_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse
     */
    public function deleteEbayCompatibilityList($inventory_delete_ebay_compatibility_list_request, string $contentType = self::contentTypes['deleteEbayCompatibilityList'][0])
    {
        list($response) = $this->deleteEbayCompatibilityListWithHttpInfo($inventory_delete_ebay_compatibility_list_request, $contentType);
        return $response;
    }

    /**
     * Operation deleteEbayCompatibilityListWithHttpInfo
     *
     * DeleteEbayCompatibilityList
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest $inventory_delete_ebay_compatibility_list_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEbayCompatibilityListWithHttpInfo($inventory_delete_ebay_compatibility_list_request, string $contentType = self::contentTypes['deleteEbayCompatibilityList'][0])
    {
        $request = $this->deleteEbayCompatibilityListRequest($inventory_delete_ebay_compatibility_list_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteEbayCompatibilityListAsync
     *
     * DeleteEbayCompatibilityList
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest $inventory_delete_ebay_compatibility_list_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEbayCompatibilityListAsync($inventory_delete_ebay_compatibility_list_request, string $contentType = self::contentTypes['deleteEbayCompatibilityList'][0])
    {
        return $this->deleteEbayCompatibilityListAsyncWithHttpInfo($inventory_delete_ebay_compatibility_list_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteEbayCompatibilityListAsyncWithHttpInfo
     *
     * DeleteEbayCompatibilityList
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest $inventory_delete_ebay_compatibility_list_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEbayCompatibilityListAsyncWithHttpInfo($inventory_delete_ebay_compatibility_list_request, string $contentType = self::contentTypes['deleteEbayCompatibilityList'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse';
        $request = $this->deleteEbayCompatibilityListRequest($inventory_delete_ebay_compatibility_list_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEbayCompatibilityList'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest $inventory_delete_ebay_compatibility_list_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteEbayCompatibilityListRequest($inventory_delete_ebay_compatibility_list_request, string $contentType = self::contentTypes['deleteEbayCompatibilityList'][0])
    {

        // verify the required parameter 'inventory_delete_ebay_compatibility_list_request' is set
        if ($inventory_delete_ebay_compatibility_list_request === null || (is_array($inventory_delete_ebay_compatibility_list_request) && count($inventory_delete_ebay_compatibility_list_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_ebay_compatibility_list_request when calling deleteEbayCompatibilityList'
            );
        }


        $resourcePath = '/api/Inventory/DeleteEbayCompatibilityList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_ebay_compatibility_list_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_ebay_compatibility_list_request));
            } else {
                $httpBody = $inventory_delete_ebay_compatibility_list_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteImagesFromInventoryItem
     *
     * DeleteImagesFromInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest $inventory_delete_images_from_inventory_item_request inventory_delete_images_from_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImagesFromInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     * @deprecated
     */
    public function deleteImagesFromInventoryItem($inventory_delete_images_from_inventory_item_request, string $contentType = self::contentTypes['deleteImagesFromInventoryItem'][0])
    {
        $this->deleteImagesFromInventoryItemWithHttpInfo($inventory_delete_images_from_inventory_item_request, $contentType);
    }

    /**
     * Operation deleteImagesFromInventoryItemWithHttpInfo
     *
     * DeleteImagesFromInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest $inventory_delete_images_from_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImagesFromInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     * @deprecated
     */
    public function deleteImagesFromInventoryItemWithHttpInfo($inventory_delete_images_from_inventory_item_request, string $contentType = self::contentTypes['deleteImagesFromInventoryItem'][0])
    {
        $request = $this->deleteImagesFromInventoryItemRequest($inventory_delete_images_from_inventory_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteImagesFromInventoryItemAsync
     *
     * DeleteImagesFromInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest $inventory_delete_images_from_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImagesFromInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteImagesFromInventoryItemAsync($inventory_delete_images_from_inventory_item_request, string $contentType = self::contentTypes['deleteImagesFromInventoryItem'][0])
    {
        return $this->deleteImagesFromInventoryItemAsyncWithHttpInfo($inventory_delete_images_from_inventory_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteImagesFromInventoryItemAsyncWithHttpInfo
     *
     * DeleteImagesFromInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest $inventory_delete_images_from_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImagesFromInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     * @deprecated
     */
    public function deleteImagesFromInventoryItemAsyncWithHttpInfo($inventory_delete_images_from_inventory_item_request, string $contentType = self::contentTypes['deleteImagesFromInventoryItem'][0])
    {
        $returnType = '';
        $request = $this->deleteImagesFromInventoryItemRequest($inventory_delete_images_from_inventory_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteImagesFromInventoryItem'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest $inventory_delete_images_from_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteImagesFromInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     * @deprecated
     */
    public function deleteImagesFromInventoryItemRequest($inventory_delete_images_from_inventory_item_request, string $contentType = self::contentTypes['deleteImagesFromInventoryItem'][0])
    {

        // verify the required parameter 'inventory_delete_images_from_inventory_item_request' is set
        if ($inventory_delete_images_from_inventory_item_request === null || (is_array($inventory_delete_images_from_inventory_item_request) && count($inventory_delete_images_from_inventory_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_images_from_inventory_item_request when calling deleteImagesFromInventoryItem'
            );
        }


        $resourcePath = '/api/Inventory/DeleteImagesFromInventoryItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_images_from_inventory_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_images_from_inventory_item_request));
            } else {
                $httpBody = $inventory_delete_images_from_inventory_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemBulk
     *
     * DeleteInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse
     */
    public function deleteInventoryItemBulk($request = null, string $contentType = self::contentTypes['deleteInventoryItemBulk'][0])
    {
        list($response) = $this->deleteInventoryItemBulkWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation deleteInventoryItemBulkWithHttpInfo
     *
     * DeleteInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemBulkWithHttpInfo($request = null, string $contentType = self::contentTypes['deleteInventoryItemBulk'][0])
    {
        $request = $this->deleteInventoryItemBulkRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemBulkAsync
     *
     * DeleteInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemBulkAsync($request = null, string $contentType = self::contentTypes['deleteInventoryItemBulk'][0])
    {
        return $this->deleteInventoryItemBulkAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemBulkAsyncWithHttpInfo
     *
     * DeleteInventoryItemBulk
     *
     * @param  \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemBulkAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['deleteInventoryItemBulk'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse';
        $request = $this->deleteInventoryItemBulkRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemBulk'
     *
     * @param  \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemBulkRequest($request = null, string $contentType = self::contentTypes['deleteInventoryItemBulk'][0])
    {



        $resourcePath = '/api/Inventory/DeleteInventoryItemBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemChannelSKUs
     *
     * DeleteInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest $inventory_delete_inventory_item_channel_skus_request inventory_delete_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemChannelSKUs($inventory_delete_inventory_item_channel_skus_request, string $contentType = self::contentTypes['deleteInventoryItemChannelSKUs'][0])
    {
        $this->deleteInventoryItemChannelSKUsWithHttpInfo($inventory_delete_inventory_item_channel_skus_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemChannelSKUsWithHttpInfo
     *
     * DeleteInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest $inventory_delete_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemChannelSKUsWithHttpInfo($inventory_delete_inventory_item_channel_skus_request, string $contentType = self::contentTypes['deleteInventoryItemChannelSKUs'][0])
    {
        $request = $this->deleteInventoryItemChannelSKUsRequest($inventory_delete_inventory_item_channel_skus_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemChannelSKUsAsync
     *
     * DeleteInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest $inventory_delete_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemChannelSKUsAsync($inventory_delete_inventory_item_channel_skus_request, string $contentType = self::contentTypes['deleteInventoryItemChannelSKUs'][0])
    {
        return $this->deleteInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_delete_inventory_item_channel_skus_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemChannelSKUsAsyncWithHttpInfo
     *
     * DeleteInventoryItemChannelSKUs
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest $inventory_delete_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_delete_inventory_item_channel_skus_request, string $contentType = self::contentTypes['deleteInventoryItemChannelSKUs'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemChannelSKUsRequest($inventory_delete_inventory_item_channel_skus_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemChannelSKUs'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest $inventory_delete_inventory_item_channel_skus_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemChannelSKUsRequest($inventory_delete_inventory_item_channel_skus_request, string $contentType = self::contentTypes['deleteInventoryItemChannelSKUs'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_channel_skus_request' is set
        if ($inventory_delete_inventory_item_channel_skus_request === null || (is_array($inventory_delete_inventory_item_channel_skus_request) && count($inventory_delete_inventory_item_channel_skus_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_channel_skus_request when calling deleteInventoryItemChannelSKUs'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemChannelSKUs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_channel_skus_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_channel_skus_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_channel_skus_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemCompositions
     *
     * DeleteInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest $inventory_delete_inventory_item_compositions_request inventory_delete_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemCompositions($inventory_delete_inventory_item_compositions_request, string $contentType = self::contentTypes['deleteInventoryItemCompositions'][0])
    {
        $this->deleteInventoryItemCompositionsWithHttpInfo($inventory_delete_inventory_item_compositions_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemCompositionsWithHttpInfo
     *
     * DeleteInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest $inventory_delete_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemCompositionsWithHttpInfo($inventory_delete_inventory_item_compositions_request, string $contentType = self::contentTypes['deleteInventoryItemCompositions'][0])
    {
        $request = $this->deleteInventoryItemCompositionsRequest($inventory_delete_inventory_item_compositions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemCompositionsAsync
     *
     * DeleteInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest $inventory_delete_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemCompositionsAsync($inventory_delete_inventory_item_compositions_request, string $contentType = self::contentTypes['deleteInventoryItemCompositions'][0])
    {
        return $this->deleteInventoryItemCompositionsAsyncWithHttpInfo($inventory_delete_inventory_item_compositions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemCompositionsAsyncWithHttpInfo
     *
     * DeleteInventoryItemCompositions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest $inventory_delete_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemCompositionsAsyncWithHttpInfo($inventory_delete_inventory_item_compositions_request, string $contentType = self::contentTypes['deleteInventoryItemCompositions'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemCompositionsRequest($inventory_delete_inventory_item_compositions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemCompositions'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest $inventory_delete_inventory_item_compositions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemCompositionsRequest($inventory_delete_inventory_item_compositions_request, string $contentType = self::contentTypes['deleteInventoryItemCompositions'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_compositions_request' is set
        if ($inventory_delete_inventory_item_compositions_request === null || (is_array($inventory_delete_inventory_item_compositions_request) && count($inventory_delete_inventory_item_compositions_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_compositions_request when calling deleteInventoryItemCompositions'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemCompositions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_compositions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_compositions_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_compositions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemDescriptions
     *
     * DeleteInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest $inventory_delete_inventory_item_descriptions_request inventory_delete_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemDescriptions($inventory_delete_inventory_item_descriptions_request, string $contentType = self::contentTypes['deleteInventoryItemDescriptions'][0])
    {
        $this->deleteInventoryItemDescriptionsWithHttpInfo($inventory_delete_inventory_item_descriptions_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemDescriptionsWithHttpInfo
     *
     * DeleteInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest $inventory_delete_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemDescriptionsWithHttpInfo($inventory_delete_inventory_item_descriptions_request, string $contentType = self::contentTypes['deleteInventoryItemDescriptions'][0])
    {
        $request = $this->deleteInventoryItemDescriptionsRequest($inventory_delete_inventory_item_descriptions_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemDescriptionsAsync
     *
     * DeleteInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest $inventory_delete_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemDescriptionsAsync($inventory_delete_inventory_item_descriptions_request, string $contentType = self::contentTypes['deleteInventoryItemDescriptions'][0])
    {
        return $this->deleteInventoryItemDescriptionsAsyncWithHttpInfo($inventory_delete_inventory_item_descriptions_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemDescriptionsAsyncWithHttpInfo
     *
     * DeleteInventoryItemDescriptions
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest $inventory_delete_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemDescriptionsAsyncWithHttpInfo($inventory_delete_inventory_item_descriptions_request, string $contentType = self::contentTypes['deleteInventoryItemDescriptions'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemDescriptionsRequest($inventory_delete_inventory_item_descriptions_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemDescriptions'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest $inventory_delete_inventory_item_descriptions_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemDescriptionsRequest($inventory_delete_inventory_item_descriptions_request, string $contentType = self::contentTypes['deleteInventoryItemDescriptions'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_descriptions_request' is set
        if ($inventory_delete_inventory_item_descriptions_request === null || (is_array($inventory_delete_inventory_item_descriptions_request) && count($inventory_delete_inventory_item_descriptions_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_descriptions_request when calling deleteInventoryItemDescriptions'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemDescriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_descriptions_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_descriptions_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_descriptions_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemExtendedProperties
     *
     * DeleteInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest $inventory_delete_inventory_item_extended_properties_request inventory_delete_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemExtendedProperties($inventory_delete_inventory_item_extended_properties_request, string $contentType = self::contentTypes['deleteInventoryItemExtendedProperties'][0])
    {
        $this->deleteInventoryItemExtendedPropertiesWithHttpInfo($inventory_delete_inventory_item_extended_properties_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemExtendedPropertiesWithHttpInfo
     *
     * DeleteInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest $inventory_delete_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemExtendedPropertiesWithHttpInfo($inventory_delete_inventory_item_extended_properties_request, string $contentType = self::contentTypes['deleteInventoryItemExtendedProperties'][0])
    {
        $request = $this->deleteInventoryItemExtendedPropertiesRequest($inventory_delete_inventory_item_extended_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemExtendedPropertiesAsync
     *
     * DeleteInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest $inventory_delete_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemExtendedPropertiesAsync($inventory_delete_inventory_item_extended_properties_request, string $contentType = self::contentTypes['deleteInventoryItemExtendedProperties'][0])
    {
        return $this->deleteInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_delete_inventory_item_extended_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemExtendedPropertiesAsyncWithHttpInfo
     *
     * DeleteInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest $inventory_delete_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_delete_inventory_item_extended_properties_request, string $contentType = self::contentTypes['deleteInventoryItemExtendedProperties'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemExtendedPropertiesRequest($inventory_delete_inventory_item_extended_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemExtendedProperties'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest $inventory_delete_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemExtendedPropertiesRequest($inventory_delete_inventory_item_extended_properties_request, string $contentType = self::contentTypes['deleteInventoryItemExtendedProperties'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_extended_properties_request' is set
        if ($inventory_delete_inventory_item_extended_properties_request === null || (is_array($inventory_delete_inventory_item_extended_properties_request) && count($inventory_delete_inventory_item_extended_properties_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_extended_properties_request when calling deleteInventoryItemExtendedProperties'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_extended_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_extended_properties_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_extended_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemImageBulk
     *
     * DeleteInventoryItemImageBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest $inventory_delete_inventory_item_image_bulk_request inventory_delete_inventory_item_image_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemImageBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse
     */
    public function deleteInventoryItemImageBulk($inventory_delete_inventory_item_image_bulk_request, string $contentType = self::contentTypes['deleteInventoryItemImageBulk'][0])
    {
        list($response) = $this->deleteInventoryItemImageBulkWithHttpInfo($inventory_delete_inventory_item_image_bulk_request, $contentType);
        return $response;
    }

    /**
     * Operation deleteInventoryItemImageBulkWithHttpInfo
     *
     * DeleteInventoryItemImageBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest $inventory_delete_inventory_item_image_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemImageBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemImageBulkWithHttpInfo($inventory_delete_inventory_item_image_bulk_request, string $contentType = self::contentTypes['deleteInventoryItemImageBulk'][0])
    {
        $request = $this->deleteInventoryItemImageBulkRequest($inventory_delete_inventory_item_image_bulk_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemImageBulkAsync
     *
     * DeleteInventoryItemImageBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest $inventory_delete_inventory_item_image_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemImageBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemImageBulkAsync($inventory_delete_inventory_item_image_bulk_request, string $contentType = self::contentTypes['deleteInventoryItemImageBulk'][0])
    {
        return $this->deleteInventoryItemImageBulkAsyncWithHttpInfo($inventory_delete_inventory_item_image_bulk_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemImageBulkAsyncWithHttpInfo
     *
     * DeleteInventoryItemImageBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest $inventory_delete_inventory_item_image_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemImageBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemImageBulkAsyncWithHttpInfo($inventory_delete_inventory_item_image_bulk_request, string $contentType = self::contentTypes['deleteInventoryItemImageBulk'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse';
        $request = $this->deleteInventoryItemImageBulkRequest($inventory_delete_inventory_item_image_bulk_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemImageBulk'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest $inventory_delete_inventory_item_image_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemImageBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemImageBulkRequest($inventory_delete_inventory_item_image_bulk_request, string $contentType = self::contentTypes['deleteInventoryItemImageBulk'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_image_bulk_request' is set
        if ($inventory_delete_inventory_item_image_bulk_request === null || (is_array($inventory_delete_inventory_item_image_bulk_request) && count($inventory_delete_inventory_item_image_bulk_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_image_bulk_request when calling deleteInventoryItemImageBulk'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemImageBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_image_bulk_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_image_bulk_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_image_bulk_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemPrices
     *
     * DeleteInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest $inventory_delete_inventory_item_prices_request inventory_delete_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemPrices($inventory_delete_inventory_item_prices_request, string $contentType = self::contentTypes['deleteInventoryItemPrices'][0])
    {
        $this->deleteInventoryItemPricesWithHttpInfo($inventory_delete_inventory_item_prices_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemPricesWithHttpInfo
     *
     * DeleteInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest $inventory_delete_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemPricesWithHttpInfo($inventory_delete_inventory_item_prices_request, string $contentType = self::contentTypes['deleteInventoryItemPrices'][0])
    {
        $request = $this->deleteInventoryItemPricesRequest($inventory_delete_inventory_item_prices_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemPricesAsync
     *
     * DeleteInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest $inventory_delete_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemPricesAsync($inventory_delete_inventory_item_prices_request, string $contentType = self::contentTypes['deleteInventoryItemPrices'][0])
    {
        return $this->deleteInventoryItemPricesAsyncWithHttpInfo($inventory_delete_inventory_item_prices_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemPricesAsyncWithHttpInfo
     *
     * DeleteInventoryItemPrices
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest $inventory_delete_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemPricesAsyncWithHttpInfo($inventory_delete_inventory_item_prices_request, string $contentType = self::contentTypes['deleteInventoryItemPrices'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemPricesRequest($inventory_delete_inventory_item_prices_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemPrices'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest $inventory_delete_inventory_item_prices_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemPricesRequest($inventory_delete_inventory_item_prices_request, string $contentType = self::contentTypes['deleteInventoryItemPrices'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_prices_request' is set
        if ($inventory_delete_inventory_item_prices_request === null || (is_array($inventory_delete_inventory_item_prices_request) && count($inventory_delete_inventory_item_prices_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_prices_request when calling deleteInventoryItemPrices'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemPrices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_prices_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_prices_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_prices_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemPricingRules
     *
     * DeleteInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest $inventory_delete_inventory_item_pricing_rules_request inventory_delete_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemPricingRules($inventory_delete_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['deleteInventoryItemPricingRules'][0])
    {
        $this->deleteInventoryItemPricingRulesWithHttpInfo($inventory_delete_inventory_item_pricing_rules_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemPricingRulesWithHttpInfo
     *
     * DeleteInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest $inventory_delete_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemPricingRulesWithHttpInfo($inventory_delete_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['deleteInventoryItemPricingRules'][0])
    {
        $request = $this->deleteInventoryItemPricingRulesRequest($inventory_delete_inventory_item_pricing_rules_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemPricingRulesAsync
     *
     * DeleteInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest $inventory_delete_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemPricingRulesAsync($inventory_delete_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['deleteInventoryItemPricingRules'][0])
    {
        return $this->deleteInventoryItemPricingRulesAsyncWithHttpInfo($inventory_delete_inventory_item_pricing_rules_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemPricingRulesAsyncWithHttpInfo
     *
     * DeleteInventoryItemPricingRules
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest $inventory_delete_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemPricingRulesAsyncWithHttpInfo($inventory_delete_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['deleteInventoryItemPricingRules'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemPricingRulesRequest($inventory_delete_inventory_item_pricing_rules_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemPricingRules'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest $inventory_delete_inventory_item_pricing_rules_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemPricingRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemPricingRulesRequest($inventory_delete_inventory_item_pricing_rules_request, string $contentType = self::contentTypes['deleteInventoryItemPricingRules'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_pricing_rules_request' is set
        if ($inventory_delete_inventory_item_pricing_rules_request === null || (is_array($inventory_delete_inventory_item_pricing_rules_request) && count($inventory_delete_inventory_item_pricing_rules_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_pricing_rules_request when calling deleteInventoryItemPricingRules'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemPricingRules';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_pricing_rules_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_pricing_rules_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_pricing_rules_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItemTitles
     *
     * DeleteInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest $inventory_delete_inventory_item_titles_request inventory_delete_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItemTitles($inventory_delete_inventory_item_titles_request, string $contentType = self::contentTypes['deleteInventoryItemTitles'][0])
    {
        $this->deleteInventoryItemTitlesWithHttpInfo($inventory_delete_inventory_item_titles_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemTitlesWithHttpInfo
     *
     * DeleteInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest $inventory_delete_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemTitlesWithHttpInfo($inventory_delete_inventory_item_titles_request, string $contentType = self::contentTypes['deleteInventoryItemTitles'][0])
    {
        $request = $this->deleteInventoryItemTitlesRequest($inventory_delete_inventory_item_titles_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemTitlesAsync
     *
     * DeleteInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest $inventory_delete_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemTitlesAsync($inventory_delete_inventory_item_titles_request, string $contentType = self::contentTypes['deleteInventoryItemTitles'][0])
    {
        return $this->deleteInventoryItemTitlesAsyncWithHttpInfo($inventory_delete_inventory_item_titles_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemTitlesAsyncWithHttpInfo
     *
     * DeleteInventoryItemTitles
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest $inventory_delete_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemTitlesAsyncWithHttpInfo($inventory_delete_inventory_item_titles_request, string $contentType = self::contentTypes['deleteInventoryItemTitles'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemTitlesRequest($inventory_delete_inventory_item_titles_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItemTitles'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest $inventory_delete_inventory_item_titles_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemTitlesRequest($inventory_delete_inventory_item_titles_request, string $contentType = self::contentTypes['deleteInventoryItemTitles'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_item_titles_request' is set
        if ($inventory_delete_inventory_item_titles_request === null || (is_array($inventory_delete_inventory_item_titles_request) && count($inventory_delete_inventory_item_titles_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_item_titles_request when calling deleteInventoryItemTitles'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItemTitles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_item_titles_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_item_titles_request));
            } else {
                $httpBody = $inventory_delete_inventory_item_titles_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInventoryItems
     *
     * DeleteInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest $inventory_delete_inventory_items_request inventory_delete_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteInventoryItems($inventory_delete_inventory_items_request, string $contentType = self::contentTypes['deleteInventoryItems'][0])
    {
        $this->deleteInventoryItemsWithHttpInfo($inventory_delete_inventory_items_request, $contentType);
    }

    /**
     * Operation deleteInventoryItemsWithHttpInfo
     *
     * DeleteInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest $inventory_delete_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItems'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInventoryItemsWithHttpInfo($inventory_delete_inventory_items_request, string $contentType = self::contentTypes['deleteInventoryItems'][0])
    {
        $request = $this->deleteInventoryItemsRequest($inventory_delete_inventory_items_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInventoryItemsAsync
     *
     * DeleteInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest $inventory_delete_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemsAsync($inventory_delete_inventory_items_request, string $contentType = self::contentTypes['deleteInventoryItems'][0])
    {
        return $this->deleteInventoryItemsAsyncWithHttpInfo($inventory_delete_inventory_items_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInventoryItemsAsyncWithHttpInfo
     *
     * DeleteInventoryItems
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest $inventory_delete_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInventoryItemsAsyncWithHttpInfo($inventory_delete_inventory_items_request, string $contentType = self::contentTypes['deleteInventoryItems'][0])
    {
        $returnType = '';
        $request = $this->deleteInventoryItemsRequest($inventory_delete_inventory_items_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInventoryItems'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest $inventory_delete_inventory_items_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInventoryItems'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInventoryItemsRequest($inventory_delete_inventory_items_request, string $contentType = self::contentTypes['deleteInventoryItems'][0])
    {

        // verify the required parameter 'inventory_delete_inventory_items_request' is set
        if ($inventory_delete_inventory_items_request === null || (is_array($inventory_delete_inventory_items_request) && count($inventory_delete_inventory_items_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_inventory_items_request when calling deleteInventoryItems'
            );
        }


        $resourcePath = '/api/Inventory/DeleteInventoryItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_inventory_items_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_inventory_items_request));
            } else {
                $httpBody = $inventory_delete_inventory_items_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteItemLocations
     *
     * DeleteItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest $inventory_delete_item_locations_request inventory_delete_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteItemLocations($inventory_delete_item_locations_request, string $contentType = self::contentTypes['deleteItemLocations'][0])
    {
        $this->deleteItemLocationsWithHttpInfo($inventory_delete_item_locations_request, $contentType);
    }

    /**
     * Operation deleteItemLocationsWithHttpInfo
     *
     * DeleteItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest $inventory_delete_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteItemLocationsWithHttpInfo($inventory_delete_item_locations_request, string $contentType = self::contentTypes['deleteItemLocations'][0])
    {
        $request = $this->deleteItemLocationsRequest($inventory_delete_item_locations_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteItemLocationsAsync
     *
     * DeleteItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest $inventory_delete_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemLocationsAsync($inventory_delete_item_locations_request, string $contentType = self::contentTypes['deleteItemLocations'][0])
    {
        return $this->deleteItemLocationsAsyncWithHttpInfo($inventory_delete_item_locations_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteItemLocationsAsyncWithHttpInfo
     *
     * DeleteItemLocations
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest $inventory_delete_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteItemLocationsAsyncWithHttpInfo($inventory_delete_item_locations_request, string $contentType = self::contentTypes['deleteItemLocations'][0])
    {
        $returnType = '';
        $request = $this->deleteItemLocationsRequest($inventory_delete_item_locations_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteItemLocations'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest $inventory_delete_item_locations_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteItemLocationsRequest($inventory_delete_item_locations_request, string $contentType = self::contentTypes['deleteItemLocations'][0])
    {

        // verify the required parameter 'inventory_delete_item_locations_request' is set
        if ($inventory_delete_item_locations_request === null || (is_array($inventory_delete_item_locations_request) && count($inventory_delete_item_locations_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_item_locations_request when calling deleteItemLocations'
            );
        }


        $resourcePath = '/api/Inventory/DeleteItemLocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_item_locations_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_item_locations_request));
            } else {
                $httpBody = $inventory_delete_item_locations_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteProductIdentifiers
     *
     * DeleteProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest $inventory_delete_product_identifiers_request inventory_delete_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteProductIdentifiers($inventory_delete_product_identifiers_request, string $contentType = self::contentTypes['deleteProductIdentifiers'][0])
    {
        $this->deleteProductIdentifiersWithHttpInfo($inventory_delete_product_identifiers_request, $contentType);
    }

    /**
     * Operation deleteProductIdentifiersWithHttpInfo
     *
     * DeleteProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest $inventory_delete_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteProductIdentifiersWithHttpInfo($inventory_delete_product_identifiers_request, string $contentType = self::contentTypes['deleteProductIdentifiers'][0])
    {
        $request = $this->deleteProductIdentifiersRequest($inventory_delete_product_identifiers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteProductIdentifiersAsync
     *
     * DeleteProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest $inventory_delete_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductIdentifiersAsync($inventory_delete_product_identifiers_request, string $contentType = self::contentTypes['deleteProductIdentifiers'][0])
    {
        return $this->deleteProductIdentifiersAsyncWithHttpInfo($inventory_delete_product_identifiers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteProductIdentifiersAsyncWithHttpInfo
     *
     * DeleteProductIdentifiers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest $inventory_delete_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteProductIdentifiersAsyncWithHttpInfo($inventory_delete_product_identifiers_request, string $contentType = self::contentTypes['deleteProductIdentifiers'][0])
    {
        $returnType = '';
        $request = $this->deleteProductIdentifiersRequest($inventory_delete_product_identifiers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteProductIdentifiers'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest $inventory_delete_product_identifiers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteProductIdentifiers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteProductIdentifiersRequest($inventory_delete_product_identifiers_request, string $contentType = self::contentTypes['deleteProductIdentifiers'][0])
    {

        // verify the required parameter 'inventory_delete_product_identifiers_request' is set
        if ($inventory_delete_product_identifiers_request === null || (is_array($inventory_delete_product_identifiers_request) && count($inventory_delete_product_identifiers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_product_identifiers_request when calling deleteProductIdentifiers'
            );
        }


        $resourcePath = '/api/Inventory/DeleteProductIdentifiers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_product_identifiers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_product_identifiers_request));
            } else {
                $httpBody = $inventory_delete_product_identifiers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteScrapCategories
     *
     * DeleteScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest $inventory_delete_scrap_categories_request inventory_delete_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteScrapCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteScrapCategories($inventory_delete_scrap_categories_request, string $contentType = self::contentTypes['deleteScrapCategories'][0])
    {
        $this->deleteScrapCategoriesWithHttpInfo($inventory_delete_scrap_categories_request, $contentType);
    }

    /**
     * Operation deleteScrapCategoriesWithHttpInfo
     *
     * DeleteScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest $inventory_delete_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteScrapCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteScrapCategoriesWithHttpInfo($inventory_delete_scrap_categories_request, string $contentType = self::contentTypes['deleteScrapCategories'][0])
    {
        $request = $this->deleteScrapCategoriesRequest($inventory_delete_scrap_categories_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteScrapCategoriesAsync
     *
     * DeleteScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest $inventory_delete_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteScrapCategoriesAsync($inventory_delete_scrap_categories_request, string $contentType = self::contentTypes['deleteScrapCategories'][0])
    {
        return $this->deleteScrapCategoriesAsyncWithHttpInfo($inventory_delete_scrap_categories_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteScrapCategoriesAsyncWithHttpInfo
     *
     * DeleteScrapCategories
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest $inventory_delete_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteScrapCategoriesAsyncWithHttpInfo($inventory_delete_scrap_categories_request, string $contentType = self::contentTypes['deleteScrapCategories'][0])
    {
        $returnType = '';
        $request = $this->deleteScrapCategoriesRequest($inventory_delete_scrap_categories_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteScrapCategories'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest $inventory_delete_scrap_categories_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteScrapCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteScrapCategoriesRequest($inventory_delete_scrap_categories_request, string $contentType = self::contentTypes['deleteScrapCategories'][0])
    {

        // verify the required parameter 'inventory_delete_scrap_categories_request' is set
        if ($inventory_delete_scrap_categories_request === null || (is_array($inventory_delete_scrap_categories_request) && count($inventory_delete_scrap_categories_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_scrap_categories_request when calling deleteScrapCategories'
            );
        }


        $resourcePath = '/api/Inventory/DeleteScrapCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_scrap_categories_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_scrap_categories_request));
            } else {
                $httpBody = $inventory_delete_scrap_categories_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteStockSupplierStat
     *
     * DeleteStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest $inventory_delete_stock_supplier_stat_request inventory_delete_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteStockSupplierStat($inventory_delete_stock_supplier_stat_request, string $contentType = self::contentTypes['deleteStockSupplierStat'][0])
    {
        $this->deleteStockSupplierStatWithHttpInfo($inventory_delete_stock_supplier_stat_request, $contentType);
    }

    /**
     * Operation deleteStockSupplierStatWithHttpInfo
     *
     * DeleteStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest $inventory_delete_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteStockSupplierStatWithHttpInfo($inventory_delete_stock_supplier_stat_request, string $contentType = self::contentTypes['deleteStockSupplierStat'][0])
    {
        $request = $this->deleteStockSupplierStatRequest($inventory_delete_stock_supplier_stat_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteStockSupplierStatAsync
     *
     * DeleteStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest $inventory_delete_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteStockSupplierStatAsync($inventory_delete_stock_supplier_stat_request, string $contentType = self::contentTypes['deleteStockSupplierStat'][0])
    {
        return $this->deleteStockSupplierStatAsyncWithHttpInfo($inventory_delete_stock_supplier_stat_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteStockSupplierStatAsyncWithHttpInfo
     *
     * DeleteStockSupplierStat
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest $inventory_delete_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteStockSupplierStatAsyncWithHttpInfo($inventory_delete_stock_supplier_stat_request, string $contentType = self::contentTypes['deleteStockSupplierStat'][0])
    {
        $returnType = '';
        $request = $this->deleteStockSupplierStatRequest($inventory_delete_stock_supplier_stat_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteStockSupplierStat'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest $inventory_delete_stock_supplier_stat_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteStockSupplierStat'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteStockSupplierStatRequest($inventory_delete_stock_supplier_stat_request, string $contentType = self::contentTypes['deleteStockSupplierStat'][0])
    {

        // verify the required parameter 'inventory_delete_stock_supplier_stat_request' is set
        if ($inventory_delete_stock_supplier_stat_request === null || (is_array($inventory_delete_stock_supplier_stat_request) && count($inventory_delete_stock_supplier_stat_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_stock_supplier_stat_request when calling deleteStockSupplierStat'
            );
        }


        $resourcePath = '/api/Inventory/DeleteStockSupplierStat';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_stock_supplier_stat_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_stock_supplier_stat_request));
            } else {
                $httpBody = $inventory_delete_stock_supplier_stat_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSuppliers
     *
     * DeleteSuppliers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest $inventory_delete_suppliers_request inventory_delete_suppliers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSuppliers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteSuppliers($inventory_delete_suppliers_request, string $contentType = self::contentTypes['deleteSuppliers'][0])
    {
        $this->deleteSuppliersWithHttpInfo($inventory_delete_suppliers_request, $contentType);
    }

    /**
     * Operation deleteSuppliersWithHttpInfo
     *
     * DeleteSuppliers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest $inventory_delete_suppliers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSuppliers'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSuppliersWithHttpInfo($inventory_delete_suppliers_request, string $contentType = self::contentTypes['deleteSuppliers'][0])
    {
        $request = $this->deleteSuppliersRequest($inventory_delete_suppliers_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteSuppliersAsync
     *
     * DeleteSuppliers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest $inventory_delete_suppliers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSuppliersAsync($inventory_delete_suppliers_request, string $contentType = self::contentTypes['deleteSuppliers'][0])
    {
        return $this->deleteSuppliersAsyncWithHttpInfo($inventory_delete_suppliers_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSuppliersAsyncWithHttpInfo
     *
     * DeleteSuppliers
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest $inventory_delete_suppliers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSuppliersAsyncWithHttpInfo($inventory_delete_suppliers_request, string $contentType = self::contentTypes['deleteSuppliers'][0])
    {
        $returnType = '';
        $request = $this->deleteSuppliersRequest($inventory_delete_suppliers_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSuppliers'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest $inventory_delete_suppliers_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSuppliers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSuppliersRequest($inventory_delete_suppliers_request, string $contentType = self::contentTypes['deleteSuppliers'][0])
    {

        // verify the required parameter 'inventory_delete_suppliers_request' is set
        if ($inventory_delete_suppliers_request === null || (is_array($inventory_delete_suppliers_request) && count($inventory_delete_suppliers_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_suppliers_request when calling deleteSuppliers'
            );
        }


        $resourcePath = '/api/Inventory/DeleteSuppliers';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_suppliers_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_suppliers_request));
            } else {
                $httpBody = $inventory_delete_suppliers_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteUserSpecificView
     *
     * DeleteUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest $inventory_delete_user_specific_view_request inventory_delete_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserSpecificView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteUserSpecificView($inventory_delete_user_specific_view_request, string $contentType = self::contentTypes['deleteUserSpecificView'][0])
    {
        $this->deleteUserSpecificViewWithHttpInfo($inventory_delete_user_specific_view_request, $contentType);
    }

    /**
     * Operation deleteUserSpecificViewWithHttpInfo
     *
     * DeleteUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest $inventory_delete_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserSpecificView'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserSpecificViewWithHttpInfo($inventory_delete_user_specific_view_request, string $contentType = self::contentTypes['deleteUserSpecificView'][0])
    {
        $request = $this->deleteUserSpecificViewRequest($inventory_delete_user_specific_view_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteUserSpecificViewAsync
     *
     * DeleteUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest $inventory_delete_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserSpecificViewAsync($inventory_delete_user_specific_view_request, string $contentType = self::contentTypes['deleteUserSpecificView'][0])
    {
        return $this->deleteUserSpecificViewAsyncWithHttpInfo($inventory_delete_user_specific_view_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteUserSpecificViewAsyncWithHttpInfo
     *
     * DeleteUserSpecificView
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest $inventory_delete_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserSpecificViewAsyncWithHttpInfo($inventory_delete_user_specific_view_request, string $contentType = self::contentTypes['deleteUserSpecificView'][0])
    {
        $returnType = '';
        $request = $this->deleteUserSpecificViewRequest($inventory_delete_user_specific_view_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteUserSpecificView'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest $inventory_delete_user_specific_view_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserSpecificView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteUserSpecificViewRequest($inventory_delete_user_specific_view_request, string $contentType = self::contentTypes['deleteUserSpecificView'][0])
    {

        // verify the required parameter 'inventory_delete_user_specific_view_request' is set
        if ($inventory_delete_user_specific_view_request === null || (is_array($inventory_delete_user_specific_view_request) && count($inventory_delete_user_specific_view_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_delete_user_specific_view_request when calling deleteUserSpecificView'
            );
        }


        $resourcePath = '/api/Inventory/DeleteUserSpecificView';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_delete_user_specific_view_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_delete_user_specific_view_request));
            } else {
                $httpBody = $inventory_delete_user_specific_view_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation duplicateInventoryItem
     *
     * DuplicateInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest $inventory_duplicate_inventory_item_request inventory_duplicate_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['duplicateInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function duplicateInventoryItem($inventory_duplicate_inventory_item_request, string $contentType = self::contentTypes['duplicateInventoryItem'][0])
    {
        $this->duplicateInventoryItemWithHttpInfo($inventory_duplicate_inventory_item_request, $contentType);
    }

    /**
     * Operation duplicateInventoryItemWithHttpInfo
     *
     * DuplicateInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest $inventory_duplicate_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['duplicateInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function duplicateInventoryItemWithHttpInfo($inventory_duplicate_inventory_item_request, string $contentType = self::contentTypes['duplicateInventoryItem'][0])
    {
        $request = $this->duplicateInventoryItemRequest($inventory_duplicate_inventory_item_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation duplicateInventoryItemAsync
     *
     * DuplicateInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest $inventory_duplicate_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['duplicateInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function duplicateInventoryItemAsync($inventory_duplicate_inventory_item_request, string $contentType = self::contentTypes['duplicateInventoryItem'][0])
    {
        return $this->duplicateInventoryItemAsyncWithHttpInfo($inventory_duplicate_inventory_item_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation duplicateInventoryItemAsyncWithHttpInfo
     *
     * DuplicateInventoryItem
     *
     * @param  \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest $inventory_duplicate_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['duplicateInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function duplicateInventoryItemAsyncWithHttpInfo($inventory_duplicate_inventory_item_request, string $contentType = self::contentTypes['duplicateInventoryItem'][0])
    {
        $returnType = '';
        $request = $this->duplicateInventoryItemRequest($inventory_duplicate_inventory_item_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'duplicateInventoryItem'
     *
     * @param  \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest $inventory_duplicate_inventory_item_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['duplicateInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function duplicateInventoryItemRequest($inventory_duplicate_inventory_item_request, string $contentType = self::contentTypes['duplicateInventoryItem'][0])
    {

        // verify the required parameter 'inventory_duplicate_inventory_item_request' is set
        if ($inventory_duplicate_inventory_item_request === null || (is_array($inventory_duplicate_inventory_item_request) && count($inventory_duplicate_inventory_item_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_duplicate_inventory_item_request when calling duplicateInventoryItem'
            );
        }


        $resourcePath = '/api/Inventory/DuplicateInventoryItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            [],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_duplicate_inventory_item_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_duplicate_inventory_item_request));
            } else {
                $httpBody = $inventory_duplicate_inventory_item_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllExtendedPropertyNames
     *
     * GetAllExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,string[]>
     */
    public function getAllExtendedPropertyNames(string $contentType = self::contentTypes['getAllExtendedPropertyNames'][0])
    {
        list($response) = $this->getAllExtendedPropertyNamesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getAllExtendedPropertyNamesWithHttpInfo
     *
     * GetAllExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,string[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllExtendedPropertyNamesWithHttpInfo(string $contentType = self::contentTypes['getAllExtendedPropertyNames'][0])
    {
        $request = $this->getAllExtendedPropertyNamesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,string[]>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,string[]>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,string[]>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,string[]>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,string[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllExtendedPropertyNamesAsync
     *
     * GetAllExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllExtendedPropertyNamesAsync(string $contentType = self::contentTypes['getAllExtendedPropertyNames'][0])
    {
        return $this->getAllExtendedPropertyNamesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllExtendedPropertyNamesAsyncWithHttpInfo
     *
     * GetAllExtendedPropertyNames
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllExtendedPropertyNamesAsyncWithHttpInfo(string $contentType = self::contentTypes['getAllExtendedPropertyNames'][0])
    {
        $returnType = 'array<string,string[]>';
        $request = $this->getAllExtendedPropertyNamesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllExtendedPropertyNames'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllExtendedPropertyNamesRequest(string $contentType = self::contentTypes['getAllExtendedPropertyNames'][0])
    {


        $resourcePath = '/api/Inventory/GetAllExtendedPropertyNames';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBatchAudit
     *
     * GetBatchAudit
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest $inventory_get_batch_audit_request inventory_get_batch_audit_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchAudit'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\GetBatchAuditResponse
     */
    public function getBatchAudit($inventory_get_batch_audit_request, string $contentType = self::contentTypes['getBatchAudit'][0])
    {
        list($response) = $this->getBatchAuditWithHttpInfo($inventory_get_batch_audit_request, $contentType);
        return $response;
    }

    /**
     * Operation getBatchAuditWithHttpInfo
     *
     * GetBatchAudit
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest $inventory_get_batch_audit_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchAudit'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\GetBatchAuditResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBatchAuditWithHttpInfo($inventory_get_batch_audit_request, string $contentType = self::contentTypes['getBatchAudit'][0])
    {
        $request = $this->getBatchAuditRequest($inventory_get_batch_audit_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\GetBatchAuditResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\GetBatchAuditResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\GetBatchAuditResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\GetBatchAuditResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\GetBatchAuditResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBatchAuditAsync
     *
     * GetBatchAudit
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest $inventory_get_batch_audit_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchAudit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchAuditAsync($inventory_get_batch_audit_request, string $contentType = self::contentTypes['getBatchAudit'][0])
    {
        return $this->getBatchAuditAsyncWithHttpInfo($inventory_get_batch_audit_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBatchAuditAsyncWithHttpInfo
     *
     * GetBatchAudit
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest $inventory_get_batch_audit_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchAudit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchAuditAsyncWithHttpInfo($inventory_get_batch_audit_request, string $contentType = self::contentTypes['getBatchAudit'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\GetBatchAuditResponse';
        $request = $this->getBatchAuditRequest($inventory_get_batch_audit_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBatchAudit'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest $inventory_get_batch_audit_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchAudit'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBatchAuditRequest($inventory_get_batch_audit_request, string $contentType = self::contentTypes['getBatchAudit'][0])
    {

        // verify the required parameter 'inventory_get_batch_audit_request' is set
        if ($inventory_get_batch_audit_request === null || (is_array($inventory_get_batch_audit_request) && count($inventory_get_batch_audit_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_batch_audit_request when calling getBatchAudit'
            );
        }


        $resourcePath = '/api/Inventory/GetBatchAudit';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_batch_audit_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_batch_audit_request));
            } else {
                $httpBody = $inventory_get_batch_audit_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBatchInventoryById
     *
     * GetBatchInventoryById
     *
     * @param  \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchInventoryById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\GetBatchInventoryByIdResponse
     */
    public function getBatchInventoryById($request = null, string $contentType = self::contentTypes['getBatchInventoryById'][0])
    {
        list($response) = $this->getBatchInventoryByIdWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation getBatchInventoryByIdWithHttpInfo
     *
     * GetBatchInventoryById
     *
     * @param  \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchInventoryById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\GetBatchInventoryByIdResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBatchInventoryByIdWithHttpInfo($request = null, string $contentType = self::contentTypes['getBatchInventoryById'][0])
    {
        $request = $this->getBatchInventoryByIdRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBatchInventoryByIdAsync
     *
     * GetBatchInventoryById
     *
     * @param  \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchInventoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchInventoryByIdAsync($request = null, string $contentType = self::contentTypes['getBatchInventoryById'][0])
    {
        return $this->getBatchInventoryByIdAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBatchInventoryByIdAsyncWithHttpInfo
     *
     * GetBatchInventoryById
     *
     * @param  \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchInventoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchInventoryByIdAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['getBatchInventoryById'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse';
        $request = $this->getBatchInventoryByIdRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBatchInventoryById'
     *
     * @param  \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchInventoryById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBatchInventoryByIdRequest($request = null, string $contentType = self::contentTypes['getBatchInventoryById'][0])
    {



        $resourcePath = '/api/Inventory/GetBatchInventoryById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBatchesByStockItemId
     *
     * GetBatchesByStockItemId
     *
     * @param  string|null $stock_item_id Item id (optional)
     * @param  bool|null $only_available If true, only available batches will be returned (optional)
     * @param  string|null $stock_location_id stock_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemBatch[]
     */
    public function getBatchesByStockItemId($stock_item_id = null, $only_available = null, $stock_location_id = null, string $contentType = self::contentTypes['getBatchesByStockItemId'][0])
    {
        list($response) = $this->getBatchesByStockItemIdWithHttpInfo($stock_item_id, $only_available, $stock_location_id, $contentType);
        return $response;
    }

    /**
     * Operation getBatchesByStockItemIdWithHttpInfo
     *
     * GetBatchesByStockItemId
     *
     * @param  string|null $stock_item_id Item id (optional)
     * @param  bool|null $only_available If true, only available batches will be returned (optional)
     * @param  string|null $stock_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getBatchesByStockItemIdWithHttpInfo($stock_item_id = null, $only_available = null, $stock_location_id = null, string $contentType = self::contentTypes['getBatchesByStockItemId'][0])
    {
        $request = $this->getBatchesByStockItemIdRequest($stock_item_id, $only_available, $stock_location_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getBatchesByStockItemIdAsync
     *
     * GetBatchesByStockItemId
     *
     * @param  string|null $stock_item_id Item id (optional)
     * @param  bool|null $only_available If true, only available batches will be returned (optional)
     * @param  string|null $stock_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchesByStockItemIdAsync($stock_item_id = null, $only_available = null, $stock_location_id = null, string $contentType = self::contentTypes['getBatchesByStockItemId'][0])
    {
        return $this->getBatchesByStockItemIdAsyncWithHttpInfo($stock_item_id, $only_available, $stock_location_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getBatchesByStockItemIdAsyncWithHttpInfo
     *
     * GetBatchesByStockItemId
     *
     * @param  string|null $stock_item_id Item id (optional)
     * @param  bool|null $only_available If true, only available batches will be returned (optional)
     * @param  string|null $stock_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBatchesByStockItemIdAsyncWithHttpInfo($stock_item_id = null, $only_available = null, $stock_location_id = null, string $contentType = self::contentTypes['getBatchesByStockItemId'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemBatch[]';
        $request = $this->getBatchesByStockItemIdRequest($stock_item_id, $only_available, $stock_location_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBatchesByStockItemId'
     *
     * @param  string|null $stock_item_id Item id (optional)
     * @param  bool|null $only_available If true, only available batches will be returned (optional)
     * @param  string|null $stock_location_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getBatchesByStockItemId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getBatchesByStockItemIdRequest($stock_item_id = null, $only_available = null, $stock_location_id = null, string $contentType = self::contentTypes['getBatchesByStockItemId'][0])
    {





        $resourcePath = '/api/Inventory/GetBatchesByStockItemId';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $only_available,
            'onlyAvailable', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_location_id,
            'stockLocationId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCategories
     *
     * GetCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\LinnworksCategory[]
     */
    public function getCategories(string $contentType = self::contentTypes['getCategories'][0])
    {
        list($response) = $this->getCategoriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCategoriesWithHttpInfo
     *
     * GetCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\LinnworksCategory[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getCategoriesWithHttpInfo(string $contentType = self::contentTypes['getCategories'][0])
    {
        $request = $this->getCategoriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\LinnworksCategory[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\LinnworksCategory[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\LinnworksCategory[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\LinnworksCategory[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\LinnworksCategory[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCategoriesAsync
     *
     * GetCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsync(string $contentType = self::contentTypes['getCategories'][0])
    {
        return $this->getCategoriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCategoriesAsyncWithHttpInfo
     *
     * GetCategories
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCategoriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getCategories'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\LinnworksCategory[]';
        $request = $this->getCategoriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCategories'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCategories'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCategoriesRequest(string $contentType = self::contentTypes['getCategories'][0])
    {


        $resourcePath = '/api/Inventory/GetCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getChannels
     *
     * GetChannels
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannels'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\AnyConfig[]
     */
    public function getChannels(string $contentType = self::contentTypes['getChannels'][0])
    {
        list($response) = $this->getChannelsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getChannelsWithHttpInfo
     *
     * GetChannels
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannels'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\AnyConfig[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getChannelsWithHttpInfo(string $contentType = self::contentTypes['getChannels'][0])
    {
        $request = $this->getChannelsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\AnyConfig[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\AnyConfig[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\AnyConfig[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\AnyConfig[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\AnyConfig[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getChannelsAsync
     *
     * GetChannels
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelsAsync(string $contentType = self::contentTypes['getChannels'][0])
    {
        return $this->getChannelsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getChannelsAsyncWithHttpInfo
     *
     * GetChannels
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelsAsyncWithHttpInfo(string $contentType = self::contentTypes['getChannels'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\AnyConfig[]';
        $request = $this->getChannelsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getChannels'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannels'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getChannelsRequest(string $contentType = self::contentTypes['getChannels'][0])
    {


        $resourcePath = '/api/Inventory/GetChannels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getChannelsBySource
     *
     * GetChannelsBySource
     *
     * @param  string|null $source Channel source (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelsBySource'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\HeaderConfig[]
     */
    public function getChannelsBySource($source = null, string $contentType = self::contentTypes['getChannelsBySource'][0])
    {
        list($response) = $this->getChannelsBySourceWithHttpInfo($source, $contentType);
        return $response;
    }

    /**
     * Operation getChannelsBySourceWithHttpInfo
     *
     * GetChannelsBySource
     *
     * @param  string|null $source Channel source (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelsBySource'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\HeaderConfig[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getChannelsBySourceWithHttpInfo($source = null, string $contentType = self::contentTypes['getChannelsBySource'][0])
    {
        $request = $this->getChannelsBySourceRequest($source, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\HeaderConfig[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\HeaderConfig[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\HeaderConfig[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\HeaderConfig[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\HeaderConfig[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getChannelsBySourceAsync
     *
     * GetChannelsBySource
     *
     * @param  string|null $source Channel source (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelsBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelsBySourceAsync($source = null, string $contentType = self::contentTypes['getChannelsBySource'][0])
    {
        return $this->getChannelsBySourceAsyncWithHttpInfo($source, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getChannelsBySourceAsyncWithHttpInfo
     *
     * GetChannelsBySource
     *
     * @param  string|null $source Channel source (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelsBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getChannelsBySourceAsyncWithHttpInfo($source = null, string $contentType = self::contentTypes['getChannelsBySource'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\HeaderConfig[]';
        $request = $this->getChannelsBySourceRequest($source, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getChannelsBySource'
     *
     * @param  string|null $source Channel source (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getChannelsBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getChannelsBySourceRequest($source = null, string $contentType = self::contentTypes['getChannelsBySource'][0])
    {



        $resourcePath = '/api/Inventory/GetChannelsBySource';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source,
            'source', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCountries
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\Country[]
     */
    public function getCountries(string $contentType = self::contentTypes['getCountries'][0])
    {
        list($response) = $this->getCountriesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCountriesWithHttpInfo
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\Country[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getCountriesWithHttpInfo(string $contentType = self::contentTypes['getCountries'][0])
    {
        $request = $this->getCountriesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\Country[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\Country[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\Country[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\Country[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\Country[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCountriesAsync
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountriesAsync(string $contentType = self::contentTypes['getCountries'][0])
    {
        return $this->getCountriesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCountriesAsyncWithHttpInfo
     *
     * GetCountries
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountriesAsyncWithHttpInfo(string $contentType = self::contentTypes['getCountries'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\Country[]';
        $request = $this->getCountriesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCountries'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountries'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCountriesRequest(string $contentType = self::contentTypes['getCountries'][0])
    {


        $resourcePath = '/api/Inventory/GetCountries';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCountryCodes
     *
     * GetCountryCodes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountryCodes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,string>
     */
    public function getCountryCodes(string $contentType = self::contentTypes['getCountryCodes'][0])
    {
        list($response) = $this->getCountryCodesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getCountryCodesWithHttpInfo
     *
     * GetCountryCodes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountryCodes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,string>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCountryCodesWithHttpInfo(string $contentType = self::contentTypes['getCountryCodes'][0])
    {
        $request = $this->getCountryCodesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,string>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,string>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,string>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,string>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,string>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCountryCodesAsync
     *
     * GetCountryCodes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountryCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountryCodesAsync(string $contentType = self::contentTypes['getCountryCodes'][0])
    {
        return $this->getCountryCodesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCountryCodesAsyncWithHttpInfo
     *
     * GetCountryCodes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountryCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCountryCodesAsyncWithHttpInfo(string $contentType = self::contentTypes['getCountryCodes'][0])
    {
        $returnType = 'array<string,string>';
        $request = $this->getCountryCodesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCountryCodes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCountryCodes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCountryCodesRequest(string $contentType = self::contentTypes['getCountryCodes'][0])
    {


        $resourcePath = '/api/Inventory/GetCountryCodes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEbayCompatibilityList
     *
     * GetEbayCompatibilityList
     *
     * @param  string|null $stock_item_id Stock Item Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemEbayCompatibility[]
     */
    public function getEbayCompatibilityList($stock_item_id = null, string $contentType = self::contentTypes['getEbayCompatibilityList'][0])
    {
        list($response) = $this->getEbayCompatibilityListWithHttpInfo($stock_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getEbayCompatibilityListWithHttpInfo
     *
     * GetEbayCompatibilityList
     *
     * @param  string|null $stock_item_id Stock Item Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemEbayCompatibility[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getEbayCompatibilityListWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getEbayCompatibilityList'][0])
    {
        $request = $this->getEbayCompatibilityListRequest($stock_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemEbayCompatibility[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemEbayCompatibility[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemEbayCompatibility[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemEbayCompatibility[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemEbayCompatibility[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEbayCompatibilityListAsync
     *
     * GetEbayCompatibilityList
     *
     * @param  string|null $stock_item_id Stock Item Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEbayCompatibilityListAsync($stock_item_id = null, string $contentType = self::contentTypes['getEbayCompatibilityList'][0])
    {
        return $this->getEbayCompatibilityListAsyncWithHttpInfo($stock_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEbayCompatibilityListAsyncWithHttpInfo
     *
     * GetEbayCompatibilityList
     *
     * @param  string|null $stock_item_id Stock Item Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEbayCompatibilityListAsyncWithHttpInfo($stock_item_id = null, string $contentType = self::contentTypes['getEbayCompatibilityList'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemEbayCompatibility[]';
        $request = $this->getEbayCompatibilityListRequest($stock_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEbayCompatibilityList'
     *
     * @param  string|null $stock_item_id Stock Item Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEbayCompatibilityList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEbayCompatibilityListRequest($stock_item_id = null, string $contentType = self::contentTypes['getEbayCompatibilityList'][0])
    {



        $resourcePath = '/api/Inventory/GetEbayCompatibilityList';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExtendedPropertyNames
     *
     * GetExtendedPropertyNames
     *
     * @param  string|null $property_type property_type (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getExtendedPropertyNames($property_type = null, string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        list($response) = $this->getExtendedPropertyNamesWithHttpInfo($property_type, $contentType);
        return $response;
    }

    /**
     * Operation getExtendedPropertyNamesWithHttpInfo
     *
     * GetExtendedPropertyNames
     *
     * @param  string|null $property_type (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getExtendedPropertyNamesWithHttpInfo($property_type = null, string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        $request = $this->getExtendedPropertyNamesRequest($property_type, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExtendedPropertyNamesAsync
     *
     * GetExtendedPropertyNames
     *
     * @param  string|null $property_type (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyNamesAsync($property_type = null, string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        return $this->getExtendedPropertyNamesAsyncWithHttpInfo($property_type, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExtendedPropertyNamesAsyncWithHttpInfo
     *
     * GetExtendedPropertyNames
     *
     * @param  string|null $property_type (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyNamesAsyncWithHttpInfo($property_type = null, string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {
        $returnType = 'string[]';
        $request = $this->getExtendedPropertyNamesRequest($property_type, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExtendedPropertyNames'
     *
     * @param  string|null $property_type (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyNames'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExtendedPropertyNamesRequest($property_type = null, string $contentType = self::contentTypes['getExtendedPropertyNames'][0])
    {



        $resourcePath = '/api/Inventory/GetExtendedPropertyNames';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $property_type,
            'propertyType', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExtendedPropertyTypes
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function getExtendedPropertyTypes(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        list($response) = $this->getExtendedPropertyTypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getExtendedPropertyTypesWithHttpInfo
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getExtendedPropertyTypesWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        $request = $this->getExtendedPropertyTypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExtendedPropertyTypesAsync
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyTypesAsync(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        return $this->getExtendedPropertyTypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExtendedPropertyTypesAsyncWithHttpInfo
     *
     * GetExtendedPropertyTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExtendedPropertyTypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {
        $returnType = 'string[]';
        $request = $this->getExtendedPropertyTypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExtendedPropertyTypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExtendedPropertyTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExtendedPropertyTypesRequest(string $contentType = self::contentTypes['getExtendedPropertyTypes'][0])
    {


        $resourcePath = '/api/Inventory/GetExtendedPropertyTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getImagesInBulk
     *
     * GetImagesInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest $inventory_get_images_in_bulk_request inventory_get_images_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImagesInBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\GetImagesInBulkResponse
     */
    public function getImagesInBulk($inventory_get_images_in_bulk_request, string $contentType = self::contentTypes['getImagesInBulk'][0])
    {
        list($response) = $this->getImagesInBulkWithHttpInfo($inventory_get_images_in_bulk_request, $contentType);
        return $response;
    }

    /**
     * Operation getImagesInBulkWithHttpInfo
     *
     * GetImagesInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest $inventory_get_images_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImagesInBulk'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\GetImagesInBulkResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getImagesInBulkWithHttpInfo($inventory_get_images_in_bulk_request, string $contentType = self::contentTypes['getImagesInBulk'][0])
    {
        $request = $this->getImagesInBulkRequest($inventory_get_images_in_bulk_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\GetImagesInBulkResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\GetImagesInBulkResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\GetImagesInBulkResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\GetImagesInBulkResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\GetImagesInBulkResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getImagesInBulkAsync
     *
     * GetImagesInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest $inventory_get_images_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImagesInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImagesInBulkAsync($inventory_get_images_in_bulk_request, string $contentType = self::contentTypes['getImagesInBulk'][0])
    {
        return $this->getImagesInBulkAsyncWithHttpInfo($inventory_get_images_in_bulk_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getImagesInBulkAsyncWithHttpInfo
     *
     * GetImagesInBulk
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest $inventory_get_images_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImagesInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getImagesInBulkAsyncWithHttpInfo($inventory_get_images_in_bulk_request, string $contentType = self::contentTypes['getImagesInBulk'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\GetImagesInBulkResponse';
        $request = $this->getImagesInBulkRequest($inventory_get_images_in_bulk_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getImagesInBulk'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest $inventory_get_images_in_bulk_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getImagesInBulk'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getImagesInBulkRequest($inventory_get_images_in_bulk_request, string $contentType = self::contentTypes['getImagesInBulk'][0])
    {

        // verify the required parameter 'inventory_get_images_in_bulk_request' is set
        if ($inventory_get_images_in_bulk_request === null || (is_array($inventory_get_images_in_bulk_request) && count($inventory_get_images_in_bulk_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_images_in_bulk_request when calling getImagesInBulk'
            );
        }


        $resourcePath = '/api/Inventory/GetImagesInBulk';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_images_in_bulk_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_images_in_bulk_request));
            } else {
                $httpBody = $inventory_get_images_in_bulk_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryBatchTypes
     *
     * GetInventoryBatchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryBatchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,int>
     */
    public function getInventoryBatchTypes(string $contentType = self::contentTypes['getInventoryBatchTypes'][0])
    {
        list($response) = $this->getInventoryBatchTypesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getInventoryBatchTypesWithHttpInfo
     *
     * GetInventoryBatchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryBatchTypes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,int>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryBatchTypesWithHttpInfo(string $contentType = self::contentTypes['getInventoryBatchTypes'][0])
    {
        $request = $this->getInventoryBatchTypesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,int>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,int>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,int>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,int>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,int>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryBatchTypesAsync
     *
     * GetInventoryBatchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryBatchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryBatchTypesAsync(string $contentType = self::contentTypes['getInventoryBatchTypes'][0])
    {
        return $this->getInventoryBatchTypesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryBatchTypesAsyncWithHttpInfo
     *
     * GetInventoryBatchTypes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryBatchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryBatchTypesAsyncWithHttpInfo(string $contentType = self::contentTypes['getInventoryBatchTypes'][0])
    {
        $returnType = 'array<string,int>';
        $request = $this->getInventoryBatchTypesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryBatchTypes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryBatchTypes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryBatchTypesRequest(string $contentType = self::contentTypes['getInventoryBatchTypes'][0])
    {


        $resourcePath = '/api/Inventory/GetInventoryBatchTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItem
     *
     * GetInventoryItem
     *
     * @param  string|null $stock_item_id The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used (optional)
     * @param  string|null $s_ku The SKU for the item.  Only used when StockItemId is not supplied (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemInv
     */
    public function getInventoryItem($stock_item_id = null, $s_ku = null, string $contentType = self::contentTypes['getInventoryItem'][0])
    {
        list($response) = $this->getInventoryItemWithHttpInfo($stock_item_id, $s_ku, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemWithHttpInfo
     *
     * GetInventoryItem
     *
     * @param  string|null $stock_item_id The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used (optional)
     * @param  string|null $s_ku The SKU for the item.  Only used when StockItemId is not supplied (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItem'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemInv, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemWithHttpInfo($stock_item_id = null, $s_ku = null, string $contentType = self::contentTypes['getInventoryItem'][0])
    {
        $request = $this->getInventoryItemRequest($stock_item_id, $s_ku, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemInv' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemInv' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemInv', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemInv';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemInv',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemAsync
     *
     * GetInventoryItem
     *
     * @param  string|null $stock_item_id The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used (optional)
     * @param  string|null $s_ku The SKU for the item.  Only used when StockItemId is not supplied (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAsync($stock_item_id = null, $s_ku = null, string $contentType = self::contentTypes['getInventoryItem'][0])
    {
        return $this->getInventoryItemAsyncWithHttpInfo($stock_item_id, $s_ku, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemAsyncWithHttpInfo
     *
     * GetInventoryItem
     *
     * @param  string|null $stock_item_id The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used (optional)
     * @param  string|null $s_ku The SKU for the item.  Only used when StockItemId is not supplied (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAsyncWithHttpInfo($stock_item_id = null, $s_ku = null, string $contentType = self::contentTypes['getInventoryItem'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemInv';
        $request = $this->getInventoryItemRequest($stock_item_id, $s_ku, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItem'
     *
     * @param  string|null $stock_item_id The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used (optional)
     * @param  string|null $s_ku The SKU for the item.  Only used when StockItemId is not supplied (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItem'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemRequest($stock_item_id = null, $s_ku = null, string $contentType = self::contentTypes['getInventoryItem'][0])
    {




        $resourcePath = '/api/Inventory/GetInventoryItem';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $s_ku,
            'sKU', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemAuditTrail
     *
     * GetInventoryItemAuditTrail
     *
     * @param  string|null $inventory_item_id StockItem unique identifier (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemAuditTrail[]
     */
    public function getInventoryItemAuditTrail($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemAuditTrail'][0])
    {
        list($response) = $this->getInventoryItemAuditTrailWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemAuditTrailWithHttpInfo
     *
     * GetInventoryItemAuditTrail
     *
     * @param  string|null $inventory_item_id StockItem unique identifier (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrail'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemAuditTrail[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemAuditTrailWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemAuditTrail'][0])
    {
        $request = $this->getInventoryItemAuditTrailRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemAuditTrail[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemAuditTrail[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemAuditTrail[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemAuditTrail[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemAuditTrail[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemAuditTrailAsync
     *
     * GetInventoryItemAuditTrail
     *
     * @param  string|null $inventory_item_id StockItem unique identifier (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAuditTrailAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemAuditTrail'][0])
    {
        return $this->getInventoryItemAuditTrailAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemAuditTrailAsyncWithHttpInfo
     *
     * GetInventoryItemAuditTrail
     *
     * @param  string|null $inventory_item_id StockItem unique identifier (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAuditTrailAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemAuditTrail'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemAuditTrail[]';
        $request = $this->getInventoryItemAuditTrailRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemAuditTrail'
     *
     * @param  string|null $inventory_item_id StockItem unique identifier (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemAuditTrailRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemAuditTrail'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemAuditTrail';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemAuditTrailPaged
     *
     * GetInventoryItemAuditTrailPaged
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest $inventory_get_inventory_item_audit_trail_paged_request inventory_get_inventory_item_audit_trail_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrailPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\PagedResultStockItemAuditTrail
     */
    public function getInventoryItemAuditTrailPaged($inventory_get_inventory_item_audit_trail_paged_request, string $contentType = self::contentTypes['getInventoryItemAuditTrailPaged'][0])
    {
        list($response) = $this->getInventoryItemAuditTrailPagedWithHttpInfo($inventory_get_inventory_item_audit_trail_paged_request, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemAuditTrailPagedWithHttpInfo
     *
     * GetInventoryItemAuditTrailPaged
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest $inventory_get_inventory_item_audit_trail_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrailPaged'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\PagedResultStockItemAuditTrail, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemAuditTrailPagedWithHttpInfo($inventory_get_inventory_item_audit_trail_paged_request, string $contentType = self::contentTypes['getInventoryItemAuditTrailPaged'][0])
    {
        $request = $this->getInventoryItemAuditTrailPagedRequest($inventory_get_inventory_item_audit_trail_paged_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemAuditTrailPagedAsync
     *
     * GetInventoryItemAuditTrailPaged
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest $inventory_get_inventory_item_audit_trail_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrailPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAuditTrailPagedAsync($inventory_get_inventory_item_audit_trail_paged_request, string $contentType = self::contentTypes['getInventoryItemAuditTrailPaged'][0])
    {
        return $this->getInventoryItemAuditTrailPagedAsyncWithHttpInfo($inventory_get_inventory_item_audit_trail_paged_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemAuditTrailPagedAsyncWithHttpInfo
     *
     * GetInventoryItemAuditTrailPaged
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest $inventory_get_inventory_item_audit_trail_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrailPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemAuditTrailPagedAsyncWithHttpInfo($inventory_get_inventory_item_audit_trail_paged_request, string $contentType = self::contentTypes['getInventoryItemAuditTrailPaged'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail';
        $request = $this->getInventoryItemAuditTrailPagedRequest($inventory_get_inventory_item_audit_trail_paged_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemAuditTrailPaged'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest $inventory_get_inventory_item_audit_trail_paged_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemAuditTrailPaged'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemAuditTrailPagedRequest($inventory_get_inventory_item_audit_trail_paged_request, string $contentType = self::contentTypes['getInventoryItemAuditTrailPaged'][0])
    {

        // verify the required parameter 'inventory_get_inventory_item_audit_trail_paged_request' is set
        if ($inventory_get_inventory_item_audit_trail_paged_request === null || (is_array($inventory_get_inventory_item_audit_trail_paged_request) && count($inventory_get_inventory_item_audit_trail_paged_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_inventory_item_audit_trail_paged_request when calling getInventoryItemAuditTrailPaged'
            );
        }


        $resourcePath = '/api/Inventory/GetInventoryItemAuditTrailPaged';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_inventory_item_audit_trail_paged_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_inventory_item_audit_trail_paged_request));
            } else {
                $httpBody = $inventory_get_inventory_item_audit_trail_paged_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemBatchInformation
     *
     * GetInventoryItemBatchInformation
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest $inventory_get_inventory_item_batch_information_request inventory_get_inventory_item_batch_information_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemBatch[]
     */
    public function getInventoryItemBatchInformation($inventory_get_inventory_item_batch_information_request, string $contentType = self::contentTypes['getInventoryItemBatchInformation'][0])
    {
        list($response) = $this->getInventoryItemBatchInformationWithHttpInfo($inventory_get_inventory_item_batch_information_request, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemBatchInformationWithHttpInfo
     *
     * GetInventoryItemBatchInformation
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest $inventory_get_inventory_item_batch_information_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemBatch[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemBatchInformationWithHttpInfo($inventory_get_inventory_item_batch_information_request, string $contentType = self::contentTypes['getInventoryItemBatchInformation'][0])
    {
        $request = $this->getInventoryItemBatchInformationRequest($inventory_get_inventory_item_batch_information_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemBatch[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemBatch[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemBatch[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemBatch[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemBatch[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemBatchInformationAsync
     *
     * GetInventoryItemBatchInformation
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest $inventory_get_inventory_item_batch_information_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemBatchInformationAsync($inventory_get_inventory_item_batch_information_request, string $contentType = self::contentTypes['getInventoryItemBatchInformation'][0])
    {
        return $this->getInventoryItemBatchInformationAsyncWithHttpInfo($inventory_get_inventory_item_batch_information_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemBatchInformationAsyncWithHttpInfo
     *
     * GetInventoryItemBatchInformation
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest $inventory_get_inventory_item_batch_information_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemBatchInformationAsyncWithHttpInfo($inventory_get_inventory_item_batch_information_request, string $contentType = self::contentTypes['getInventoryItemBatchInformation'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemBatch[]';
        $request = $this->getInventoryItemBatchInformationRequest($inventory_get_inventory_item_batch_information_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemBatchInformation'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest $inventory_get_inventory_item_batch_information_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemBatchInformationRequest($inventory_get_inventory_item_batch_information_request, string $contentType = self::contentTypes['getInventoryItemBatchInformation'][0])
    {

        // verify the required parameter 'inventory_get_inventory_item_batch_information_request' is set
        if ($inventory_get_inventory_item_batch_information_request === null || (is_array($inventory_get_inventory_item_batch_information_request) && count($inventory_get_inventory_item_batch_information_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_inventory_item_batch_information_request when calling getInventoryItemBatchInformation'
            );
        }


        $resourcePath = '/api/Inventory/GetInventoryItemBatchInformation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_inventory_item_batch_information_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_inventory_item_batch_information_request));
            } else {
                $httpBody = $inventory_get_inventory_item_batch_information_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemBatchInformationByIds
     *
     * GetInventoryItemBatchInformationByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest $inventory_get_inventory_item_batch_information_by_ids_request inventory_get_inventory_item_batch_information_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformationByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse
     */
    public function getInventoryItemBatchInformationByIds($inventory_get_inventory_item_batch_information_by_ids_request, string $contentType = self::contentTypes['getInventoryItemBatchInformationByIds'][0])
    {
        list($response) = $this->getInventoryItemBatchInformationByIdsWithHttpInfo($inventory_get_inventory_item_batch_information_by_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemBatchInformationByIdsWithHttpInfo
     *
     * GetInventoryItemBatchInformationByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest $inventory_get_inventory_item_batch_information_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformationByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemBatchInformationByIdsWithHttpInfo($inventory_get_inventory_item_batch_information_by_ids_request, string $contentType = self::contentTypes['getInventoryItemBatchInformationByIds'][0])
    {
        $request = $this->getInventoryItemBatchInformationByIdsRequest($inventory_get_inventory_item_batch_information_by_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemBatchInformationByIdsAsync
     *
     * GetInventoryItemBatchInformationByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest $inventory_get_inventory_item_batch_information_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformationByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemBatchInformationByIdsAsync($inventory_get_inventory_item_batch_information_by_ids_request, string $contentType = self::contentTypes['getInventoryItemBatchInformationByIds'][0])
    {
        return $this->getInventoryItemBatchInformationByIdsAsyncWithHttpInfo($inventory_get_inventory_item_batch_information_by_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemBatchInformationByIdsAsyncWithHttpInfo
     *
     * GetInventoryItemBatchInformationByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest $inventory_get_inventory_item_batch_information_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformationByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemBatchInformationByIdsAsyncWithHttpInfo($inventory_get_inventory_item_batch_information_by_ids_request, string $contentType = self::contentTypes['getInventoryItemBatchInformationByIds'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse';
        $request = $this->getInventoryItemBatchInformationByIdsRequest($inventory_get_inventory_item_batch_information_by_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemBatchInformationByIds'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest $inventory_get_inventory_item_batch_information_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemBatchInformationByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemBatchInformationByIdsRequest($inventory_get_inventory_item_batch_information_by_ids_request, string $contentType = self::contentTypes['getInventoryItemBatchInformationByIds'][0])
    {

        // verify the required parameter 'inventory_get_inventory_item_batch_information_by_ids_request' is set
        if ($inventory_get_inventory_item_batch_information_by_ids_request === null || (is_array($inventory_get_inventory_item_batch_information_by_ids_request) && count($inventory_get_inventory_item_batch_information_by_ids_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_inventory_item_batch_information_by_ids_request when calling getInventoryItemBatchInformationByIds'
            );
        }


        $resourcePath = '/api/Inventory/GetInventoryItemBatchInformationByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_inventory_item_batch_information_by_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_inventory_item_batch_information_by_ids_request));
            } else {
                $httpBody = $inventory_get_inventory_item_batch_information_by_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemById
     *
     * GetInventoryItemById
     *
     * @param  string|null $id id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemInv
     */
    public function getInventoryItemById($id = null, string $contentType = self::contentTypes['getInventoryItemById'][0])
    {
        list($response) = $this->getInventoryItemByIdWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemByIdWithHttpInfo
     *
     * GetInventoryItemById
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemInv, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemByIdWithHttpInfo($id = null, string $contentType = self::contentTypes['getInventoryItemById'][0])
    {
        $request = $this->getInventoryItemByIdRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemInv' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemInv' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemInv', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemInv';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemInv',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemByIdAsync
     *
     * GetInventoryItemById
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemByIdAsync($id = null, string $contentType = self::contentTypes['getInventoryItemById'][0])
    {
        return $this->getInventoryItemByIdAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemByIdAsyncWithHttpInfo
     *
     * GetInventoryItemById
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemByIdAsyncWithHttpInfo($id = null, string $contentType = self::contentTypes['getInventoryItemById'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemInv';
        $request = $this->getInventoryItemByIdRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemById'
     *
     * @param  string|null $id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemByIdRequest($id = null, string $contentType = self::contentTypes['getInventoryItemById'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $id,
            'id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemChannelSKUs
     *
     * GetInventoryItemChannelSKUs
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemChannelSKU[]
     */
    public function getInventoryItemChannelSKUs($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUs'][0])
    {
        list($response) = $this->getInventoryItemChannelSKUsWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemChannelSKUsWithHttpInfo
     *
     * GetInventoryItemChannelSKUs
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemChannelSKU[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemChannelSKUsWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUs'][0])
    {
        $request = $this->getInventoryItemChannelSKUsRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemChannelSKU[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemChannelSKU[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemChannelSKU[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemChannelSKU[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemChannelSKU[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemChannelSKUsAsync
     *
     * GetInventoryItemChannelSKUs
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemChannelSKUsAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUs'][0])
    {
        return $this->getInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemChannelSKUsAsyncWithHttpInfo
     *
     * GetInventoryItemChannelSKUs
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemChannelSKUsAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUs'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemChannelSKU[]';
        $request = $this->getInventoryItemChannelSKUsRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemChannelSKUs'
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUs'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemChannelSKUsRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUs'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemChannelSKUs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemChannelSKUsWithLocation
     *
     * GetInventoryItemChannelSKUsWithLocation
     *
     * @param  string|null $channel_sku_row_id ChannelSKU record Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUsWithLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]
     */
    public function getInventoryItemChannelSKUsWithLocation($channel_sku_row_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUsWithLocation'][0])
    {
        list($response) = $this->getInventoryItemChannelSKUsWithLocationWithHttpInfo($channel_sku_row_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemChannelSKUsWithLocationWithHttpInfo
     *
     * GetInventoryItemChannelSKUsWithLocation
     *
     * @param  string|null $channel_sku_row_id ChannelSKU record Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUsWithLocation'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemChannelSKUsWithLocationWithHttpInfo($channel_sku_row_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUsWithLocation'][0])
    {
        $request = $this->getInventoryItemChannelSKUsWithLocationRequest($channel_sku_row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemChannelSKUsWithLocationAsync
     *
     * GetInventoryItemChannelSKUsWithLocation
     *
     * @param  string|null $channel_sku_row_id ChannelSKU record Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUsWithLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemChannelSKUsWithLocationAsync($channel_sku_row_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUsWithLocation'][0])
    {
        return $this->getInventoryItemChannelSKUsWithLocationAsyncWithHttpInfo($channel_sku_row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemChannelSKUsWithLocationAsyncWithHttpInfo
     *
     * GetInventoryItemChannelSKUsWithLocation
     *
     * @param  string|null $channel_sku_row_id ChannelSKU record Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUsWithLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemChannelSKUsWithLocationAsyncWithHttpInfo($channel_sku_row_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUsWithLocation'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]';
        $request = $this->getInventoryItemChannelSKUsWithLocationRequest($channel_sku_row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemChannelSKUsWithLocation'
     *
     * @param  string|null $channel_sku_row_id ChannelSKU record Id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemChannelSKUsWithLocation'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemChannelSKUsWithLocationRequest($channel_sku_row_id = null, string $contentType = self::contentTypes['getInventoryItemChannelSKUsWithLocation'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemChannelSKUsWithLocation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $channel_sku_row_id,
            'channelSKURowId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemCompositions
     *
     * GetInventoryItemCompositions
     *
     * @param  string|null $inventory_item_id Id of StockItem (optional)
     * @param  bool|null $get_full_detail Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemComposition[]
     */
    public function getInventoryItemCompositions($inventory_item_id = null, $get_full_detail = null, string $contentType = self::contentTypes['getInventoryItemCompositions'][0])
    {
        list($response) = $this->getInventoryItemCompositionsWithHttpInfo($inventory_item_id, $get_full_detail, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemCompositionsWithHttpInfo
     *
     * GetInventoryItemCompositions
     *
     * @param  string|null $inventory_item_id Id of StockItem (optional)
     * @param  bool|null $get_full_detail Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemComposition[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemCompositionsWithHttpInfo($inventory_item_id = null, $get_full_detail = null, string $contentType = self::contentTypes['getInventoryItemCompositions'][0])
    {
        $request = $this->getInventoryItemCompositionsRequest($inventory_item_id, $get_full_detail, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemComposition[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemComposition[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemComposition[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemComposition[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemComposition[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemCompositionsAsync
     *
     * GetInventoryItemCompositions
     *
     * @param  string|null $inventory_item_id Id of StockItem (optional)
     * @param  bool|null $get_full_detail Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemCompositionsAsync($inventory_item_id = null, $get_full_detail = null, string $contentType = self::contentTypes['getInventoryItemCompositions'][0])
    {
        return $this->getInventoryItemCompositionsAsyncWithHttpInfo($inventory_item_id, $get_full_detail, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemCompositionsAsyncWithHttpInfo
     *
     * GetInventoryItemCompositions
     *
     * @param  string|null $inventory_item_id Id of StockItem (optional)
     * @param  bool|null $get_full_detail Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemCompositionsAsyncWithHttpInfo($inventory_item_id = null, $get_full_detail = null, string $contentType = self::contentTypes['getInventoryItemCompositions'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemComposition[]';
        $request = $this->getInventoryItemCompositionsRequest($inventory_item_id, $get_full_detail, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemCompositions'
     *
     * @param  string|null $inventory_item_id Id of StockItem (optional)
     * @param  bool|null $get_full_detail Indicate if the method has to be recursive, going throw inner composites, getting only real items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemCompositions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemCompositionsRequest($inventory_item_id = null, $get_full_detail = null, string $contentType = self::contentTypes['getInventoryItemCompositions'][0])
    {




        $resourcePath = '/api/Inventory/GetInventoryItemCompositions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $get_full_detail,
            'getFullDetail', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemDescriptions
     *
     * GetInventoryItemDescriptions
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemDescription[]
     */
    public function getInventoryItemDescriptions($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemDescriptions'][0])
    {
        list($response) = $this->getInventoryItemDescriptionsWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemDescriptionsWithHttpInfo
     *
     * GetInventoryItemDescriptions
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemDescription[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemDescriptionsWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemDescriptions'][0])
    {
        $request = $this->getInventoryItemDescriptionsRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemDescription[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemDescription[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemDescription[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemDescription[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemDescription[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemDescriptionsAsync
     *
     * GetInventoryItemDescriptions
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemDescriptionsAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemDescriptions'][0])
    {
        return $this->getInventoryItemDescriptionsAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemDescriptionsAsyncWithHttpInfo
     *
     * GetInventoryItemDescriptions
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemDescriptionsAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemDescriptions'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemDescription[]';
        $request = $this->getInventoryItemDescriptionsRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemDescriptions'
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemDescriptions'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemDescriptionsRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemDescriptions'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemDescriptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemExtendedProperties
     *
     * GetInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest $inventory_get_inventory_item_extended_properties_request inventory_get_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemExtendedProperty[]
     */
    public function getInventoryItemExtendedProperties($inventory_get_inventory_item_extended_properties_request, string $contentType = self::contentTypes['getInventoryItemExtendedProperties'][0])
    {
        list($response) = $this->getInventoryItemExtendedPropertiesWithHttpInfo($inventory_get_inventory_item_extended_properties_request, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemExtendedPropertiesWithHttpInfo
     *
     * GetInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest $inventory_get_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemExtendedProperty[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemExtendedPropertiesWithHttpInfo($inventory_get_inventory_item_extended_properties_request, string $contentType = self::contentTypes['getInventoryItemExtendedProperties'][0])
    {
        $request = $this->getInventoryItemExtendedPropertiesRequest($inventory_get_inventory_item_extended_properties_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemExtendedProperty[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemExtendedProperty[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemExtendedProperty[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemExtendedProperty[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemExtendedProperty[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemExtendedPropertiesAsync
     *
     * GetInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest $inventory_get_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemExtendedPropertiesAsync($inventory_get_inventory_item_extended_properties_request, string $contentType = self::contentTypes['getInventoryItemExtendedProperties'][0])
    {
        return $this->getInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_get_inventory_item_extended_properties_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemExtendedPropertiesAsyncWithHttpInfo
     *
     * GetInventoryItemExtendedProperties
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest $inventory_get_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemExtendedPropertiesAsyncWithHttpInfo($inventory_get_inventory_item_extended_properties_request, string $contentType = self::contentTypes['getInventoryItemExtendedProperties'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemExtendedProperty[]';
        $request = $this->getInventoryItemExtendedPropertiesRequest($inventory_get_inventory_item_extended_properties_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemExtendedProperties'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest $inventory_get_inventory_item_extended_properties_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemExtendedProperties'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemExtendedPropertiesRequest($inventory_get_inventory_item_extended_properties_request, string $contentType = self::contentTypes['getInventoryItemExtendedProperties'][0])
    {

        // verify the required parameter 'inventory_get_inventory_item_extended_properties_request' is set
        if ($inventory_get_inventory_item_extended_properties_request === null || (is_array($inventory_get_inventory_item_extended_properties_request) && count($inventory_get_inventory_item_extended_properties_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_inventory_item_extended_properties_request when calling getInventoryItemExtendedProperties'
            );
        }


        $resourcePath = '/api/Inventory/GetInventoryItemExtendedProperties';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_inventory_item_extended_properties_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_inventory_item_extended_properties_request));
            } else {
                $httpBody = $inventory_get_inventory_item_extended_properties_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemImages
     *
     * GetInventoryItemImages
     *
     * @param  string|null $inventory_item_id Conditional. If not provided, you must provide ItemNumber (optional)
     * @param  string|null $item_number Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemImages'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemImage[]
     */
    public function getInventoryItemImages($inventory_item_id = null, $item_number = null, string $contentType = self::contentTypes['getInventoryItemImages'][0])
    {
        list($response) = $this->getInventoryItemImagesWithHttpInfo($inventory_item_id, $item_number, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemImagesWithHttpInfo
     *
     * GetInventoryItemImages
     *
     * @param  string|null $inventory_item_id Conditional. If not provided, you must provide ItemNumber (optional)
     * @param  string|null $item_number Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemImages'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemImage[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemImagesWithHttpInfo($inventory_item_id = null, $item_number = null, string $contentType = self::contentTypes['getInventoryItemImages'][0])
    {
        $request = $this->getInventoryItemImagesRequest($inventory_item_id, $item_number, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemImage[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemImage[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemImage[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemImage[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemImage[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemImagesAsync
     *
     * GetInventoryItemImages
     *
     * @param  string|null $inventory_item_id Conditional. If not provided, you must provide ItemNumber (optional)
     * @param  string|null $item_number Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemImagesAsync($inventory_item_id = null, $item_number = null, string $contentType = self::contentTypes['getInventoryItemImages'][0])
    {
        return $this->getInventoryItemImagesAsyncWithHttpInfo($inventory_item_id, $item_number, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemImagesAsyncWithHttpInfo
     *
     * GetInventoryItemImages
     *
     * @param  string|null $inventory_item_id Conditional. If not provided, you must provide ItemNumber (optional)
     * @param  string|null $item_number Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemImagesAsyncWithHttpInfo($inventory_item_id = null, $item_number = null, string $contentType = self::contentTypes['getInventoryItemImages'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemImage[]';
        $request = $this->getInventoryItemImagesRequest($inventory_item_id, $item_number, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemImages'
     *
     * @param  string|null $inventory_item_id Conditional. If not provided, you must provide ItemNumber (optional)
     * @param  string|null $item_number Conditional. if InventoryItemId is provided, ItemNumber will be ignored (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemImages'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemImagesRequest($inventory_item_id = null, $item_number = null, string $contentType = self::contentTypes['getInventoryItemImages'][0])
    {




        $resourcePath = '/api/Inventory/GetInventoryItemImages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $item_number,
            'itemNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemLocations
     *
     * GetInventoryItemLocations
     *
     * @param  string|null $inventory_item_id Stock item ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemLocation[]
     */
    public function getInventoryItemLocations($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemLocations'][0])
    {
        list($response) = $this->getInventoryItemLocationsWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemLocationsWithHttpInfo
     *
     * GetInventoryItemLocations
     *
     * @param  string|null $inventory_item_id Stock item ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemLocations'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemLocation[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemLocationsWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemLocations'][0])
    {
        $request = $this->getInventoryItemLocationsRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemLocation[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemLocation[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemLocation[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemLocation[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemLocation[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemLocationsAsync
     *
     * GetInventoryItemLocations
     *
     * @param  string|null $inventory_item_id Stock item ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemLocationsAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemLocations'][0])
    {
        return $this->getInventoryItemLocationsAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemLocationsAsyncWithHttpInfo
     *
     * GetInventoryItemLocations
     *
     * @param  string|null $inventory_item_id Stock item ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemLocationsAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemLocations'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemLocation[]';
        $request = $this->getInventoryItemLocationsRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemLocations'
     *
     * @param  string|null $inventory_item_id Stock item ID (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemLocations'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemLocationsRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemLocations'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemLocations';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemPriceChannelSuffixes
     *
     * GetInventoryItemPriceChannelSuffixes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceChannelSuffixes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,string[]>
     */
    public function getInventoryItemPriceChannelSuffixes(string $contentType = self::contentTypes['getInventoryItemPriceChannelSuffixes'][0])
    {
        list($response) = $this->getInventoryItemPriceChannelSuffixesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemPriceChannelSuffixesWithHttpInfo
     *
     * GetInventoryItemPriceChannelSuffixes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceChannelSuffixes'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,string[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemPriceChannelSuffixesWithHttpInfo(string $contentType = self::contentTypes['getInventoryItemPriceChannelSuffixes'][0])
    {
        $request = $this->getInventoryItemPriceChannelSuffixesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,string[]>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,string[]>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,string[]>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,string[]>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,string[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemPriceChannelSuffixesAsync
     *
     * GetInventoryItemPriceChannelSuffixes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceChannelSuffixes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceChannelSuffixesAsync(string $contentType = self::contentTypes['getInventoryItemPriceChannelSuffixes'][0])
    {
        return $this->getInventoryItemPriceChannelSuffixesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemPriceChannelSuffixesAsyncWithHttpInfo
     *
     * GetInventoryItemPriceChannelSuffixes
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceChannelSuffixes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceChannelSuffixesAsyncWithHttpInfo(string $contentType = self::contentTypes['getInventoryItemPriceChannelSuffixes'][0])
    {
        $returnType = 'array<string,string[]>';
        $request = $this->getInventoryItemPriceChannelSuffixesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemPriceChannelSuffixes'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceChannelSuffixes'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemPriceChannelSuffixesRequest(string $contentType = self::contentTypes['getInventoryItemPriceChannelSuffixes'][0])
    {


        $resourcePath = '/api/Inventory/GetInventoryItemPriceChannelSuffixes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemPriceRulesById
     *
     * GetInventoryItemPriceRulesById
     *
     * @param  string|null $stock_item_price_id Price ID of an item (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemPricingRule[]
     */
    public function getInventoryItemPriceRulesById($stock_item_price_id = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesById'][0])
    {
        list($response) = $this->getInventoryItemPriceRulesByIdWithHttpInfo($stock_item_price_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemPriceRulesByIdWithHttpInfo
     *
     * GetInventoryItemPriceRulesById
     *
     * @param  string|null $stock_item_price_id Price ID of an item (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesById'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemPricingRule[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemPriceRulesByIdWithHttpInfo($stock_item_price_id = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesById'][0])
    {
        $request = $this->getInventoryItemPriceRulesByIdRequest($stock_item_price_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemPricingRule[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemPricingRule[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemPricingRule[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemPricingRule[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemPricingRule[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemPriceRulesByIdAsync
     *
     * GetInventoryItemPriceRulesById
     *
     * @param  string|null $stock_item_price_id Price ID of an item (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceRulesByIdAsync($stock_item_price_id = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesById'][0])
    {
        return $this->getInventoryItemPriceRulesByIdAsyncWithHttpInfo($stock_item_price_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemPriceRulesByIdAsyncWithHttpInfo
     *
     * GetInventoryItemPriceRulesById
     *
     * @param  string|null $stock_item_price_id Price ID of an item (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceRulesByIdAsyncWithHttpInfo($stock_item_price_id = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesById'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemPricingRule[]';
        $request = $this->getInventoryItemPriceRulesByIdRequest($stock_item_price_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemPriceRulesById'
     *
     * @param  string|null $stock_item_price_id Price ID of an item (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemPriceRulesByIdRequest($stock_item_price_id = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesById'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemPriceRulesById';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_price_id,
            'stockItemPriceId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemPriceRulesBySource
     *
     * GetInventoryItemPriceRulesBySource
     *
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $source Channel source (optional)
     * @param  string|null $sub_source Channel subsource (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesBySource'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemPricingRule[]
     */
    public function getInventoryItemPriceRulesBySource($stock_item_id = null, $source = null, $sub_source = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesBySource'][0])
    {
        list($response) = $this->getInventoryItemPriceRulesBySourceWithHttpInfo($stock_item_id, $source, $sub_source, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemPriceRulesBySourceWithHttpInfo
     *
     * GetInventoryItemPriceRulesBySource
     *
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $source Channel source (optional)
     * @param  string|null $sub_source Channel subsource (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesBySource'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemPricingRule[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemPriceRulesBySourceWithHttpInfo($stock_item_id = null, $source = null, $sub_source = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesBySource'][0])
    {
        $request = $this->getInventoryItemPriceRulesBySourceRequest($stock_item_id, $source, $sub_source, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemPricingRule[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemPricingRule[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemPricingRule[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemPricingRule[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemPricingRule[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemPriceRulesBySourceAsync
     *
     * GetInventoryItemPriceRulesBySource
     *
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $source Channel source (optional)
     * @param  string|null $sub_source Channel subsource (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceRulesBySourceAsync($stock_item_id = null, $source = null, $sub_source = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesBySource'][0])
    {
        return $this->getInventoryItemPriceRulesBySourceAsyncWithHttpInfo($stock_item_id, $source, $sub_source, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemPriceRulesBySourceAsyncWithHttpInfo
     *
     * GetInventoryItemPriceRulesBySource
     *
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $source Channel source (optional)
     * @param  string|null $sub_source Channel subsource (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceRulesBySourceAsyncWithHttpInfo($stock_item_id = null, $source = null, $sub_source = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesBySource'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemPricingRule[]';
        $request = $this->getInventoryItemPriceRulesBySourceRequest($stock_item_id, $source, $sub_source, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemPriceRulesBySource'
     *
     * @param  string|null $stock_item_id Stock item id (optional)
     * @param  string|null $source Channel source (optional)
     * @param  string|null $sub_source Channel subsource (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceRulesBySource'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemPriceRulesBySourceRequest($stock_item_id = null, $source = null, $sub_source = null, string $contentType = self::contentTypes['getInventoryItemPriceRulesBySource'][0])
    {





        $resourcePath = '/api/Inventory/GetInventoryItemPriceRulesBySource';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $stock_item_id,
            'stockItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $source,
            'source', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $sub_source,
            'subSource', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemPriceTags
     *
     * GetInventoryItemPriceTags
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceTags'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array<string,string[]>
     */
    public function getInventoryItemPriceTags(string $contentType = self::contentTypes['getInventoryItemPriceTags'][0])
    {
        list($response) = $this->getInventoryItemPriceTagsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemPriceTagsWithHttpInfo
     *
     * GetInventoryItemPriceTags
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceTags'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of array<string,string[]>, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemPriceTagsWithHttpInfo(string $contentType = self::contentTypes['getInventoryItemPriceTags'][0])
    {
        $request = $this->getInventoryItemPriceTagsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('array<string,string[]>' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('array<string,string[]>' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'array<string,string[]>', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'array<string,string[]>';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'array<string,string[]>',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemPriceTagsAsync
     *
     * GetInventoryItemPriceTags
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceTagsAsync(string $contentType = self::contentTypes['getInventoryItemPriceTags'][0])
    {
        return $this->getInventoryItemPriceTagsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemPriceTagsAsyncWithHttpInfo
     *
     * GetInventoryItemPriceTags
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPriceTagsAsyncWithHttpInfo(string $contentType = self::contentTypes['getInventoryItemPriceTags'][0])
    {
        $returnType = 'array<string,string[]>';
        $request = $this->getInventoryItemPriceTagsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemPriceTags'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPriceTags'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemPriceTagsRequest(string $contentType = self::contentTypes['getInventoryItemPriceTags'][0])
    {


        $resourcePath = '/api/Inventory/GetInventoryItemPriceTags';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemPrices
     *
     * GetInventoryItemPrices
     *
     * @param  string|null $inventory_item_id Stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemPrice[]
     */
    public function getInventoryItemPrices($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemPrices'][0])
    {
        list($response) = $this->getInventoryItemPricesWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemPricesWithHttpInfo
     *
     * GetInventoryItemPrices
     *
     * @param  string|null $inventory_item_id Stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemPrice[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemPricesWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemPrices'][0])
    {
        $request = $this->getInventoryItemPricesRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemPrice[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemPrice[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemPrice[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemPrice[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemPrice[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemPricesAsync
     *
     * GetInventoryItemPrices
     *
     * @param  string|null $inventory_item_id Stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPricesAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemPrices'][0])
    {
        return $this->getInventoryItemPricesAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemPricesAsyncWithHttpInfo
     *
     * GetInventoryItemPrices
     *
     * @param  string|null $inventory_item_id Stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemPricesAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemPrices'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemPrice[]';
        $request = $this->getInventoryItemPricesRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemPrices'
     *
     * @param  string|null $inventory_item_id Stock item id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemPrices'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemPricesRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemPrices'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemPrices';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemTitles
     *
     * GetInventoryItemTitles
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\StockItemTitle[]
     */
    public function getInventoryItemTitles($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemTitles'][0])
    {
        list($response) = $this->getInventoryItemTitlesWithHttpInfo($inventory_item_id, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemTitlesWithHttpInfo
     *
     * GetInventoryItemTitles
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\StockItemTitle[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemTitlesWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemTitles'][0])
    {
        $request = $this->getInventoryItemTitlesRequest($inventory_item_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\StockItemTitle[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\StockItemTitle[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\StockItemTitle[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\StockItemTitle[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\StockItemTitle[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemTitlesAsync
     *
     * GetInventoryItemTitles
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemTitlesAsync($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemTitles'][0])
    {
        return $this->getInventoryItemTitlesAsyncWithHttpInfo($inventory_item_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemTitlesAsyncWithHttpInfo
     *
     * GetInventoryItemTitles
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemTitlesAsyncWithHttpInfo($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemTitles'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\StockItemTitle[]';
        $request = $this->getInventoryItemTitlesRequest($inventory_item_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemTitles'
     *
     * @param  string|null $inventory_item_id stockitem id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemTitles'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemTitlesRequest($inventory_item_id = null, string $contentType = self::contentTypes['getInventoryItemTitles'][0])
    {



        $resourcePath = '/api/Inventory/GetInventoryItemTitles';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $inventory_item_id,
            'inventoryItemId', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemsCompositionByIds
     *
     * GetInventoryItemsCompositionByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest $inventory_get_inventory_items_composition_by_ids_request inventory_get_inventory_items_composition_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCompositionByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse
     */
    public function getInventoryItemsCompositionByIds($inventory_get_inventory_items_composition_by_ids_request, string $contentType = self::contentTypes['getInventoryItemsCompositionByIds'][0])
    {
        list($response) = $this->getInventoryItemsCompositionByIdsWithHttpInfo($inventory_get_inventory_items_composition_by_ids_request, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemsCompositionByIdsWithHttpInfo
     *
     * GetInventoryItemsCompositionByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest $inventory_get_inventory_items_composition_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCompositionByIds'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemsCompositionByIdsWithHttpInfo($inventory_get_inventory_items_composition_by_ids_request, string $contentType = self::contentTypes['getInventoryItemsCompositionByIds'][0])
    {
        $request = $this->getInventoryItemsCompositionByIdsRequest($inventory_get_inventory_items_composition_by_ids_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemsCompositionByIdsAsync
     *
     * GetInventoryItemsCompositionByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest $inventory_get_inventory_items_composition_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCompositionByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemsCompositionByIdsAsync($inventory_get_inventory_items_composition_by_ids_request, string $contentType = self::contentTypes['getInventoryItemsCompositionByIds'][0])
    {
        return $this->getInventoryItemsCompositionByIdsAsyncWithHttpInfo($inventory_get_inventory_items_composition_by_ids_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemsCompositionByIdsAsyncWithHttpInfo
     *
     * GetInventoryItemsCompositionByIds
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest $inventory_get_inventory_items_composition_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCompositionByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemsCompositionByIdsAsyncWithHttpInfo($inventory_get_inventory_items_composition_by_ids_request, string $contentType = self::contentTypes['getInventoryItemsCompositionByIds'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse';
        $request = $this->getInventoryItemsCompositionByIdsRequest($inventory_get_inventory_items_composition_by_ids_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemsCompositionByIds'
     *
     * @param  \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest $inventory_get_inventory_items_composition_by_ids_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCompositionByIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemsCompositionByIdsRequest($inventory_get_inventory_items_composition_by_ids_request, string $contentType = self::contentTypes['getInventoryItemsCompositionByIds'][0])
    {

        // verify the required parameter 'inventory_get_inventory_items_composition_by_ids_request' is set
        if ($inventory_get_inventory_items_composition_by_ids_request === null || (is_array($inventory_get_inventory_items_composition_by_ids_request) && count($inventory_get_inventory_items_composition_by_ids_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $inventory_get_inventory_items_composition_by_ids_request when calling getInventoryItemsCompositionByIds'
            );
        }


        $resourcePath = '/api/Inventory/GetInventoryItemsCompositionByIds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($inventory_get_inventory_items_composition_by_ids_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($inventory_get_inventory_items_composition_by_ids_request));
            } else {
                $httpBody = $inventory_get_inventory_items_composition_by_ids_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getInventoryItemsCount
     *
     * GetInventoryItemsCount
     *
     * @param  bool|null $include_deleted Include deleted items (optional)
     * @param  bool|null $include_archived Include archived items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCount'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return int
     */
    public function getInventoryItemsCount($include_deleted = null, $include_archived = null, string $contentType = self::contentTypes['getInventoryItemsCount'][0])
    {
        list($response) = $this->getInventoryItemsCountWithHttpInfo($include_deleted, $include_archived, $contentType);
        return $response;
    }

    /**
     * Operation getInventoryItemsCountWithHttpInfo
     *
     * GetInventoryItemsCount
     *
     * @param  bool|null $include_deleted Include deleted items (optional)
     * @param  bool|null $include_archived Include archived items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCount'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of int, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInventoryItemsCountWithHttpInfo($include_deleted = null, $include_archived = null, string $contentType = self::contentTypes['getInventoryItemsCount'][0])
    {
        $request = $this->getInventoryItemsCountRequest($include_deleted, $include_archived, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('int' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('int' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'int', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'int';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getInventoryItemsCountAsync
     *
     * GetInventoryItemsCount
     *
     * @param  bool|null $include_deleted Include deleted items (optional)
     * @param  bool|null $include_archived Include archived items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemsCountAsync($include_deleted = null, $include_archived = null, string $contentType = self::contentTypes['getInventoryItemsCount'][0])
    {
        return $this->getInventoryItemsCountAsyncWithHttpInfo($include_deleted, $include_archived, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getInventoryItemsCountAsyncWithHttpInfo
     *
     * GetInventoryItemsCount
     *
     * @param  bool|null $include_deleted Include deleted items (optional)
     * @param  bool|null $include_archived Include archived items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getInventoryItemsCountAsyncWithHttpInfo($include_deleted = null, $include_archived = null, string $contentType = self::contentTypes['getInventoryItemsCount'][0])
    {
        $returnType = 'int';
        $request = $this->getInventoryItemsCountRequest($include_deleted, $include_archived, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getInventoryItemsCount'
     *
     * @param  bool|null $include_deleted Include deleted items (optional)
     * @param  bool|null $include_archived Include archived items (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getInventoryItemsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getInventoryItemsCountRequest($include_deleted = null, $include_archived = null, string $contentType = self::contentTypes['getInventoryItemsCount'][0])
    {




        $resourcePath = '/api/Inventory/GetInventoryItemsCount';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_deleted,
            'includeDeleted', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $include_archived,
            'includeArchived', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getNewItemNumber
     *
     * GetNewItemNumber
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getNewItemNumber'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return string
     */
    public function getNewItemNumber(string $contentType = self::contentTypes['getNewItemNumber'][0])
    {
        list($response) = $this->getNewItemNumberWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getNewItemNumberWithHttpInfo
     *
     * GetNewItemNumber
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getNewItemNumber'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of string, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNewItemNumberWithHttpInfo(string $contentType = self::contentTypes['getNewItemNumber'][0])
    {
        $request = $this->getNewItemNumberRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('string' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('string' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'string', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = 'string';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getNewItemNumberAsync
     *
     * GetNewItemNumber
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getNewItemNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNewItemNumberAsync(string $contentType = self::contentTypes['getNewItemNumber'][0])
    {
        return $this->getNewItemNumberAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getNewItemNumberAsyncWithHttpInfo
     *
     * GetNewItemNumber
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getNewItemNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getNewItemNumberAsyncWithHttpInfo(string $contentType = self::contentTypes['getNewItemNumber'][0])
    {
        $returnType = 'string';
        $request = $this->getNewItemNumberRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getNewItemNumber'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getNewItemNumber'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getNewItemNumberRequest(string $contentType = self::contentTypes['getNewItemNumber'][0])
    {


        $resourcePath = '/api/Inventory/GetNewItemNumber';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPackageGroups
     *
     * GetPackageGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Inventory\Model\KeyGuidValue[]
     */
    public function getPackageGroups(string $contentType = self::contentTypes['getPackageGroups'][0])
    {
        list($response) = $this->getPackageGroupsWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation getPackageGroupsWithHttpInfo
     *
     * GetPackageGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageGroups'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Inventory\Model\KeyGuidValue[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getPackageGroupsWithHttpInfo(string $contentType = self::contentTypes['getPackageGroups'][0])
    {
        $request = $this->getPackageGroupsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Inventory\Model\KeyGuidValue[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Inventory\Model\KeyGuidValue[]' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Inventory\Model\KeyGuidValue[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Inventory\Model\KeyGuidValue[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Inventory\Model\KeyGuidValue[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPackageGroupsAsync
     *
     * GetPackageGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageGroupsAsync(string $contentType = self::contentTypes['getPackageGroups'][0])
    {
        return $this->getPackageGroupsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPackageGroupsAsyncWithHttpInfo
     *
     * GetPackageGroups
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPackageGroupsAsyncWithHttpInfo(string $contentType = self::contentTypes['getPackageGroups'][0])
    {
        $returnType = '\Linnworks\Inventory\Model\KeyGuidValue[]';
        $request = $this->getPackageGroupsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPackageGroups'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPackageGroups'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPackageGroupsRequest(string $contentType = self::contentTypes['getPackageGroups'][0])
    {


        $resourcePath = '/api/Inventory/GetPackageGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPostalServices
     *
     * GetPostalServices
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPostalServices'] to see the possible values for this operation
     *
     * @throws \Linnworks\Inventory\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArg