# Linnworks\Inventory\InventoryApi

All URIs are relative to https://eu-ext.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**addImageToInventoryItem()**](InventoryApi.md#addImageToInventoryItem) | **POST** /api/Inventory/AddImageToInventoryItem | AddImageToInventoryItem |
| [**addInventoryItem()**](InventoryApi.md#addInventoryItem) | **POST** /api/Inventory/AddInventoryItem | AddInventoryItem |
| [**addInventoryItemBulk()**](InventoryApi.md#addInventoryItemBulk) | **POST** /api/Inventory/AddInventoryItemBulk | AddInventoryItemBulk |
| [**addItemLocations()**](InventoryApi.md#addItemLocations) | **POST** /api/Inventory/AddItemLocations | AddItemLocations |
| [**addProductIdentifiers()**](InventoryApi.md#addProductIdentifiers) | **POST** /api/Inventory/AddProductIdentifiers | AddProductIdentifiers |
| [**addScrapCategories()**](InventoryApi.md#addScrapCategories) | **POST** /api/Inventory/AddScrapCategories | AddScrapCategories |
| [**addScrapItem()**](InventoryApi.md#addScrapItem) | **POST** /api/Inventory/AddScrapItem | AddScrapItem |
| [**addSupplier()**](InventoryApi.md#addSupplier) | **POST** /api/Inventory/AddSupplier | AddSupplier |
| [**adjustTemplatesInstant()**](InventoryApi.md#adjustTemplatesInstant) | **POST** /api/Inventory/AdjustTemplatesInstant | AdjustTemplatesInstant |
| [**archiveInventoryItems()**](InventoryApi.md#archiveInventoryItems) | **POST** /api/Inventory/ArchiveInventoryItems | ArchiveInventoryItems |
| [**batchGetInventoryItemChannelSKUs()**](InventoryApi.md#batchGetInventoryItemChannelSKUs) | **POST** /api/Inventory/BatchGetInventoryItemChannelSKUs | BatchGetInventoryItemChannelSKUs |
| [**bulkScrapBatchedItems()**](InventoryApi.md#bulkScrapBatchedItems) | **POST** /api/Inventory/BulkScrapBatchedItems | BulkScrapBatchedItems |
| [**createBatches()**](InventoryApi.md#createBatches) | **POST** /api/Inventory/CreateBatches | CreateBatches |
| [**createCategory()**](InventoryApi.md#createCategory) | **POST** /api/Inventory/CreateCategory | CreateCategory |
| [**createCountries()**](InventoryApi.md#createCountries) | **POST** /api/Inventory/CreateCountries | CreateCountries |
| [**createCountryRegions()**](InventoryApi.md#createCountryRegions) | **POST** /api/Inventory/CreateCountryRegions | CreateCountryRegions |
| [**createInventoryItemChannelSKUs()**](InventoryApi.md#createInventoryItemChannelSKUs) | **POST** /api/Inventory/CreateInventoryItemChannelSKUs | CreateInventoryItemChannelSKUs |
| [**createInventoryItemCompositions()**](InventoryApi.md#createInventoryItemCompositions) | **POST** /api/Inventory/CreateInventoryItemCompositions | CreateInventoryItemCompositions |
| [**createInventoryItemDescriptions()**](InventoryApi.md#createInventoryItemDescriptions) | **POST** /api/Inventory/CreateInventoryItemDescriptions | CreateInventoryItemDescriptions |
| [**createInventoryItemExtendedProperties()**](InventoryApi.md#createInventoryItemExtendedProperties) | **POST** /api/Inventory/CreateInventoryItemExtendedProperties | CreateInventoryItemExtendedProperties |
| [**createInventoryItemPrices()**](InventoryApi.md#createInventoryItemPrices) | **POST** /api/Inventory/CreateInventoryItemPrices | CreateInventoryItemPrices |
| [**createInventoryItemPricingRules()**](InventoryApi.md#createInventoryItemPricingRules) | **POST** /api/Inventory/CreateInventoryItemPricingRules | CreateInventoryItemPricingRules |
| [**createInventoryItemTitles()**](InventoryApi.md#createInventoryItemTitles) | **POST** /api/Inventory/CreateInventoryItemTitles | CreateInventoryItemTitles |
| [**createStockSupplierStat()**](InventoryApi.md#createStockSupplierStat) | **POST** /api/Inventory/CreateStockSupplierStat | CreateStockSupplierStat |
| [**createUserSpecificView()**](InventoryApi.md#createUserSpecificView) | **POST** /api/Inventory/CreateUserSpecificView | CreateUserSpecificView |
| [**deleteBatchInventoryInBulk()**](InventoryApi.md#deleteBatchInventoryInBulk) | **POST** /api/Inventory/DeleteBatchInventoryInBulk | DeleteBatchInventoryInBulk |
| [**deleteBatchesByStockItemId()**](InventoryApi.md#deleteBatchesByStockItemId) | **POST** /api/Inventory/DeleteBatchesByStockItemId | DeleteBatchesByStockItemId |
| [**deleteCategoryById()**](InventoryApi.md#deleteCategoryById) | **POST** /api/Inventory/DeleteCategoryById | DeleteCategoryById |
| [**deleteCountries()**](InventoryApi.md#deleteCountries) | **POST** /api/Inventory/DeleteCountries | DeleteCountries |
| [**deleteEbayCompatibilityList()**](InventoryApi.md#deleteEbayCompatibilityList) | **POST** /api/Inventory/DeleteEbayCompatibilityList | DeleteEbayCompatibilityList |
| [**deleteImagesFromInventoryItem()**](InventoryApi.md#deleteImagesFromInventoryItem) | **POST** /api/Inventory/DeleteImagesFromInventoryItem | DeleteImagesFromInventoryItem |
| [**deleteInventoryItemBulk()**](InventoryApi.md#deleteInventoryItemBulk) | **POST** /api/Inventory/DeleteInventoryItemBulk | DeleteInventoryItemBulk |
| [**deleteInventoryItemChannelSKUs()**](InventoryApi.md#deleteInventoryItemChannelSKUs) | **POST** /api/Inventory/DeleteInventoryItemChannelSKUs | DeleteInventoryItemChannelSKUs |
| [**deleteInventoryItemCompositions()**](InventoryApi.md#deleteInventoryItemCompositions) | **POST** /api/Inventory/DeleteInventoryItemCompositions | DeleteInventoryItemCompositions |
| [**deleteInventoryItemDescriptions()**](InventoryApi.md#deleteInventoryItemDescriptions) | **POST** /api/Inventory/DeleteInventoryItemDescriptions | DeleteInventoryItemDescriptions |
| [**deleteInventoryItemExtendedProperties()**](InventoryApi.md#deleteInventoryItemExtendedProperties) | **POST** /api/Inventory/DeleteInventoryItemExtendedProperties | DeleteInventoryItemExtendedProperties |
| [**deleteInventoryItemImageBulk()**](InventoryApi.md#deleteInventoryItemImageBulk) | **POST** /api/Inventory/DeleteInventoryItemImageBulk | DeleteInventoryItemImageBulk |
| [**deleteInventoryItemPrices()**](InventoryApi.md#deleteInventoryItemPrices) | **POST** /api/Inventory/DeleteInventoryItemPrices | DeleteInventoryItemPrices |
| [**deleteInventoryItemPricingRules()**](InventoryApi.md#deleteInventoryItemPricingRules) | **POST** /api/Inventory/DeleteInventoryItemPricingRules | DeleteInventoryItemPricingRules |
| [**deleteInventoryItemTitles()**](InventoryApi.md#deleteInventoryItemTitles) | **POST** /api/Inventory/DeleteInventoryItemTitles | DeleteInventoryItemTitles |
| [**deleteInventoryItems()**](InventoryApi.md#deleteInventoryItems) | **POST** /api/Inventory/DeleteInventoryItems | DeleteInventoryItems |
| [**deleteItemLocations()**](InventoryApi.md#deleteItemLocations) | **POST** /api/Inventory/DeleteItemLocations | DeleteItemLocations |
| [**deleteProductIdentifiers()**](InventoryApi.md#deleteProductIdentifiers) | **POST** /api/Inventory/DeleteProductIdentifiers | DeleteProductIdentifiers |
| [**deleteScrapCategories()**](InventoryApi.md#deleteScrapCategories) | **POST** /api/Inventory/DeleteScrapCategories | DeleteScrapCategories |
| [**deleteStockSupplierStat()**](InventoryApi.md#deleteStockSupplierStat) | **POST** /api/Inventory/DeleteStockSupplierStat | DeleteStockSupplierStat |
| [**deleteSuppliers()**](InventoryApi.md#deleteSuppliers) | **POST** /api/Inventory/DeleteSuppliers | DeleteSuppliers |
| [**deleteUserSpecificView()**](InventoryApi.md#deleteUserSpecificView) | **POST** /api/Inventory/DeleteUserSpecificView | DeleteUserSpecificView |
| [**duplicateInventoryItem()**](InventoryApi.md#duplicateInventoryItem) | **POST** /api/Inventory/DuplicateInventoryItem | DuplicateInventoryItem |
| [**getAllExtendedPropertyNames()**](InventoryApi.md#getAllExtendedPropertyNames) | **GET** /api/Inventory/GetAllExtendedPropertyNames | GetAllExtendedPropertyNames |
| [**getBatchAudit()**](InventoryApi.md#getBatchAudit) | **POST** /api/Inventory/GetBatchAudit | GetBatchAudit |
| [**getBatchInventoryById()**](InventoryApi.md#getBatchInventoryById) | **POST** /api/Inventory/GetBatchInventoryById | GetBatchInventoryById |
| [**getBatchesByStockItemId()**](InventoryApi.md#getBatchesByStockItemId) | **GET** /api/Inventory/GetBatchesByStockItemId | GetBatchesByStockItemId |
| [**getCategories()**](InventoryApi.md#getCategories) | **GET** /api/Inventory/GetCategories | GetCategories |
| [**getChannels()**](InventoryApi.md#getChannels) | **GET** /api/Inventory/GetChannels | GetChannels |
| [**getChannelsBySource()**](InventoryApi.md#getChannelsBySource) | **GET** /api/Inventory/GetChannelsBySource | GetChannelsBySource |
| [**getCountries()**](InventoryApi.md#getCountries) | **GET** /api/Inventory/GetCountries | GetCountries |
| [**getCountryCodes()**](InventoryApi.md#getCountryCodes) | **GET** /api/Inventory/GetCountryCodes | GetCountryCodes |
| [**getEbayCompatibilityList()**](InventoryApi.md#getEbayCompatibilityList) | **GET** /api/Inventory/GetEbayCompatibilityList | GetEbayCompatibilityList |
| [**getExtendedPropertyNames()**](InventoryApi.md#getExtendedPropertyNames) | **GET** /api/Inventory/GetExtendedPropertyNames | GetExtendedPropertyNames |
| [**getExtendedPropertyTypes()**](InventoryApi.md#getExtendedPropertyTypes) | **GET** /api/Inventory/GetExtendedPropertyTypes | GetExtendedPropertyTypes |
| [**getImagesInBulk()**](InventoryApi.md#getImagesInBulk) | **POST** /api/Inventory/GetImagesInBulk | GetImagesInBulk |
| [**getInventoryBatchTypes()**](InventoryApi.md#getInventoryBatchTypes) | **GET** /api/Inventory/GetInventoryBatchTypes | GetInventoryBatchTypes |
| [**getInventoryItem()**](InventoryApi.md#getInventoryItem) | **GET** /api/Inventory/GetInventoryItem | GetInventoryItem |
| [**getInventoryItemAuditTrail()**](InventoryApi.md#getInventoryItemAuditTrail) | **GET** /api/Inventory/GetInventoryItemAuditTrail | GetInventoryItemAuditTrail |
| [**getInventoryItemAuditTrailPaged()**](InventoryApi.md#getInventoryItemAuditTrailPaged) | **POST** /api/Inventory/GetInventoryItemAuditTrailPaged | GetInventoryItemAuditTrailPaged |
| [**getInventoryItemBatchInformation()**](InventoryApi.md#getInventoryItemBatchInformation) | **POST** /api/Inventory/GetInventoryItemBatchInformation | GetInventoryItemBatchInformation |
| [**getInventoryItemBatchInformationByIds()**](InventoryApi.md#getInventoryItemBatchInformationByIds) | **POST** /api/Inventory/GetInventoryItemBatchInformationByIds | GetInventoryItemBatchInformationByIds |
| [**getInventoryItemById()**](InventoryApi.md#getInventoryItemById) | **GET** /api/Inventory/GetInventoryItemById | GetInventoryItemById |
| [**getInventoryItemChannelSKUs()**](InventoryApi.md#getInventoryItemChannelSKUs) | **GET** /api/Inventory/GetInventoryItemChannelSKUs | GetInventoryItemChannelSKUs |
| [**getInventoryItemChannelSKUsWithLocation()**](InventoryApi.md#getInventoryItemChannelSKUsWithLocation) | **GET** /api/Inventory/GetInventoryItemChannelSKUsWithLocation | GetInventoryItemChannelSKUsWithLocation |
| [**getInventoryItemCompositions()**](InventoryApi.md#getInventoryItemCompositions) | **GET** /api/Inventory/GetInventoryItemCompositions | GetInventoryItemCompositions |
| [**getInventoryItemDescriptions()**](InventoryApi.md#getInventoryItemDescriptions) | **GET** /api/Inventory/GetInventoryItemDescriptions | GetInventoryItemDescriptions |
| [**getInventoryItemExtendedProperties()**](InventoryApi.md#getInventoryItemExtendedProperties) | **POST** /api/Inventory/GetInventoryItemExtendedProperties | GetInventoryItemExtendedProperties |
| [**getInventoryItemImages()**](InventoryApi.md#getInventoryItemImages) | **GET** /api/Inventory/GetInventoryItemImages | GetInventoryItemImages |
| [**getInventoryItemLocations()**](InventoryApi.md#getInventoryItemLocations) | **GET** /api/Inventory/GetInventoryItemLocations | GetInventoryItemLocations |
| [**getInventoryItemPriceChannelSuffixes()**](InventoryApi.md#getInventoryItemPriceChannelSuffixes) | **GET** /api/Inventory/GetInventoryItemPriceChannelSuffixes | GetInventoryItemPriceChannelSuffixes |
| [**getInventoryItemPriceRulesById()**](InventoryApi.md#getInventoryItemPriceRulesById) | **GET** /api/Inventory/GetInventoryItemPriceRulesById | GetInventoryItemPriceRulesById |
| [**getInventoryItemPriceRulesBySource()**](InventoryApi.md#getInventoryItemPriceRulesBySource) | **GET** /api/Inventory/GetInventoryItemPriceRulesBySource | GetInventoryItemPriceRulesBySource |
| [**getInventoryItemPriceTags()**](InventoryApi.md#getInventoryItemPriceTags) | **GET** /api/Inventory/GetInventoryItemPriceTags | GetInventoryItemPriceTags |
| [**getInventoryItemPrices()**](InventoryApi.md#getInventoryItemPrices) | **GET** /api/Inventory/GetInventoryItemPrices | GetInventoryItemPrices |
| [**getInventoryItemTitles()**](InventoryApi.md#getInventoryItemTitles) | **GET** /api/Inventory/GetInventoryItemTitles | GetInventoryItemTitles |
| [**getInventoryItemsCompositionByIds()**](InventoryApi.md#getInventoryItemsCompositionByIds) | **POST** /api/Inventory/GetInventoryItemsCompositionByIds | GetInventoryItemsCompositionByIds |
| [**getInventoryItemsCount()**](InventoryApi.md#getInventoryItemsCount) | **GET** /api/Inventory/GetInventoryItemsCount | GetInventoryItemsCount |
| [**getNewItemNumber()**](InventoryApi.md#getNewItemNumber) | **GET** /api/Inventory/GetNewItemNumber | GetNewItemNumber |
| [**getPackageGroups()**](InventoryApi.md#getPackageGroups) | **GET** /api/Inventory/GetPackageGroups | GetPackageGroups |
| [**getPostalServices()**](InventoryApi.md#getPostalServices) | **GET** /api/Inventory/GetPostalServices | GetPostalServices |
| [**getPreDefinedViews()**](InventoryApi.md#getPreDefinedViews) | **GET** /api/Inventory/GetPreDefinedViews | GetPreDefinedViews |
| [**getProductIdentifierExtendedTypes()**](InventoryApi.md#getProductIdentifierExtendedTypes) | **GET** /api/Inventory/GetProductIdentifierExtendedTypes | GetProductIdentifierExtendedTypes |
| [**getProductIdentifierTypes()**](InventoryApi.md#getProductIdentifierTypes) | **GET** /api/Inventory/GetProductIdentifierTypes | GetProductIdentifierTypes |
| [**getProductIdentifiersBulkByStockItemId()**](InventoryApi.md#getProductIdentifiersBulkByStockItemId) | **POST** /api/Inventory/GetProductIdentifiersBulkByStockItemId | GetProductIdentifiersBulkByStockItemId |
| [**getProductIdentifiersByStockItemId()**](InventoryApi.md#getProductIdentifiersByStockItemId) | **POST** /api/Inventory/GetProductIdentifiersByStockItemId | GetProductIdentifiersByStockItemId |
| [**getScannableProductIdentifiersByOrderIds()**](InventoryApi.md#getScannableProductIdentifiersByOrderIds) | **POST** /api/Inventory/GetScannableProductIdentifiersByOrderIds | GetScannableProductIdentifiersByOrderIds |
| [**getScrapCategories()**](InventoryApi.md#getScrapCategories) | **GET** /api/Inventory/GetScrapCategories | GetScrapCategories |
| [**getScrapHistory()**](InventoryApi.md#getScrapHistory) | **POST** /api/Inventory/GetScrapHistory | GetScrapHistory |
| [**getStockItemBatchesByLocation()**](InventoryApi.md#getStockItemBatchesByLocation) | **POST** /api/Inventory/GetStockItemBatchesByLocation | GetStockItemBatchesByLocation |
| [**getStockItemIdsBySKU()**](InventoryApi.md#getStockItemIdsBySKU) | **POST** /api/Inventory/GetStockItemIdsBySKU | GetStockItemIdsBySKU |
| [**getStockItemLabels()**](InventoryApi.md#getStockItemLabels) | **POST** /api/Inventory/GetStockItemLabels | GetStockItemLabels |
| [**getStockLocations()**](InventoryApi.md#getStockLocations) | **GET** /api/Inventory/GetStockLocations | GetStockLocations |
| [**getStockSupplierStat()**](InventoryApi.md#getStockSupplierStat) | **GET** /api/Inventory/GetStockSupplierStat | GetStockSupplierStat |
| [**getStockSupplierStatsBulk()**](InventoryApi.md#getStockSupplierStatsBulk) | **GET** /api/Inventory/GetStockSupplierStatsBulk | GetStockSupplierStatsBulk |
| [**getSupplierDetails()**](InventoryApi.md#getSupplierDetails) | **GET** /api/Inventory/GetSupplierDetails | GetSupplierDetails |
| [**getSuppliers()**](InventoryApi.md#getSuppliers) | **GET** /api/Inventory/GetSuppliers | GetSuppliers |
| [**getUserSpecificViews()**](InventoryApi.md#getUserSpecificViews) | **GET** /api/Inventory/GetUserSpecificViews | GetUserSpecificViews |
| [**hasStockItemBatches()**](InventoryApi.md#hasStockItemBatches) | **GET** /api/Inventory/HasStockItemBatches | HasStockItemBatches |
| [**hasStockItemStockLevel()**](InventoryApi.md#hasStockItemStockLevel) | **POST** /api/Inventory/HasStockItemStockLevel | HasStockItemStockLevel |
| [**insertUpdateEbayCompatibilityList()**](InventoryApi.md#insertUpdateEbayCompatibilityList) | **POST** /api/Inventory/InsertUpdateEbayCompatibilityList | InsertUpdateEbayCompatibilityList |
| [**isInventoryItemChannelSKULinked()**](InventoryApi.md#isInventoryItemChannelSKULinked) | **GET** /api/Inventory/IsInventoryItemChannelSKULinked | IsInventoryItemChannelSKULinked |
| [**isOwnedStockLocation()**](InventoryApi.md#isOwnedStockLocation) | **GET** /api/Inventory/IsOwnedStockLocation | IsOwnedStockLocation |
| [**itemsHaveScannableIdentifiers()**](InventoryApi.md#itemsHaveScannableIdentifiers) | **POST** /api/Inventory/ItemsHaveScannableIdentifiers | ItemsHaveScannableIdentifiers |
| [**scrapBatchedItem()**](InventoryApi.md#scrapBatchedItem) | **POST** /api/Inventory/ScrapBatchedItem | ScrapBatchedItem |
| [**setInventoryItemImageAsMain()**](InventoryApi.md#setInventoryItemImageAsMain) | **POST** /api/Inventory/SetInventoryItemImageAsMain | SetInventoryItemImageAsMain |
| [**unarchiveInventoryItems()**](InventoryApi.md#unarchiveInventoryItems) | **POST** /api/Inventory/UnarchiveInventoryItems | UnarchiveInventoryItems |
| [**unlinkChannelListing()**](InventoryApi.md#unlinkChannelListing) | **POST** /api/Inventory/UnlinkChannelListing | UnlinkChannelListing |
| [**updateBatchDates()**](InventoryApi.md#updateBatchDates) | **POST** /api/Inventory/UpdateBatchDates | UpdateBatchDates |
| [**updateBatchDetails()**](InventoryApi.md#updateBatchDetails) | **POST** /api/Inventory/UpdateBatchDetails | UpdateBatchDetails |
| [**updateBatchesWithInventory()**](InventoryApi.md#updateBatchesWithInventory) | **POST** /api/Inventory/UpdateBatchesWithInventory | UpdateBatchesWithInventory |
| [**updateCategory()**](InventoryApi.md#updateCategory) | **POST** /api/Inventory/UpdateCategory | UpdateCategory |
| [**updateCompositeParentStockLevel()**](InventoryApi.md#updateCompositeParentStockLevel) | **POST** /api/Inventory/UpdateCompositeParentStockLevel | UpdateCompositeParentStockLevel |
| [**updateCountries()**](InventoryApi.md#updateCountries) | **POST** /api/Inventory/UpdateCountries | UpdateCountries |
| [**updateCountryRegions()**](InventoryApi.md#updateCountryRegions) | **POST** /api/Inventory/UpdateCountryRegions | UpdateCountryRegions |
| [**updateImages()**](InventoryApi.md#updateImages) | **POST** /api/Inventory/UpdateImages | UpdateImages |
| [**updateInventoryItem()**](InventoryApi.md#updateInventoryItem) | **POST** /api/Inventory/UpdateInventoryItem | UpdateInventoryItem |
| [**updateInventoryItemChannelSKUs()**](InventoryApi.md#updateInventoryItemChannelSKUs) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUs | UpdateInventoryItemChannelSKUs |
| [**updateInventoryItemChannelSKUsWithLocation()**](InventoryApi.md#updateInventoryItemChannelSKUsWithLocation) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUsWithLocation | UpdateInventoryItemChannelSKUsWithLocation |
| [**updateInventoryItemCompositions()**](InventoryApi.md#updateInventoryItemCompositions) | **POST** /api/Inventory/UpdateInventoryItemCompositions | UpdateInventoryItemCompositions |
| [**updateInventoryItemDescriptions()**](InventoryApi.md#updateInventoryItemDescriptions) | **POST** /api/Inventory/UpdateInventoryItemDescriptions | UpdateInventoryItemDescriptions |
| [**updateInventoryItemExtendedProperties()**](InventoryApi.md#updateInventoryItemExtendedProperties) | **POST** /api/Inventory/UpdateInventoryItemExtendedProperties | UpdateInventoryItemExtendedProperties |
| [**updateInventoryItemField()**](InventoryApi.md#updateInventoryItemField) | **POST** /api/Inventory/UpdateInventoryItemField | UpdateInventoryItemField |
| [**updateInventoryItemLevels()**](InventoryApi.md#updateInventoryItemLevels) | **POST** /api/Inventory/UpdateInventoryItemLevels | UpdateInventoryItemLevels |
| [**updateInventoryItemLocationField()**](InventoryApi.md#updateInventoryItemLocationField) | **POST** /api/Inventory/UpdateInventoryItemLocationField | UpdateInventoryItemLocationField |
| [**updateInventoryItemPrices()**](InventoryApi.md#updateInventoryItemPrices) | **POST** /api/Inventory/UpdateInventoryItemPrices | UpdateInventoryItemPrices |
| [**updateInventoryItemPricingRules()**](InventoryApi.md#updateInventoryItemPricingRules) | **POST** /api/Inventory/UpdateInventoryItemPricingRules | UpdateInventoryItemPricingRules |
| [**updateInventoryItemStockField()**](InventoryApi.md#updateInventoryItemStockField) | **POST** /api/Inventory/UpdateInventoryItemStockField | UpdateInventoryItemStockField |
| [**updateInventoryItemTitles()**](InventoryApi.md#updateInventoryItemTitles) | **POST** /api/Inventory/UpdateInventoryItemTitles | UpdateInventoryItemTitles |
| [**updateItemLocations()**](InventoryApi.md#updateItemLocations) | **POST** /api/Inventory/UpdateItemLocations | UpdateItemLocations |
| [**updateProductIdentifiers()**](InventoryApi.md#updateProductIdentifiers) | **POST** /api/Inventory/UpdateProductIdentifiers | UpdateProductIdentifiers |
| [**updateScrapCategories()**](InventoryApi.md#updateScrapCategories) | **POST** /api/Inventory/UpdateScrapCategories | UpdateScrapCategories |
| [**updateStockSupplierStat()**](InventoryApi.md#updateStockSupplierStat) | **POST** /api/Inventory/UpdateStockSupplierStat | UpdateStockSupplierStat |
| [**updateSupplier()**](InventoryApi.md#updateSupplier) | **POST** /api/Inventory/UpdateSupplier | UpdateSupplier |
| [**updateUserSpecificView()**](InventoryApi.md#updateUserSpecificView) | **POST** /api/Inventory/UpdateUserSpecificView | UpdateUserSpecificView |
| [**uploadImagesToInventoryItem()**](InventoryApi.md#uploadImagesToInventoryItem) | **POST** /api/Inventory/UploadImagesToInventoryItem | UploadImagesToInventoryItem |


## `addImageToInventoryItem()`

```php
addImageToInventoryItem($inventory_add_image_to_inventory_item_request): \Linnworks\Inventory\Model\AddImageToInventoryItemResponse
```

AddImageToInventoryItem

Adds an image to the stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_image_to_inventory_item_request = new \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest

try {
    $result = $apiInstance->addImageToInventoryItem($inventory_add_image_to_inventory_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addImageToInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_image_to_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest**](../Model/InventoryAddImageToInventoryItemRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\AddImageToInventoryItemResponse**](../Model/AddImageToInventoryItemResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addInventoryItem()`

```php
addInventoryItem($inventory_add_inventory_item_request)
```

AddInventoryItem

Use this call to add stock item. Use null for MinimumLevel to use Default Minimum Level from Settings <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_inventory_item_request = new \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryAddInventoryItemRequest

try {
    $apiInstance->addInventoryItem($inventory_add_inventory_item_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryAddInventoryItemRequest**](../Model/InventoryAddInventoryItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addInventoryItemBulk()`

```php
addInventoryItemBulk($inventory_add_inventory_item_bulk_request): \Linnworks\Inventory\Model\BatchedAPIResponseGuid
```

AddInventoryItemBulk

Use this call to add up to 200 stock items. <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_inventory_item_bulk_request = new \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest(); // \Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest

try {
    $result = $apiInstance->addInventoryItemBulk($inventory_add_inventory_item_bulk_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addInventoryItemBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_inventory_item_bulk_request** | [**\Linnworks\Inventory\Model\InventoryAddInventoryItemBulkRequest**](../Model/InventoryAddInventoryItemBulkRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\BatchedAPIResponseGuid**](../Model/BatchedAPIResponseGuid.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addItemLocations()`

```php
addItemLocations($inventory_add_item_locations_request)
```

AddItemLocations

Use this call to add stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_item_locations_request = new \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest(); // \Linnworks\Inventory\Model\InventoryAddItemLocationsRequest

try {
    $apiInstance->addItemLocations($inventory_add_item_locations_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addItemLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_item_locations_request** | [**\Linnworks\Inventory\Model\InventoryAddItemLocationsRequest**](../Model/InventoryAddItemLocationsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addProductIdentifiers()`

```php
addProductIdentifiers($inventory_add_product_identifiers_request): \Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier
```

AddProductIdentifiers

Used to add product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_product_identifiers_request = new \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest(); // \Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest

try {
    $result = $apiInstance->addProductIdentifiers($inventory_add_product_identifiers_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addProductIdentifiers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_product_identifiers_request** | [**\Linnworks\Inventory\Model\InventoryAddProductIdentifiersRequest**](../Model/InventoryAddProductIdentifiersRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\BatchedAPIResponseStockItemProductIdentifier**](../Model/BatchedAPIResponseStockItemProductIdentifier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addScrapCategories()`

```php
addScrapCategories($inventory_add_scrap_categories_request): \Linnworks\Inventory\Model\AddScrapCategoriesResponse
```

AddScrapCategories

Used to add scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_scrap_categories_request = new \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest(); // \Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest

try {
    $result = $apiInstance->addScrapCategories($inventory_add_scrap_categories_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addScrapCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_scrap_categories_request** | [**\Linnworks\Inventory\Model\InventoryAddScrapCategoriesRequest**](../Model/InventoryAddScrapCategoriesRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\AddScrapCategoriesResponse**](../Model/AddScrapCategoriesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addScrapItem()`

```php
addScrapItem($inventory_add_scrap_item_request): \Linnworks\Inventory\Model\AddScrapItemResponse
```

AddScrapItem

Used to add scrap item <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_scrap_item_request = new \Linnworks\Inventory\Model\InventoryAddScrapItemRequest(); // \Linnworks\Inventory\Model\InventoryAddScrapItemRequest

try {
    $result = $apiInstance->addScrapItem($inventory_add_scrap_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addScrapItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_scrap_item_request** | [**\Linnworks\Inventory\Model\InventoryAddScrapItemRequest**](../Model/InventoryAddScrapItemRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\AddScrapItemResponse**](../Model/AddScrapItemResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `addSupplier()`

```php
addSupplier($inventory_add_supplier_request): \Linnworks\Inventory\Model\Supplier
```

AddSupplier

Use this call to create a new supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_supplier_request = new \Linnworks\Inventory\Model\InventoryAddSupplierRequest(); // \Linnworks\Inventory\Model\InventoryAddSupplierRequest

try {
    $result = $apiInstance->addSupplier($inventory_add_supplier_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_add_supplier_request** | [**\Linnworks\Inventory\Model\InventoryAddSupplierRequest**](../Model/InventoryAddSupplierRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\Supplier**](../Model/Supplier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `adjustTemplatesInstant()`

```php
adjustTemplatesInstant($inventory_adjust_templates_instant_request)
```

AdjustTemplatesInstant

Use this call to adjust templates <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_adjust_templates_instant_request = new \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest(); // \Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest

try {
    $apiInstance->adjustTemplatesInstant($inventory_adjust_templates_instant_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->adjustTemplatesInstant: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_adjust_templates_instant_request** | [**\Linnworks\Inventory\Model\InventoryAdjustTemplatesInstantRequest**](../Model/InventoryAdjustTemplatesInstantRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `archiveInventoryItems()`

```php
archiveInventoryItems($inventory_archive_inventory_items_request)
```

ArchiveInventoryItems

Use this call to archive inventory items. Send only list of IDs and empty list of regions. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_archive_inventory_items_request = new \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest(); // \Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest

try {
    $apiInstance->archiveInventoryItems($inventory_archive_inventory_items_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->archiveInventoryItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_archive_inventory_items_request** | [**\Linnworks\Inventory\Model\InventoryArchiveInventoryItemsRequest**](../Model/InventoryArchiveInventoryItemsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `batchGetInventoryItemChannelSKUs()`

```php
batchGetInventoryItemChannelSKUs($inventory_batch_get_inventory_item_channel_skus_request): \Linnworks\Inventory\Model\StockItemChannelSkuResponse[]
```

BatchGetInventoryItemChannelSKUs

Use this call to get stock item channel skus for a list of inventory items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_batch_get_inventory_item_channel_skus_request = new \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest(); // \Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest

try {
    $result = $apiInstance->batchGetInventoryItemChannelSKUs($inventory_batch_get_inventory_item_channel_skus_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->batchGetInventoryItemChannelSKUs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_batch_get_inventory_item_channel_skus_request** | [**\Linnworks\Inventory\Model\InventoryBatchGetInventoryItemChannelSKUsRequest**](../Model/InventoryBatchGetInventoryItemChannelSKUsRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\StockItemChannelSkuResponse[]**](../Model/StockItemChannelSkuResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `bulkScrapBatchedItems()`

```php
bulkScrapBatchedItems($request)
```

BulkScrapBatchedItems

Scrap batched items in bulk without consumption <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest(); // \Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest

try {
    $apiInstance->bulkScrapBatchedItems($request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->bulkScrapBatchedItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\BulkScrapBatchedItemsRequest**](../Model/BulkScrapBatchedItemsRequest.md)|  | [optional] |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createBatches()`

```php
createBatches($inventory_create_batches_request)
```

CreateBatches

Used to create new batches <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_batches_request = new \Linnworks\Inventory\Model\InventoryCreateBatchesRequest(); // \Linnworks\Inventory\Model\InventoryCreateBatchesRequest

try {
    $apiInstance->createBatches($inventory_create_batches_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createBatches: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_batches_request** | [**\Linnworks\Inventory\Model\InventoryCreateBatchesRequest**](../Model/InventoryCreateBatchesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCategory()`

```php
createCategory($inventory_create_category_request): \Linnworks\Inventory\Model\LinnworksCategory
```

CreateCategory

Use this call to create new category <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_category_request = new \Linnworks\Inventory\Model\InventoryCreateCategoryRequest(); // \Linnworks\Inventory\Model\InventoryCreateCategoryRequest

try {
    $result = $apiInstance->createCategory($inventory_create_category_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_category_request** | [**\Linnworks\Inventory\Model\InventoryCreateCategoryRequest**](../Model/InventoryCreateCategoryRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\LinnworksCategory**](../Model/LinnworksCategory.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCountries()`

```php
createCountries($inventory_create_countries_request)
```

CreateCountries

Use this call to create new countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_countries_request = new \Linnworks\Inventory\Model\InventoryCreateCountriesRequest(); // \Linnworks\Inventory\Model\InventoryCreateCountriesRequest

try {
    $apiInstance->createCountries($inventory_create_countries_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_countries_request** | [**\Linnworks\Inventory\Model\InventoryCreateCountriesRequest**](../Model/InventoryCreateCountriesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCountryRegions()`

```php
createCountryRegions($inventory_create_country_regions_request): \Linnworks\Inventory\Model\CreateCountryRegionsResponse
```

CreateCountryRegions

Create regions for country <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_country_regions_request = new \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest(); // \Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest

try {
    $result = $apiInstance->createCountryRegions($inventory_create_country_regions_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createCountryRegions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_country_regions_request** | [**\Linnworks\Inventory\Model\InventoryCreateCountryRegionsRequest**](../Model/InventoryCreateCountryRegionsRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\CreateCountryRegionsResponse**](../Model/CreateCountryRegionsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemChannelSKUs()`

```php
createInventoryItemChannelSKUs($inventory_create_inventory_item_channel_skus_request)
```

CreateInventoryItemChannelSKUs

Use this call to create stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_channel_skus_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest

try {
    $apiInstance->createInventoryItemChannelSKUs($inventory_create_inventory_item_channel_skus_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemChannelSKUs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_channel_skus_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemChannelSKUsRequest**](../Model/InventoryCreateInventoryItemChannelSKUsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemCompositions()`

```php
createInventoryItemCompositions($inventory_create_inventory_item_compositions_request)
```

CreateInventoryItemCompositions

Use this call to create compositions for stockItem <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_compositions_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest

try {
    $apiInstance->createInventoryItemCompositions($inventory_create_inventory_item_compositions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemCompositions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_compositions_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemCompositionsRequest**](../Model/InventoryCreateInventoryItemCompositionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemDescriptions()`

```php
createInventoryItemDescriptions($inventory_create_inventory_item_descriptions_request)
```

CreateInventoryItemDescriptions

Use this call to create stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_descriptions_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest

try {
    $apiInstance->createInventoryItemDescriptions($inventory_create_inventory_item_descriptions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemDescriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_descriptions_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemDescriptionsRequest**](../Model/InventoryCreateInventoryItemDescriptionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemExtendedProperties()`

```php
createInventoryItemExtendedProperties($inventory_create_inventory_item_extended_properties_request)
```

CreateInventoryItemExtendedProperties

Use this call to create stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_extended_properties_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest

try {
    $apiInstance->createInventoryItemExtendedProperties($inventory_create_inventory_item_extended_properties_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_extended_properties_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemExtendedPropertiesRequest**](../Model/InventoryCreateInventoryItemExtendedPropertiesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemPrices()`

```php
createInventoryItemPrices($inventory_create_inventory_item_prices_request)
```

CreateInventoryItemPrices

Use this call to create stock item prices for a specific channel <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_prices_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest

try {
    $apiInstance->createInventoryItemPrices($inventory_create_inventory_item_prices_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemPrices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_prices_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemPricesRequest**](../Model/InventoryCreateInventoryItemPricesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemPricingRules()`

```php
createInventoryItemPricingRules($inventory_create_inventory_item_pricing_rules_request)
```

CreateInventoryItemPricingRules

Use this call to create stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_pricing_rules_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest

try {
    $apiInstance->createInventoryItemPricingRules($inventory_create_inventory_item_pricing_rules_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemPricingRules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_pricing_rules_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemPricingRulesRequest**](../Model/InventoryCreateInventoryItemPricingRulesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createInventoryItemTitles()`

```php
createInventoryItemTitles($inventory_create_inventory_item_titles_request)
```

CreateInventoryItemTitles

Use this call to create stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_inventory_item_titles_request = new \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest(); // \Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest

try {
    $apiInstance->createInventoryItemTitles($inventory_create_inventory_item_titles_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createInventoryItemTitles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_inventory_item_titles_request** | [**\Linnworks\Inventory\Model\InventoryCreateInventoryItemTitlesRequest**](../Model/InventoryCreateInventoryItemTitlesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createStockSupplierStat()`

```php
createStockSupplierStat($inventory_create_stock_supplier_stat_request)
```

CreateStockSupplierStat

Use this call to create item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_stock_supplier_stat_request = new \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest(); // \Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest

try {
    $apiInstance->createStockSupplierStat($inventory_create_stock_supplier_stat_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createStockSupplierStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_stock_supplier_stat_request** | [**\Linnworks\Inventory\Model\InventoryCreateStockSupplierStatRequest**](../Model/InventoryCreateStockSupplierStatRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createUserSpecificView()`

```php
createUserSpecificView($inventory_create_user_specific_view_request)
```

CreateUserSpecificView

Use this call to create a new user-specific view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_create_user_specific_view_request = new \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest(); // \Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest

try {
    $apiInstance->createUserSpecificView($inventory_create_user_specific_view_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->createUserSpecificView: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_create_user_specific_view_request** | [**\Linnworks\Inventory\Model\InventoryCreateUserSpecificViewRequest**](../Model/InventoryCreateUserSpecificViewRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteBatchInventoryInBulk()`

```php
deleteBatchInventoryInBulk($inventory_delete_batch_inventory_in_bulk_request)
```

DeleteBatchInventoryInBulk

Used to delete batch inventory info <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_batch_inventory_in_bulk_request = new \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest(); // \Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest

try {
    $apiInstance->deleteBatchInventoryInBulk($inventory_delete_batch_inventory_in_bulk_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteBatchInventoryInBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_batch_inventory_in_bulk_request** | [**\Linnworks\Inventory\Model\InventoryDeleteBatchInventoryInBulkRequest**](../Model/InventoryDeleteBatchInventoryInBulkRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteBatchesByStockItemId()`

```php
deleteBatchesByStockItemId($inventory_delete_batches_by_stock_item_id_request)
```

DeleteBatchesByStockItemId

Used to delete batches by stock item id <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_batches_by_stock_item_id_request = new \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest(); // \Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest

try {
    $apiInstance->deleteBatchesByStockItemId($inventory_delete_batches_by_stock_item_id_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteBatchesByStockItemId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_batches_by_stock_item_id_request** | [**\Linnworks\Inventory\Model\InventoryDeleteBatchesByStockItemIdRequest**](../Model/InventoryDeleteBatchesByStockItemIdRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCategoryById()`

```php
deleteCategoryById($inventory_delete_category_by_id_request)
```

DeleteCategoryById

Use this call to delete category by id. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_category_by_id_request = new \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest(); // \Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest

try {
    $apiInstance->deleteCategoryById($inventory_delete_category_by_id_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteCategoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_category_by_id_request** | [**\Linnworks\Inventory\Model\InventoryDeleteCategoryByIdRequest**](../Model/InventoryDeleteCategoryByIdRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCountries()`

```php
deleteCountries($inventory_delete_countries_request)
```

DeleteCountries

Use this call to delete countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_countries_request = new \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteCountriesRequest

try {
    $apiInstance->deleteCountries($inventory_delete_countries_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_countries_request** | [**\Linnworks\Inventory\Model\InventoryDeleteCountriesRequest**](../Model/InventoryDeleteCountriesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteEbayCompatibilityList()`

```php
deleteEbayCompatibilityList($inventory_delete_ebay_compatibility_list_request): \Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse
```

DeleteEbayCompatibilityList

Use this call to delete a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_ebay_compatibility_list_request = new \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest(); // \Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest

try {
    $result = $apiInstance->deleteEbayCompatibilityList($inventory_delete_ebay_compatibility_list_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteEbayCompatibilityList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_ebay_compatibility_list_request** | [**\Linnworks\Inventory\Model\InventoryDeleteEbayCompatibilityListRequest**](../Model/InventoryDeleteEbayCompatibilityListRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\DeleteEbayCompatibilityListResponse**](../Model/DeleteEbayCompatibilityListResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteImagesFromInventoryItem()`

```php
deleteImagesFromInventoryItem($inventory_delete_images_from_inventory_item_request)
```

DeleteImagesFromInventoryItem

Use this call to delete images from inventory items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_images_from_inventory_item_request = new \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest

try {
    $apiInstance->deleteImagesFromInventoryItem($inventory_delete_images_from_inventory_item_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteImagesFromInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_images_from_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryDeleteImagesFromInventoryItemRequest**](../Model/InventoryDeleteImagesFromInventoryItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemBulk()`

```php
deleteInventoryItemBulk($request): \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse
```

DeleteInventoryItemBulk

Use this call to delete inventory items.  All associated information will be unlinked/removed from this stock item. <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest(); // \Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest

try {
    $result = $apiInstance->deleteInventoryItemBulk($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\DeleteInventoryItemBulkRequest**](../Model/DeleteInventoryItemBulkRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemBulkResponse**](../Model/BatchedAPIResponseDeleteInventoryItemBulkResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemChannelSKUs()`

```php
deleteInventoryItemChannelSKUs($inventory_delete_inventory_item_channel_skus_request)
```

DeleteInventoryItemChannelSKUs

Use this call to delete stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_channel_skus_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest

try {
    $apiInstance->deleteInventoryItemChannelSKUs($inventory_delete_inventory_item_channel_skus_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemChannelSKUs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_channel_skus_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemChannelSKUsRequest**](../Model/InventoryDeleteInventoryItemChannelSKUsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemCompositions()`

```php
deleteInventoryItemCompositions($inventory_delete_inventory_item_compositions_request)
```

DeleteInventoryItemCompositions

Use this call to delete stockItem compositions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_compositions_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest

try {
    $apiInstance->deleteInventoryItemCompositions($inventory_delete_inventory_item_compositions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemCompositions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_compositions_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemCompositionsRequest**](../Model/InventoryDeleteInventoryItemCompositionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemDescriptions()`

```php
deleteInventoryItemDescriptions($inventory_delete_inventory_item_descriptions_request)
```

DeleteInventoryItemDescriptions

Use this call to delete stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_descriptions_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest

try {
    $apiInstance->deleteInventoryItemDescriptions($inventory_delete_inventory_item_descriptions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemDescriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_descriptions_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemDescriptionsRequest**](../Model/InventoryDeleteInventoryItemDescriptionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemExtendedProperties()`

```php
deleteInventoryItemExtendedProperties($inventory_delete_inventory_item_extended_properties_request)
```

DeleteInventoryItemExtendedProperties

Use this call to delete stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_extended_properties_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest

try {
    $apiInstance->deleteInventoryItemExtendedProperties($inventory_delete_inventory_item_extended_properties_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_extended_properties_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemExtendedPropertiesRequest**](../Model/InventoryDeleteInventoryItemExtendedPropertiesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemImageBulk()`

```php
deleteInventoryItemImageBulk($inventory_delete_inventory_item_image_bulk_request): \Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse
```

DeleteInventoryItemImageBulk

Use this call to delete images from inventory items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_image_bulk_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest

try {
    $result = $apiInstance->deleteInventoryItemImageBulk($inventory_delete_inventory_item_image_bulk_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemImageBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_image_bulk_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemImageBulkRequest**](../Model/InventoryDeleteInventoryItemImageBulkRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\BatchedAPIResponseDeleteInventoryItemImagesResponse**](../Model/BatchedAPIResponseDeleteInventoryItemImagesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemPrices()`

```php
deleteInventoryItemPrices($inventory_delete_inventory_item_prices_request)
```

DeleteInventoryItemPrices

Use this call to delete stock item prices <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_prices_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest

try {
    $apiInstance->deleteInventoryItemPrices($inventory_delete_inventory_item_prices_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemPrices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_prices_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricesRequest**](../Model/InventoryDeleteInventoryItemPricesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemPricingRules()`

```php
deleteInventoryItemPricingRules($inventory_delete_inventory_item_pricing_rules_request)
```

DeleteInventoryItemPricingRules

Use this call to update stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_pricing_rules_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest

try {
    $apiInstance->deleteInventoryItemPricingRules($inventory_delete_inventory_item_pricing_rules_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemPricingRules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_pricing_rules_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemPricingRulesRequest**](../Model/InventoryDeleteInventoryItemPricingRulesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItemTitles()`

```php
deleteInventoryItemTitles($inventory_delete_inventory_item_titles_request)
```

DeleteInventoryItemTitles

Use this call to delete stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_item_titles_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest

try {
    $apiInstance->deleteInventoryItemTitles($inventory_delete_inventory_item_titles_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItemTitles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_item_titles_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemTitlesRequest**](../Model/InventoryDeleteInventoryItemTitlesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteInventoryItems()`

```php
deleteInventoryItems($inventory_delete_inventory_items_request)
```

DeleteInventoryItems

Use this call to delete inventory item.  All associated information will be unlinked/removed from this stock item. <b>Permissions Required: </b> GlobalPermissions.Inventory.DeleteMyInventoryItems.DeleteItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_inventory_items_request = new \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest(); // \Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest

try {
    $apiInstance->deleteInventoryItems($inventory_delete_inventory_items_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteInventoryItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_inventory_items_request** | [**\Linnworks\Inventory\Model\InventoryDeleteInventoryItemsRequest**](../Model/InventoryDeleteInventoryItemsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteItemLocations()`

```php
deleteItemLocations($inventory_delete_item_locations_request)
```

DeleteItemLocations

Use this call to delete stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_item_locations_request = new \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest(); // \Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest

try {
    $apiInstance->deleteItemLocations($inventory_delete_item_locations_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteItemLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_item_locations_request** | [**\Linnworks\Inventory\Model\InventoryDeleteItemLocationsRequest**](../Model/InventoryDeleteItemLocationsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductIdentifiers()`

```php
deleteProductIdentifiers($inventory_delete_product_identifiers_request)
```

DeleteProductIdentifiers

Used to delete product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_product_identifiers_request = new \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest(); // \Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest

try {
    $apiInstance->deleteProductIdentifiers($inventory_delete_product_identifiers_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteProductIdentifiers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_product_identifiers_request** | [**\Linnworks\Inventory\Model\InventoryDeleteProductIdentifiersRequest**](../Model/InventoryDeleteProductIdentifiersRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteScrapCategories()`

```php
deleteScrapCategories($inventory_delete_scrap_categories_request)
```

DeleteScrapCategories

Used to delete scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_scrap_categories_request = new \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest(); // \Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest

try {
    $apiInstance->deleteScrapCategories($inventory_delete_scrap_categories_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteScrapCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_scrap_categories_request** | [**\Linnworks\Inventory\Model\InventoryDeleteScrapCategoriesRequest**](../Model/InventoryDeleteScrapCategoriesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteStockSupplierStat()`

```php
deleteStockSupplierStat($inventory_delete_stock_supplier_stat_request)
```

DeleteStockSupplierStat

Use this call to delete item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_stock_supplier_stat_request = new \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest(); // \Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest

try {
    $apiInstance->deleteStockSupplierStat($inventory_delete_stock_supplier_stat_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteStockSupplierStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_stock_supplier_stat_request** | [**\Linnworks\Inventory\Model\InventoryDeleteStockSupplierStatRequest**](../Model/InventoryDeleteStockSupplierStatRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteSuppliers()`

```php
deleteSuppliers($inventory_delete_suppliers_request)
```

DeleteSuppliers

Use this call delete Supplied by Id  <param name=\"suppliersIds\">List of Supplier IDs</param> <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_suppliers_request = new \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest(); // \Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest

try {
    $apiInstance->deleteSuppliers($inventory_delete_suppliers_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteSuppliers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_suppliers_request** | [**\Linnworks\Inventory\Model\InventoryDeleteSuppliersRequest**](../Model/InventoryDeleteSuppliersRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteUserSpecificView()`

```php
deleteUserSpecificView($inventory_delete_user_specific_view_request)
```

DeleteUserSpecificView

Use this call to delete user-specific view from database <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_delete_user_specific_view_request = new \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest(); // \Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest

try {
    $apiInstance->deleteUserSpecificView($inventory_delete_user_specific_view_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->deleteUserSpecificView: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_delete_user_specific_view_request** | [**\Linnworks\Inventory\Model\InventoryDeleteUserSpecificViewRequest**](../Model/InventoryDeleteUserSpecificViewRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `duplicateInventoryItem()`

```php
duplicateInventoryItem($inventory_duplicate_inventory_item_request)
```

DuplicateInventoryItem

Use this call to add stock item by duplicating existing one <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_duplicate_inventory_item_request = new \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest

try {
    $apiInstance->duplicateInventoryItem($inventory_duplicate_inventory_item_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->duplicateInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_duplicate_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryDuplicateInventoryItemRequest**](../Model/InventoryDuplicateInventoryItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getAllExtendedPropertyNames()`

```php
getAllExtendedPropertyNames(): array<string,string[]>
```

GetAllExtendedPropertyNames

Use this call to get extended properties for all types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getAllExtendedPropertyNames();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getAllExtendedPropertyNames: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**array<string,string[]>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBatchAudit()`

```php
getBatchAudit($inventory_get_batch_audit_request): \Linnworks\Inventory\Model\GetBatchAuditResponse
```

GetBatchAudit

Get audit trail for batches <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_batch_audit_request = new \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest(); // \Linnworks\Inventory\Model\InventoryGetBatchAuditRequest

try {
    $result = $apiInstance->getBatchAudit($inventory_get_batch_audit_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getBatchAudit: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_batch_audit_request** | [**\Linnworks\Inventory\Model\InventoryGetBatchAuditRequest**](../Model/InventoryGetBatchAuditRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetBatchAuditResponse**](../Model/GetBatchAuditResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBatchInventoryById()`

```php
getBatchInventoryById($request): \Linnworks\Inventory\Model\GetBatchInventoryByIdResponse
```

GetBatchInventoryById

Retruns batch header and only batch inventory for provided batch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest(); // \Linnworks\Inventory\Model\GetBatchInventoryByIdRequest

try {
    $result = $apiInstance->getBatchInventoryById($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getBatchInventoryById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\GetBatchInventoryByIdRequest**](../Model/GetBatchInventoryByIdRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\GetBatchInventoryByIdResponse**](../Model/GetBatchInventoryByIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getBatchesByStockItemId()`

```php
getBatchesByStockItemId($stock_item_id, $only_available, $stock_location_id): \Linnworks\Inventory\Model\StockItemBatch[]
```

GetBatchesByStockItemId

Used to get batch info for stock item for all locations <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Item id
$only_available = True; // bool | If true, only available batches will be returned
$stock_location_id = 'stock_location_id_example'; // string

try {
    $result = $apiInstance->getBatchesByStockItemId($stock_item_id, $only_available, $stock_location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getBatchesByStockItemId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Item id | [optional] |
| **only_available** | **bool**| If true, only available batches will be returned | [optional] |
| **stock_location_id** | **string**|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemBatch[]**](../Model/StockItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCategories()`

```php
getCategories(): \Linnworks\Inventory\Model\LinnworksCategory[]
```

GetCategories

Use this call to get categories <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCategories();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\LinnworksCategory[]**](../Model/LinnworksCategory.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getChannels()`

```php
getChannels(): \Linnworks\Inventory\Model\AnyConfig[]
```

GetChannels

Use this call to get all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getChannels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\AnyConfig[]**](../Model/AnyConfig.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getChannelsBySource()`

```php
getChannelsBySource($source): \Linnworks\Inventory\Model\HeaderConfig[]
```

GetChannelsBySource

Use this call to get channels by source <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$source = 'source_example'; // string | Channel source

try {
    $result = $apiInstance->getChannelsBySource($source);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getChannelsBySource: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **source** | **string**| Channel source | [optional] |

### Return type

[**\Linnworks\Inventory\Model\HeaderConfig[]**](../Model/HeaderConfig.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCountries()`

```php
getCountries(): \Linnworks\Inventory\Model\Country[]
```

GetCountries

Use this call to get list of all countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCountries();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\Country[]**](../Model/Country.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCountryCodes()`

```php
getCountryCodes(): array<string,string>
```

GetCountryCodes

Use this call to get all country codes from ebay channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getCountryCodes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getCountryCodes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**array<string,string>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getEbayCompatibilityList()`

```php
getEbayCompatibilityList($stock_item_id): \Linnworks\Inventory\Model\StockItemEbayCompatibility[]
```

GetEbayCompatibilityList

Use this call to get a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Stock Item Id

try {
    $result = $apiInstance->getEbayCompatibilityList($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getEbayCompatibilityList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Stock Item Id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemEbayCompatibility[]**](../Model/StockItemEbayCompatibility.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getExtendedPropertyNames()`

```php
getExtendedPropertyNames($property_type): string[]
```

GetExtendedPropertyNames

Use this call to get all available extended property names <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$property_type = 'property_type_example'; // string

try {
    $result = $apiInstance->getExtendedPropertyNames($property_type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getExtendedPropertyNames: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **property_type** | **string**|  | [optional] |

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getExtendedPropertyTypes()`

```php
getExtendedPropertyTypes(): string[]
```

GetExtendedPropertyTypes

Use this call to get default extended property types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getExtendedPropertyTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getExtendedPropertyTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string[]**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getImagesInBulk()`

```php
getImagesInBulk($inventory_get_images_in_bulk_request): \Linnworks\Inventory\Model\GetImagesInBulkResponse
```

GetImagesInBulk

Use this call to Get inventory item images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_images_in_bulk_request = new \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest(); // \Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest

try {
    $result = $apiInstance->getImagesInBulk($inventory_get_images_in_bulk_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getImagesInBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_images_in_bulk_request** | [**\Linnworks\Inventory\Model\InventoryGetImagesInBulkRequest**](../Model/InventoryGetImagesInBulkRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetImagesInBulkResponse**](../Model/GetImagesInBulkResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryBatchTypes()`

```php
getInventoryBatchTypes(): array<string,int>
```

GetInventoryBatchTypes

Use this call to get available inventory batch types <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getInventoryBatchTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryBatchTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**array<string,int>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItem()`

```php
getInventoryItem($stock_item_id, $s_ku): \Linnworks\Inventory\Model\StockItemInv
```

GetInventoryItem

Gets stock item details by either the SKU or StockItemId  The stock item id is supplied, it is used as the primary identifier  If both stock item id and SKU are supplied,  an exception will be thrown if they dont relate to the same Linnworks item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used
$s_ku = 's_ku_example'; // string | The SKU for the item.  Only used when StockItemId is not supplied

try {
    $result = $apiInstance->getInventoryItem($stock_item_id, $s_ku);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| The Linnworks stock item id.  Used in preference over SKU when supplied   If not supplied, the SKU will be used | [optional] |
| **s_ku** | **string**| The SKU for the item.  Only used when StockItemId is not supplied | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemInv**](../Model/StockItemInv.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemAuditTrail()`

```php
getInventoryItemAuditTrail($inventory_item_id): \Linnworks\Inventory\Model\StockItemAuditTrail[]
```

GetInventoryItemAuditTrail

Use this call to get StockItem AuditTrail <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | StockItem unique identifier

try {
    $result = $apiInstance->getInventoryItemAuditTrail($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemAuditTrail: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| StockItem unique identifier | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemAuditTrail[]**](../Model/StockItemAuditTrail.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemAuditTrailPaged()`

```php
getInventoryItemAuditTrailPaged($inventory_get_inventory_item_audit_trail_paged_request): \Linnworks\Inventory\Model\PagedResultStockItemAuditTrail
```

GetInventoryItemAuditTrailPaged

Use this call to retrieve StockItem AuditTrail list by filters <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_inventory_item_audit_trail_paged_request = new \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest(); // \Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest

try {
    $result = $apiInstance->getInventoryItemAuditTrailPaged($inventory_get_inventory_item_audit_trail_paged_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemAuditTrailPaged: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_inventory_item_audit_trail_paged_request** | [**\Linnworks\Inventory\Model\InventoryGetInventoryItemAuditTrailPagedRequest**](../Model/InventoryGetInventoryItemAuditTrailPagedRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\PagedResultStockItemAuditTrail**](../Model/PagedResultStockItemAuditTrail.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemBatchInformation()`

```php
getInventoryItemBatchInformation($inventory_get_inventory_item_batch_information_request): \Linnworks\Inventory\Model\StockItemBatch[]
```

GetInventoryItemBatchInformation

Used to get the batch information of a specific item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_inventory_item_batch_information_request = new \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest(); // \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest

try {
    $result = $apiInstance->getInventoryItemBatchInformation($inventory_get_inventory_item_batch_information_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemBatchInformation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_inventory_item_batch_information_request** | [**\Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationRequest**](../Model/InventoryGetInventoryItemBatchInformationRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\StockItemBatch[]**](../Model/StockItemBatch.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemBatchInformationByIds()`

```php
getInventoryItemBatchInformationByIds($inventory_get_inventory_item_batch_information_by_ids_request): \Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse
```

GetInventoryItemBatchInformationByIds

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_inventory_item_batch_information_by_ids_request = new \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest(); // \Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest

try {
    $result = $apiInstance->getInventoryItemBatchInformationByIds($inventory_get_inventory_item_batch_information_by_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemBatchInformationByIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_inventory_item_batch_information_by_ids_request** | [**\Linnworks\Inventory\Model\InventoryGetInventoryItemBatchInformationByIdsRequest**](../Model/InventoryGetInventoryItemBatchInformationByIdsRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetInventoryItemBatchInformationByIdsResponse**](../Model/GetInventoryItemBatchInformationByIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemById()`

```php
getInventoryItemById($id): \Linnworks\Inventory\Model\StockItemInv
```

GetInventoryItemById

Use this call to get all product details <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string

try {
    $result = $apiInstance->getInventoryItemById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **id** | **string**|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemInv**](../Model/StockItemInv.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemChannelSKUs()`

```php
getInventoryItemChannelSKUs($inventory_item_id): \Linnworks\Inventory\Model\StockItemChannelSKU[]
```

GetInventoryItemChannelSKUs

Use this call to get stockitem channel skus <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | stockitem id

try {
    $result = $apiInstance->getInventoryItemChannelSKUs($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemChannelSKUs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| stockitem id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemChannelSKU[]**](../Model/StockItemChannelSKU.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemChannelSKUsWithLocation()`

```php
getInventoryItemChannelSKUsWithLocation($channel_sku_row_id): \Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]
```

GetInventoryItemChannelSKUsWithLocation

Use this call to retrieve all stock item channel sku's with location for a given channel sku RowId <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$channel_sku_row_id = 'channel_sku_row_id_example'; // string | ChannelSKU record Id

try {
    $result = $apiInstance->getInventoryItemChannelSKUsWithLocation($channel_sku_row_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemChannelSKUsWithLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **channel_sku_row_id** | **string**| ChannelSKU record Id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemChannelSKUWithLocation[]**](../Model/StockItemChannelSKUWithLocation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemCompositions()`

```php
getInventoryItemCompositions($inventory_item_id, $get_full_detail): \Linnworks\Inventory\Model\StockItemComposition[]
```

GetInventoryItemCompositions

Use this call to get all StockItem Compositions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | Id of StockItem
$get_full_detail = True; // bool | Indicate if the method has to be recursive, going throw inner composites, getting only real items

try {
    $result = $apiInstance->getInventoryItemCompositions($inventory_item_id, $get_full_detail);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemCompositions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| Id of StockItem | [optional] |
| **get_full_detail** | **bool**| Indicate if the method has to be recursive, going throw inner composites, getting only real items | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemComposition[]**](../Model/StockItemComposition.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemDescriptions()`

```php
getInventoryItemDescriptions($inventory_item_id): \Linnworks\Inventory\Model\StockItemDescription[]
```

GetInventoryItemDescriptions

Use this call to get stockitem Descriptions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | stockitem id

try {
    $result = $apiInstance->getInventoryItemDescriptions($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemDescriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| stockitem id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemDescription[]**](../Model/StockItemDescription.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemExtendedProperties()`

```php
getInventoryItemExtendedProperties($inventory_get_inventory_item_extended_properties_request): \Linnworks\Inventory\Model\StockItemExtendedProperty[]
```

GetInventoryItemExtendedProperties

Use this call to get stockitem Extended Properties <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_inventory_item_extended_properties_request = new \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest(); // \Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest

try {
    $result = $apiInstance->getInventoryItemExtendedProperties($inventory_get_inventory_item_extended_properties_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_inventory_item_extended_properties_request** | [**\Linnworks\Inventory\Model\InventoryGetInventoryItemExtendedPropertiesRequest**](../Model/InventoryGetInventoryItemExtendedPropertiesRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\StockItemExtendedProperty[]**](../Model/StockItemExtendedProperty.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemImages()`

```php
getInventoryItemImages($inventory_item_id, $item_number): \Linnworks\Inventory\Model\StockItemImage[]
```

GetInventoryItemImages

Use this call to get inventory item images <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | Conditional. If not provided, you must provide ItemNumber
$item_number = 'item_number_example'; // string | Conditional. if InventoryItemId is provided, ItemNumber will be ignored

try {
    $result = $apiInstance->getInventoryItemImages($inventory_item_id, $item_number);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemImages: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| Conditional. If not provided, you must provide ItemNumber | [optional] |
| **item_number** | **string**| Conditional. if InventoryItemId is provided, ItemNumber will be ignored | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemImage[]**](../Model/StockItemImage.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemLocations()`

```php
getInventoryItemLocations($inventory_item_id): \Linnworks\Inventory\Model\StockItemLocation[]
```

GetInventoryItemLocations

Use this call to get stock item locations bin/rack <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | Stock item ID

try {
    $result = $apiInstance->getInventoryItemLocations($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| Stock item ID | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemLocation[]**](../Model/StockItemLocation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemPriceChannelSuffixes()`

```php
getInventoryItemPriceChannelSuffixes(): array<string,string[]>
```

GetInventoryItemPriceChannelSuffixes

Use this call to get all possible price change subsource suffices for all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getInventoryItemPriceChannelSuffixes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemPriceChannelSuffixes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**array<string,string[]>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemPriceRulesById()`

```php
getInventoryItemPriceRulesById($stock_item_price_id): \Linnworks\Inventory\Model\StockItemPricingRule[]
```

GetInventoryItemPriceRulesById

Use this call to get stock item price rules by price id <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_price_id = 'stock_item_price_id_example'; // string | Price ID of an item

try {
    $result = $apiInstance->getInventoryItemPriceRulesById($stock_item_price_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemPriceRulesById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_price_id** | **string**| Price ID of an item | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemPricingRule[]**](../Model/StockItemPricingRule.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemPriceRulesBySource()`

```php
getInventoryItemPriceRulesBySource($stock_item_id, $source, $sub_source): \Linnworks\Inventory\Model\StockItemPricingRule[]
```

GetInventoryItemPriceRulesBySource

Use this call to get stock item price rules by item id, source and subsource <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Stock item id
$source = 'source_example'; // string | Channel source
$sub_source = 'sub_source_example'; // string | Channel subsource

try {
    $result = $apiInstance->getInventoryItemPriceRulesBySource($stock_item_id, $source, $sub_source);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemPriceRulesBySource: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Stock item id | [optional] |
| **source** | **string**| Channel source | [optional] |
| **sub_source** | **string**| Channel subsource | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemPricingRule[]**](../Model/StockItemPricingRule.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemPriceTags()`

```php
getInventoryItemPriceTags(): array<string,string[]>
```

GetInventoryItemPriceTags

Use this call to get all possible price change tags for all channels <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getInventoryItemPriceTags();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemPriceTags: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**array<string,string[]>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemPrices()`

```php
getInventoryItemPrices($inventory_item_id): \Linnworks\Inventory\Model\StockItemPrice[]
```

GetInventoryItemPrices

Use this call to get stock item prices by channel <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | Stock item id

try {
    $result = $apiInstance->getInventoryItemPrices($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemPrices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| Stock item id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemPrice[]**](../Model/StockItemPrice.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemTitles()`

```php
getInventoryItemTitles($inventory_item_id): \Linnworks\Inventory\Model\StockItemTitle[]
```

GetInventoryItemTitles

Use this call to get stockitem Titles <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | stockitem id

try {
    $result = $apiInstance->getInventoryItemTitles($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemTitles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| stockitem id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemTitle[]**](../Model/StockItemTitle.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemsCompositionByIds()`

```php
getInventoryItemsCompositionByIds($inventory_get_inventory_items_composition_by_ids_request): \Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse
```

GetInventoryItemsCompositionByIds

Use this call to get all StockItem Compositions <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_inventory_items_composition_by_ids_request = new \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest(); // \Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest

try {
    $result = $apiInstance->getInventoryItemsCompositionByIds($inventory_get_inventory_items_composition_by_ids_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemsCompositionByIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_inventory_items_composition_by_ids_request** | [**\Linnworks\Inventory\Model\InventoryGetInventoryItemsCompositionByIdsRequest**](../Model/InventoryGetInventoryItemsCompositionByIdsRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetInventoryItemsCompositionByIdsResponse**](../Model/GetInventoryItemsCompositionByIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getInventoryItemsCount()`

```php
getInventoryItemsCount($include_deleted, $include_archived): int
```

GetInventoryItemsCount

Use this call to get total items count <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$include_deleted = True; // bool | Include deleted items
$include_archived = True; // bool | Include archived items

try {
    $result = $apiInstance->getInventoryItemsCount($include_deleted, $include_archived);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getInventoryItemsCount: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **include_deleted** | **bool**| Include deleted items | [optional] |
| **include_archived** | **bool**| Include archived items | [optional] |

### Return type

**int**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getNewItemNumber()`

```php
getNewItemNumber(): string
```

GetNewItemNumber

Use this call to get next unused SKU <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getNewItemNumber();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getNewItemNumber: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

**string**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPackageGroups()`

```php
getPackageGroups(): \Linnworks\Inventory\Model\KeyGuidValue[]
```

GetPackageGroups

Use this call to get all package groups <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getPackageGroups();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getPackageGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\KeyGuidValue[]**](../Model/KeyGuidValue.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPostalServices()`

```php
getPostalServices(): \Linnworks\Inventory\Model\KeyGuidValue[]
```

GetPostalServices

Use this call to get all postal services <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getPostalServices();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getPostalServices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\KeyGuidValue[]**](../Model/KeyGuidValue.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPreDefinedViews()`

```php
getPreDefinedViews(): \Linnworks\Inventory\Model\InventoryView[]
```

GetPreDefinedViews

Use this call to get pre-defined (standard) views <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getPreDefinedViews();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getPreDefinedViews: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\InventoryView[]**](../Model/InventoryView.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductIdentifierExtendedTypes()`

```php
getProductIdentifierExtendedTypes(): \Linnworks\Inventory\Model\GetProductIdentifierExtendedResponse
```

GetProductIdentifierExtendedTypes

Use this call to get available Product Identifier types with extended information, eg related sources, scanned at dispatch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getProductIdentifierExtendedTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getProductIdentifierExtendedTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\GetProductIdentifierExtendedResponse**](../Model/GetProductIdentifierExtendedResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductIdentifierTypes()`

```php
getProductIdentifierTypes(): \Linnworks\Inventory\Model\GetProductIdentifierTypesRequest
```

GetProductIdentifierTypes

Use this call to get available Product Identifier types <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getProductIdentifierTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getProductIdentifierTypes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\GetProductIdentifierTypesRequest**](../Model/GetProductIdentifierTypesRequest.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductIdentifiersBulkByStockItemId()`

```php
getProductIdentifiersBulkByStockItemId($request): \Linnworks\Inventory\Model\GetProductIdentifiersByStockItemIdResponse
```

GetProductIdentifiersBulkByStockItemId

Used to get product identifiers for multiple stock items <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\GetProductIdentifiersBulkByStockItemIdRequest(); // \Linnworks\Inventory\Model\GetProductIdentifiersBulkByStockItemIdRequest | Object containing a list of stock item ids

try {
    $result = $apiInstance->getProductIdentifiersBulkByStockItemId($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getProductIdentifiersBulkByStockItemId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\GetProductIdentifiersBulkByStockItemIdRequest**](../Model/GetProductIdentifiersBulkByStockItemIdRequest.md)| Object containing a list of stock item ids | [optional] |

### Return type

[**\Linnworks\Inventory\Model\GetProductIdentifiersByStockItemIdResponse**](../Model/GetProductIdentifiersByStockItemIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductIdentifiersByStockItemId()`

```php
getProductIdentifiersByStockItemId($inventory_get_product_identifiers_by_stock_item_id_request): \Linnworks\Inventory\Model\GetProductIdentifiersByStockItemIdResponse
```

GetProductIdentifiersByStockItemId

Used to get product identifiers for a stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_product_identifiers_by_stock_item_id_request = new \Linnworks\Inventory\Model\InventoryGetProductIdentifiersByStockItemIdRequest(); // \Linnworks\Inventory\Model\InventoryGetProductIdentifiersByStockItemIdRequest

try {
    $result = $apiInstance->getProductIdentifiersByStockItemId($inventory_get_product_identifiers_by_stock_item_id_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getProductIdentifiersByStockItemId: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_product_identifiers_by_stock_item_id_request** | [**\Linnworks\Inventory\Model\InventoryGetProductIdentifiersByStockItemIdRequest**](../Model/InventoryGetProductIdentifiersByStockItemIdRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetProductIdentifiersByStockItemIdResponse**](../Model/GetProductIdentifiersByStockItemIdResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getScannableProductIdentifiersByOrderIds()`

```php
getScannableProductIdentifiersByOrderIds($request): \Linnworks\Inventory\Model\GetScannableProductIdentifiersByOrderIdsResponse
```

GetScannableProductIdentifiersByOrderIds

Use this call to get available Product Identifier types with extended information, eg related sources, scanned at dispatch <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\GetScannableProductIdentifiersByOrderIdsRequest(); // \Linnworks\Inventory\Model\GetScannableProductIdentifiersByOrderIdsRequest

try {
    $result = $apiInstance->getScannableProductIdentifiersByOrderIds($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getScannableProductIdentifiersByOrderIds: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\GetScannableProductIdentifiersByOrderIdsRequest**](../Model/GetScannableProductIdentifiersByOrderIdsRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\GetScannableProductIdentifiersByOrderIdsResponse**](../Model/GetScannableProductIdentifiersByOrderIdsResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getScrapCategories()`

```php
getScrapCategories(): \Linnworks\Inventory\Model\GetScrapCategoriesResponse
```

GetScrapCategories

Used to get scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItemsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getScrapCategories();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getScrapCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\GetScrapCategoriesResponse**](../Model/GetScrapCategoriesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getScrapHistory()`

```php
getScrapHistory($inventory_get_scrap_history_request): \Linnworks\Inventory\Model\GetScrapHistoryResponse
```

GetScrapHistory

Used to get scrap history <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapHistoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_scrap_history_request = new \Linnworks\Inventory\Model\InventoryGetScrapHistoryRequest(); // \Linnworks\Inventory\Model\InventoryGetScrapHistoryRequest

try {
    $result = $apiInstance->getScrapHistory($inventory_get_scrap_history_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getScrapHistory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_scrap_history_request** | [**\Linnworks\Inventory\Model\InventoryGetScrapHistoryRequest**](../Model/InventoryGetScrapHistoryRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetScrapHistoryResponse**](../Model/GetScrapHistoryResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemBatchesByLocation()`

```php
getStockItemBatchesByLocation($inventory_get_stock_item_batches_by_location_request): \Linnworks\Inventory\Model\GetStockItemBatchesByLocationResponse
```

GetStockItemBatchesByLocation

Used to get batch info by stock item id and location id <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_stock_item_batches_by_location_request = new \Linnworks\Inventory\Model\InventoryGetStockItemBatchesByLocationRequest(); // \Linnworks\Inventory\Model\InventoryGetStockItemBatchesByLocationRequest

try {
    $result = $apiInstance->getStockItemBatchesByLocation($inventory_get_stock_item_batches_by_location_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockItemBatchesByLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_stock_item_batches_by_location_request** | [**\Linnworks\Inventory\Model\InventoryGetStockItemBatchesByLocationRequest**](../Model/InventoryGetStockItemBatchesByLocationRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetStockItemBatchesByLocationResponse**](../Model/GetStockItemBatchesByLocationResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemIdsBySKU()`

```php
getStockItemIdsBySKU($inventory_get_stock_item_ids_by_sku_request): \Linnworks\Inventory\Model\GetStockItemIdsBySKU
```

GetStockItemIdsBySKU

Use this call to Get inventory item images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockReadNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_stock_item_ids_by_sku_request = new \Linnworks\Inventory\Model\InventoryGetStockItemIdsBySKURequest(); // \Linnworks\Inventory\Model\InventoryGetStockItemIdsBySKURequest

try {
    $result = $apiInstance->getStockItemIdsBySKU($inventory_get_stock_item_ids_by_sku_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockItemIdsBySKU: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_stock_item_ids_by_sku_request** | [**\Linnworks\Inventory\Model\InventoryGetStockItemIdsBySKURequest**](../Model/InventoryGetStockItemIdsBySKURequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\GetStockItemIdsBySKU**](../Model/GetStockItemIdsBySKU.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockItemLabels()`

```php
getStockItemLabels($inventory_get_stock_item_labels_request): \Linnworks\Inventory\Model\StockItemLabel[]
```

GetStockItemLabels

Use this call to get labels by search token <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_get_stock_item_labels_request = new \Linnworks\Inventory\Model\InventoryGetStockItemLabelsRequest(); // \Linnworks\Inventory\Model\InventoryGetStockItemLabelsRequest

try {
    $result = $apiInstance->getStockItemLabels($inventory_get_stock_item_labels_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockItemLabels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_get_stock_item_labels_request** | [**\Linnworks\Inventory\Model\InventoryGetStockItemLabelsRequest**](../Model/InventoryGetStockItemLabelsRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\StockItemLabel[]**](../Model/StockItemLabel.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockLocations()`

```php
getStockLocations(): \Linnworks\Inventory\Model\StockLocation[]
```

GetStockLocations

Use this call to get all stock locations <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getStockLocations();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\StockLocation[]**](../Model/StockLocation.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockSupplierStat()`

```php
getStockSupplierStat($inventory_item_id): \Linnworks\Inventory\Model\StockItemSupplierStat[]
```

GetStockSupplierStat

Use this call to retrieve report about \"item supplier stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_id = 'inventory_item_id_example'; // string | Used to specify report stock item id

try {
    $result = $apiInstance->getStockSupplierStat($inventory_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockSupplierStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_id** | **string**| Used to specify report stock item id | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemSupplierStat[]**](../Model/StockItemSupplierStat.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getStockSupplierStatsBulk()`

```php
getStockSupplierStatsBulk($inventory_item_ids): \Linnworks\Inventory\Model\StockItemSupplierStat[]
```

GetStockSupplierStatsBulk

Use this call to retrieve report about \"item supplier stat\" <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_item_ids = array('inventory_item_ids_example'); // string[] | Used to specify report stock item ids

try {
    $result = $apiInstance->getStockSupplierStatsBulk($inventory_item_ids);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getStockSupplierStatsBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_item_ids** | [**string[]**](../Model/string.md)| Used to specify report stock item ids | [optional] |

### Return type

[**\Linnworks\Inventory\Model\StockItemSupplierStat[]**](../Model/StockItemSupplierStat.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSupplierDetails()`

```php
getSupplierDetails($supplier_id): \Linnworks\Inventory\Model\Supplier
```

GetSupplierDetails

Use this call to retrieve details of one Supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$supplier_id = 'supplier_id_example'; // string | Supplier ID

try {
    $result = $apiInstance->getSupplierDetails($supplier_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getSupplierDetails: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **supplier_id** | **string**| Supplier ID | [optional] |

### Return type

[**\Linnworks\Inventory\Model\Supplier**](../Model/Supplier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSuppliers()`

```php
getSuppliers(): \Linnworks\Inventory\Model\Supplier[]
```

GetSuppliers

Use this call to retrieve list of all Suppliers' names <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getSuppliers();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getSuppliers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\Supplier[]**](../Model/Supplier.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getUserSpecificViews()`

```php
getUserSpecificViews(): \Linnworks\Inventory\Model\InventoryView[]
```

GetUserSpecificViews

Use this call to get user-specific views from database <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->getUserSpecificViews();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->getUserSpecificViews: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Linnworks\Inventory\Model\InventoryView[]**](../Model/InventoryView.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `hasStockItemBatches()`

```php
hasStockItemBatches($stock_item_id): bool
```

HasStockItemBatches

Used to check if stock item has batches <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$stock_item_id = 'stock_item_id_example'; // string | Stock item unique identifier

try {
    $result = $apiInstance->hasStockItemBatches($stock_item_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->hasStockItemBatches: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **stock_item_id** | **string**| Stock item unique identifier | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `hasStockItemStockLevel()`

```php
hasStockItemStockLevel($inventory_has_stock_item_stock_level_request): \Linnworks\Inventory\Model\HasStockItemStockLevelResponse
```

HasStockItemStockLevel

Used to check has stock item stock level or not <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_has_stock_item_stock_level_request = new \Linnworks\Inventory\Model\InventoryHasStockItemStockLevelRequest(); // \Linnworks\Inventory\Model\InventoryHasStockItemStockLevelRequest

try {
    $result = $apiInstance->hasStockItemStockLevel($inventory_has_stock_item_stock_level_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->hasStockItemStockLevel: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_has_stock_item_stock_level_request** | [**\Linnworks\Inventory\Model\InventoryHasStockItemStockLevelRequest**](../Model/InventoryHasStockItemStockLevelRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\HasStockItemStockLevelResponse**](../Model/HasStockItemStockLevelResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `insertUpdateEbayCompatibilityList()`

```php
insertUpdateEbayCompatibilityList($inventory_insert_update_ebay_compatibility_list_request): \Linnworks\Inventory\Model\InsertUpdateEbayCompatibilityListResponse
```

InsertUpdateEbayCompatibilityList

Use this call to insert and update a list of Ebay Compatibility <b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_insert_update_ebay_compatibility_list_request = new \Linnworks\Inventory\Model\InventoryInsertUpdateEbayCompatibilityListRequest(); // \Linnworks\Inventory\Model\InventoryInsertUpdateEbayCompatibilityListRequest

try {
    $result = $apiInstance->insertUpdateEbayCompatibilityList($inventory_insert_update_ebay_compatibility_list_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->insertUpdateEbayCompatibilityList: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_insert_update_ebay_compatibility_list_request** | [**\Linnworks\Inventory\Model\InventoryInsertUpdateEbayCompatibilityListRequest**](../Model/InventoryInsertUpdateEbayCompatibilityListRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\InsertUpdateEbayCompatibilityListResponse**](../Model/InsertUpdateEbayCompatibilityListResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `isInventoryItemChannelSKULinked()`

```php
isInventoryItemChannelSKULinked($channel_sku, $source, $sub_source): bool
```

IsInventoryItemChannelSKULinked

Use this call to check if ChannelSKU is linked <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$channel_sku = 'channel_sku_example'; // string | Product Channel SKU
$source = 'source_example'; // string | ChannelName/Source (e.g. EBAY)
$sub_source = 'sub_source_example'; // string | Subsource (e.g. EBAY1)

try {
    $result = $apiInstance->isInventoryItemChannelSKULinked($channel_sku, $source, $sub_source);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->isInventoryItemChannelSKULinked: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **channel_sku** | **string**| Product Channel SKU | [optional] |
| **source** | **string**| ChannelName/Source (e.g. EBAY) | [optional] |
| **sub_source** | **string**| Subsource (e.g. EBAY1) | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `isOwnedStockLocation()`

```php
isOwnedStockLocation($location_id): bool
```

IsOwnedStockLocation

Checks whether a location is FBA or has an enabled inventory update import <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$location_id = 'location_id_example'; // string | Location ID

try {
    $result = $apiInstance->isOwnedStockLocation($location_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->isOwnedStockLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **location_id** | **string**| Location ID | [optional] |

### Return type

**bool**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `itemsHaveScannableIdentifiers()`

```php
itemsHaveScannableIdentifiers($request): \Linnworks\Inventory\Model\ItemsHaveScannableIdentifiersResponse
```

ItemsHaveScannableIdentifiers

<b>Permissions Required: </b> GlobalPermissions.Inventory.MyInventoryNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\ItemsHaveScannableIdentifiersRequest(); // \Linnworks\Inventory\Model\ItemsHaveScannableIdentifiersRequest

try {
    $result = $apiInstance->itemsHaveScannableIdentifiers($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->itemsHaveScannableIdentifiers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\ItemsHaveScannableIdentifiersRequest**](../Model/ItemsHaveScannableIdentifiersRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\ItemsHaveScannableIdentifiersResponse**](../Model/ItemsHaveScannableIdentifiersResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `scrapBatchedItem()`

```php
scrapBatchedItem($inventory_scrap_batched_item_request): \Linnworks\Inventory\Model\ScrapBatchedItemResponse
```

ScrapBatchedItem

Used to scrap batched item <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapStockNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_scrap_batched_item_request = new \Linnworks\Inventory\Model\InventoryScrapBatchedItemRequest(); // \Linnworks\Inventory\Model\InventoryScrapBatchedItemRequest

try {
    $result = $apiInstance->scrapBatchedItem($inventory_scrap_batched_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->scrapBatchedItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_scrap_batched_item_request** | [**\Linnworks\Inventory\Model\InventoryScrapBatchedItemRequest**](../Model/InventoryScrapBatchedItemRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\ScrapBatchedItemResponse**](../Model/ScrapBatchedItemResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setInventoryItemImageAsMain()`

```php
setInventoryItemImageAsMain($inventory_set_inventory_item_image_as_main_request)
```

SetInventoryItemImageAsMain

Use this call to update inventory item main image <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_set_inventory_item_image_as_main_request = new \Linnworks\Inventory\Model\InventorySetInventoryItemImageAsMainRequest(); // \Linnworks\Inventory\Model\InventorySetInventoryItemImageAsMainRequest

try {
    $apiInstance->setInventoryItemImageAsMain($inventory_set_inventory_item_image_as_main_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->setInventoryItemImageAsMain: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_set_inventory_item_image_as_main_request** | [**\Linnworks\Inventory\Model\InventorySetInventoryItemImageAsMainRequest**](../Model/InventorySetInventoryItemImageAsMainRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `unarchiveInventoryItems()`

```php
unarchiveInventoryItems($inventory_unarchive_inventory_items_request)
```

UnarchiveInventoryItems

Use this call to unarchive inventory items <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_unarchive_inventory_items_request = new \Linnworks\Inventory\Model\InventoryUnarchiveInventoryItemsRequest(); // \Linnworks\Inventory\Model\InventoryUnarchiveInventoryItemsRequest

try {
    $apiInstance->unarchiveInventoryItems($inventory_unarchive_inventory_items_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->unarchiveInventoryItems: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_unarchive_inventory_items_request** | [**\Linnworks\Inventory\Model\InventoryUnarchiveInventoryItemsRequest**](../Model/InventoryUnarchiveInventoryItemsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `unlinkChannelListing()`

```php
unlinkChannelListing($inventory_unlink_channel_listing_request)
```

UnlinkChannelListing

Use this call to unlink  inventory listing from inventory item <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_unlink_channel_listing_request = new \Linnworks\Inventory\Model\InventoryUnlinkChannelListingRequest(); // \Linnworks\Inventory\Model\InventoryUnlinkChannelListingRequest

try {
    $apiInstance->unlinkChannelListing($inventory_unlink_channel_listing_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->unlinkChannelListing: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_unlink_channel_listing_request** | [**\Linnworks\Inventory\Model\InventoryUnlinkChannelListingRequest**](../Model/InventoryUnlinkChannelListingRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateBatchDates()`

```php
updateBatchDates($request): \Linnworks\Inventory\Model\UpdateBatchDatesResponse
```

UpdateBatchDates

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request = new \Linnworks\Inventory\Model\UpdateBatchDatesRequest(); // \Linnworks\Inventory\Model\UpdateBatchDatesRequest

try {
    $result = $apiInstance->updateBatchDates($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateBatchDates: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Inventory\Model\UpdateBatchDatesRequest**](../Model/UpdateBatchDatesRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Inventory\Model\UpdateBatchDatesResponse**](../Model/UpdateBatchDatesResponse.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateBatchDetails()`

```php
updateBatchDetails($inventory_update_batch_details_request)
```

UpdateBatchDetails

Used to update batch details for stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_batch_details_request = new \Linnworks\Inventory\Model\InventoryUpdateBatchDetailsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateBatchDetailsRequest

try {
    $apiInstance->updateBatchDetails($inventory_update_batch_details_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateBatchDetails: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_batch_details_request** | [**\Linnworks\Inventory\Model\InventoryUpdateBatchDetailsRequest**](../Model/InventoryUpdateBatchDetailsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateBatchesWithInventory()`

```php
updateBatchesWithInventory($inventory_update_batches_with_inventory_request)
```

UpdateBatchesWithInventory

Used to update batches and batch inventory info <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_batches_with_inventory_request = new \Linnworks\Inventory\Model\InventoryUpdateBatchesWithInventoryRequest(); // \Linnworks\Inventory\Model\InventoryUpdateBatchesWithInventoryRequest

try {
    $apiInstance->updateBatchesWithInventory($inventory_update_batches_with_inventory_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateBatchesWithInventory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_batches_with_inventory_request** | [**\Linnworks\Inventory\Model\InventoryUpdateBatchesWithInventoryRequest**](../Model/InventoryUpdateBatchesWithInventoryRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCategory()`

```php
updateCategory($inventory_update_category_request)
```

UpdateCategory

Use this call to update category name <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_category_request = new \Linnworks\Inventory\Model\InventoryUpdateCategoryRequest(); // \Linnworks\Inventory\Model\InventoryUpdateCategoryRequest

try {
    $apiInstance->updateCategory($inventory_update_category_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_category_request** | [**\Linnworks\Inventory\Model\InventoryUpdateCategoryRequest**](../Model/InventoryUpdateCategoryRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCompositeParentStockLevel()`

```php
updateCompositeParentStockLevel($inventory_update_composite_parent_stock_level_request): int
```

UpdateCompositeParentStockLevel

Updates the stock level of the composite parent item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_composite_parent_stock_level_request = new \Linnworks\Inventory\Model\InventoryUpdateCompositeParentStockLevelRequest(); // \Linnworks\Inventory\Model\InventoryUpdateCompositeParentStockLevelRequest

try {
    $result = $apiInstance->updateCompositeParentStockLevel($inventory_update_composite_parent_stock_level_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateCompositeParentStockLevel: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_composite_parent_stock_level_request** | [**\Linnworks\Inventory\Model\InventoryUpdateCompositeParentStockLevelRequest**](../Model/InventoryUpdateCompositeParentStockLevelRequest.md)|  | |

### Return type

**int**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCountries()`

```php
updateCountries($inventory_update_countries_request)
```

UpdateCountries

Use this call to udpate countries <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_countries_request = new \Linnworks\Inventory\Model\InventoryUpdateCountriesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateCountriesRequest

try {
    $apiInstance->updateCountries($inventory_update_countries_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateCountries: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_countries_request** | [**\Linnworks\Inventory\Model\InventoryUpdateCountriesRequest**](../Model/InventoryUpdateCountriesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCountryRegions()`

```php
updateCountryRegions($inventory_update_country_regions_request)
```

UpdateCountryRegions

Update regions for country <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_country_regions_request = new \Linnworks\Inventory\Model\InventoryUpdateCountryRegionsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateCountryRegionsRequest

try {
    $apiInstance->updateCountryRegions($inventory_update_country_regions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateCountryRegions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_country_regions_request** | [**\Linnworks\Inventory\Model\InventoryUpdateCountryRegionsRequest**](../Model/InventoryUpdateCountryRegionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateImages()`

```php
updateImages($inventory_update_images_request)
```

UpdateImages

Update properties on images <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_images_request = new \Linnworks\Inventory\Model\InventoryUpdateImagesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateImagesRequest

try {
    $apiInstance->updateImages($inventory_update_images_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateImages: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_images_request** | [**\Linnworks\Inventory\Model\InventoryUpdateImagesRequest**](../Model/InventoryUpdateImagesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItem()`

```php
updateInventoryItem($inventory_update_inventory_item_request)
```

UpdateInventoryItem

Use this call to update stock items. This acts as a set endpoint, all data for the stock item will be replaced, even if not provided in the request.  The only exception is StockItemId. If left empty, the item to update will be identified by ItemNumber. <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemRequest

try {
    $apiInstance->updateInventoryItem($inventory_update_inventory_item_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemRequest**](../Model/InventoryUpdateInventoryItemRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemChannelSKUs()`

```php
updateInventoryItemChannelSKUs($inventory_update_inventory_item_channel_skus_request)
```

UpdateInventoryItemChannelSKUs

Update inventory Channel SKU's properties, such as Max Listed Quantity <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_channel_skus_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsRequest

try {
    $apiInstance->updateInventoryItemChannelSKUs($inventory_update_inventory_item_channel_skus_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemChannelSKUs: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_channel_skus_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsRequest**](../Model/InventoryUpdateInventoryItemChannelSKUsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemChannelSKUsWithLocation()`

```php
updateInventoryItemChannelSKUsWithLocation($inventory_update_inventory_item_channel_skus_with_location_request)
```

UpdateInventoryItemChannelSKUsWithLocation

Update inventory Channel SKU's with location properties, such as Max Listed Quantity <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_channel_skus_with_location_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsWithLocationRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsWithLocationRequest

try {
    $apiInstance->updateInventoryItemChannelSKUsWithLocation($inventory_update_inventory_item_channel_skus_with_location_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemChannelSKUsWithLocation: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_channel_skus_with_location_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemChannelSKUsWithLocationRequest**](../Model/InventoryUpdateInventoryItemChannelSKUsWithLocationRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemCompositions()`

```php
updateInventoryItemCompositions($inventory_update_inventory_item_compositions_request)
```

UpdateInventoryItemCompositions

Use this call to update stockItem compositions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_compositions_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemCompositionsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemCompositionsRequest

try {
    $apiInstance->updateInventoryItemCompositions($inventory_update_inventory_item_compositions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemCompositions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_compositions_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemCompositionsRequest**](../Model/InventoryUpdateInventoryItemCompositionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemDescriptions()`

```php
updateInventoryItemDescriptions($inventory_update_inventory_item_descriptions_request)
```

UpdateInventoryItemDescriptions

Use this call to update stockitem Descriptions <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_descriptions_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemDescriptionsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemDescriptionsRequest

try {
    $apiInstance->updateInventoryItemDescriptions($inventory_update_inventory_item_descriptions_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemDescriptions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_descriptions_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemDescriptionsRequest**](../Model/InventoryUpdateInventoryItemDescriptionsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemExtendedProperties()`

```php
updateInventoryItemExtendedProperties($inventory_update_inventory_item_extended_properties_request)
```

UpdateInventoryItemExtendedProperties

Use this call to update stockitem Extended Properties <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_extended_properties_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemExtendedPropertiesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemExtendedPropertiesRequest

try {
    $apiInstance->updateInventoryItemExtendedProperties($inventory_update_inventory_item_extended_properties_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemExtendedProperties: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_extended_properties_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemExtendedPropertiesRequest**](../Model/InventoryUpdateInventoryItemExtendedPropertiesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemField()`

```php
updateInventoryItemField($inventory_update_inventory_item_field_request): array<string,object>
```

UpdateInventoryItemField

<b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_field_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemFieldRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemFieldRequest

try {
    $result = $apiInstance->updateInventoryItemField($inventory_update_inventory_item_field_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemField: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_field_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemFieldRequest**](../Model/InventoryUpdateInventoryItemFieldRequest.md)|  | |

### Return type

**array<string,object>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemLevels()`

```php
updateInventoryItemLevels($inventory_update_inventory_item_levels_request): array<string,array<string,object>>
```

UpdateInventoryItemLevels

Update and return stock level records for the stock item and any composite related items <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockLevelsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_levels_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemLevelsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemLevelsRequest

try {
    $result = $apiInstance->updateInventoryItemLevels($inventory_update_inventory_item_levels_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemLevels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_levels_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemLevelsRequest**](../Model/InventoryUpdateInventoryItemLevelsRequest.md)|  | |

### Return type

**array<string,array<string,object>>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemLocationField()`

```php
updateInventoryItemLocationField($inventory_update_inventory_item_location_field_request): array<string,object>
```

UpdateInventoryItemLocationField

Update and return stock level records for the stock item <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_location_field_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemLocationFieldRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemLocationFieldRequest

try {
    $result = $apiInstance->updateInventoryItemLocationField($inventory_update_inventory_item_location_field_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemLocationField: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_location_field_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemLocationFieldRequest**](../Model/InventoryUpdateInventoryItemLocationFieldRequest.md)|  | |

### Return type

**array<string,object>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemPrices()`

```php
updateInventoryItemPrices($inventory_update_inventory_item_prices_request)
```

UpdateInventoryItemPrices

Use this call to update stock item prices <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_prices_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricesRequest

try {
    $apiInstance->updateInventoryItemPrices($inventory_update_inventory_item_prices_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemPrices: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_prices_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricesRequest**](../Model/InventoryUpdateInventoryItemPricesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemPricingRules()`

```php
updateInventoryItemPricingRules($inventory_update_inventory_item_pricing_rules_request)
```

UpdateInventoryItemPricingRules

Use this call to update stock item price rules <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_pricing_rules_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricingRulesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricingRulesRequest

try {
    $apiInstance->updateInventoryItemPricingRules($inventory_update_inventory_item_pricing_rules_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemPricingRules: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_pricing_rules_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemPricingRulesRequest**](../Model/InventoryUpdateInventoryItemPricingRulesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemStockField()`

```php
updateInventoryItemStockField($inventory_update_inventory_item_stock_field_request): array<string,object>
```

UpdateInventoryItemStockField

Update and return stock level <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>250</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_stock_field_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemStockFieldRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemStockFieldRequest

try {
    $result = $apiInstance->updateInventoryItemStockField($inventory_update_inventory_item_stock_field_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemStockField: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_stock_field_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemStockFieldRequest**](../Model/InventoryUpdateInventoryItemStockFieldRequest.md)|  | |

### Return type

**array<string,object>**

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateInventoryItemTitles()`

```php
updateInventoryItemTitles($inventory_update_inventory_item_titles_request)
```

UpdateInventoryItemTitles

Use this call to update stockitem Titles <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_inventory_item_titles_request = new \Linnworks\Inventory\Model\InventoryUpdateInventoryItemTitlesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateInventoryItemTitlesRequest

try {
    $apiInstance->updateInventoryItemTitles($inventory_update_inventory_item_titles_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateInventoryItemTitles: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_inventory_item_titles_request** | [**\Linnworks\Inventory\Model\InventoryUpdateInventoryItemTitlesRequest**](../Model/InventoryUpdateInventoryItemTitlesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateItemLocations()`

```php
updateItemLocations($inventory_update_item_locations_request)
```

UpdateItemLocations

Use this call to update stock item locations bin/rack <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemBinRackNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_item_locations_request = new \Linnworks\Inventory\Model\InventoryUpdateItemLocationsRequest(); // \Linnworks\Inventory\Model\InventoryUpdateItemLocationsRequest

try {
    $apiInstance->updateItemLocations($inventory_update_item_locations_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateItemLocations: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_item_locations_request** | [**\Linnworks\Inventory\Model\InventoryUpdateItemLocationsRequest**](../Model/InventoryUpdateItemLocationsRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductIdentifiers()`

```php
updateProductIdentifiers($inventory_update_product_identifiers_request)
```

UpdateProductIdentifiers

Used to update product identifiers <b>Permissions Required: </b> GlobalPermissions.Inventory.Stock.StockWrite.ChangeStockItemDetailsNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_product_identifiers_request = new \Linnworks\Inventory\Model\InventoryUpdateProductIdentifiersRequest(); // \Linnworks\Inventory\Model\InventoryUpdateProductIdentifiersRequest

try {
    $apiInstance->updateProductIdentifiers($inventory_update_product_identifiers_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateProductIdentifiers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_product_identifiers_request** | [**\Linnworks\Inventory\Model\InventoryUpdateProductIdentifiersRequest**](../Model/InventoryUpdateProductIdentifiersRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateScrapCategories()`

```php
updateScrapCategories($inventory_update_scrap_categories_request)
```

UpdateScrapCategories

Used to update scrap categories <b>Permissions Required: </b> GlobalPermissions.Inventory.ScrapItems.ScrapCategoriesNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_scrap_categories_request = new \Linnworks\Inventory\Model\InventoryUpdateScrapCategoriesRequest(); // \Linnworks\Inventory\Model\InventoryUpdateScrapCategoriesRequest

try {
    $apiInstance->updateScrapCategories($inventory_update_scrap_categories_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateScrapCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_scrap_categories_request** | [**\Linnworks\Inventory\Model\InventoryUpdateScrapCategoriesRequest**](../Model/InventoryUpdateScrapCategoriesRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateStockSupplierStat()`

```php
updateStockSupplierStat($inventory_update_stock_supplier_stat_request)
```

UpdateStockSupplierStat

Use this call to update item supplier stat <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_stock_supplier_stat_request = new \Linnworks\Inventory\Model\InventoryUpdateStockSupplierStatRequest(); // \Linnworks\Inventory\Model\InventoryUpdateStockSupplierStatRequest

try {
    $apiInstance->updateStockSupplierStat($inventory_update_stock_supplier_stat_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateStockSupplierStat: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_stock_supplier_stat_request** | [**\Linnworks\Inventory\Model\InventoryUpdateStockSupplierStatRequest**](../Model/InventoryUpdateStockSupplierStatRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateSupplier()`

```php
updateSupplier($inventory_update_supplier_request)
```

UpdateSupplier

Use this call to update supplier <b>Permissions Required: </b> GlobalPermissions.Inventory.InventorySettings.SuppliersNode <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_supplier_request = new \Linnworks\Inventory\Model\InventoryUpdateSupplierRequest(); // \Linnworks\Inventory\Model\InventoryUpdateSupplierRequest

try {
    $apiInstance->updateSupplier($inventory_update_supplier_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateSupplier: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_supplier_request** | [**\Linnworks\Inventory\Model\InventoryUpdateSupplierRequest**](../Model/InventoryUpdateSupplierRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateUserSpecificView()`

```php
updateUserSpecificView($inventory_update_user_specific_view_request)
```

UpdateUserSpecificView

Use this call to update an existing user-specific view <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_update_user_specific_view_request = new \Linnworks\Inventory\Model\InventoryUpdateUserSpecificViewRequest(); // \Linnworks\Inventory\Model\InventoryUpdateUserSpecificViewRequest

try {
    $apiInstance->updateUserSpecificView($inventory_update_user_specific_view_request);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->updateUserSpecificView: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_update_user_specific_view_request** | [**\Linnworks\Inventory\Model\InventoryUpdateUserSpecificViewRequest**](../Model/InventoryUpdateUserSpecificViewRequest.md)|  | |

### Return type

void (empty response body)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `uploadImagesToInventoryItem()`

```php
uploadImagesToInventoryItem($inventory_upload_images_to_inventory_item_request): \Linnworks\Inventory\Model\PictureSource[]
```

UploadImagesToInventoryItem

Use this call to upload images from Uploader to StockItem <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_upload_images_to_inventory_item_request = new \Linnworks\Inventory\Model\InventoryUploadImagesToInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryUploadImagesToInventoryItemRequest

try {
    $result = $apiInstance->uploadImagesToInventoryItem($inventory_upload_images_to_inventory_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->uploadImagesToInventoryItem: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **inventory_upload_images_to_inventory_item_request** | [**\Linnworks\Inventory\Model\InventoryUploadImagesToInventoryItemRequest**](../Model/InventoryUploadImagesToInventoryItemRequest.md)|  | |

### Return type

[**\Linnworks\Inventory\Model\PictureSource[]**](../Model/PictureSource.md)

### Authorization

[token](../../README.md#token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
