# OpenAPIClient-php

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)


## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/linnworks.git"
    }
  ],
  "require": {
    "talisman/linnworks": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: token
$config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Linnworks\Inventory\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Linnworks\Inventory\Api\InventoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$inventory_add_image_to_inventory_item_request = new \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest(); // \Linnworks\Inventory\Model\InventoryAddImageToInventoryItemRequest

try {
    $result = $apiInstance->addImageToInventoryItem($inventory_add_image_to_inventory_item_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling InventoryApi->addImageToInventoryItem: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://eu-ext.linnworks.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*InventoryApi* | [**addImageToInventoryItem**](docs/Api/InventoryApi.md#addimagetoinventoryitem) | **POST** /api/Inventory/AddImageToInventoryItem | AddImageToInventoryItem
*InventoryApi* | [**addInventoryItem**](docs/Api/InventoryApi.md#addinventoryitem) | **POST** /api/Inventory/AddInventoryItem | AddInventoryItem
*InventoryApi* | [**addInventoryItemBulk**](docs/Api/InventoryApi.md#addinventoryitembulk) | **POST** /api/Inventory/AddInventoryItemBulk | AddInventoryItemBulk
*InventoryApi* | [**addItemLocations**](docs/Api/InventoryApi.md#additemlocations) | **POST** /api/Inventory/AddItemLocations | AddItemLocations
*InventoryApi* | [**addProductIdentifiers**](docs/Api/InventoryApi.md#addproductidentifiers) | **POST** /api/Inventory/AddProductIdentifiers | AddProductIdentifiers
*InventoryApi* | [**addScrapCategories**](docs/Api/InventoryApi.md#addscrapcategories) | **POST** /api/Inventory/AddScrapCategories | AddScrapCategories
*InventoryApi* | [**addScrapItem**](docs/Api/InventoryApi.md#addscrapitem) | **POST** /api/Inventory/AddScrapItem | AddScrapItem
*InventoryApi* | [**addSupplier**](docs/Api/InventoryApi.md#addsupplier) | **POST** /api/Inventory/AddSupplier | AddSupplier
*InventoryApi* | [**adjustTemplatesInstant**](docs/Api/InventoryApi.md#adjusttemplatesinstant) | **POST** /api/Inventory/AdjustTemplatesInstant | AdjustTemplatesInstant
*InventoryApi* | [**archiveInventoryItems**](docs/Api/InventoryApi.md#archiveinventoryitems) | **POST** /api/Inventory/ArchiveInventoryItems | ArchiveInventoryItems
*InventoryApi* | [**batchGetInventoryItemChannelSKUs**](docs/Api/InventoryApi.md#batchgetinventoryitemchannelskus) | **POST** /api/Inventory/BatchGetInventoryItemChannelSKUs | BatchGetInventoryItemChannelSKUs
*InventoryApi* | [**bulkScrapBatchedItems**](docs/Api/InventoryApi.md#bulkscrapbatcheditems) | **POST** /api/Inventory/BulkScrapBatchedItems | BulkScrapBatchedItems
*InventoryApi* | [**createBatches**](docs/Api/InventoryApi.md#createbatches) | **POST** /api/Inventory/CreateBatches | CreateBatches
*InventoryApi* | [**createCategory**](docs/Api/InventoryApi.md#createcategory) | **POST** /api/Inventory/CreateCategory | CreateCategory
*InventoryApi* | [**createCountries**](docs/Api/InventoryApi.md#createcountries) | **POST** /api/Inventory/CreateCountries | CreateCountries
*InventoryApi* | [**createCountryRegions**](docs/Api/InventoryApi.md#createcountryregions) | **POST** /api/Inventory/CreateCountryRegions | CreateCountryRegions
*InventoryApi* | [**createInventoryItemChannelSKUs**](docs/Api/InventoryApi.md#createinventoryitemchannelskus) | **POST** /api/Inventory/CreateInventoryItemChannelSKUs | CreateInventoryItemChannelSKUs
*InventoryApi* | [**createInventoryItemCompositions**](docs/Api/InventoryApi.md#createinventoryitemcompositions) | **POST** /api/Inventory/CreateInventoryItemCompositions | CreateInventoryItemCompositions
*InventoryApi* | [**createInventoryItemDescriptions**](docs/Api/InventoryApi.md#createinventoryitemdescriptions) | **POST** /api/Inventory/CreateInventoryItemDescriptions | CreateInventoryItemDescriptions
*InventoryApi* | [**createInventoryItemExtendedProperties**](docs/Api/InventoryApi.md#createinventoryitemextendedproperties) | **POST** /api/Inventory/CreateInventoryItemExtendedProperties | CreateInventoryItemExtendedProperties
*InventoryApi* | [**createInventoryItemPrices**](docs/Api/InventoryApi.md#createinventoryitemprices) | **POST** /api/Inventory/CreateInventoryItemPrices | CreateInventoryItemPrices
*InventoryApi* | [**createInventoryItemPricingRules**](docs/Api/InventoryApi.md#createinventoryitempricingrules) | **POST** /api/Inventory/CreateInventoryItemPricingRules | CreateInventoryItemPricingRules
*InventoryApi* | [**createInventoryItemTitles**](docs/Api/InventoryApi.md#createinventoryitemtitles) | **POST** /api/Inventory/CreateInventoryItemTitles | CreateInventoryItemTitles
*InventoryApi* | [**createStockSupplierStat**](docs/Api/InventoryApi.md#createstocksupplierstat) | **POST** /api/Inventory/CreateStockSupplierStat | CreateStockSupplierStat
*InventoryApi* | [**createUserSpecificView**](docs/Api/InventoryApi.md#createuserspecificview) | **POST** /api/Inventory/CreateUserSpecificView | CreateUserSpecificView
*InventoryApi* | [**deleteBatchInventoryInBulk**](docs/Api/InventoryApi.md#deletebatchinventoryinbulk) | **POST** /api/Inventory/DeleteBatchInventoryInBulk | DeleteBatchInventoryInBulk
*InventoryApi* | [**deleteBatchesByStockItemId**](docs/Api/InventoryApi.md#deletebatchesbystockitemid) | **POST** /api/Inventory/DeleteBatchesByStockItemId | DeleteBatchesByStockItemId
*InventoryApi* | [**deleteCategoryById**](docs/Api/InventoryApi.md#deletecategorybyid) | **POST** /api/Inventory/DeleteCategoryById | DeleteCategoryById
*InventoryApi* | [**deleteCountries**](docs/Api/InventoryApi.md#deletecountries) | **POST** /api/Inventory/DeleteCountries | DeleteCountries
*InventoryApi* | [**deleteEbayCompatibilityList**](docs/Api/InventoryApi.md#deleteebaycompatibilitylist) | **POST** /api/Inventory/DeleteEbayCompatibilityList | DeleteEbayCompatibilityList
*InventoryApi* | [**deleteImagesFromInventoryItem**](docs/Api/InventoryApi.md#deleteimagesfrominventoryitem) | **POST** /api/Inventory/DeleteImagesFromInventoryItem | DeleteImagesFromInventoryItem
*InventoryApi* | [**deleteInventoryItemBulk**](docs/Api/InventoryApi.md#deleteinventoryitembulk) | **POST** /api/Inventory/DeleteInventoryItemBulk | DeleteInventoryItemBulk
*InventoryApi* | [**deleteInventoryItemChannelSKUs**](docs/Api/InventoryApi.md#deleteinventoryitemchannelskus) | **POST** /api/Inventory/DeleteInventoryItemChannelSKUs | DeleteInventoryItemChannelSKUs
*InventoryApi* | [**deleteInventoryItemCompositions**](docs/Api/InventoryApi.md#deleteinventoryitemcompositions) | **POST** /api/Inventory/DeleteInventoryItemCompositions | DeleteInventoryItemCompositions
*InventoryApi* | [**deleteInventoryItemDescriptions**](docs/Api/InventoryApi.md#deleteinventoryitemdescriptions) | **POST** /api/Inventory/DeleteInventoryItemDescriptions | DeleteInventoryItemDescriptions
*InventoryApi* | [**deleteInventoryItemExtendedProperties**](docs/Api/InventoryApi.md#deleteinventoryitemextendedproperties) | **POST** /api/Inventory/DeleteInventoryItemExtendedProperties | DeleteInventoryItemExtendedProperties
*InventoryApi* | [**deleteInventoryItemImageBulk**](docs/Api/InventoryApi.md#deleteinventoryitemimagebulk) | **POST** /api/Inventory/DeleteInventoryItemImageBulk | DeleteInventoryItemImageBulk
*InventoryApi* | [**deleteInventoryItemPrices**](docs/Api/InventoryApi.md#deleteinventoryitemprices) | **POST** /api/Inventory/DeleteInventoryItemPrices | DeleteInventoryItemPrices
*InventoryApi* | [**deleteInventoryItemPricingRules**](docs/Api/InventoryApi.md#deleteinventoryitempricingrules) | **POST** /api/Inventory/DeleteInventoryItemPricingRules | DeleteInventoryItemPricingRules
*InventoryApi* | [**deleteInventoryItemTitles**](docs/Api/InventoryApi.md#deleteinventoryitemtitles) | **POST** /api/Inventory/DeleteInventoryItemTitles | DeleteInventoryItemTitles
*InventoryApi* | [**deleteInventoryItems**](docs/Api/InventoryApi.md#deleteinventoryitems) | **POST** /api/Inventory/DeleteInventoryItems | DeleteInventoryItems
*InventoryApi* | [**deleteItemLocations**](docs/Api/InventoryApi.md#deleteitemlocations) | **POST** /api/Inventory/DeleteItemLocations | DeleteItemLocations
*InventoryApi* | [**deleteProductIdentifiers**](docs/Api/InventoryApi.md#deleteproductidentifiers) | **POST** /api/Inventory/DeleteProductIdentifiers | DeleteProductIdentifiers
*InventoryApi* | [**deleteScrapCategories**](docs/Api/InventoryApi.md#deletescrapcategories) | **POST** /api/Inventory/DeleteScrapCategories | DeleteScrapCategories
*InventoryApi* | [**deleteStockSupplierStat**](docs/Api/InventoryApi.md#deletestocksupplierstat) | **POST** /api/Inventory/DeleteStockSupplierStat | DeleteStockSupplierStat
*InventoryApi* | [**deleteSuppliers**](docs/Api/InventoryApi.md#deletesuppliers) | **POST** /api/Inventory/DeleteSuppliers | DeleteSuppliers
*InventoryApi* | [**deleteUserSpecificView**](docs/Api/InventoryApi.md#deleteuserspecificview) | **POST** /api/Inventory/DeleteUserSpecificView | DeleteUserSpecificView
*InventoryApi* | [**duplicateInventoryItem**](docs/Api/InventoryApi.md#duplicateinventoryitem) | **POST** /api/Inventory/DuplicateInventoryItem | DuplicateInventoryItem
*InventoryApi* | [**getAllExtendedPropertyNames**](docs/Api/InventoryApi.md#getallextendedpropertynames) | **GET** /api/Inventory/GetAllExtendedPropertyNames | GetAllExtendedPropertyNames
*InventoryApi* | [**getBatchAudit**](docs/Api/InventoryApi.md#getbatchaudit) | **POST** /api/Inventory/GetBatchAudit | GetBatchAudit
*InventoryApi* | [**getBatchInventoryById**](docs/Api/InventoryApi.md#getbatchinventorybyid) | **POST** /api/Inventory/GetBatchInventoryById | GetBatchInventoryById
*InventoryApi* | [**getBatchesByStockItemId**](docs/Api/InventoryApi.md#getbatchesbystockitemid) | **GET** /api/Inventory/GetBatchesByStockItemId | GetBatchesByStockItemId
*InventoryApi* | [**getCategories**](docs/Api/InventoryApi.md#getcategories) | **GET** /api/Inventory/GetCategories | GetCategories
*InventoryApi* | [**getChannels**](docs/Api/InventoryApi.md#getchannels) | **GET** /api/Inventory/GetChannels | GetChannels
*InventoryApi* | [**getChannelsBySource**](docs/Api/InventoryApi.md#getchannelsbysource) | **GET** /api/Inventory/GetChannelsBySource | GetChannelsBySource
*InventoryApi* | [**getCountries**](docs/Api/InventoryApi.md#getcountries) | **GET** /api/Inventory/GetCountries | GetCountries
*InventoryApi* | [**getCountryCodes**](docs/Api/InventoryApi.md#getcountrycodes) | **GET** /api/Inventory/GetCountryCodes | GetCountryCodes
*InventoryApi* | [**getEbayCompatibilityList**](docs/Api/InventoryApi.md#getebaycompatibilitylist) | **GET** /api/Inventory/GetEbayCompatibilityList | GetEbayCompatibilityList
*InventoryApi* | [**getExtendedPropertyNames**](docs/Api/InventoryApi.md#getextendedpropertynames) | **GET** /api/Inventory/GetExtendedPropertyNames | GetExtendedPropertyNames
*InventoryApi* | [**getExtendedPropertyTypes**](docs/Api/InventoryApi.md#getextendedpropertytypes) | **GET** /api/Inventory/GetExtendedPropertyTypes | GetExtendedPropertyTypes
*InventoryApi* | [**getImagesInBulk**](docs/Api/InventoryApi.md#getimagesinbulk) | **POST** /api/Inventory/GetImagesInBulk | GetImagesInBulk
*InventoryApi* | [**getInventoryBatchTypes**](docs/Api/InventoryApi.md#getinventorybatchtypes) | **GET** /api/Inventory/GetInventoryBatchTypes | GetInventoryBatchTypes
*InventoryApi* | [**getInventoryItem**](docs/Api/InventoryApi.md#getinventoryitem) | **GET** /api/Inventory/GetInventoryItem | GetInventoryItem
*InventoryApi* | [**getInventoryItemAuditTrail**](docs/Api/InventoryApi.md#getinventoryitemaudittrail) | **GET** /api/Inventory/GetInventoryItemAuditTrail | GetInventoryItemAuditTrail
*InventoryApi* | [**getInventoryItemAuditTrailPaged**](docs/Api/InventoryApi.md#getinventoryitemaudittrailpaged) | **POST** /api/Inventory/GetInventoryItemAuditTrailPaged | GetInventoryItemAuditTrailPaged
*InventoryApi* | [**getInventoryItemBatchInformation**](docs/Api/InventoryApi.md#getinventoryitembatchinformation) | **POST** /api/Inventory/GetInventoryItemBatchInformation | GetInventoryItemBatchInformation
*InventoryApi* | [**getInventoryItemBatchInformationByIds**](docs/Api/InventoryApi.md#getinventoryitembatchinformationbyids) | **POST** /api/Inventory/GetInventoryItemBatchInformationByIds | GetInventoryItemBatchInformationByIds
*InventoryApi* | [**getInventoryItemById**](docs/Api/InventoryApi.md#getinventoryitembyid) | **GET** /api/Inventory/GetInventoryItemById | GetInventoryItemById
*InventoryApi* | [**getInventoryItemChannelSKUs**](docs/Api/InventoryApi.md#getinventoryitemchannelskus) | **GET** /api/Inventory/GetInventoryItemChannelSKUs | GetInventoryItemChannelSKUs
*InventoryApi* | [**getInventoryItemChannelSKUsWithLocation**](docs/Api/InventoryApi.md#getinventoryitemchannelskuswithlocation) | **GET** /api/Inventory/GetInventoryItemChannelSKUsWithLocation | GetInventoryItemChannelSKUsWithLocation
*InventoryApi* | [**getInventoryItemCompositions**](docs/Api/InventoryApi.md#getinventoryitemcompositions) | **GET** /api/Inventory/GetInventoryItemCompositions | GetInventoryItemCompositions
*InventoryApi* | [**getInventoryItemDescriptions**](docs/Api/InventoryApi.md#getinventoryitemdescriptions) | **GET** /api/Inventory/GetInventoryItemDescriptions | GetInventoryItemDescriptions
*InventoryApi* | [**getInventoryItemExtendedProperties**](docs/Api/InventoryApi.md#getinventoryitemextendedproperties) | **POST** /api/Inventory/GetInventoryItemExtendedProperties | GetInventoryItemExtendedProperties
*InventoryApi* | [**getInventoryItemImages**](docs/Api/InventoryApi.md#getinventoryitemimages) | **GET** /api/Inventory/GetInventoryItemImages | GetInventoryItemImages
*InventoryApi* | [**getInventoryItemLocations**](docs/Api/InventoryApi.md#getinventoryitemlocations) | **GET** /api/Inventory/GetInventoryItemLocations | GetInventoryItemLocations
*InventoryApi* | [**getInventoryItemPriceChannelSuffixes**](docs/Api/InventoryApi.md#getinventoryitempricechannelsuffixes) | **GET** /api/Inventory/GetInventoryItemPriceChannelSuffixes | GetInventoryItemPriceChannelSuffixes
*InventoryApi* | [**getInventoryItemPriceRulesById**](docs/Api/InventoryApi.md#getinventoryitempricerulesbyid) | **GET** /api/Inventory/GetInventoryItemPriceRulesById | GetInventoryItemPriceRulesById
*InventoryApi* | [**getInventoryItemPriceRulesBySource**](docs/Api/InventoryApi.md#getinventoryitempricerulesbysource) | **GET** /api/Inventory/GetInventoryItemPriceRulesBySource | GetInventoryItemPriceRulesBySource
*InventoryApi* | [**getInventoryItemPriceTags**](docs/Api/InventoryApi.md#getinventoryitempricetags) | **GET** /api/Inventory/GetInventoryItemPriceTags | GetInventoryItemPriceTags
*InventoryApi* | [**getInventoryItemPrices**](docs/Api/InventoryApi.md#getinventoryitemprices) | **GET** /api/Inventory/GetInventoryItemPrices | GetInventoryItemPrices
*InventoryApi* | [**getInventoryItemTitles**](docs/Api/InventoryApi.md#getinventoryitemtitles) | **GET** /api/Inventory/GetInventoryItemTitles | GetInventoryItemTitles
*InventoryApi* | [**getInventoryItemsCompositionByIds**](docs/Api/InventoryApi.md#getinventoryitemscompositionbyids) | **POST** /api/Inventory/GetInventoryItemsCompositionByIds | GetInventoryItemsCompositionByIds
*InventoryApi* | [**getInventoryItemsCount**](docs/Api/InventoryApi.md#getinventoryitemscount) | **GET** /api/Inventory/GetInventoryItemsCount | GetInventoryItemsCount
*InventoryApi* | [**getNewItemNumber**](docs/Api/InventoryApi.md#getnewitemnumber) | **GET** /api/Inventory/GetNewItemNumber | GetNewItemNumber
*InventoryApi* | [**getPackageGroups**](docs/Api/InventoryApi.md#getpackagegroups) | **GET** /api/Inventory/GetPackageGroups | GetPackageGroups
*InventoryApi* | [**getPostalServices**](docs/Api/InventoryApi.md#getpostalservices) | **GET** /api/Inventory/GetPostalServices | GetPostalServices
*InventoryApi* | [**getPreDefinedViews**](docs/Api/InventoryApi.md#getpredefinedviews) | **GET** /api/Inventory/GetPreDefinedViews | GetPreDefinedViews
*InventoryApi* | [**getProductIdentifierExtendedTypes**](docs/Api/InventoryApi.md#getproductidentifierextendedtypes) | **GET** /api/Inventory/GetProductIdentifierExtendedTypes | GetProductIdentifierExtendedTypes
*InventoryApi* | [**getProductIdentifierTypes**](docs/Api/InventoryApi.md#getproductidentifiertypes) | **GET** /api/Inventory/GetProductIdentifierTypes | GetProductIdentifierTypes
*InventoryApi* | [**getProductIdentifiersBulkByStockItemId**](docs/Api/InventoryApi.md#getproductidentifiersbulkbystockitemid) | **POST** /api/Inventory/GetProductIdentifiersBulkByStockItemId | GetProductIdentifiersBulkByStockItemId
*InventoryApi* | [**getProductIdentifiersByStockItemId**](docs/Api/InventoryApi.md#getproductidentifiersbystockitemid) | **POST** /api/Inventory/GetProductIdentifiersByStockItemId | GetProductIdentifiersByStockItemId
*InventoryApi* | [**getScannableProductIdentifiersByOrderIds**](docs/Api/InventoryApi.md#getscannableproductidentifiersbyorderids) | **POST** /api/Inventory/GetScannableProductIdentifiersByOrderIds | GetScannableProductIdentifiersByOrderIds
*InventoryApi* | [**getScrapCategories**](docs/Api/InventoryApi.md#getscrapcategories) | **GET** /api/Inventory/GetScrapCategories | GetScrapCategories
*InventoryApi* | [**getScrapHistory**](docs/Api/InventoryApi.md#getscraphistory) | **POST** /api/Inventory/GetScrapHistory | GetScrapHistory
*InventoryApi* | [**getStockItemBatchesByLocation**](docs/Api/InventoryApi.md#getstockitembatchesbylocation) | **POST** /api/Inventory/GetStockItemBatchesByLocation | GetStockItemBatchesByLocation
*InventoryApi* | [**getStockItemIdsBySKU**](docs/Api/InventoryApi.md#getstockitemidsbysku) | **POST** /api/Inventory/GetStockItemIdsBySKU | GetStockItemIdsBySKU
*InventoryApi* | [**getStockItemLabels**](docs/Api/InventoryApi.md#getstockitemlabels) | **POST** /api/Inventory/GetStockItemLabels | GetStockItemLabels
*InventoryApi* | [**getStockLocations**](docs/Api/InventoryApi.md#getstocklocations) | **GET** /api/Inventory/GetStockLocations | GetStockLocations
*InventoryApi* | [**getStockSupplierStat**](docs/Api/InventoryApi.md#getstocksupplierstat) | **GET** /api/Inventory/GetStockSupplierStat | GetStockSupplierStat
*InventoryApi* | [**getStockSupplierStatsBulk**](docs/Api/InventoryApi.md#getstocksupplierstatsbulk) | **GET** /api/Inventory/GetStockSupplierStatsBulk | GetStockSupplierStatsBulk
*InventoryApi* | [**getSupplierDetails**](docs/Api/InventoryApi.md#getsupplierdetails) | **GET** /api/Inventory/GetSupplierDetails | GetSupplierDetails
*InventoryApi* | [**getSuppliers**](docs/Api/InventoryApi.md#getsuppliers) | **GET** /api/Inventory/GetSuppliers | GetSuppliers
*InventoryApi* | [**getUserSpecificViews**](docs/Api/InventoryApi.md#getuserspecificviews) | **GET** /api/Inventory/GetUserSpecificViews | GetUserSpecificViews
*InventoryApi* | [**hasStockItemBatches**](docs/Api/InventoryApi.md#hasstockitembatches) | **GET** /api/Inventory/HasStockItemBatches | HasStockItemBatches
*InventoryApi* | [**hasStockItemStockLevel**](docs/Api/InventoryApi.md#hasstockitemstocklevel) | **POST** /api/Inventory/HasStockItemStockLevel | HasStockItemStockLevel
*InventoryApi* | [**insertUpdateEbayCompatibilityList**](docs/Api/InventoryApi.md#insertupdateebaycompatibilitylist) | **POST** /api/Inventory/InsertUpdateEbayCompatibilityList | InsertUpdateEbayCompatibilityList
*InventoryApi* | [**isInventoryItemChannelSKULinked**](docs/Api/InventoryApi.md#isinventoryitemchannelskulinked) | **GET** /api/Inventory/IsInventoryItemChannelSKULinked | IsInventoryItemChannelSKULinked
*InventoryApi* | [**isOwnedStockLocation**](docs/Api/InventoryApi.md#isownedstocklocation) | **GET** /api/Inventory/IsOwnedStockLocation | IsOwnedStockLocation
*InventoryApi* | [**itemsHaveScannableIdentifiers**](docs/Api/InventoryApi.md#itemshavescannableidentifiers) | **POST** /api/Inventory/ItemsHaveScannableIdentifiers | ItemsHaveScannableIdentifiers
*InventoryApi* | [**scrapBatchedItem**](docs/Api/InventoryApi.md#scrapbatcheditem) | **POST** /api/Inventory/ScrapBatchedItem | ScrapBatchedItem
*InventoryApi* | [**setInventoryItemImageAsMain**](docs/Api/InventoryApi.md#setinventoryitemimageasmain) | **POST** /api/Inventory/SetInventoryItemImageAsMain | SetInventoryItemImageAsMain
*InventoryApi* | [**unarchiveInventoryItems**](docs/Api/InventoryApi.md#unarchiveinventoryitems) | **POST** /api/Inventory/UnarchiveInventoryItems | UnarchiveInventoryItems
*InventoryApi* | [**unlinkChannelListing**](docs/Api/InventoryApi.md#unlinkchannellisting) | **POST** /api/Inventory/UnlinkChannelListing | UnlinkChannelListing
*InventoryApi* | [**updateBatchDates**](docs/Api/InventoryApi.md#updatebatchdates) | **POST** /api/Inventory/UpdateBatchDates | UpdateBatchDates
*InventoryApi* | [**updateBatchDetails**](docs/Api/InventoryApi.md#updatebatchdetails) | **POST** /api/Inventory/UpdateBatchDetails | UpdateBatchDetails
*InventoryApi* | [**updateBatchesWithInventory**](docs/Api/InventoryApi.md#updatebatcheswithinventory) | **POST** /api/Inventory/UpdateBatchesWithInventory | UpdateBatchesWithInventory
*InventoryApi* | [**updateCategory**](docs/Api/InventoryApi.md#updatecategory) | **POST** /api/Inventory/UpdateCategory | UpdateCategory
*InventoryApi* | [**updateCompositeParentStockLevel**](docs/Api/InventoryApi.md#updatecompositeparentstocklevel) | **POST** /api/Inventory/UpdateCompositeParentStockLevel | UpdateCompositeParentStockLevel
*InventoryApi* | [**updateCountries**](docs/Api/InventoryApi.md#updatecountries) | **POST** /api/Inventory/UpdateCountries | UpdateCountries
*InventoryApi* | [**updateCountryRegions**](docs/Api/InventoryApi.md#updatecountryregions) | **POST** /api/Inventory/UpdateCountryRegions | UpdateCountryRegions
*InventoryApi* | [**updateImages**](docs/Api/InventoryApi.md#updateimages) | **POST** /api/Inventory/UpdateImages | UpdateImages
*InventoryApi* | [**updateInventoryItem**](docs/Api/InventoryApi.md#updateinventoryitem) | **POST** /api/Inventory/UpdateInventoryItem | UpdateInventoryItem
*InventoryApi* | [**updateInventoryItemChannelSKUs**](docs/Api/InventoryApi.md#updateinventoryitemchannelskus) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUs | UpdateInventoryItemChannelSKUs
*InventoryApi* | [**updateInventoryItemChannelSKUsWithLocation**](docs/Api/InventoryApi.md#updateinventoryitemchannelskuswithlocation) | **POST** /api/Inventory/UpdateInventoryItemChannelSKUsWithLocation | UpdateInventoryItemChannelSKUsWithLocation
*InventoryApi* | [**updateInventoryItemCompositions**](docs/Api/InventoryApi.md#updateinventoryitemcompositions) | **POST** /api/Inventory/UpdateInventoryItemCompositions | UpdateInventoryItemCompositions
*InventoryApi* | [**updateInventoryItemDescriptions**](docs/Api/InventoryApi.md#updateinventoryitemdescriptions) | **POST** /api/Inventory/UpdateInventoryItemDescriptions | UpdateInventoryItemDescriptions
*InventoryApi* | [**updateInventoryItemExtendedProperties**](docs/Api/InventoryApi.md#updateinventoryitemextendedproperties) | **POST** /api/Inventory/UpdateInventoryItemExtendedProperties | UpdateInventoryItemExtendedProperties
*InventoryApi* | [**updateInventoryItemField**](docs/Api/InventoryApi.md#updateinventoryitemfield) | **POST** /api/Inventory/UpdateInventoryItemField | UpdateInventoryItemField
*InventoryApi* | [**updateInventoryItemLevels**](docs/Api/InventoryApi.md#updateinventoryitemlevels) | **POST** /api/Inventory/UpdateInventoryItemLevels | UpdateInventoryItemLevels
*InventoryApi* | [**updateInventoryItemLocationField**](docs/Api/InventoryApi.md#updateinventoryitemlocationfield) | **POST** /api/Inventory/UpdateInventoryItemLocationField | UpdateInventoryItemLocationField
*InventoryApi* | [**updateInventoryItemPrices**](docs/Api/InventoryApi.md#updateinventoryitemprices) | **POST** /api/Inventory/UpdateInventoryItemPrices | UpdateInventoryItemPrices
*InventoryApi* | [**updateInventoryItemPricingRules**](docs/Api/InventoryApi.md#updateinventoryitempricingrules) | **POST** /api/Inventory/UpdateInventoryItemPricingRules | UpdateInventoryItemPricingRules
*InventoryApi* | [**updateInventoryItemStockField**](docs/Api/InventoryApi.md#updateinventoryitemstockfield) | **POST** /api/Inventory/UpdateInventoryItemStockField | UpdateInventoryItemStockField
*InventoryApi* | [**updateInventoryItemTitles**](docs/Api/InventoryApi.md#updateinventoryitemtitles) | **POST** /api/Inventory/UpdateInventoryItemTitles | UpdateInventoryItemTitles
*InventoryApi* | [**updateItemLocations**](docs/Api/InventoryApi.md#updateitemlocations) | **POST** /api/Inventory/UpdateItemLocations | UpdateItemLocations
*InventoryApi* | [**updateProductIdentifiers**](docs/Api/InventoryApi.md#updateproductidentifiers) | **POST** /api/Inventory/UpdateProductIdentifiers | UpdateProductIdentifiers
*InventoryApi* | [**updateScrapCategories**](docs/Api/InventoryApi.md#updatescrapcategories) | **POST** /api/Inventory/UpdateScrapCategories | UpdateScrapCategories
*InventoryApi* | [**updateStockSupplierStat**](docs/Api/InventoryApi.md#updatestocksupplierstat) | **POST** /api/Inventory/UpdateStockSupplierStat | UpdateStockSupplierStat
*InventoryApi* | [**updateSupplier**](docs/Api/InventoryApi.md#updatesupplier) | **POST** /api/Inventory/UpdateSupplier | UpdateSupplier
*InventoryApi* | [**updateUserSpecificView**](docs/Api/InventoryApi.md#updateuserspecificview) | **POST** /api/Inventory/UpdateUserSpecificView | UpdateUserSpecificView
*InventoryApi* | [**uploadImagesToInventoryItem**](docs/Api/InventoryApi.md#uploadimagestoinventoryitem) | **POST** /api/Inventory/UploadImagesToInventoryItem | UploadImagesToInventoryItem

## Models

- [APIResultResponseDeleteInventoryItemBulkResponse](docs/Model/APIResultResponseDeleteInventoryItemBulkResponse.md)
- [APIResultResponseDeleteInventoryItemImagesResponse](docs/Model/APIResultResponseDeleteInventoryItemImagesResponse.md)
- [APIResultResponseGuid](docs/Model/APIResultResponseGuid.md)
- [APIResultResponseStockItemProductIdentifier](docs/Model/APIResultResponseStockItemProductIdentifier.md)
- [AddImageToInventoryItemRequest](docs/Model/AddImageToInventoryItemRequest.md)
- [AddImageToInventoryItemResponse](docs/Model/AddImageToInventoryItemResponse.md)
- [AddInventoryItemRequest](docs/Model/AddInventoryItemRequest.md)
- [AddProductIdentifiersRequest](docs/Model/AddProductIdentifiersRequest.md)
- [AddScrapCategoriesRequest](docs/Model/AddScrapCategoriesRequest.md)
- [AddScrapCategoriesResponse](docs/Model/AddScrapCategoriesResponse.md)
- [AddScrapItemRequest](docs/Model/AddScrapItemRequest.md)
- [AddScrapItemResponse](docs/Model/AddScrapItemResponse.md)
- [AdjustmentOptions](docs/Model/AdjustmentOptions.md)
- [AnyConfig](docs/Model/AnyConfig.md)
- [BatchDatesUpdateItem](docs/Model/BatchDatesUpdateItem.md)
- [BatchDatesUpdateItemResult](docs/Model/BatchDatesUpdateItemResult.md)
- [BatchInformation](docs/Model/BatchInformation.md)
- [BatchedAPIResponseDeleteInventoryItemBulkResponse](docs/Model/BatchedAPIResponseDeleteInventoryItemBulkResponse.md)
- [BatchedAPIResponseDeleteInventoryItemImagesResponse](docs/Model/BatchedAPIResponseDeleteInventoryItemImagesResponse.md)
- [BatchedAPIResponseGuid](docs/Model/BatchedAPIResponseGuid.md)
- [BatchedAPIResponseStockItemProductIdentifier](docs/Model/BatchedAPIResponseStockItemProductIdentifier.md)
- [BulkScrapBatchedItemsRequest](docs/Model/BulkScrapBatchedItemsRequest.md)
- [ChannelPaymentMethod](docs/Model/ChannelPaymentMethod.md)
- [ChannelPostalService](docs/Model/ChannelPostalService.md)
- [ChannelSettingAudit](docs/Model/ChannelSettingAudit.md)
- [Column](docs/Model/Column.md)
- [ConfigButton](docs/Model/ConfigButton.md)
- [ConfigChannelLocation](docs/Model/ConfigChannelLocation.md)
- [ConfigChannelLocationBinding](docs/Model/ConfigChannelLocationBinding.md)
- [ConfigItemBoolean](docs/Model/ConfigItemBoolean.md)
- [ConfigItemDateTime](docs/Model/ConfigItemDateTime.md)
- [ConfigItemDouble](docs/Model/ConfigItemDouble.md)
- [ConfigItemExternal](docs/Model/ConfigItemExternal.md)
- [ConfigItemInt32](docs/Model/ConfigItemInt32.md)
- [ConfigItemListItem](docs/Model/ConfigItemListItem.md)
- [ConfigItemString](docs/Model/ConfigItemString.md)
- [ConfigPaymentMethodMapping](docs/Model/ConfigPaymentMethodMapping.md)
- [ConfigPaymentMethodMappingItem](docs/Model/ConfigPaymentMethodMappingItem.md)
- [ConfigPostalServiceMapping](docs/Model/ConfigPostalServiceMapping.md)
- [ConfigPostalServiceMappingItem](docs/Model/ConfigPostalServiceMappingItem.md)
- [ConfigPropertyBoolean](docs/Model/ConfigPropertyBoolean.md)
- [ConfigPropertySelectionListSelectStringValueOptionGuid](docs/Model/ConfigPropertySelectionListSelectStringValueOptionGuid.md)
- [ConfigPropertySelectionListSelectStringValueOptionString](docs/Model/ConfigPropertySelectionListSelectStringValueOptionString.md)
- [ConfigPropertyString](docs/Model/ConfigPropertyString.md)
- [ConfigRule](docs/Model/ConfigRule.md)
- [ConfigStockLocation](docs/Model/ConfigStockLocation.md)
- [ConfigStockLocationBinding](docs/Model/ConfigStockLocationBinding.md)
- [ConstructorInfo](docs/Model/ConstructorInfo.md)
- [Country](docs/Model/Country.md)
- [CountryRegion](docs/Model/CountryRegion.md)
- [CreateCountryRegionsRequest](docs/Model/CreateCountryRegionsRequest.md)
- [CreateCountryRegionsResponse](docs/Model/CreateCountryRegionsResponse.md)
- [CustomAttributeData](docs/Model/CustomAttributeData.md)
- [CustomAttributeNamedArgument](docs/Model/CustomAttributeNamedArgument.md)
- [CustomAttributeTypedArgument](docs/Model/CustomAttributeTypedArgument.md)
- [DeleteEbayCompatibilityListRequest](docs/Model/DeleteEbayCompatibilityListRequest.md)
- [DeleteEbayCompatibilityListResponse](docs/Model/DeleteEbayCompatibilityListResponse.md)
- [DeleteInventoryItemBulkRequest](docs/Model/DeleteInventoryItemBulkRequest.md)
- [DeleteInventoryItemBulkResponse](docs/Model/DeleteInventoryItemBulkResponse.md)
- [DeleteInventoryItemImagesRequest](docs/Model/DeleteInventoryItemImagesRequest.md)
- [DeleteInventoryItemImagesResponse](docs/Model/DeleteInventoryItemImagesResponse.md)
- [DeleteInventoryItemsRequest](docs/Model/DeleteInventoryItemsRequest.md)
- [DeleteProductIdentifiersRequest](docs/Model/DeleteProductIdentifiersRequest.md)
- [DeleteScrapCategoriesRequest](docs/Model/DeleteScrapCategoriesRequest.md)
- [Filter](docs/Model/Filter.md)
- [GenericPagedResultScrapItem](docs/Model/GenericPagedResultScrapItem.md)
- [GetBatchAuditRequest](docs/Model/GetBatchAuditRequest.md)
- [GetBatchAuditResponse](docs/Model/GetBatchAuditResponse.md)
- [GetBatchInventoryByIdRequest](docs/Model/GetBatchInventoryByIdRequest.md)
- [GetBatchInventoryByIdResponse](docs/Model/GetBatchInventoryByIdResponse.md)
- [GetExtendedPropertyFilter](docs/Model/GetExtendedPropertyFilter.md)
- [GetImagesInBulkRequest](docs/Model/GetImagesInBulkRequest.md)
- [GetImagesInBulkResponse](docs/Model/GetImagesInBulkResponse.md)
- [GetImagesInBulkResponseImage](docs/Model/GetImagesInBulkResponseImage.md)
- [GetInventoryItemAuditTrailPagedRequest](docs/Model/GetInventoryItemAuditTrailPagedRequest.md)
- [GetInventoryItemBatchInformationByIdsRequest](docs/Model/GetInventoryItemBatchInformationByIdsRequest.md)
- [GetInventoryItemBatchInformationByIdsResponse](docs/Model/GetInventoryItemBatchInformationByIdsResponse.md)
- [GetInventoryItemBatchInformationRequest](docs/Model/GetInventoryItemBatchInformationRequest.md)
- [GetInventoryItemImagesRequest](docs/Model/GetInventoryItemImagesRequest.md)
- [GetInventoryItemRequest](docs/Model/GetInventoryItemRequest.md)
- [GetInventoryItemsCompositionByIdsRequest](docs/Model/GetInventoryItemsCompositionByIdsRequest.md)
- [GetInventoryItemsCompositionByIdsResponse](docs/Model/GetInventoryItemsCompositionByIdsResponse.md)
- [GetProductIdentifierExtendedResponse](docs/Model/GetProductIdentifierExtendedResponse.md)
- [GetProductIdentifierTypesRequest](docs/Model/GetProductIdentifierTypesRequest.md)
- [GetProductIdentifiersBulkByStockItemIdRequest](docs/Model/GetProductIdentifiersBulkByStockItemIdRequest.md)
- [GetProductIdentifiersByStockItemIdRequest](docs/Model/GetProductIdentifiersByStockItemIdRequest.md)
- [GetProductIdentifiersByStockItemIdResponse](docs/Model/GetProductIdentifiersByStockItemIdResponse.md)
- [GetScannableProductIdentifiersByOrderIdsRequest](docs/Model/GetScannableProductIdentifiersByOrderIdsRequest.md)
- [GetScannableProductIdentifiersByOrderIdsResponse](docs/Model/GetScannableProductIdentifiersByOrderIdsResponse.md)
- [GetScrapCategoriesResponse](docs/Model/GetScrapCategoriesResponse.md)
- [GetScrapHistoryRequest](docs/Model/GetScrapHistoryRequest.md)
- [GetScrapHistoryResponse](docs/Model/GetScrapHistoryResponse.md)
- [GetSelectionListSelectStringValueOption](docs/Model/GetSelectionListSelectStringValueOption.md)
- [GetStockItemBatchesByLocationRequest](docs/Model/GetStockItemBatchesByLocationRequest.md)
- [GetStockItemBatchesByLocationResponse](docs/Model/GetStockItemBatchesByLocationResponse.md)
- [GetStockItemIdsBySKU](docs/Model/GetStockItemIdsBySKU.md)
- [GetStockItemIdsBySKUItem](docs/Model/GetStockItemIdsBySKUItem.md)
- [GetStockItemIdsBySKURequest](docs/Model/GetStockItemIdsBySKURequest.md)
- [HasStockItemStockLevelRequest](docs/Model/HasStockItemStockLevelRequest.md)
- [HasStockItemStockLevelResponse](docs/Model/HasStockItemStockLevelResponse.md)
- [HeaderConfig](docs/Model/HeaderConfig.md)
- [InsertUpdateEbayCompatibilityListRequest](docs/Model/InsertUpdateEbayCompatibilityListRequest.md)
- [InsertUpdateEbayCompatibilityListResponse](docs/Model/InsertUpdateEbayCompatibilityListResponse.md)
- [InventoryAddImageToInventoryItemRequest](docs/Model/InventoryAddImageToInventoryItemRequest.md)
- [InventoryAddInventoryItemBulkRequest](docs/Model/InventoryAddInventoryItemBulkRequest.md)
- [InventoryAddInventoryItemRequest](docs/Model/InventoryAddInventoryItemRequest.md)
- [InventoryAddItemLocationsRequest](docs/Model/InventoryAddItemLocationsRequest.md)
- [InventoryAddProductIdentifiersRequest](docs/Model/InventoryAddProductIdentifiersRequest.md)
- [InventoryAddScrapCategoriesRequest](docs/Model/InventoryAddScrapCategoriesRequest.md)
- [InventoryAddScrapItemRequest](docs/Model/InventoryAddScrapItemRequest.md)
- [InventoryAddSupplierRequest](docs/Model/InventoryAddSupplierRequest.md)
- [InventoryAdjustTemplatesInstantRequest](docs/Model/InventoryAdjustTemplatesInstantRequest.md)
- [InventoryArchiveInventoryItemsRequest](docs/Model/InventoryArchiveInventoryItemsRequest.md)
- [InventoryBatchGetInventoryItemChannelSKUsRequest](docs/Model/InventoryBatchGetInventoryItemChannelSKUsRequest.md)
- [InventoryChannel](docs/Model/InventoryChannel.md)
- [InventoryCreateBatchesRequest](docs/Model/InventoryCreateBatchesRequest.md)
- [InventoryCreateCategoryRequest](docs/Model/InventoryCreateCategoryRequest.md)
- [InventoryCreateCountriesRequest](docs/Model/InventoryCreateCountriesRequest.md)
- [InventoryCreateCountryRegionsRequest](docs/Model/InventoryCreateCountryRegionsRequest.md)
- [InventoryCreateInventoryItemChannelSKUsRequest](docs/Model/InventoryCreateInventoryItemChannelSKUsRequest.md)
- [InventoryCreateInventoryItemCompositionsRequest](docs/Model/InventoryCreateInventoryItemCompositionsRequest.md)
- [InventoryCreateInventoryItemDescriptionsRequest](docs/Model/InventoryCreateInventoryItemDescriptionsRequest.md)
- [InventoryCreateInventoryItemExtendedPropertiesRequest](docs/Model/InventoryCreateInventoryItemExtendedPropertiesRequest.md)
- [InventoryCreateInventoryItemPricesRequest](docs/Model/InventoryCreateInventoryItemPricesRequest.md)
- [InventoryCreateInventoryItemPricingRulesRequest](docs/Model/InventoryCreateInventoryItemPricingRulesRequest.md)
- [InventoryCreateInventoryItemTitlesRequest](docs/Model/InventoryCreateInventoryItemTitlesRequest.md)
- [InventoryCreateStockSupplierStatRequest](docs/Model/InventoryCreateStockSupplierStatRequest.md)
- [InventoryCreateUserSpecificViewRequest](docs/Model/InventoryCreateUserSpecificViewRequest.md)
- [InventoryDeleteBatchInventoryInBulkRequest](docs/Model/InventoryDeleteBatchInventoryInBulkRequest.md)
- [InventoryDeleteBatchesByStockItemIdRequest](docs/Model/InventoryDeleteBatchesByStockItemIdRequest.md)
- [InventoryDeleteCategoryByIdRequest](docs/Model/InventoryDeleteCategoryByIdRequest.md)
- [InventoryDeleteCountriesRequest](docs/Model/InventoryDeleteCountriesRequest.md)
- [InventoryDeleteEbayCompatibilityListRequest](docs/Model/InventoryDeleteEbayCompatibilityListRequest.md)
- [InventoryDeleteImagesFromInventoryItemRequest](docs/Model/InventoryDeleteImagesFromInventoryItemRequest.md)
- [InventoryDeleteInventoryItemChannelSKUsRequest](docs/Model/InventoryDeleteInventoryItemChannelSKUsRequest.md)
- [InventoryDeleteInventoryItemCompositionsRequest](docs/Model/InventoryDeleteInventoryItemCompositionsRequest.md)
- [InventoryDeleteInventoryItemDescriptionsRequest](docs/Model/InventoryDeleteInventoryItemDescriptionsRequest.md)
- [InventoryDeleteInventoryItemExtendedPropertiesRequest](docs/Model/InventoryDeleteInventoryItemExtendedPropertiesRequest.md)
- [InventoryDeleteInventoryItemImageBulkRequest](docs/Model/InventoryDeleteInventoryItemImageBulkRequest.md)
- [InventoryDeleteInventoryItemPricesRequest](docs/Model/InventoryDeleteInventoryItemPricesRequest.md)
- [InventoryDeleteInventoryItemPricingRulesRequest](docs/Model/InventoryDeleteInventoryItemPricingRulesRequest.md)
- [InventoryDeleteInventoryItemTitlesRequest](docs/Model/InventoryDeleteInventoryItemTitlesRequest.md)
- [InventoryDeleteInventoryItemsRequest](docs/Model/InventoryDeleteInventoryItemsRequest.md)
- [InventoryDeleteItemLocationsRequest](docs/Model/InventoryDeleteItemLocationsRequest.md)
- [InventoryDeleteProductIdentifiersRequest](docs/Model/InventoryDeleteProductIdentifiersRequest.md)
- [InventoryDeleteScrapCategoriesRequest](docs/Model/InventoryDeleteScrapCategoriesRequest.md)
- [InventoryDeleteStockSupplierStatRequest](docs/Model/InventoryDeleteStockSupplierStatRequest.md)
- [InventoryDeleteSuppliersRequest](docs/Model/InventoryDeleteSuppliersRequest.md)
- [InventoryDeleteUserSpecificViewRequest](docs/Model/InventoryDeleteUserSpecificViewRequest.md)
- [InventoryDuplicateInventoryItemRequest](docs/Model/InventoryDuplicateInventoryItemRequest.md)
- [InventoryGetBatchAuditRequest](docs/Model/InventoryGetBatchAuditRequest.md)
- [InventoryGetImagesInBulkRequest](docs/Model/InventoryGetImagesInBulkRequest.md)
- [InventoryGetInventoryItemAuditTrailPagedRequest](docs/Model/InventoryGetInventoryItemAuditTrailPagedRequest.md)
- [InventoryGetInventoryItemBatchInformationByIdsRequest](docs/Model/InventoryGetInventoryItemBatchInformationByIdsRequest.md)
- [InventoryGetInventoryItemBatchInformationRequest](docs/Model/InventoryGetInventoryItemBatchInformationRequest.md)
- [InventoryGetInventoryItemExtendedPropertiesRequest](docs/Model/InventoryGetInventoryItemExtendedPropertiesRequest.md)
- [InventoryGetInventoryItemsCompositionByIdsRequest](docs/Model/InventoryGetInventoryItemsCompositionByIdsRequest.md)
- [InventoryGetProductIdentifiersByStockItemIdRequest](docs/Model/InventoryGetProductIdentifiersByStockItemIdRequest.md)
- [InventoryGetScrapHistoryRequest](docs/Model/InventoryGetScrapHistoryRequest.md)
- [InventoryGetStockItemBatchesByLocationRequest](docs/Model/InventoryGetStockItemBatchesByLocationRequest.md)
- [InventoryGetStockItemIdsBySKURequest](docs/Model/InventoryGetStockItemIdsBySKURequest.md)
- [InventoryGetStockItemLabelsRequest](docs/Model/InventoryGetStockItemLabelsRequest.md)
- [InventoryHasStockItemStockLevelRequest](docs/Model/InventoryHasStockItemStockLevelRequest.md)
- [InventoryInsertUpdateEbayCompatibilityListRequest](docs/Model/InventoryInsertUpdateEbayCompatibilityListRequest.md)
- [InventoryParametersRequest](docs/Model/InventoryParametersRequest.md)
- [InventoryScrapBatchedItemRequest](docs/Model/InventoryScrapBatchedItemRequest.md)
- [InventorySetInventoryItemImageAsMainRequest](docs/Model/InventorySetInventoryItemImageAsMainRequest.md)
- [InventoryUnarchiveInventoryItemsRequest](docs/Model/InventoryUnarchiveInventoryItemsRequest.md)
- [InventoryUnlinkChannelListingRequest](docs/Model/InventoryUnlinkChannelListingRequest.md)
- [InventoryUpdateBatchDetailsRequest](docs/Model/InventoryUpdateBatchDetailsRequest.md)
- [InventoryUpdateBatchesWithInventoryRequest](docs/Model/InventoryUpdateBatchesWithInventoryRequest.md)
- [InventoryUpdateCategoryRequest](docs/Model/InventoryUpdateCategoryRequest.md)
- [InventoryUpdateCompositeParentStockLevelRequest](docs/Model/InventoryUpdateCompositeParentStockLevelRequest.md)
- [InventoryUpdateCountriesRequest](docs/Model/InventoryUpdateCountriesRequest.md)
- [InventoryUpdateCountryRegionsRequest](docs/Model/InventoryUpdateCountryRegionsRequest.md)
- [InventoryUpdateImagesRequest](docs/Model/InventoryUpdateImagesRequest.md)
- [InventoryUpdateInventoryItemChannelSKUsRequest](docs/Model/InventoryUpdateInventoryItemChannelSKUsRequest.md)
- [InventoryUpdateInventoryItemChannelSKUsWithLocationRequest](docs/Model/InventoryUpdateInventoryItemChannelSKUsWithLocationRequest.md)
- [InventoryUpdateInventoryItemCompositionsRequest](docs/Model/InventoryUpdateInventoryItemCompositionsRequest.md)
- [InventoryUpdateInventoryItemDescriptionsRequest](docs/Model/InventoryUpdateInventoryItemDescriptionsRequest.md)
- [InventoryUpdateInventoryItemExtendedPropertiesRequest](docs/Model/InventoryUpdateInventoryItemExtendedPropertiesRequest.md)
- [InventoryUpdateInventoryItemFieldRequest](docs/Model/InventoryUpdateInventoryItemFieldRequest.md)
- [InventoryUpdateInventoryItemLevelsRequest](docs/Model/InventoryUpdateInventoryItemLevelsRequest.md)
- [InventoryUpdateInventoryItemLocationFieldRequest](docs/Model/InventoryUpdateInventoryItemLocationFieldRequest.md)
- [InventoryUpdateInventoryItemPricesRequest](docs/Model/InventoryUpdateInventoryItemPricesRequest.md)
- [InventoryUpdateInventoryItemPricingRulesRequest](docs/Model/InventoryUpdateInventoryItemPricingRulesRequest.md)
- [InventoryUpdateInventoryItemRequest](docs/Model/InventoryUpdateInventoryItemRequest.md)
- [InventoryUpdateInventoryItemStockFieldRequest](docs/Model/InventoryUpdateInventoryItemStockFieldRequest.md)
- [InventoryUpdateInventoryItemTitlesRequest](docs/Model/InventoryUpdateInventoryItemTitlesRequest.md)
- [InventoryUpdateItemLocationsRequest](docs/Model/InventoryUpdateItemLocationsRequest.md)
- [InventoryUpdateProductIdentifiersRequest](docs/Model/InventoryUpdateProductIdentifiersRequest.md)
- [InventoryUpdateScrapCategoriesRequest](docs/Model/InventoryUpdateScrapCategoriesRequest.md)
- [InventoryUpdateStockSupplierStatRequest](docs/Model/InventoryUpdateStockSupplierStatRequest.md)
- [InventoryUpdateSupplierRequest](docs/Model/InventoryUpdateSupplierRequest.md)
- [InventoryUpdateUserSpecificViewRequest](docs/Model/InventoryUpdateUserSpecificViewRequest.md)
- [InventoryUploadImagesToInventoryItemRequest](docs/Model/InventoryUploadImagesToInventoryItemRequest.md)
- [InventoryView](docs/Model/InventoryView.md)
- [ItemsHaveScannableIdentifiersRequest](docs/Model/ItemsHaveScannableIdentifiersRequest.md)
- [ItemsHaveScannableIdentifiersResponse](docs/Model/ItemsHaveScannableIdentifiersResponse.md)
- [KeyGuidValue](docs/Model/KeyGuidValue.md)
- [LinnworksCategory](docs/Model/LinnworksCategory.md)
- [MemberInfo](docs/Model/MemberInfo.md)
- [MethodInfo](docs/Model/MethodInfo.md)
- [PagedResultStockItemAuditTrail](docs/Model/PagedResultStockItemAuditTrail.md)
- [ParameterInfo](docs/Model/ParameterInfo.md)
- [PictureSource](docs/Model/PictureSource.md)
- [ProductIdentifierInformation](docs/Model/ProductIdentifierInformation.md)
- [PropertyRule](docs/Model/PropertyRule.md)
- [ScrapBatchedItemRequest](docs/Model/ScrapBatchedItemRequest.md)
- [ScrapBatchedItemResponse](docs/Model/ScrapBatchedItemResponse.md)
- [ScrapCategory](docs/Model/ScrapCategory.md)
- [ScrapItem](docs/Model/ScrapItem.md)
- [ScrapItemExtended](docs/Model/ScrapItemExtended.md)
- [StockItem](docs/Model/StockItem.md)
- [StockItemAuditTrail](docs/Model/StockItemAuditTrail.md)
- [StockItemBatch](docs/Model/StockItemBatch.md)
- [StockItemBatchAudit](docs/Model/StockItemBatchAudit.md)
- [StockItemBatchInventory](docs/Model/StockItemBatchInventory.md)
- [StockItemChannelSKU](docs/Model/StockItemChannelSKU.md)
- [StockItemChannelSKUWithLocation](docs/Model/StockItemChannelSKUWithLocation.md)
- [StockItemChannelSkuResponse](docs/Model/StockItemChannelSkuResponse.md)
- [StockItemComposition](docs/Model/StockItemComposition.md)
- [StockItemDescription](docs/Model/StockItemDescription.md)
- [StockItemEbayCompatibility](docs/Model/StockItemEbayCompatibility.md)
- [StockItemExtendedProperty](docs/Model/StockItemExtendedProperty.md)
- [StockItemExtendedPropertyUpsertItem](docs/Model/StockItemExtendedPropertyUpsertItem.md)
- [StockItemExtendedPropertyWithSku](docs/Model/StockItemExtendedPropertyWithSku.md)
- [StockItemHeader](docs/Model/StockItemHeader.md)
- [StockItemImage](docs/Model/StockItemImage.md)
- [StockItemImageSimple](docs/Model/StockItemImageSimple.md)
- [StockItemInv](docs/Model/StockItemInv.md)
- [StockItemLabel](docs/Model/StockItemLabel.md)
- [StockItemLocation](docs/Model/StockItemLocation.md)
- [StockItemPrice](docs/Model/StockItemPrice.md)
- [StockItemPricingRule](docs/Model/StockItemPricingRule.md)
- [StockItemProductIdentifier](docs/Model/StockItemProductIdentifier.md)
- [StockItemSupplierStat](docs/Model/StockItemSupplierStat.md)
- [StockItemTitle](docs/Model/StockItemTitle.md)
- [StockLocation](docs/Model/StockLocation.md)
- [Supplier](docs/Model/Supplier.md)
- [TupleInt32Int32](docs/Model/TupleInt32Int32.md)
- [UpdateBatchDatesRequest](docs/Model/UpdateBatchDatesRequest.md)
- [UpdateBatchDatesResponse](docs/Model/UpdateBatchDatesResponse.md)
- [UpdateBatchDetailsRequest](docs/Model/UpdateBatchDetailsRequest.md)
- [UpdateCountryRegionsRequest](docs/Model/UpdateCountryRegionsRequest.md)
- [UpdateInventoryItemRequest](docs/Model/UpdateInventoryItemRequest.md)
- [UpdateProductIdentifiersRequest](docs/Model/UpdateProductIdentifiersRequest.md)
- [UpdateScrapCategoriesRequest](docs/Model/UpdateScrapCategoriesRequest.md)

## Authorization

Authentication schemes defined for the API:
### token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author



## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `inventory`
    - Package version: `1.0`
    - Generator version: `7.11.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
