<?php
/**
 * Order
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Channel
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * linnworks_channel
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Channel\Model;

use \ArrayAccess;
use \Linnworks\Channel\ObjectSerializer;

/**
 * Order Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Channel
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Order implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Order';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'billing_address' => '\Linnworks\Channel\Model\Address',
        'delivery_address' => '\Linnworks\Channel\Model\Address',
        'order_items' => '\Linnworks\Channel\Model\OrderItem[]',
        'extended_properties' => '\Linnworks\Channel\Model\ExtendedProperty[]',
        'notes' => '\Linnworks\Channel\Model\Note[]',
        'site' => 'string',
        'match_postal_service_tag' => 'string',
        'match_payment_method_tag' => 'string',
        'payment_status' => 'string',
        'channel_buyer_name' => 'string',
        'reference_number' => 'string',
        'external_reference' => 'string',
        'secondary_reference_number' => 'string',
        'currency' => 'string',
        'received_date' => 'string',
        'dispatch_by' => 'string',
        'paid_on' => 'string',
        'postal_service_cost' => 'float',
        'postal_service_tax_rate' => 'int',
        'use_channel_tax' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'billing_address' => null,
        'delivery_address' => null,
        'order_items' => null,
        'extended_properties' => null,
        'notes' => null,
        'site' => null,
        'match_postal_service_tag' => null,
        'match_payment_method_tag' => null,
        'payment_status' => null,
        'channel_buyer_name' => null,
        'reference_number' => null,
        'external_reference' => null,
        'secondary_reference_number' => null,
        'currency' => null,
        'received_date' => null,
        'dispatch_by' => null,
        'paid_on' => null,
        'postal_service_cost' => null,
        'postal_service_tax_rate' => null,
        'use_channel_tax' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'billing_address' => false,
        'delivery_address' => false,
        'order_items' => false,
        'extended_properties' => false,
        'notes' => false,
        'site' => false,
        'match_postal_service_tag' => false,
        'match_payment_method_tag' => false,
        'payment_status' => false,
        'channel_buyer_name' => false,
        'reference_number' => false,
        'external_reference' => false,
        'secondary_reference_number' => true,
        'currency' => false,
        'received_date' => false,
        'dispatch_by' => false,
        'paid_on' => false,
        'postal_service_cost' => false,
        'postal_service_tax_rate' => false,
        'use_channel_tax' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'billing_address' => 'BillingAddress',
        'delivery_address' => 'DeliveryAddress',
        'order_items' => 'OrderItems',
        'extended_properties' => 'ExtendedProperties',
        'notes' => 'Notes',
        'site' => 'Site',
        'match_postal_service_tag' => 'MatchPostalServiceTag',
        'match_payment_method_tag' => 'MatchPaymentMethodTag',
        'payment_status' => 'PaymentStatus',
        'channel_buyer_name' => 'ChannelBuyerName',
        'reference_number' => 'ReferenceNumber',
        'external_reference' => 'ExternalReference',
        'secondary_reference_number' => 'SecondaryReferenceNumber',
        'currency' => 'Currency',
        'received_date' => 'ReceivedDate',
        'dispatch_by' => 'DispatchBy',
        'paid_on' => 'PaidOn',
        'postal_service_cost' => 'PostalServiceCost',
        'postal_service_tax_rate' => 'PostalServiceTaxRate',
        'use_channel_tax' => 'UseChannelTax'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'billing_address' => 'setBillingAddress',
        'delivery_address' => 'setDeliveryAddress',
        'order_items' => 'setOrderItems',
        'extended_properties' => 'setExtendedProperties',
        'notes' => 'setNotes',
        'site' => 'setSite',
        'match_postal_service_tag' => 'setMatchPostalServiceTag',
        'match_payment_method_tag' => 'setMatchPaymentMethodTag',
        'payment_status' => 'setPaymentStatus',
        'channel_buyer_name' => 'setChannelBuyerName',
        'reference_number' => 'setReferenceNumber',
        'external_reference' => 'setExternalReference',
        'secondary_reference_number' => 'setSecondaryReferenceNumber',
        'currency' => 'setCurrency',
        'received_date' => 'setReceivedDate',
        'dispatch_by' => 'setDispatchBy',
        'paid_on' => 'setPaidOn',
        'postal_service_cost' => 'setPostalServiceCost',
        'postal_service_tax_rate' => 'setPostalServiceTaxRate',
        'use_channel_tax' => 'setUseChannelTax'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'billing_address' => 'getBillingAddress',
        'delivery_address' => 'getDeliveryAddress',
        'order_items' => 'getOrderItems',
        'extended_properties' => 'getExtendedProperties',
        'notes' => 'getNotes',
        'site' => 'getSite',
        'match_postal_service_tag' => 'getMatchPostalServiceTag',
        'match_payment_method_tag' => 'getMatchPaymentMethodTag',
        'payment_status' => 'getPaymentStatus',
        'channel_buyer_name' => 'getChannelBuyerName',
        'reference_number' => 'getReferenceNumber',
        'external_reference' => 'getExternalReference',
        'secondary_reference_number' => 'getSecondaryReferenceNumber',
        'currency' => 'getCurrency',
        'received_date' => 'getReceivedDate',
        'dispatch_by' => 'getDispatchBy',
        'paid_on' => 'getPaidOn',
        'postal_service_cost' => 'getPostalServiceCost',
        'postal_service_tax_rate' => 'getPostalServiceTaxRate',
        'use_channel_tax' => 'getUseChannelTax'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('billing_address', $data ?? [], null);
        $this->setIfExists('delivery_address', $data ?? [], null);
        $this->setIfExists('order_items', $data ?? [], null);
        $this->setIfExists('extended_properties', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('site', $data ?? [], null);
        $this->setIfExists('match_postal_service_tag', $data ?? [], null);
        $this->setIfExists('match_payment_method_tag', $data ?? [], null);
        $this->setIfExists('payment_status', $data ?? [], null);
        $this->setIfExists('channel_buyer_name', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('external_reference', $data ?? [], null);
        $this->setIfExists('secondary_reference_number', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('received_date', $data ?? [], null);
        $this->setIfExists('dispatch_by', $data ?? [], null);
        $this->setIfExists('paid_on', $data ?? [], null);
        $this->setIfExists('postal_service_cost', $data ?? [], null);
        $this->setIfExists('postal_service_tax_rate', $data ?? [], null);
        $this->setIfExists('use_channel_tax', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets billing_address
     *
     * @return \Linnworks\Channel\Model\Address|null
     */
    public function getBillingAddress()
    {
        return $this->container['billing_address'];
    }

    /**
     * Sets billing_address
     *
     * @param \Linnworks\Channel\Model\Address|null $billing_address billing_address
     *
     * @return self
     */
    public function setBillingAddress($billing_address)
    {
        if (is_null($billing_address)) {
            throw new \InvalidArgumentException('non-nullable billing_address cannot be null');
        }
        $this->container['billing_address'] = $billing_address;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return \Linnworks\Channel\Model\Address|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param \Linnworks\Channel\Model\Address|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        if (is_null($delivery_address)) {
            throw new \InvalidArgumentException('non-nullable delivery_address cannot be null');
        }
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }

    /**
     * Gets order_items
     *
     * @return \Linnworks\Channel\Model\OrderItem[]|null
     */
    public function getOrderItems()
    {
        return $this->container['order_items'];
    }

    /**
     * Sets order_items
     *
     * @param \Linnworks\Channel\Model\OrderItem[]|null $order_items order_items
     *
     * @return self
     */
    public function setOrderItems($order_items)
    {
        if (is_null($order_items)) {
            throw new \InvalidArgumentException('non-nullable order_items cannot be null');
        }
        $this->container['order_items'] = $order_items;

        return $this;
    }

    /**
     * Gets extended_properties
     *
     * @return \Linnworks\Channel\Model\ExtendedProperty[]|null
     */
    public function getExtendedProperties()
    {
        return $this->container['extended_properties'];
    }

    /**
     * Sets extended_properties
     *
     * @param \Linnworks\Channel\Model\ExtendedProperty[]|null $extended_properties extended_properties
     *
     * @return self
     */
    public function setExtendedProperties($extended_properties)
    {
        if (is_null($extended_properties)) {
            throw new \InvalidArgumentException('non-nullable extended_properties cannot be null');
        }
        $this->container['extended_properties'] = $extended_properties;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return \Linnworks\Channel\Model\Note[]|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param \Linnworks\Channel\Model\Note[]|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets site
     *
     * @return string|null
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site
     *
     * @param string|null $site site
     *
     * @return self
     */
    public function setSite($site)
    {
        if (is_null($site)) {
            throw new \InvalidArgumentException('non-nullable site cannot be null');
        }
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets match_postal_service_tag
     *
     * @return string|null
     */
    public function getMatchPostalServiceTag()
    {
        return $this->container['match_postal_service_tag'];
    }

    /**
     * Sets match_postal_service_tag
     *
     * @param string|null $match_postal_service_tag match_postal_service_tag
     *
     * @return self
     */
    public function setMatchPostalServiceTag($match_postal_service_tag)
    {
        if (is_null($match_postal_service_tag)) {
            throw new \InvalidArgumentException('non-nullable match_postal_service_tag cannot be null');
        }
        $this->container['match_postal_service_tag'] = $match_postal_service_tag;

        return $this;
    }

    /**
     * Gets match_payment_method_tag
     *
     * @return string|null
     */
    public function getMatchPaymentMethodTag()
    {
        return $this->container['match_payment_method_tag'];
    }

    /**
     * Sets match_payment_method_tag
     *
     * @param string|null $match_payment_method_tag match_payment_method_tag
     *
     * @return self
     */
    public function setMatchPaymentMethodTag($match_payment_method_tag)
    {
        if (is_null($match_payment_method_tag)) {
            throw new \InvalidArgumentException('non-nullable match_payment_method_tag cannot be null');
        }
        $this->container['match_payment_method_tag'] = $match_payment_method_tag;

        return $this;
    }

    /**
     * Gets payment_status
     *
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->container['payment_status'];
    }

    /**
     * Sets payment_status
     *
     * @param string|null $payment_status payment_status
     *
     * @return self
     */
    public function setPaymentStatus($payment_status)
    {
        if (is_null($payment_status)) {
            throw new \InvalidArgumentException('non-nullable payment_status cannot be null');
        }
        $this->container['payment_status'] = $payment_status;

        return $this;
    }

    /**
     * Gets channel_buyer_name
     *
     * @return string|null
     */
    public function getChannelBuyerName()
    {
        return $this->container['channel_buyer_name'];
    }

    /**
     * Sets channel_buyer_name
     *
     * @param string|null $channel_buyer_name channel_buyer_name
     *
     * @return self
     */
    public function setChannelBuyerName($channel_buyer_name)
    {
        if (is_null($channel_buyer_name)) {
            throw new \InvalidArgumentException('non-nullable channel_buyer_name cannot be null');
        }
        $this->container['channel_buyer_name'] = $channel_buyer_name;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number reference_number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            throw new \InvalidArgumentException('non-nullable reference_number cannot be null');
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets external_reference
     *
     * @return string|null
     */
    public function getExternalReference()
    {
        return $this->container['external_reference'];
    }

    /**
     * Sets external_reference
     *
     * @param string|null $external_reference external_reference
     *
     * @return self
     */
    public function setExternalReference($external_reference)
    {
        if (is_null($external_reference)) {
            throw new \InvalidArgumentException('non-nullable external_reference cannot be null');
        }
        $this->container['external_reference'] = $external_reference;

        return $this;
    }

    /**
     * Gets secondary_reference_number
     *
     * @return string|null
     */
    public function getSecondaryReferenceNumber()
    {
        return $this->container['secondary_reference_number'];
    }

    /**
     * Sets secondary_reference_number
     *
     * @param string|null $secondary_reference_number secondary_reference_number
     *
     * @return self
     */
    public function setSecondaryReferenceNumber($secondary_reference_number)
    {
        if (is_null($secondary_reference_number)) {
            array_push($this->openAPINullablesSetToNull, 'secondary_reference_number');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('secondary_reference_number', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['secondary_reference_number'] = $secondary_reference_number;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets received_date
     *
     * @return string|null
     */
    public function getReceivedDate()
    {
        return $this->container['received_date'];
    }

    /**
     * Sets received_date
     *
     * @param string|null $received_date received_date
     *
     * @return self
     */
    public function setReceivedDate($received_date)
    {
        if (is_null($received_date)) {
            throw new \InvalidArgumentException('non-nullable received_date cannot be null');
        }
        $this->container['received_date'] = $received_date;

        return $this;
    }

    /**
     * Gets dispatch_by
     *
     * @return string|null
     */
    public function getDispatchBy()
    {
        return $this->container['dispatch_by'];
    }

    /**
     * Sets dispatch_by
     *
     * @param string|null $dispatch_by dispatch_by
     *
     * @return self
     */
    public function setDispatchBy($dispatch_by)
    {
        if (is_null($dispatch_by)) {
            throw new \InvalidArgumentException('non-nullable dispatch_by cannot be null');
        }
        $this->container['dispatch_by'] = $dispatch_by;

        return $this;
    }

    /**
     * Gets paid_on
     *
     * @return string|null
     */
    public function getPaidOn()
    {
        return $this->container['paid_on'];
    }

    /**
     * Sets paid_on
     *
     * @param string|null $paid_on paid_on
     *
     * @return self
     */
    public function setPaidOn($paid_on)
    {
        if (is_null($paid_on)) {
            throw new \InvalidArgumentException('non-nullable paid_on cannot be null');
        }
        $this->container['paid_on'] = $paid_on;

        return $this;
    }

    /**
     * Gets postal_service_cost
     *
     * @return float|null
     */
    public function getPostalServiceCost()
    {
        return $this->container['postal_service_cost'];
    }

    /**
     * Sets postal_service_cost
     *
     * @param float|null $postal_service_cost postal_service_cost
     *
     * @return self
     */
    public function setPostalServiceCost($postal_service_cost)
    {
        if (is_null($postal_service_cost)) {
            throw new \InvalidArgumentException('non-nullable postal_service_cost cannot be null');
        }
        $this->container['postal_service_cost'] = $postal_service_cost;

        return $this;
    }

    /**
     * Gets postal_service_tax_rate
     *
     * @return int|null
     */
    public function getPostalServiceTaxRate()
    {
        return $this->container['postal_service_tax_rate'];
    }

    /**
     * Sets postal_service_tax_rate
     *
     * @param int|null $postal_service_tax_rate postal_service_tax_rate
     *
     * @return self
     */
    public function setPostalServiceTaxRate($postal_service_tax_rate)
    {
        if (is_null($postal_service_tax_rate)) {
            throw new \InvalidArgumentException('non-nullable postal_service_tax_rate cannot be null');
        }
        $this->container['postal_service_tax_rate'] = $postal_service_tax_rate;

        return $this;
    }

    /**
     * Gets use_channel_tax
     *
     * @return bool|null
     */
    public function getUseChannelTax()
    {
        return $this->container['use_channel_tax'];
    }

    /**
     * Sets use_channel_tax
     *
     * @param bool|null $use_channel_tax use_channel_tax
     *
     * @return self
     */
    public function setUseChannelTax($use_channel_tax)
    {
        if (is_null($use_channel_tax)) {
            throw new \InvalidArgumentException('non-nullable use_channel_tax cannot be null');
        }
        $this->container['use_channel_tax'] = $use_channel_tax;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


