<?php
/**
 * DespatchOrder
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Channel
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * linnworks_channel
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Channel\Model;

use \ArrayAccess;
use \Linnworks\Channel\ObjectSerializer;

/**
 * DespatchOrder Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Channel
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class DespatchOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'DespatchOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'reference_number' => 'string',
        'shipping_vendor' => 'string',
        'shipping_method' => 'string',
        'tracking_number' => 'string',
        'secondary_tracking_numbers' => 'string[]',
        'processed_on' => 'string',
        'items' => '\Linnworks\Channel\Model\DespatchItem[]',
        'packages' => '\Linnworks\Channel\Model\DespatchPackage[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'reference_number' => null,
        'shipping_vendor' => null,
        'shipping_method' => null,
        'tracking_number' => null,
        'secondary_tracking_numbers' => null,
        'processed_on' => null,
        'items' => null,
        'packages' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'reference_number' => false,
        'shipping_vendor' => false,
        'shipping_method' => false,
        'tracking_number' => false,
        'secondary_tracking_numbers' => false,
        'processed_on' => false,
        'items' => false,
        'packages' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'reference_number' => 'ReferenceNumber',
        'shipping_vendor' => 'ShippingVendor',
        'shipping_method' => 'ShippingMethod',
        'tracking_number' => 'TrackingNumber',
        'secondary_tracking_numbers' => 'SecondaryTrackingNumbers',
        'processed_on' => 'ProcessedOn',
        'items' => 'Items',
        'packages' => 'Packages'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'reference_number' => 'setReferenceNumber',
        'shipping_vendor' => 'setShippingVendor',
        'shipping_method' => 'setShippingMethod',
        'tracking_number' => 'setTrackingNumber',
        'secondary_tracking_numbers' => 'setSecondaryTrackingNumbers',
        'processed_on' => 'setProcessedOn',
        'items' => 'setItems',
        'packages' => 'setPackages'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'reference_number' => 'getReferenceNumber',
        'shipping_vendor' => 'getShippingVendor',
        'shipping_method' => 'getShippingMethod',
        'tracking_number' => 'getTrackingNumber',
        'secondary_tracking_numbers' => 'getSecondaryTrackingNumbers',
        'processed_on' => 'getProcessedOn',
        'items' => 'getItems',
        'packages' => 'getPackages'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('shipping_vendor', $data ?? [], null);
        $this->setIfExists('shipping_method', $data ?? [], null);
        $this->setIfExists('tracking_number', $data ?? [], null);
        $this->setIfExists('secondary_tracking_numbers', $data ?? [], null);
        $this->setIfExists('processed_on', $data ?? [], null);
        $this->setIfExists('items', $data ?? [], null);
        $this->setIfExists('packages', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number reference_number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            throw new \InvalidArgumentException('non-nullable reference_number cannot be null');
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets shipping_vendor
     *
     * @return string|null
     */
    public function getShippingVendor()
    {
        return $this->container['shipping_vendor'];
    }

    /**
     * Sets shipping_vendor
     *
     * @param string|null $shipping_vendor shipping_vendor
     *
     * @return self
     */
    public function setShippingVendor($shipping_vendor)
    {
        if (is_null($shipping_vendor)) {
            throw new \InvalidArgumentException('non-nullable shipping_vendor cannot be null');
        }
        $this->container['shipping_vendor'] = $shipping_vendor;

        return $this;
    }

    /**
     * Gets shipping_method
     *
     * @return string|null
     */
    public function getShippingMethod()
    {
        return $this->container['shipping_method'];
    }

    /**
     * Sets shipping_method
     *
     * @param string|null $shipping_method shipping_method
     *
     * @return self
     */
    public function setShippingMethod($shipping_method)
    {
        if (is_null($shipping_method)) {
            throw new \InvalidArgumentException('non-nullable shipping_method cannot be null');
        }
        $this->container['shipping_method'] = $shipping_method;

        return $this;
    }

    /**
     * Gets tracking_number
     *
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->container['tracking_number'];
    }

    /**
     * Sets tracking_number
     *
     * @param string|null $tracking_number tracking_number
     *
     * @return self
     */
    public function setTrackingNumber($tracking_number)
    {
        if (is_null($tracking_number)) {
            throw new \InvalidArgumentException('non-nullable tracking_number cannot be null');
        }
        $this->container['tracking_number'] = $tracking_number;

        return $this;
    }

    /**
     * Gets secondary_tracking_numbers
     *
     * @return string[]|null
     */
    public function getSecondaryTrackingNumbers()
    {
        return $this->container['secondary_tracking_numbers'];
    }

    /**
     * Sets secondary_tracking_numbers
     *
     * @param string[]|null $secondary_tracking_numbers secondary_tracking_numbers
     *
     * @return self
     */
    public function setSecondaryTrackingNumbers($secondary_tracking_numbers)
    {
        if (is_null($secondary_tracking_numbers)) {
            throw new \InvalidArgumentException('non-nullable secondary_tracking_numbers cannot be null');
        }
        $this->container['secondary_tracking_numbers'] = $secondary_tracking_numbers;

        return $this;
    }

    /**
     * Gets processed_on
     *
     * @return string|null
     */
    public function getProcessedOn()
    {
        return $this->container['processed_on'];
    }

    /**
     * Sets processed_on
     *
     * @param string|null $processed_on processed_on
     *
     * @return self
     */
    public function setProcessedOn($processed_on)
    {
        if (is_null($processed_on)) {
            throw new \InvalidArgumentException('non-nullable processed_on cannot be null');
        }
        $this->container['processed_on'] = $processed_on;

        return $this;
    }

    /**
     * Gets items
     *
     * @return \Linnworks\Channel\Model\DespatchItem[]|null
     */
    public function getItems()
    {
        return $this->container['items'];
    }

    /**
     * Sets items
     *
     * @param \Linnworks\Channel\Model\DespatchItem[]|null $items items
     *
     * @return self
     */
    public function setItems($items)
    {
        if (is_null($items)) {
            throw new \InvalidArgumentException('non-nullable items cannot be null');
        }
        $this->container['items'] = $items;

        return $this;
    }

    /**
     * Gets packages
     *
     * @return \Linnworks\Channel\Model\DespatchPackage[]|null
     */
    public function getPackages()
    {
        return $this->container['packages'];
    }

    /**
     * Sets packages
     *
     * @param \Linnworks\Channel\Model\DespatchPackage[]|null $packages packages
     *
     * @return self
     */
    public function setPackages($packages)
    {
        if (is_null($packages)) {
            throw new \InvalidArgumentException('non-nullable packages cannot be null');
        }
        $this->container['packages'] = $packages;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


