<?php
/**
 * BaseSession
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Auth
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Authenticate API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: auth
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Auth\Model;

use \ArrayAccess;
use \Linnworks\Auth\ObjectSerializer;

/**
 * BaseSession Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Auth
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class BaseSession implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'BaseSession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'entity_id' => 'string',
        'database_name' => 'string',
        'database_server' => 'string',
        'private_database_server' => 'string',
        'database_user' => 'string',
        'database_password' => 'string',
        'app_name' => 'string',
        'sid_registration' => 'string',
        'user_name' => 'string',
        'md5_hash' => 'string',
        'locality' => 'string',
        'super_admin' => 'bool',
        'ttl' => 'int',
        'token' => 'string',
        'access_token' => 'string',
        'group_name' => 'string',
        'device' => 'string',
        'device_type' => 'string',
        'user_type' => 'string',
        'status' => '\Linnworks\Auth\Model\StatusDetails',
        'user_id' => 'string',
        'properties' => 'array<string,string>',
        'email' => 'string',
        'server' => 'string',
        'push_server' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'entity_id' => 'uuid',
        'database_name' => null,
        'database_server' => null,
        'private_database_server' => null,
        'database_user' => null,
        'database_password' => null,
        'app_name' => null,
        'sid_registration' => 'uuid',
        'user_name' => null,
        'md5_hash' => null,
        'locality' => null,
        'super_admin' => null,
        'ttl' => 'int32',
        'token' => 'uuid',
        'access_token' => null,
        'group_name' => null,
        'device' => null,
        'device_type' => null,
        'user_type' => null,
        'status' => null,
        'user_id' => 'uuid',
        'properties' => null,
        'email' => null,
        'server' => null,
        'push_server' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'id' => false,
        'entity_id' => false,
        'database_name' => false,
        'database_server' => false,
        'private_database_server' => false,
        'database_user' => false,
        'database_password' => false,
        'app_name' => false,
        'sid_registration' => false,
        'user_name' => false,
        'md5_hash' => false,
        'locality' => false,
        'super_admin' => false,
        'ttl' => false,
        'token' => false,
        'access_token' => false,
        'group_name' => false,
        'device' => false,
        'device_type' => false,
        'user_type' => false,
        'status' => false,
        'user_id' => false,
        'properties' => false,
        'email' => false,
        'server' => false,
        'push_server' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'Id',
        'entity_id' => 'EntityId',
        'database_name' => 'DatabaseName',
        'database_server' => 'DatabaseServer',
        'private_database_server' => 'PrivateDatabaseServer',
        'database_user' => 'DatabaseUser',
        'database_password' => 'DatabasePassword',
        'app_name' => 'AppName',
        'sid_registration' => 'sid_registration',
        'user_name' => 'UserName',
        'md5_hash' => 'Md5Hash',
        'locality' => 'Locality',
        'super_admin' => 'SuperAdmin',
        'ttl' => 'TTL',
        'token' => 'Token',
        'access_token' => 'AccessToken',
        'group_name' => 'GroupName',
        'device' => 'Device',
        'device_type' => 'DeviceType',
        'user_type' => 'UserType',
        'status' => 'Status',
        'user_id' => 'UserId',
        'properties' => 'Properties',
        'email' => 'Email',
        'server' => 'Server',
        'push_server' => 'PushServer'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'entity_id' => 'setEntityId',
        'database_name' => 'setDatabaseName',
        'database_server' => 'setDatabaseServer',
        'private_database_server' => 'setPrivateDatabaseServer',
        'database_user' => 'setDatabaseUser',
        'database_password' => 'setDatabasePassword',
        'app_name' => 'setAppName',
        'sid_registration' => 'setSidRegistration',
        'user_name' => 'setUserName',
        'md5_hash' => 'setMd5Hash',
        'locality' => 'setLocality',
        'super_admin' => 'setSuperAdmin',
        'ttl' => 'setTtl',
        'token' => 'setToken',
        'access_token' => 'setAccessToken',
        'group_name' => 'setGroupName',
        'device' => 'setDevice',
        'device_type' => 'setDeviceType',
        'user_type' => 'setUserType',
        'status' => 'setStatus',
        'user_id' => 'setUserId',
        'properties' => 'setProperties',
        'email' => 'setEmail',
        'server' => 'setServer',
        'push_server' => 'setPushServer'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'entity_id' => 'getEntityId',
        'database_name' => 'getDatabaseName',
        'database_server' => 'getDatabaseServer',
        'private_database_server' => 'getPrivateDatabaseServer',
        'database_user' => 'getDatabaseUser',
        'database_password' => 'getDatabasePassword',
        'app_name' => 'getAppName',
        'sid_registration' => 'getSidRegistration',
        'user_name' => 'getUserName',
        'md5_hash' => 'getMd5Hash',
        'locality' => 'getLocality',
        'super_admin' => 'getSuperAdmin',
        'ttl' => 'getTtl',
        'token' => 'getToken',
        'access_token' => 'getAccessToken',
        'group_name' => 'getGroupName',
        'device' => 'getDevice',
        'device_type' => 'getDeviceType',
        'user_type' => 'getUserType',
        'status' => 'getStatus',
        'user_id' => 'getUserId',
        'properties' => 'getProperties',
        'email' => 'getEmail',
        'server' => 'getServer',
        'push_server' => 'getPushServer'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const LOCALITY_EU = 'EU';
    public const LOCALITY_US = 'US';
    public const LOCALITY__AS = 'AS';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getLocalityAllowableValues()
    {
        return [
            self::LOCALITY_EU,
            self::LOCALITY_US,
            self::LOCALITY__AS,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('id', $data ?? [], null);
        $this->setIfExists('entity_id', $data ?? [], null);
        $this->setIfExists('database_name', $data ?? [], null);
        $this->setIfExists('database_server', $data ?? [], null);
        $this->setIfExists('private_database_server', $data ?? [], null);
        $this->setIfExists('database_user', $data ?? [], null);
        $this->setIfExists('database_password', $data ?? [], null);
        $this->setIfExists('app_name', $data ?? [], null);
        $this->setIfExists('sid_registration', $data ?? [], null);
        $this->setIfExists('user_name', $data ?? [], null);
        $this->setIfExists('md5_hash', $data ?? [], null);
        $this->setIfExists('locality', $data ?? [], null);
        $this->setIfExists('super_admin', $data ?? [], null);
        $this->setIfExists('ttl', $data ?? [], null);
        $this->setIfExists('token', $data ?? [], null);
        $this->setIfExists('access_token', $data ?? [], null);
        $this->setIfExists('group_name', $data ?? [], null);
        $this->setIfExists('device', $data ?? [], null);
        $this->setIfExists('device_type', $data ?? [], null);
        $this->setIfExists('user_type', $data ?? [], null);
        $this->setIfExists('status', $data ?? [], null);
        $this->setIfExists('user_id', $data ?? [], null);
        $this->setIfExists('properties', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('server', $data ?? [], null);
        $this->setIfExists('push_server', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getLocalityAllowableValues();
        if (!is_null($this->container['locality']) && !in_array($this->container['locality'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'locality', must be one of '%s'",
                $this->container['locality'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id id
     *
     * @return self
     */
    public function setId($id)
    {
        if (is_null($id)) {
            throw new \InvalidArgumentException('non-nullable id cannot be null');
        }
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets entity_id
     *
     * @return string|null
     */
    public function getEntityId()
    {
        return $this->container['entity_id'];
    }

    /**
     * Sets entity_id
     *
     * @param string|null $entity_id entity_id
     *
     * @return self
     */
    public function setEntityId($entity_id)
    {
        if (is_null($entity_id)) {
            throw new \InvalidArgumentException('non-nullable entity_id cannot be null');
        }
        $this->container['entity_id'] = $entity_id;

        return $this;
    }

    /**
     * Gets database_name
     *
     * @return string|null
     */
    public function getDatabaseName()
    {
        return $this->container['database_name'];
    }

    /**
     * Sets database_name
     *
     * @param string|null $database_name database_name
     *
     * @return self
     */
    public function setDatabaseName($database_name)
    {
        if (is_null($database_name)) {
            throw new \InvalidArgumentException('non-nullable database_name cannot be null');
        }
        $this->container['database_name'] = $database_name;

        return $this;
    }

    /**
     * Gets database_server
     *
     * @return string|null
     */
    public function getDatabaseServer()
    {
        return $this->container['database_server'];
    }

    /**
     * Sets database_server
     *
     * @param string|null $database_server database_server
     *
     * @return self
     */
    public function setDatabaseServer($database_server)
    {
        if (is_null($database_server)) {
            throw new \InvalidArgumentException('non-nullable database_server cannot be null');
        }
        $this->container['database_server'] = $database_server;

        return $this;
    }

    /**
     * Gets private_database_server
     *
     * @return string|null
     */
    public function getPrivateDatabaseServer()
    {
        return $this->container['private_database_server'];
    }

    /**
     * Sets private_database_server
     *
     * @param string|null $private_database_server private_database_server
     *
     * @return self
     */
    public function setPrivateDatabaseServer($private_database_server)
    {
        if (is_null($private_database_server)) {
            throw new \InvalidArgumentException('non-nullable private_database_server cannot be null');
        }
        $this->container['private_database_server'] = $private_database_server;

        return $this;
    }

    /**
     * Gets database_user
     *
     * @return string|null
     */
    public function getDatabaseUser()
    {
        return $this->container['database_user'];
    }

    /**
     * Sets database_user
     *
     * @param string|null $database_user database_user
     *
     * @return self
     */
    public function setDatabaseUser($database_user)
    {
        if (is_null($database_user)) {
            throw new \InvalidArgumentException('non-nullable database_user cannot be null');
        }
        $this->container['database_user'] = $database_user;

        return $this;
    }

    /**
     * Gets database_password
     *
     * @return string|null
     */
    public function getDatabasePassword()
    {
        return $this->container['database_password'];
    }

    /**
     * Sets database_password
     *
     * @param string|null $database_password database_password
     *
     * @return self
     */
    public function setDatabasePassword($database_password)
    {
        if (is_null($database_password)) {
            throw new \InvalidArgumentException('non-nullable database_password cannot be null');
        }
        $this->container['database_password'] = $database_password;

        return $this;
    }

    /**
     * Gets app_name
     *
     * @return string|null
     */
    public function getAppName()
    {
        return $this->container['app_name'];
    }

    /**
     * Sets app_name
     *
     * @param string|null $app_name app_name
     *
     * @return self
     */
    public function setAppName($app_name)
    {
        if (is_null($app_name)) {
            throw new \InvalidArgumentException('non-nullable app_name cannot be null');
        }
        $this->container['app_name'] = $app_name;

        return $this;
    }

    /**
     * Gets sid_registration
     *
     * @return string|null
     */
    public function getSidRegistration()
    {
        return $this->container['sid_registration'];
    }

    /**
     * Sets sid_registration
     *
     * @param string|null $sid_registration sid_registration
     *
     * @return self
     */
    public function setSidRegistration($sid_registration)
    {
        if (is_null($sid_registration)) {
            throw new \InvalidArgumentException('non-nullable sid_registration cannot be null');
        }
        $this->container['sid_registration'] = $sid_registration;

        return $this;
    }

    /**
     * Gets user_name
     *
     * @return string|null
     */
    public function getUserName()
    {
        return $this->container['user_name'];
    }

    /**
     * Sets user_name
     *
     * @param string|null $user_name user_name
     *
     * @return self
     */
    public function setUserName($user_name)
    {
        if (is_null($user_name)) {
            throw new \InvalidArgumentException('non-nullable user_name cannot be null');
        }
        $this->container['user_name'] = $user_name;

        return $this;
    }

    /**
     * Gets md5_hash
     *
     * @return string|null
     */
    public function getMd5Hash()
    {
        return $this->container['md5_hash'];
    }

    /**
     * Sets md5_hash
     *
     * @param string|null $md5_hash md5_hash
     *
     * @return self
     */
    public function setMd5Hash($md5_hash)
    {
        if (is_null($md5_hash)) {
            throw new \InvalidArgumentException('non-nullable md5_hash cannot be null');
        }
        $this->container['md5_hash'] = $md5_hash;

        return $this;
    }

    /**
     * Gets locality
     *
     * @return string|null
     */
    public function getLocality()
    {
        return $this->container['locality'];
    }

    /**
     * Sets locality
     *
     * @param string|null $locality locality
     *
     * @return self
     */
    public function setLocality($locality)
    {
        if (is_null($locality)) {
            throw new \InvalidArgumentException('non-nullable locality cannot be null');
        }
        $allowedValues = $this->getLocalityAllowableValues();
        if (!in_array($locality, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'locality', must be one of '%s'",
                    $locality,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['locality'] = $locality;

        return $this;
    }

    /**
     * Gets super_admin
     *
     * @return bool|null
     */
    public function getSuperAdmin()
    {
        return $this->container['super_admin'];
    }

    /**
     * Sets super_admin
     *
     * @param bool|null $super_admin super_admin
     *
     * @return self
     */
    public function setSuperAdmin($super_admin)
    {
        if (is_null($super_admin)) {
            throw new \InvalidArgumentException('non-nullable super_admin cannot be null');
        }
        $this->container['super_admin'] = $super_admin;

        return $this;
    }

    /**
     * Gets ttl
     *
     * @return int|null
     */
    public function getTtl()
    {
        return $this->container['ttl'];
    }

    /**
     * Sets ttl
     *
     * @param int|null $ttl ttl
     *
     * @return self
     */
    public function setTtl($ttl)
    {
        if (is_null($ttl)) {
            throw new \InvalidArgumentException('non-nullable ttl cannot be null');
        }
        $this->container['ttl'] = $ttl;

        return $this;
    }

    /**
     * Gets token
     *
     * @return string|null
     */
    public function getToken()
    {
        return $this->container['token'];
    }

    /**
     * Sets token
     *
     * @param string|null $token token
     *
     * @return self
     */
    public function setToken($token)
    {
        if (is_null($token)) {
            throw new \InvalidArgumentException('non-nullable token cannot be null');
        }
        $this->container['token'] = $token;

        return $this;
    }

    /**
     * Gets access_token
     *
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->container['access_token'];
    }

    /**
     * Sets access_token
     *
     * @param string|null $access_token access_token
     *
     * @return self
     */
    public function setAccessToken($access_token)
    {
        if (is_null($access_token)) {
            throw new \InvalidArgumentException('non-nullable access_token cannot be null');
        }
        $this->container['access_token'] = $access_token;

        return $this;
    }

    /**
     * Gets group_name
     *
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->container['group_name'];
    }

    /**
     * Sets group_name
     *
     * @param string|null $group_name group_name
     *
     * @return self
     */
    public function setGroupName($group_name)
    {
        if (is_null($group_name)) {
            throw new \InvalidArgumentException('non-nullable group_name cannot be null');
        }
        $this->container['group_name'] = $group_name;

        return $this;
    }

    /**
     * Gets device
     *
     * @return string|null
     */
    public function getDevice()
    {
        return $this->container['device'];
    }

    /**
     * Sets device
     *
     * @param string|null $device device
     *
     * @return self
     */
    public function setDevice($device)
    {
        if (is_null($device)) {
            throw new \InvalidArgumentException('non-nullable device cannot be null');
        }
        $this->container['device'] = $device;

        return $this;
    }

    /**
     * Gets device_type
     *
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->container['device_type'];
    }

    /**
     * Sets device_type
     *
     * @param string|null $device_type device_type
     *
     * @return self
     */
    public function setDeviceType($device_type)
    {
        if (is_null($device_type)) {
            throw new \InvalidArgumentException('non-nullable device_type cannot be null');
        }
        $this->container['device_type'] = $device_type;

        return $this;
    }

    /**
     * Gets user_type
     *
     * @return string|null
     */
    public function getUserType()
    {
        return $this->container['user_type'];
    }

    /**
     * Sets user_type
     *
     * @param string|null $user_type user_type
     *
     * @return self
     */
    public function setUserType($user_type)
    {
        if (is_null($user_type)) {
            throw new \InvalidArgumentException('non-nullable user_type cannot be null');
        }
        $this->container['user_type'] = $user_type;

        return $this;
    }

    /**
     * Gets status
     *
     * @return \Linnworks\Auth\Model\StatusDetails|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param \Linnworks\Auth\Model\StatusDetails|null $status status
     *
     * @return self
     */
    public function setStatus($status)
    {
        if (is_null($status)) {
            throw new \InvalidArgumentException('non-nullable status cannot be null');
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id user_id
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        if (is_null($user_id)) {
            throw new \InvalidArgumentException('non-nullable user_id cannot be null');
        }
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets properties
     *
     * @return array<string,string>|null
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     *
     * @param array<string,string>|null $properties properties
     *
     * @return self
     */
    public function setProperties($properties)
    {
        if (is_null($properties)) {
            throw new \InvalidArgumentException('non-nullable properties cannot be null');
        }
        $this->container['properties'] = $properties;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets server
     *
     * @return string|null
     */
    public function getServer()
    {
        return $this->container['server'];
    }

    /**
     * Sets server
     *
     * @param string|null $server server
     *
     * @return self
     */
    public function setServer($server)
    {
        if (is_null($server)) {
            throw new \InvalidArgumentException('non-nullable server cannot be null');
        }
        $this->container['server'] = $server;

        return $this;
    }

    /**
     * Gets push_server
     *
     * @return string|null
     */
    public function getPushServer()
    {
        return $this->container['push_server'];
    }

    /**
     * Sets push_server
     *
     * @param string|null $push_server push_server
     *
     * @return self
     */
    public function setPushServer($push_server)
    {
        if (is_null($push_server)) {
            throw new \InvalidArgumentException('non-nullable push_server cannot be null');
        }
        $this->container['push_server'] = $push_server;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


