<?php
/**
 * AuthApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Linnworks\Auth
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Authenticate API
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: auth
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.11.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Linnworks\Auth\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Linnworks\Auth\ApiException;
use Linnworks\Auth\Configuration;
use Linnworks\Auth\HeaderSelector;
use Linnworks\Auth\ObjectSerializer;

/**
 * AuthApi Class Doc Comment
 *
 * @category Class
 * @package  Linnworks\Auth
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AuthApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'authorizeByApplication' => [
            'application/json',
        ],
        'getApplicationProfileBySecretKey' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation authorizeByApplication
     *
     * AuthorizeByApplication
     *
     * @param  \Linnworks\Auth\Model\AuthorizeByApplicationRequest|null $request request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authorizeByApplication'] to see the possible values for this operation
     *
     * @throws \Linnworks\Auth\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Auth\Model\BaseSession
     */
    public function authorizeByApplication($request = null, string $contentType = self::contentTypes['authorizeByApplication'][0])
    {
        list($response) = $this->authorizeByApplicationWithHttpInfo($request, $contentType);
        return $response;
    }

    /**
     * Operation authorizeByApplicationWithHttpInfo
     *
     * AuthorizeByApplication
     *
     * @param  \Linnworks\Auth\Model\AuthorizeByApplicationRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authorizeByApplication'] to see the possible values for this operation
     *
     * @throws \Linnworks\Auth\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Auth\Model\BaseSession, HTTP status code, HTTP response headers (array of strings)
     */
    public function authorizeByApplicationWithHttpInfo($request = null, string $contentType = self::contentTypes['authorizeByApplication'][0])
    {
        $request = $this->authorizeByApplicationRequest($request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Auth\Model\BaseSession' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Auth\Model\BaseSession' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Auth\Model\BaseSession', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Auth\Model\BaseSession';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Auth\Model\BaseSession',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation authorizeByApplicationAsync
     *
     * AuthorizeByApplication
     *
     * @param  \Linnworks\Auth\Model\AuthorizeByApplicationRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authorizeByApplication'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function authorizeByApplicationAsync($request = null, string $contentType = self::contentTypes['authorizeByApplication'][0])
    {
        return $this->authorizeByApplicationAsyncWithHttpInfo($request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation authorizeByApplicationAsyncWithHttpInfo
     *
     * AuthorizeByApplication
     *
     * @param  \Linnworks\Auth\Model\AuthorizeByApplicationRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authorizeByApplication'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function authorizeByApplicationAsyncWithHttpInfo($request = null, string $contentType = self::contentTypes['authorizeByApplication'][0])
    {
        $returnType = '\Linnworks\Auth\Model\BaseSession';
        $request = $this->authorizeByApplicationRequest($request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'authorizeByApplication'
     *
     * @param  \Linnworks\Auth\Model\AuthorizeByApplicationRequest|null $request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['authorizeByApplication'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function authorizeByApplicationRequest($request = null, string $contentType = self::contentTypes['authorizeByApplication'][0])
    {



        $resourcePath = '/api/Auth/AuthorizeByApplication';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($request));
            } else {
                $httpBody = $request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getApplicationProfileBySecretKey
     *
     * GetApplicationProfileBySecretKey
     *
     * @param  \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest $auth_get_application_profile_by_secret_key_request auth_get_application_profile_by_secret_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApplicationProfileBySecretKey'] to see the possible values for this operation
     *
     * @throws \Linnworks\Auth\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Linnworks\Auth\Model\ApplicationProfileResponse
     */
    public function getApplicationProfileBySecretKey($auth_get_application_profile_by_secret_key_request, string $contentType = self::contentTypes['getApplicationProfileBySecretKey'][0])
    {
        list($response) = $this->getApplicationProfileBySecretKeyWithHttpInfo($auth_get_application_profile_by_secret_key_request, $contentType);
        return $response;
    }

    /**
     * Operation getApplicationProfileBySecretKeyWithHttpInfo
     *
     * GetApplicationProfileBySecretKey
     *
     * @param  \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest $auth_get_application_profile_by_secret_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApplicationProfileBySecretKey'] to see the possible values for this operation
     *
     * @throws \Linnworks\Auth\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Linnworks\Auth\Model\ApplicationProfileResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getApplicationProfileBySecretKeyWithHttpInfo($auth_get_application_profile_by_secret_key_request, string $contentType = self::contentTypes['getApplicationProfileBySecretKey'][0])
    {
        $request = $this->getApplicationProfileBySecretKeyRequest($auth_get_application_profile_by_secret_key_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\Linnworks\Auth\Model\ApplicationProfileResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Linnworks\Auth\Model\ApplicationProfileResponse' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Linnworks\Auth\Model\ApplicationProfileResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\Linnworks\Auth\Model\ApplicationProfileResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Linnworks\Auth\Model\ApplicationProfileResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getApplicationProfileBySecretKeyAsync
     *
     * GetApplicationProfileBySecretKey
     *
     * @param  \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest $auth_get_application_profile_by_secret_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApplicationProfileBySecretKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getApplicationProfileBySecretKeyAsync($auth_get_application_profile_by_secret_key_request, string $contentType = self::contentTypes['getApplicationProfileBySecretKey'][0])
    {
        return $this->getApplicationProfileBySecretKeyAsyncWithHttpInfo($auth_get_application_profile_by_secret_key_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getApplicationProfileBySecretKeyAsyncWithHttpInfo
     *
     * GetApplicationProfileBySecretKey
     *
     * @param  \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest $auth_get_application_profile_by_secret_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApplicationProfileBySecretKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getApplicationProfileBySecretKeyAsyncWithHttpInfo($auth_get_application_profile_by_secret_key_request, string $contentType = self::contentTypes['getApplicationProfileBySecretKey'][0])
    {
        $returnType = '\Linnworks\Auth\Model\ApplicationProfileResponse';
        $request = $this->getApplicationProfileBySecretKeyRequest($auth_get_application_profile_by_secret_key_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getApplicationProfileBySecretKey'
     *
     * @param  \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest $auth_get_application_profile_by_secret_key_request (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getApplicationProfileBySecretKey'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getApplicationProfileBySecretKeyRequest($auth_get_application_profile_by_secret_key_request, string $contentType = self::contentTypes['getApplicationProfileBySecretKey'][0])
    {

        // verify the required parameter 'auth_get_application_profile_by_secret_key_request' is set
        if ($auth_get_application_profile_by_secret_key_request === null || (is_array($auth_get_application_profile_by_secret_key_request) && count($auth_get_application_profile_by_secret_key_request) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $auth_get_application_profile_by_secret_key_request when calling getApplicationProfileBySecretKey'
            );
        }


        $resourcePath = '/api/Auth/GetApplicationProfileBySecretKey';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'text/json', 'application/xml', 'text/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($auth_get_application_profile_by_secret_key_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($auth_get_application_profile_by_secret_key_request));
            } else {
                $httpBody = $auth_get_application_profile_by_secret_key_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
