# Linnworks\Auth\AuthApi

All URIs are relative to https://api.linnworks.net, except if the operation defines another base path.

| Method | HTTP request | Description |
| ------------- | ------------- | ------------- |
| [**authorizeByApplication()**](AuthApi.md#authorizeByApplication) | **POST** /api/Auth/AuthorizeByApplication | AuthorizeByApplication |
| [**getApplicationProfileBySecretKey()**](AuthApi.md#getApplicationProfileBySecretKey) | **POST** /api/Auth/GetApplicationProfileBySecretKey | GetApplicationProfileBySecretKey |


## `authorizeByApplication()`

```php
authorizeByApplication($request): \Linnworks\Auth\Model\BaseSession
```

AuthorizeByApplication

Generates a sesssion and provide Authorization Token and server in response. <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Linnworks\Auth\Api\AuthApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$request = new \Linnworks\Auth\Model\AuthorizeByApplicationRequest(); // \Linnworks\Auth\Model\AuthorizeByApplicationRequest

try {
    $result = $apiInstance->authorizeByApplication($request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthApi->authorizeByApplication: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **request** | [**\Linnworks\Auth\Model\AuthorizeByApplicationRequest**](../Model/AuthorizeByApplicationRequest.md)|  | [optional] |

### Return type

[**\Linnworks\Auth\Model\BaseSession**](../Model/BaseSession.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getApplicationProfileBySecretKey()`

```php
getApplicationProfileBySecretKey($auth_get_application_profile_by_secret_key_request): \Linnworks\Auth\Model\ApplicationProfileResponse
```

GetApplicationProfileBySecretKey

Returns current application subscription profile information for a given application for a specific user.   You can use this method to get the current application subscription after AuthorizedByApplication returned a session.   The session will contain Id, this is the UserId you need to supply in the call.  If there are no current subscriptions for the application for the user. The method will return null (nothing) <b>Rate limit: </b><span style=\"background-color:#0272d9;color:white;padding:4px 8px;text-align:center;border-radius:5px; font-size: small;\"><b>150</b></span> / minute

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



$apiInstance = new Linnworks\Auth\Api\AuthApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$auth_get_application_profile_by_secret_key_request = new \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest(); // \Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest

try {
    $result = $apiInstance->getApplicationProfileBySecretKey($auth_get_application_profile_by_secret_key_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthApi->getApplicationProfileBySecretKey: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

| Name | Type | Description  | Notes |
| ------------- | ------------- | ------------- | ------------- |
| **auth_get_application_profile_by_secret_key_request** | [**\Linnworks\Auth\Model\AuthGetApplicationProfileBySecretKeyRequest**](../Model/AuthGetApplicationProfileBySecretKeyRequest.md)|  | |

### Return type

[**\Linnworks\Auth\Model\ApplicationProfileResponse**](../Model/ApplicationProfileResponse.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`, `text/json`, `application/xml`, `text/xml`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
