<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Talisman\LightspeedBundle\Lightspeed;

use Psr\Log\LoggerInterface;
use Dmishh\SettingsBundle\Manager\SettingsManagerInterface;
use Symfony\Component\Routing\RouterInterface;
use Lightspeed\Customer;
use Lightspeed\CustomerType;
use Lightspeed\Inventory;
use Lightspeed\InventoryCount;
use Lightspeed\InventoryCountItem;
use Lightspeed\Item;
use Lightspeed\ItemAttributeSet;
use Lightspeed\Order;
use Lightspeed\OrderLine;
use Lightspeed\Vendor;
use Lightspeed\VendorReturn;
use Lightspeed\Sale;
use Lightspeed\SaleLine;
use Lightspeed\SalePayment;
use Lightspeed\Register;
use Lightspeed\RegisterCountAmount;
use Lightspeed\RegisterCount;
use Lightspeed\Category;
use Lightspeed\PaymentType;
use Lightspeed\TaxCategory;
use Lightspeed\TaxCategoryClass;
use Lightspeed\TaxClass;
use Lightspeed\InventoryCountReconcile;
use Lightspeed\Locale;
use Exception;
use Lightspeed\Auth as lsAuth;
use Lightspeed\Shop;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Lightspeed\Matrix;
use Lightspeed\AttributeSet;
use Lightspeed\Employee;
use Lightspeed\CustomField;

class Service {

    protected $logger;
    protected $sm;

    protected $token;
    protected $account;
    protected $auth;

    public function __construct(LoggerInterface $logger,SettingsManagerInterface $sm)
    {
        $this->logger = $logger;
        $this->sm = $sm;
    }

    public function setup($token, $account, $auth) {

        if(!$token || !$account || !$auth) {
            throw new Exception('Please check that all fields have been set');
        }

        $this->token = $token;
        $this->account = $account;
        $this->auth = $auth;
    }

    protected function accessTokenChange($class)
    {
        if ($this->token !== $class->getAccessToken())
        {
            $this->token = $class->getAccessToken();
            $this->sm->set('lightspeed_access_token', $this->token);
        }
    }

    public function customer()
    {
        $class = new Customer($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function customerType()
    {
        $class = new CustomerType($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function inventory()
    {
        $class = new Inventory($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function inventoryCount()
    {
        $class = new InventoryCount($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function inventoryCountItem()
    {
        $class = new InventoryCountItem($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function item()
    {
        $class = new Item($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function itemAttributeSet()
    {
        $class = new ItemAttributeSet($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function order()
    {
        $class = new Order($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function orderLine()
    {
        $class = new OrderLine($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function sale()
    {
        $class = new Sale($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function saleLine()
    {
        $class = new SaleLine($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function salePayment()
    {
        $class = new SalePayment($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function vendor()
    {
        $class = new Vendor($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function register()
    {
        $class = new Register($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function registerCountAmount()
    {
        $class = new RegisterCountAmount($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function registerCount()
    {
        $class = new RegisterCount($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function category()
    {
        $class = new Category($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }


    public function paymentType()
    {
        $class = new PaymentType($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function taxCategory()
    {
        $class = new TaxCategory($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function taxCategoryClass()
    {
        $class = new TaxCategoryClass($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function vendorReturn()
    {
        $class = new VendorReturn($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function taxClass()
    {
        $class = new TaxClass($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function inventoryCountReconcile()
    {
        $class = new InventoryCountReconcile($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function shop()
    {
        $class = new Shop($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function locale()
    {
        $class = new Locale($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function matrix()
    {
        $class = new Matrix($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function attributeSet()
    {
        $class = new AttributeSet($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function employee()
    {
        $class = new Employee($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

    public function customField()
    {
        $class = new CustomField($this->logger, $this->token, $this->auth, $this->account);
        $this->accessTokenChange($class);
        return $class;
    }

}
