<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

class DefaultController extends Controller {

    /**
     * Authorise Lightspeed route to capture tokens
     * Example
     * @Route("/lightspeed_auth", name="auth")
     */
    public function authAction(Request $request) {

        $lightSpeedAuth = $this->get('talisman_lightspeed_auth');

        $authArray = [];
        $authArray['clientId'] = 'abc-def-12345';
        $authArray['clientSecret'] = 'I am a test secret what are you ';
        $authArray['scope'] = 'employee:all';
        $authArray['format'] = 'json';
        $authArray['returnUrl'] = 'http://127.0.0.1:8000/unleashed';

        $auth = $lightSpeedAuth->auth($authArray);
        $auth->getCodeRedirect();
        
        return new Response('Redirected');
    }

    /**
     * Return Lightspeed route to capture tokens
     * @Route("/unleashed", name="lightspeed")
     */
    public function lightspeedAction(Request $request) {

        if (!$request->query->get('code')) {
            return new Response('No code detected');
        }

        $lightSpeedAuth = $this->get('talisman_lightspeed_auth');

        $authArray = [];
        $authArray['clientId'] = 'abc-def-12345';
        $authArray['clientSecret'] = 'I am a test secret what are you ';
        $authArray['scope'] = 'employee:all';
        $authArray['format'] = 'json';
        $authArray['returnUrl'] = 'http://127.0.0.1:8000/unleashed';

        $auth = $lightSpeedAuth->auth($authArray);
                
        $auth->setTokens($request->query->get('code'));
        
        # Required access tokens
        $accessToken = $lightSpeedAuth->getAccessToken();
        $refreshToken = $lightSpeedAuth->getRefreshToken();
        $tokenType = $lightSpeedAuth->getTokenType();
        $expiresIn = $lightSpeedAuth->getExpiresIn();

        // replace this example code with whatever you need
        return $this->render('default/index.html.twig', array(
                    'base_dir' => realpath($this->container->getParameter('kernel.root_dir') . '/..'),
                    'accessToken' => $accessToken,
                    'refreshToken' => $refreshToken,
                    'tokenType' => $tokenType,
                    'expiresIn' => $expiresIn
        ));
    }

    /**
     * Example call
     * replace this example code with whatever you need
     * @Route("/test", name="test call")
     */
    public function testAction(Request $request) {
        
        $lightSpeed = $this->get('talisman_lightspeed');

        # Get access token from wherever you have stored it
        $accessToken = '721e4086df28fe012e466c4d83bab3ffd0616a2e';
        # Set the token 
        $lightSpeed->setToken($accessToken);
        # Load the class you want to call
        $cust = $lightSpeed->sale();
        # Make the call
        $customers = json_decode($cust->getSales());

        return $this->render('default/index.html.twig', array(
                    'base_dir' => realpath($this->container->getParameter('kernel.root_dir') . '/..'),
                    'customers' => $customers,
        ));
    }

}
