<?php

/* 
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Talisman\LightspeedBundle\Lightspeed;

use Psr\Log\LoggerInterface;
use Lightspeed\Auth as lsAuth;

class Auth {
    
    protected $logger;
    protected $service;
    protected $auth;
    
    public function __construct(LoggerInterface $logger) {
        $this->logger = $logger;
    }

    /**
     * Auth
     * @param array $auth
     * @return boolean|\Talisman\LightspeedBundle\Lightspeed\Auth
     */
    public function auth(array $auth) {
        if(!$this->logger || !isset($auth['clientId']) || !isset($auth['clientSecret']) || !isset($auth['scope']) || !isset($auth['format']) || !isset($auth['returnUrl'])) {
            return false;
        }
        $this->auth = new lsAuth($this->logger, $auth['clientId'], $auth['clientSecret'], $auth['scope'], $auth['format'], $auth['returnUrl']);
        return $this;
    }
    
    /**
     * Redirect to Lightspeed to get tokens
     * @throws Exception
     */
    public function getCodeRedirect() {
        if(!$this->auth) {
            $error = 'Setup auth';
            $this->logger->critical($error);
            throw new Exception($error);
        }
        $this->auth->auth();
        exit;
    }
    /**
     * Call used to request the 
     * tokens from lightspeed
     * and store them 
     * @param type $code
     * @return json
     */
    public function setTokens($code) {
        return $this->auth->setTokens($code);
    }
    
    /**
     * Get stored token
     * @return string
     */
    public function getAccessToken() {
        return $this->auth->accessToken;
    }
    /**
     * Get stored token
     * @return string
     */
    public function getRefreshToken() {
        return $this->auth->refreshToken;
    }
    /**
     * Get stored token type
     * @return string
     */
    public function getTokenType() {
        return $this->auth->tokenType;
    }
    /**
     * Get stored exires in
     * @return string
     */
    public function getExpiresIn() {
        return $this->auth->expires;
    }
    
    
}