<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class VendorReturn extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'VendorReturn';
    }    
    
    public function getVendorReturn(int $vendorId): object {
        return $this->getSingle($vendorId);
    }
    
    public function getVendorReturns(): object {
        return $this->getAll();
    }
    
    public function createVendorReturn(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateVendorReturn(int $vendorId, array|object $data): object {
        return $this->update($vendorId, $data);
    }
    
    public function deleteVendorReturn(int $vendorId): object {
        return $this->delete($vendorId);
    }
    
    public function getVendorReturnBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getVendorReturnAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getVendorReturnBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchVendorReturns(array $query): ?object {
        return $this->search($query);
    }
}