<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Vendor extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Vendor';
    }    
    
    public function getVendor(int $vendorId): object {
        return $this->getSingle($vendorId);
    }
    
    public function getVendors(): object {
        return $this->getAll();
    }
    
    public function createVendor(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateVendor(int $vendorId, array|object $data): object {
        return $this->update($vendorId, $data);
    }
    
    public function deleteVendor(int $vendorId): object {
        return $this->delete($vendorId);
    }
    
    public function getVendorBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getVendorAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getVendorBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchVendors(array $query): ?object {
        return $this->search($query);
    }
}