<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class TaxClass extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxClass';
    }    
    
    public function getTaxClass(int $itemId): object {
        return $this->getSingle($itemId);
    }
    
    public function getTaxClasses(): object {
        return $this->getAll();
    }
    
    public function createTaxClass(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateTaxClass(int $itemId, array|object $data): object {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxClass(int $itemId): object {
        return $this->delete($itemId);
    }
    
    public function getTaxClassBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxClassAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getTaxClassBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchTaxClass(array $query): ?object {
        return $this->search($query);
    }
}