<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class TaxCategoryClass extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxCategoryClass';
    }    
    
    public function getTaxCategoryClass(int $itemId): object {
        return $this->getSingle($itemId);
    }
    
    public function getTaxCategoryClasses(): object {
        return $this->getAll();
    }
    
    public function createTaxCategoryClass(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateTaxCategoryClass(int $itemId, array|object $data): object {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxCategoryClass(int $itemId): object {
        return $this->delete($itemId);
    }
    
    public function getTaxCategoryClassBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxCategoryClassAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getTaxCategoryClassBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchTaxCategoryClass(array $query): ?object {
        return $this->search($query);
    }
}