<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class TaxCategory extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'TaxCategory';
    }    
    
    public function getTaxCategory(int $itemId): object {
        return $this->getSingle($itemId);
    }
    
    public function getTaxCategorys(): object {
        return $this->getAll();
    }
    
    public function createTaxCategory(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateTaxCategory(int $itemId, array|object $data): object {
        return $this->update($itemId, $data);
    }
    
    public function deleteTaxCategory(int $itemId): object {
        return $this->delete($itemId);
    }
    
    public function getTaxCategoryBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getTaxCategoryAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getTaxCategoryBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchTaxCategory(array $query): ?object {
        return $this->search($query);
    }
}