<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Shop extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Shop';
    }    
    
    public function getShop(int $shopId): object {
        return $this->getSingle($shopId);
    }
    
    public function getShops(): object {
        return $this->getAll();
    }
   
    public function searchShops(array $query): ?object {
        return $this->search($query);
    }
}