<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class SalePayment extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'SalePayment';
    }    
    
    public function getSalePayment(int $saleLineId): object {
        return $this->getSingle($saleLineId);
    }
    
    public function getSalePayments(): object {
        return $this->getAll();
    }
    
    public function createSalePayment(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateSalePayment(int $saleLineId, array|object $data): object {
        return $this->update($saleLineId, $data);
    }
    
    public function deleteSalePayment(int $saleLineId): object {
        return $this->delete($saleLineId);
    }
    
    public function getSalePaymentBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSalePaymentAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getSalePaymentBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}