<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class SaleLine extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'SaleLine';
    }    
    
    public function getSaleLine(int $saleLineId): object {
        return $this->getSingle($saleLineId);
    }
    
    public function getSaleLines(): object {
        return $this->getAll();
    }
    
    public function createSaleLine(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateSaleLine(int $saleLineId, array|object $data): object {
        return $this->update($saleLineId, $data);
    }
    
    public function deleteSaleLine(int $saleLineId): object {
        return $this->delete($saleLineId);
    }
    
    public function getSaleLineBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSaleLineAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getSaleLineBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchSaleLine(array $query): ?object {
        return $this->search($query);
    }
}