<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Sale extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Sale';
    }    
    
    public function getSale(int $saleId): object {
        return $this->getSingle($saleId);
    }
    
    public function getSales(): object {
        return $this->getAll();
    }
    
    public function createSale(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateSale(int $saleId, array|object $data): object {
        return $this->update($saleId, $data);
    }
    
    public function deleteSale(int $saleId): object {
        return $this->delete($saleId);
    }
    
    public function getSaleBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getSaleAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getSaleBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchSales(array $query): ?object {
        return $this->search($query);
    }
    
    public function getSaleRefund(int $saleId): object {
        return $this->getSingle($saleId, 'refund');
    }
}