<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class RegisterCountAmount extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'RegisterCountAmount';
    }    
    
    public function getRegisterCountAmount(int $registerId): object {
        return $this->getSingle($registerId);
    }
    
    public function getRegisterCountAmounts(): object {
        return $this->getAll();
    }
    
    public function searchRegisterCountAmounts(array $query): ?object {
        return $this->search($query);
    }
    
    public function createRegisterCountAmount(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateRegisterCountAmount(int $registerId, array|object $data): object {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegisterCountAmount(int $registerId): object {
        return $this->delete($registerId);
    }
    
    public function getRegisterCountAmountBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterCountAmountAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getRegisterCountAmountBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}