<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class RegisterCount extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'RegisterCount';
    }    
    
    public function getRegisterCount(int $registerId): object {
        return $this->getSingle($registerId);
    }
    
    public function getRegisterCounts(): object {
        return $this->getAll();
    }
    
    public function searchRegisterCounts(array $query): ?object {
        return $this->search($query);
    }
    
    public function createRegisterCount(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateRegisterCount(int $registerId, array|object $data): object {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegisterCount(int $registerId): object {
        return $this->delete($registerId);
    }
    
    public function getRegisterCountBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterCountAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getRegisterCountBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}