<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Register extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Register';
    }    
    
    public function getRegister(int $registerId): object {
        return $this->getSingle($registerId);
    }
    
    public function getRegisters(): object {
        return $this->getAll();
    }
    
    public function createRegister(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateRegister(int $registerId, array|object $data): object {
        return $this->update($registerId, $data);
    }
    
    public function deleteRegister(int $registerId): object {
        return $this->delete($registerId);
    }
    
    public function getRegisterBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getRegisterAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getRegisterBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function getRegistersCalculated(int $registerId): object {
        return $this->getSingle($registerId, 'calculated');
    }
    
    public function searchRegisters(array $query): ?object {
        return $this->search($query);
    }
}