<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class PaymentType extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'PaymentType';
    }    
    
    public function getPaymentType(int $typeId): object {
        return $this->getSingle($typeId);
    }
    
    public function getPaymentTypes(): object {
        return $this->getAll();
    }
    
    public function createPaymentType(array|object $data): object {
         return $this->create($data);
    }
    
    public function updatePaymentType(int $typeId, array|object $data): object {
        return $this->update($typeId, $data);
    }
    
    public function deletePaymentType(int $typeId): object {
        return $this->delete($typeId);
    }
    
    public function getPaymentTypeBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getPaymentTypeAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getPaymentTypeBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchPaymentType(array $query): ?object {
        return $this->search($query);
    }
}