<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class OrderLine extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'OrderLine';
    }    
    
    public function getOrderLine(int $orderlineId): object {
        return $this->getSingle($orderlineId);
    }
    
    public function getOrderLines(): object {
        return $this->getAll();
    }
    
    public function createOrderLine(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateOrderLine(int $orderlineId, array|object $data): object {
        return $this->update($orderlineId, $data);
    }
    
    public function deleteOrderLine(int $orderlineId): object {
        return $this->delete($orderlineId);
    }
    
    public function getOrderLineBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getOrderLineAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getOrderLineBefore(string $date): ?object {
        return $this->getBefore($date);
    }
}