<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Order extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'Order';
    }    
    
    public function getOrder(int $orderId): object {
        return $this->getSingle($orderId);
    }
    
    public function getOrders(): object {
        return $this->getAll();
    }
    
    public function createOrder(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateOrder(int $orderId, array|object $data): object {
        return $this->update($orderId, $data);
    }
    
    public function deleteOrder(int $orderId): object {
        return $this->delete($orderId);
    }
    
    public function getOrderBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getOrderAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getOrderBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchOrders(array $query): ?object {
        return $this->search($query);
    }
}