<?php

declare(strict_types=1);

/*
 * Copyright Talisman Innovations Ltd. (2016). All rights reserved.
 */

namespace Lightspeed;

use Psr\Log\LoggerInterface;

class Matrix extends CallAbstract {

    public function __construct(LoggerInterface $logger, string $token, Auth $auth, ?string $accountId) {
        parent::__construct($logger, $token, $auth, $accountId);
        $this->endpoint = 'ItemMatrix';
    }    
    
    public function getMatrix(int $matrixId): object {
        return $this->getSingle($matrixId);
    }
    
    public function getMatrixes(): object {
        return $this->getAll();
    }
    
    public function createMatrix(array|object $data): object {
         return $this->create($data);
    }
    
    public function updateMatrix(int $matrixId, array|object $data): object {
        return $this->update($matrixId, $data);
    }
    
    public function deleteMatrix(int $matrixId): object {
        return $this->delete($matrixId);
    }
    
    public function getMatrixBetweenDates(string $fromDate, string $toDate): ?object {
        return $this->getBetweenDates($fromDate, $toDate);
    }
    
    public function getMatrixAfter(string $date): ?object {
        return $this->getAfter($date);
    }
    
    public function getMatrixBefore(string $date): ?object {
        return $this->getBefore($date);
    }
    
    public function searchMatrix(array $query): ?object {
        return $this->search($query);
    }
    
}